/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.jps;

import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Set;
import org.netbeans.lib.profiler.jps.RunningVM;
import org.netbeans.lib.profiler.utils.MiscUtils;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;

public class JpsProxy {
    private static Method monitoredVmUtil_isAttachable;

    public static RunningVM[] getRunningVMs() {
        String string = null;
        ArrayList<RunningVM> arrayList = new ArrayList<RunningVM>();
        try {
            HostIdentifier hostIdentifier = new HostIdentifier(string);
            MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(hostIdentifier);
            String string2 = ManagementFactory.getRuntimeMXBean().getName();
            Set<Integer> set = monitoredHost.activeVms();
            if (set.isEmpty()) {
                return null;
            }
            for (int n : set) {
                if (string2.startsWith(n + "@")) continue;
                VmIdentifier vmIdentifier = null;
                MonitoredVm monitoredVm = null;
                String string3 = "//" + n + "?mode=r";
                try {
                    vmIdentifier = new VmIdentifier(string3);
                    monitoredVm = monitoredHost.getMonitoredVm(vmIdentifier, 0);
                }
                catch (URISyntaxException uRISyntaxException) {
                    MiscUtils.printWarningMessage("in jvmps, detected malformed VM Identifier: " + string3 + "; ignored");
                    continue;
                }
                catch (MonitorException monitorException) {
                    System.out.println("Ex " + monitorException.getMessage());
                    monitorException.printStackTrace();
                    continue;
                }
                catch (Exception exception) {
                    MiscUtils.printWarningMessage("in jvmps, for VM = " + String.valueOf(n) + " got exception: " + exception);
                    continue;
                }
                if (!JpsProxy.isAttachable(monitoredVm)) {
                    monitoredHost.detach(monitoredVm);
                    continue;
                }
                String string4 = MonitoredVmUtil.commandLine(monitoredVm);
                String string5 = MonitoredVmUtil.mainClass(monitoredVm, true);
                String string6 = MonitoredVmUtil.mainArgs(monitoredVm);
                String string7 = MonitoredVmUtil.jvmArgs(monitoredVm);
                String string8 = MonitoredVmUtil.jvmFlags(monitoredVm);
                monitoredHost.detach(monitoredVm);
                RunningVM runningVM = new RunningVM(n, string8, string7, string5, string6);
                arrayList.add(runningVM);
            }
        }
        catch (MonitorException monitorException) {
            String string9 = "in jvmps, got MonitorException";
            if (monitorException.getMessage() != null) {
                string9 = string9 + " with message + " + monitorException.getMessage();
            }
            MiscUtils.printWarningMessage(string9);
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            MiscUtils.printWarningMessage("in jvmps, got malformed Host Identifier: " + string);
            return null;
        }
        return arrayList.toArray(new RunningVM[arrayList.size()]);
    }

    private static boolean isAttachable(MonitoredVm monitoredVm) {
        try {
            Object object = monitoredVmUtil_isAttachable.invoke(null, monitoredVm);
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return false;
    }

    static {
        try {
            monitoredVmUtil_isAttachable = MonitoredVmUtil.class.getMethod("isAttachable", MonitoredVm.class);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
    }
}

