/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.classfile;

import java.io.IOException;
import java.util.ArrayList;
import org.netbeans.lib.profiler.classfile.ClassFileCache;
import org.netbeans.lib.profiler.classfile.ClassFileParser;
import org.netbeans.lib.profiler.classfile.ClassInfo;

public class DynamicClassInfo
extends ClassInfo {
    private ArrayList subclasses;
    private DynamicClassInfo superClass;
    private String classFileLocation;
    private int[] baseCPoolCount;
    private char[] instrMethodIds;
    private DynamicClassInfo[] interfacesDCI;
    private char[] methodScanStatus;
    private byte[][] modifiedAndSavedMethodInfos;
    private boolean allMethodsMarkers = false;
    private boolean allMethodsRoots = false;
    private boolean hasUninstrumentedMarkerMethods;
    private boolean hasUninstrumentedRootMethods;
    private boolean isLoaded;
    private boolean servletDoMethodScanned;
    private int currentCPoolCount;
    private int nInstrumentedMethods;

    public DynamicClassInfo(String string, int n, String string2) throws IOException, ClassFormatError {
        super(string, n);
        this.classFileLocation = string2;
        byte[] byArray = this.getClassFileBytes();
        try {
            new ClassFileParser().parseClassFile(byArray, this);
            if (!string.equals(this.name)) {
                throw new ClassFormatError("Mismatch between name in .class file and location for " + string + "\nYour class path setting may be incorrect.");
            }
        }
        catch (ClassFileParser.ClassFileReadException classFileReadException) {
            throw new ClassFormatError(classFileReadException.getMessage());
        }
        this.methodScanStatus = new char[this.methodNames.length];
        this.instrMethodIds = new char[this.methodNames.length];
        this.currentCPoolCount = this.origCPoolCount;
        this.baseCPoolCount = new int[11];
        for (int i = 0; i < 11; ++i) {
            this.baseCPoolCount[i] = -1;
        }
    }

    public void setAllMethodsMarkers() {
        this.allMethodsMarkers = true;
        this.hasUninstrumentedMarkerMethods = true;
    }

    public boolean getAllMethodsMarkers() {
        return this.allMethodsMarkers;
    }

    public void setAllMethodsRoots() {
        this.allMethodsRoots = true;
        this.hasUninstrumentedRootMethods = true;
    }

    public boolean getAllMethodsRoots() {
        return this.allMethodsRoots;
    }

    public void setBaseCPoolCount(int n, int n2) {
        this.baseCPoolCount[n] = n2;
    }

    public int getBaseCPoolCount(int n) {
        return this.baseCPoolCount[n];
    }

    public int getBaseCPoolCountLen() {
        return this.baseCPoolCount.length;
    }

    public byte[] getClassFileBytes() throws IOException {
        return ClassFileCache.getDefault().getClassFile(this.name, this.classFileLocation);
    }

    public String getClassFileLocation() {
        return this.classFileLocation;
    }

    public void setCurrentCPoolCount(int n) {
        this.currentCPoolCount = n;
    }

    public int getCurrentCPoolCount() {
        return this.currentCPoolCount;
    }

    public int getExceptionTableStartOffsetInMethodInfo(int n) {
        if (this.modifiedAndSavedMethodInfos != null && this.modifiedAndSavedMethodInfos[n] != null) {
            int n2 = this.getBCLenForModifiedAndSavedMethodInfo(n);
            return this.methodBytecodesOffsets[n] + n2;
        }
        return super.getExceptionTableStartOffsetInMethodInfo(n);
    }

    public void setHasUninstrumentedMarkerMethods(boolean bl) {
        this.hasUninstrumentedMarkerMethods = bl;
    }

    public void setHasUninstrumentedRootMethods(boolean bl) {
        this.hasUninstrumentedRootMethods = bl;
    }

    public void setInstrMethodId(int n, int n2) {
        this.instrMethodIds[n] = (char)n2;
    }

    public char getInstrMethodId(int n) {
        return this.instrMethodIds[n];
    }

    public void setLoaded(boolean bl) {
        this.isLoaded = bl;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public byte[] getMethodBytecode(int n) {
        if (this.modifiedAndSavedMethodInfos != null && this.modifiedAndSavedMethodInfos[n] != null) {
            byte[] byArray = this.modifiedAndSavedMethodInfos[n];
            int n2 = this.getBCLenForModifiedAndSavedMethodInfo(n);
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, this.methodBytecodesOffsets[n], byArray2, 0, n2);
            return byArray2;
        }
        return super.getMethodBytecode(n);
    }

    public int getMethodBytecodesLength(int n) {
        if (this.modifiedAndSavedMethodInfos != null && this.modifiedAndSavedMethodInfos[n] != null) {
            return this.getBCLenForModifiedAndSavedMethodInfo(n);
        }
        return super.getMethodBytecodesLength(n);
    }

    public byte[] getMethodInfo(int n) {
        if (this.modifiedAndSavedMethodInfos != null && this.modifiedAndSavedMethodInfos[n] != null) {
            return this.modifiedAndSavedMethodInfos[n];
        }
        return super.getMethodInfo(n);
    }

    public int getMethodInfoLength(int n) {
        if (this.modifiedAndSavedMethodInfos != null && this.modifiedAndSavedMethodInfos[n] != null) {
            return this.modifiedAndSavedMethodInfos[n].length;
        }
        return super.getMethodInfoLength(n);
    }

    public void setMethodInstrumented(int n) {
        int n2 = n;
        this.methodScanStatus[n2] = (char)(this.methodScanStatus[n2] | 8);
        ++this.nInstrumentedMethods;
    }

    public boolean isMethodInstrumented(int n) {
        return (this.methodScanStatus[n] & 8) != 0;
    }

    public void setMethodLeaf(int n) {
        int n2 = n;
        this.methodScanStatus[n2] = (char)(this.methodScanStatus[n2] | 0x10);
    }

    public boolean isMethodLeaf(int n) {
        return (this.methodScanStatus[n] & 0x10) != 0;
    }

    public void setMethodMarker(int n) {
        int n2 = n;
        this.methodScanStatus[n2] = (char)(this.methodScanStatus[n2] | 0x100);
        this.hasUninstrumentedMarkerMethods = true;
    }

    public boolean isMethodMarker(int n) {
        return this.allMethodsMarkers || (this.methodScanStatus[n] & 0x100) != 0;
    }

    public void setMethodReachable(int n) {
        int n2 = n;
        this.methodScanStatus[n2] = (char)(this.methodScanStatus[n2] | '\u0001');
    }

    public boolean isMethodReachable(int n) {
        return (this.methodScanStatus[n] & '\u0001') != 0;
    }

    public void setMethodRoot(int n) {
        int n2 = n;
        this.methodScanStatus[n2] = (char)(this.methodScanStatus[n2] | 0x40);
        this.hasUninstrumentedRootMethods = true;
    }

    public boolean isMethodRoot(int n) {
        return this.allMethodsRoots || (this.methodScanStatus[n] & 0x40) != 0;
    }

    public void setMethodScanned(int n) {
        int n2 = n;
        this.methodScanStatus[n2] = (char)(this.methodScanStatus[n2] | 4);
    }

    public boolean isMethodScanned(int n) {
        return (this.methodScanStatus[n] & 4) != 0;
    }

    public void setMethodSpecial(int n) {
        int n2 = n;
        this.methodScanStatus[n2] = (char)(this.methodScanStatus[n2] | 0x80);
    }

    public boolean isMethodSpecial(int n) {
        return (this.methodScanStatus[n] & 0x80) != 0;
    }

    public void setMethodUnscannable(int n) {
        int n2 = n;
        this.methodScanStatus[n2] = (char)(this.methodScanStatus[n2] | 2);
    }

    public boolean isMethodUnscannable(int n) {
        return (this.methodScanStatus[n] & 2) != 0;
    }

    public void setMethodVirtual(int n) {
        int n2 = n;
        this.methodScanStatus[n2] = (char)(this.methodScanStatus[n2] | 0x20);
    }

    public boolean isMethodVirtual(int n) {
        return (this.methodScanStatus[n] & 0x20) != 0;
    }

    public byte[] getOrigMethodInfo(int n) {
        return super.getMethodInfo(n);
    }

    public int getOrigMethodInfoLength(int n) {
        return super.getMethodInfoLength(n);
    }

    public void setServletDoMethodScanned() {
        this.servletDoMethodScanned = true;
    }

    public boolean isServletDoMethodScanned() {
        return this.servletDoMethodScanned;
    }

    public boolean isSubclassOf(String string) {
        if (this.getName() == string) {
            return true;
        }
        DynamicClassInfo dynamicClassInfo = this.getSuperClass();
        if (dynamicClassInfo == null || dynamicClassInfo == this) {
            return false;
        }
        return dynamicClassInfo.isSubclassOf(string);
    }

    public ArrayList getSubclasses() {
        return this.subclasses;
    }

    public void setSuperClass(DynamicClassInfo dynamicClassInfo) {
        this.superClass = dynamicClassInfo;
    }

    public DynamicClassInfo getSuperClass() {
        return this.superClass;
    }

    public void setSuperInterface(DynamicClassInfo dynamicClassInfo, int n) {
        if (this.interfacesDCI == null) {
            this.interfacesDCI = new DynamicClassInfo[this.interfaces.length];
        }
        this.interfacesDCI[n] = dynamicClassInfo;
    }

    public DynamicClassInfo[] getSuperInterfaces() {
        return this.interfacesDCI;
    }

    public void addSubclass(DynamicClassInfo dynamicClassInfo) {
        if (this.subclasses == null) {
            this.subclasses = this.name == "java/lang/Object" ? new ArrayList(500) : new ArrayList();
        }
        this.subclasses.add(dynamicClassInfo);
    }

    public boolean hasInstrumentedMethods() {
        return this.nInstrumentedMethods > 0;
    }

    public boolean hasUninstrumentedMarkerMethods() {
        return this.hasUninstrumentedMarkerMethods;
    }

    public boolean hasUninstrumentedRootMethods() {
        return this.hasUninstrumentedRootMethods;
    }

    public boolean implementsInterface(String string) {
        DynamicClassInfo[] dynamicClassInfoArray;
        int n = this.getLoaderId();
        String[] stringArray = this.getInterfaceNames();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (string != stringArray[i]) continue;
                return true;
            }
            dynamicClassInfoArray = this.getSuperInterfaces();
            if (dynamicClassInfoArray != null) {
                for (int i = 0; i < dynamicClassInfoArray.length; ++i) {
                    DynamicClassInfo dynamicClassInfo = dynamicClassInfoArray[i];
                    if (dynamicClassInfo == null || !dynamicClassInfo.implementsInterface(string)) continue;
                    return true;
                }
            }
        }
        if ((dynamicClassInfoArray = this.getSuperClass()) == null || dynamicClassInfoArray.getName() == "java/lang/Object") {
            return false;
        }
        return dynamicClassInfoArray.implementsInterface(string);
    }

    public void saveMethodInfo(int n, byte[] byArray) {
        if (this.modifiedAndSavedMethodInfos == null) {
            this.modifiedAndSavedMethodInfos = new byte[this.methodNames.length][];
        }
        this.modifiedAndSavedMethodInfos[n] = byArray;
    }

    public void unsetMethodInstrumented(int n) {
        int n2 = n;
        this.methodScanStatus[n2] = (char)(this.methodScanStatus[n2] & 0xFFFFFFF7);
        --this.nInstrumentedMethods;
    }

    public void unsetMethodSpecial(int n) {
        int n2 = n;
        this.methodScanStatus[n2] = (char)(this.methodScanStatus[n2] & 0xFFFFFF7F);
    }

    private int getBCLenForModifiedAndSavedMethodInfo(int n) {
        byte[] byArray = this.modifiedAndSavedMethodInfos[n];
        int n2 = this.methodBytecodesOffsets[n] - 4;
        return ((byArray[n2++] & 0xFF) << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF);
    }
}

