/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionProcessor
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ConnectionProcessor.class.getName());
    final BlockingQueue<Runnable> inqueue;
    private Connection conn;
    private SQLIdentifiers.Quoter quoter;
    private final AtomicReference<Thread> taskThreadRef = new AtomicReference();

    synchronized void setConnection(Connection connection) throws DatabaseException {
        this.conn = connection;
        this.setQuoter();
    }

    private synchronized void setQuoter() throws DatabaseException {
        try {
            this.quoter = this.conn != null && !this.conn.isClosed() ? SQLIdentifiers.createQuoter((DatabaseMetaData)this.conn.getMetaData()) : null;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException((Throwable)sQLException);
        }
    }

    synchronized Connection getConnection() {
        return this.conn;
    }

    synchronized SQLIdentifiers.Quoter getQuoter() {
        return this.quoter;
    }

    synchronized void validateConnection() throws DatabaseException {
        try {
            if (this.conn == null) {
                return;
            }
            if (this.conn.isClosed()) {
                this.conn = null;
                throw new DatabaseException(NbBundle.getMessage(ConnectionProcessor.class, (String)"MSG_ConnectionLost"));
            }
            this.conn.getMetaData().getTables(null, null, " ", new String[]{"TABLE"}).close();
        }
        catch (SQLException sQLException) {
            this.conn = null;
            LOGGER.log(Level.FINE, null, sQLException);
            throw new DatabaseException(NbBundle.getMessage(ConnectionProcessor.class, (String)"MSG_ConnectionLost"), (Throwable)sQLException);
        }
        finally {
            this.setQuoter();
        }
    }

    synchronized boolean isConnected() {
        return this.conn != null;
    }

    boolean isConnProcessorThread() {
        return Thread.currentThread().equals(this.taskThreadRef.get());
    }

    public ConnectionProcessor(BlockingQueue<Runnable> blockingQueue) {
        this.inqueue = blockingQueue;
    }

    @Override
    public void run() {
        if (this.taskThreadRef.getAndSet(Thread.currentThread()) != null) {
            throw new IllegalStateException("Run method called more than once on connection command processor");
        }
        try {
            while (true) {
                Runnable runnable = this.inqueue.take();
                runnable.run();
            }
        }
        catch (InterruptedException interruptedException) {
            LOGGER.log(Level.INFO, null, interruptedException);
            return;
        }
    }
}

