/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.regex.Pattern;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.openide.util.Exceptions;

public final class EnvWriter {
    private final OutputStream os;
    private static final String remoteCharSet = System.getProperty("cnd.remote.charset");

    public EnvWriter(OutputStream outputStream) {
        this.os = outputStream;
    }

    static String getCharSet() {
        return remoteCharSet == null ? "UTF-8" : remoteCharSet;
    }

    public static byte[] getBytesWithRemoteCharset(String string) {
        String string2 = EnvWriter.getCharSet();
        if (Charset.isSupported(string2)) {
            try {
                return string.getBytes(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Exceptions.printStackTrace((Throwable)unsupportedEncodingException);
            }
        }
        return string.getBytes();
    }

    public void write(MacroMap macroMap) throws IOException {
        if (!macroMap.isEmpty()) {
            String string = null;
            String string2 = null;
            Pattern pattern = Pattern.compile("[A-Z0-9_]+");
            for (Map.Entry<String, String> entry : macroMap.entrySet()) {
                string = entry.getKey().toUpperCase();
                if (!pattern.matcher(string).matches() || (string2 = entry.getValue()) == null) continue;
                this.os.write(EnvWriter.getBytesWithRemoteCharset(string + "=\"" + string2 + "\" && export " + string + "\n"));
                this.os.flush();
            }
        }
    }
}

