/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.TasksCachedProcessor;
import org.netbeans.modules.nativeexecution.support.filesearch.FileSearchParams;
import org.netbeans.modules.nativeexecution.support.filesearch.FileSearchSupport;
import org.netbeans.modules.nativeexecution.support.hostinfo.FetchHostInfoTask;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HostInfoUtils {
    public static final String LOCALHOST = "localhost";
    private static final List<String> myIPAdresses = new ArrayList<String>();
    private static final TasksCachedProcessor<ExecutionEnvironment, HostInfo> hostInfoCachedProcessor = new TasksCachedProcessor<ExecutionEnvironment, HostInfo>(new FetchHostInfoTask(), false);

    private HostInfoUtils() {
    }

    public static void dumpInfo(HostInfo hostInfo, PrintStream printStream) {
        printStream.println("------------");
        if (hostInfo == null) {
            printStream.println("HostInfo is NULL");
        } else {
            printStream.println("Hostname      : " + hostInfo.getHostname());
            printStream.println("OS Family     : " + (Object)((Object)hostInfo.getOSFamily()));
            printStream.println("OS            : " + hostInfo.getOS().getName());
            printStream.println("OS Version    : " + hostInfo.getOS().getVersion());
            printStream.println("OS Bitness    : " + (Object)((Object)hostInfo.getOS().getBitness()));
            printStream.println("CPU Family    : " + (Object)((Object)hostInfo.getCpuFamily()));
            printStream.println("CPU #         : " + hostInfo.getCpuNum());
            printStream.println("shell to use  : " + hostInfo.getShell());
            printStream.println("tmpdir to use : " + hostInfo.getTempDir());
            printStream.println("tmpdir (file) to use : " + hostInfo.getTempDirFile().toString());
            printStream.println("PATH          : " + hostInfo.getPath());
        }
        printStream.println("------------");
    }

    public static boolean fileExists(ExecutionEnvironment executionEnvironment, String string) throws IOException {
        boolean bl = false;
        if (executionEnvironment.isLocal()) {
            bl = new File(string).exists();
        } else {
            if (!ConnectionManager.getInstance().isConnectedTo(executionEnvironment)) {
                throw new ConnectException();
            }
            NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder(executionEnvironment);
            nativeProcessBuilder.setExecutable("test").setArguments("-e", string);
            try {
                bl = nativeProcessBuilder.call().waitFor() == 0;
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException.getMessage());
            }
        }
        return bl;
    }

    public static String searchFile(ExecutionEnvironment executionEnvironment, List<String> list, String string, boolean bl) {
        String string2 = null;
        try {
            string2 = new FileSearchSupport().searchFile(new FileSearchParams(executionEnvironment, list, string, bl));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return string2;
    }

    public static boolean isLocalhost(String string) {
        boolean bl = false;
        try {
            bl = myIPAdresses.contains(InetAddress.getByName(string).getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return bl;
    }

    public static boolean isHostInfoAvailable(ExecutionEnvironment executionEnvironment) {
        return hostInfoCachedProcessor.isResultAvailable(executionEnvironment);
    }

    public static HostInfo getHostInfo(ExecutionEnvironment executionEnvironment) throws IOException, CancellationException {
        if (executionEnvironment == null) {
            throw new IllegalArgumentException("ExecutionEnvironment should not be null");
        }
        Logger.assertNonUiThread();
        try {
            HostInfo hostInfo = hostInfoCachedProcessor.compute(executionEnvironment);
            if (hostInfo == null) {
                throw new IOException("Can not get HostInfo for " + executionEnvironment);
            }
            return hostInfo;
        }
        catch (InterruptedException interruptedException) {
            throw new CancellationException("getHostInfo interrupted");
        }
    }

    protected static void resetHostsData() {
        hostInfoCachedProcessor.resetCache();
    }

    static {
        NetworkInterface networkInterface = null;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    myIPAdresses.add(enumeration2.nextElement().getHostAddress());
                }
            }
        }
        catch (SocketException socketException) {
            Exceptions.printStackTrace((Throwable)socketException);
        }
    }
}

