/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.ProcessInfo;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeProcessExecutionService {
    private final ExecutionTask task;
    private final String descr;

    private NativeProcessExecutionService(ExecutionTask executionTask, String string) {
        this.task = executionTask;
        this.descr = string;
    }

    public static NativeProcessExecutionService newService(NativeProcessBuilder nativeProcessBuilder, LineProcessor lineProcessor, LineProcessor lineProcessor2, String string) {
        ExecutionTask executionTask = new ExecutionTask(nativeProcessBuilder, lineProcessor, lineProcessor2, string);
        return new NativeProcessExecutionService(executionTask, string);
    }

    public Future<Integer> start() {
        return NativeTaskExecutorService.submit(this.task, this.descr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessInfo getProcessInfo() {
        ExecutionTask executionTask = this.task;
        synchronized (executionTask) {
            if (this.task.process == null) {
                throw new IllegalThreadStateException("Not started yet");
            }
            return this.task.process.getProcessInfo();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecutionTask
    implements Callable<Integer> {
        private static final java.util.logging.Logger log = Logger.getInstance();
        private final NativeProcessBuilder npb;
        private final LineProcessor outProcessor;
        private final LineProcessor errProcessor;
        private final String descr;
        private NativeProcess process = null;

        public ExecutionTask(NativeProcessBuilder nativeProcessBuilder, LineProcessor lineProcessor, LineProcessor lineProcessor2, String string) {
            this.npb = nativeProcessBuilder;
            this.outProcessor = lineProcessor;
            this.errProcessor = lineProcessor2;
            this.descr = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public synchronized Integer call() throws Exception {
            int n;
            block32: {
                if (this.process != null) {
                    throw new IllegalThreadStateException("Already started!");
                }
                n = -1;
                InputStream inputStream = null;
                BufferedReader bufferedReader = null;
                if (this.outProcessor != null) {
                    this.outProcessor.reset();
                }
                if (this.errProcessor != null) {
                    this.errProcessor.reset();
                }
                this.process = this.npb.call();
                inputStream = this.process.getInputStream();
                if (inputStream != null) {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    try {
                        Object object;
                        while ((object = bufferedReader.readLine()) != null) {
                            if (this.outProcessor == null) continue;
                            this.outProcessor.processLine((String)object);
                        }
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        Thread.interrupted();
                    }
                }
                Object var7_8 = null;
                try {
                    if (this.outProcessor != null) {
                        this.outProcessor.close();
                    }
                }
                catch (Throwable throwable2) {
                    log.log(Level.FINE, this.descr, throwable2.getMessage());
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (this.process == null) break block32;
                try {
                    n = this.process.exitValue();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                this.process.destroy();
                {
                    break block32;
                    catch (Throwable throwable) {
                        log.log(Level.FINE, this.descr, throwable.getMessage());
                        var7_8 = null;
                        try {
                            if (this.outProcessor != null) {
                                this.outProcessor.close();
                            }
                        }
                        catch (Throwable throwable2) {
                            log.log(Level.FINE, this.descr, throwable2.getMessage());
                        }
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (this.process == null) break block32;
                        try {
                            n = this.process.exitValue();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        this.process.destroy();
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    try {
                        if (this.outProcessor != null) {
                            this.outProcessor.close();
                        }
                    }
                    catch (Throwable throwable3) {
                        log.log(Level.FINE, this.descr, throwable3.getMessage());
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (this.process != null) {
                        try {
                            n = this.process.exitValue();
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                        this.process.destroy();
                    }
                    throw throwable;
                }
            }
            if (n != 0) {
                if (this.errProcessor != null) {
                    for (String string : ProcessUtils.readProcessError(this.process)) {
                        this.errProcessor.processLine(string);
                    }
                    this.errProcessor.close();
                } else {
                    ProcessUtils.logError(Level.FINE, log, this.process);
                }
            }
            return n;
        }
    }
}

