/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.nativeexecution.ExecutionEnvironmentFactoryServiceImpl;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.spi.ExecutionEnvironmentFactoryService;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class ExecutionEnvironmentFactory {
    private static final ExecutionEnvironmentFactoryService defaultFactory = new ExecutionEnvironmentFactoryServiceImpl();
    private static final Collection<ExecutionEnvironmentFactoryService> allFactories = new CopyOnWriteArrayList<ExecutionEnvironmentFactoryService>();
    private static final Lookup.Result<ExecutionEnvironmentFactoryService> lookupResult = Lookup.getDefault().lookupResult(ExecutionEnvironmentFactoryService.class);
    private static final LookupListener ll = new LookupListener(){

        public synchronized void resultChanged(LookupEvent lookupEvent) {
            Collection collection = lookupResult.allInstances();
            allFactories.retainAll(collection);
            for (ExecutionEnvironmentFactoryService executionEnvironmentFactoryService : collection) {
                if (allFactories.contains(executionEnvironmentFactoryService)) continue;
                allFactories.add(executionEnvironmentFactoryService);
            }
        }
    };

    private ExecutionEnvironmentFactory() {
    }

    public static ExecutionEnvironmentFactoryService getDefault() {
        return defaultFactory;
    }

    public static ExecutionEnvironment getLocal() {
        for (ExecutionEnvironmentFactoryService executionEnvironmentFactoryService : allFactories) {
            ExecutionEnvironment executionEnvironment = executionEnvironmentFactoryService.getLocal();
            if (executionEnvironment == null) continue;
            return executionEnvironment;
        }
        return null;
    }

    public static ExecutionEnvironment createNew(String string, String string2) {
        for (ExecutionEnvironmentFactoryService executionEnvironmentFactoryService : allFactories) {
            ExecutionEnvironment executionEnvironment = executionEnvironmentFactoryService.createNew(string, string2);
            if (executionEnvironment == null) continue;
            return executionEnvironment;
        }
        return null;
    }

    public static ExecutionEnvironment createNew(String string, String string2, int n) {
        for (ExecutionEnvironmentFactoryService executionEnvironmentFactoryService : allFactories) {
            ExecutionEnvironment executionEnvironment = executionEnvironmentFactoryService.createNew(string, string2, n);
            if (executionEnvironment == null) continue;
            return executionEnvironment;
        }
        return null;
    }

    public static String toUniqueID(ExecutionEnvironment executionEnvironment) {
        for (ExecutionEnvironmentFactoryService executionEnvironmentFactoryService : allFactories) {
            String string = executionEnvironmentFactoryService.toUniqueID(executionEnvironment);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public static ExecutionEnvironment fromUniqueID(String string) {
        for (ExecutionEnvironmentFactoryService executionEnvironmentFactoryService : allFactories) {
            ExecutionEnvironment executionEnvironment = executionEnvironmentFactoryService.fromUniqueID(string);
            if (executionEnvironment == null) continue;
            return executionEnvironment;
        }
        return null;
    }

    static {
        lookupResult.addLookupListener(ll);
        ll.resultChanged(null);
    }
}

