/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.AbstractNativeProcess;
import org.netbeans.modules.nativeexecution.ExternalTerminalAccessor;
import org.netbeans.modules.nativeexecution.NativeProcessInfo;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ExternalTerminal;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.Signal;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.support.EnvWriter;
import org.netbeans.modules.nativeexecution.support.InstalledFileLocatorProvider;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class TerminalLocalNativeProcess
extends AbstractNativeProcess {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private static final File dorunScript;
    private ExternalTerminal terminal;
    private InputStream processOutput;
    private InputStream processError;
    private File resultFile;
    private final HostInfo.OSFamily osFamily;

    public TerminalLocalNativeProcess(NativeProcessInfo nativeProcessInfo, ExternalTerminal externalTerminal) {
        super(nativeProcessInfo);
        this.terminal = externalTerminal;
        this.processOutput = new ByteArrayInputStream((TerminalLocalNativeProcess.loc("TerminalLocalNativeProcess.ProcessStarted.text", new String[0]) + '\n').getBytes());
        this.osFamily = this.hostInfo == null ? HostInfo.OSFamily.UNKNOWN : this.hostInfo.getOSFamily();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void create() throws Throwable {
        File file3 = null;
        File file2 = null;
        File file = null;
        try {
            try {
                int n;
                Object object;
                Object object2;
                if (dorunScript == null) {
                    throw new IOException(TerminalLocalNativeProcess.loc("TerminalLocalNativeProcess.dorunNotFound.text", new String[0]));
                }
                if (this.osFamily == HostInfo.OSFamily.WINDOWS && this.hostInfo.getShell() == null) {
                    throw new IOException(TerminalLocalNativeProcess.loc("NativeProcess.shellNotFound.text", new String[0]));
                }
                String string = this.info.getCommandLineForShell();
                String string2 = this.info.getWorkingDirectory(true);
                File file4 = string2 == null ? new File(".") : new File(string2);
                file3 = File.createTempFile("dlight", "termexec", this.hostInfo.getTempDirFile()).getAbsoluteFile();
                file2 = new File(file3.getPath() + ".env");
                file = new File(file3.getPath() + ".sh");
                this.resultFile = new File(file.getPath() + ".res");
                this.resultFile.deleteOnExit();
                String string3 = this.osFamily == HostInfo.OSFamily.WINDOWS ? WindowsSupport.getInstance().convertToShellPath(file3.getPath()) : file3.getPath();
                String string4 = string3 + ".env";
                String string5 = string3 + ".sh";
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write("echo $$ > \"" + string3 + "\" || exit $?\n");
                fileWriter.write(". \"" + string4 + "\" 2>/dev/null\n");
                fileWriter.write("exec " + string + "\n");
                fileWriter.flush();
                fileWriter.close();
                ExternalTerminalAccessor externalTerminalAccessor = ExternalTerminalAccessor.getDefault();
                if (externalTerminalAccessor.getTitle(this.terminal) == null) {
                    this.terminal = this.terminal.setTitle(string);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(Arrays.asList(dorunScript.getAbsolutePath(), "-p", externalTerminalAccessor.getPrompt(this.terminal), "-x", string5));
                List<String> list = externalTerminalAccessor.wrapCommand(this.info.getExecutionEnvironment(), this.terminal, arrayList);
                ProcessBuilder processBuilder = new ProcessBuilder(list);
                processBuilder.directory(file4);
                LOG.log(Level.FINEST, "Command: " + list);
                MacroMap macroMap = this.info.getEnvironment().clone();
                if (this.osFamily == HostInfo.OSFamily.MACOSX) {
                    object2 = new ProcessBuilder("/bin/sh", "-c", "/bin/echo $DISPLAY");
                    object = ((ProcessBuilder)object2).start();
                    n = ((Process)object).waitFor();
                    String string6 = null;
                    if (n == 0) {
                        string6 = ProcessUtils.readProcessOutputLine((Process)object);
                    }
                    if (string6 == null || "".equals(string6)) {
                        string6 = ":0.0";
                    }
                    processBuilder.environment().put("DISPLAY", string6);
                }
                macroMap.appendPathVariable("PATH", this.hostInfo.getPath());
                if (!macroMap.isEmpty()) {
                    if (this.osFamily == HostInfo.OSFamily.WINDOWS) {
                        macroMap.put("PATH", "/bin:/usr/bin:" + WindowsSupport.getInstance().convertToAllShellPaths(macroMap.get("PATH")));
                    }
                    object2 = new FileOutputStream(file2);
                    object = new EnvWriter((OutputStream)object2);
                    ((EnvWriter)object).write(macroMap);
                    ((OutputStream)object2).close();
                    boolean bl = false;
                    for (n = 10; n > 0 && !(bl = HostInfoUtils.fileExists(ExecutionEnvironmentFactory.getLocal(), file.getPath()) & HostInfoUtils.fileExists(ExecutionEnvironmentFactory.getLocal(), file2.getPath())); --n) {
                        LOG.warning("env or sh file is not available yet... waiting [" + n + "]");
                        Thread.sleep(50L);
                    }
                    if (LOG.isLoggable(Level.FINEST)) {
                        macroMap.dump(System.err);
                    }
                }
                this.processError = new ByteArrayInputStream(new byte[0]);
                object2 = processBuilder.start();
                this.creation_ts = System.nanoTime();
                this.waitPID((Process)object2, file3);
                if (this.isInterrupted()) {
                    this.cancel();
                    throw new IOException(TerminalLocalNativeProcess.loc("TerminalLocalNativeProcess.terminalRunCancelled.text", new String[0]));
                }
                Object var21_23 = null;
                if (file3 != null) {
                    file3.delete();
                }
            }
            catch (Throwable throwable) {
                String string = (throwable.getMessage() == null ? throwable.toString() : throwable.getMessage()) + "\n";
                this.processError = new ByteArrayInputStream(string.getBytes());
                this.resultFile = null;
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var21_24 = null;
            if (file3 != null) {
                file3.delete();
            }
            if (file2 != null) {
                file2.delete();
            }
            if (file == null) throw throwable;
            file.delete();
            throw throwable;
        }
        if (file2 != null) {
            file2.delete();
        }
        if (file == null) return;
        file.delete();
    }

    private int getPIDNoException() {
        int n = -1;
        try {
            n = this.getPID();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public void cancel() {
        int n = this.getPIDNoException();
        if (n < 0) {
            return;
        }
        CommonTasksSupport.sendSignal(this.info.getExecutionEnvironment(), n, Signal.SIGTERM, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int waitResult() throws InterruptedException {
        int n = this.getPIDNoException();
        if (n < 0) {
            return -1;
        }
        if (this.osFamily == HostInfo.OSFamily.LINUX || this.osFamily == HostInfo.OSFamily.SUNOS) {
            File file = new File("/proc/" + n);
            while (file.exists()) {
                Thread.sleep(300L);
            }
        } else {
            int n2 = 0;
            while (n2 == 0) {
                try {
                    n2 = CommonTasksSupport.sendSignal(this.info.getExecutionEnvironment(), n, Signal.NULL, null).get();
                }
                catch (ExecutionException executionException) {
                    log.log(Level.FINEST, "", executionException);
                    n2 = -1;
                }
                Thread.sleep(300L);
            }
        }
        if (this.resultFile == null) {
            return -1;
        }
        int n3 = -1;
        BufferedReader bufferedReader = null;
        int n4 = 10;
        while (n4-- > 0) {
            if (this.resultFile.exists() && this.resultFile.length() > 0L) {
                bufferedReader = new BufferedReader(new FileReader(this.resultFile));
                String string = bufferedReader.readLine();
                if (string == null) break;
                n3 = Integer.parseInt(string.trim());
                break;
            }
            Thread.sleep(500L);
        }
        Object var7_12 = null;
        if (bufferedReader == null) return n3;
        try {
            bufferedReader.close();
            return n3;
        }
        catch (IOException iOException) {}
        return n3;
        {
            catch (InterruptedIOException interruptedIOException) {
                throw new InterruptedException();
            }
            catch (IOException iOException) {
                Object var7_13 = null;
                if (bufferedReader == null) return n3;
                try {
                    bufferedReader.close();
                    return n3;
                }
                catch (IOException iOException2) {}
                return n3;
            }
            catch (NumberFormatException numberFormatException) {
                Object var7_14 = null;
                if (bufferedReader == null) return n3;
                try {
                    bufferedReader.close();
                    return n3;
                }
                catch (IOException iOException) {}
                return n3;
            }
        }
        catch (Throwable throwable) {
            Object var7_15 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public OutputStream getOutputStream() {
        return null;
    }

    public InputStream getInputStream() {
        return this.processOutput;
    }

    public InputStream getErrorStream() {
        return this.processError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitPID(Process process, File file) throws IOException {
        while (!this.isInterrupted()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                break;
            }
            if (file.exists() && file.length() > 0L) {
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    this.readPID(fileInputStream);
                    Object var5_7 = null;
                    if (fileInputStream == null) break;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                    }
                    throw throwable;
                }
                ((InputStream)fileInputStream).close();
                {
                    break;
                }
            }
            try {
                int n = process.exitValue();
                if (n != 0) {
                    String string = ProcessUtils.readProcessErrorLine(process);
                    log.info(TerminalLocalNativeProcess.loc("TerminalLocalNativeProcess.terminalFailed.text", new String[0]));
                    log.info(string);
                    throw new IOException(string);
                }
                break;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
        }
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(TerminalLocalNativeProcess.class, (String)string, (Object[])stringArray);
    }

    static {
        InstalledFileLocator installedFileLocator = InstalledFileLocatorProvider.getDefault();
        File file = installedFileLocator.locate("bin/nativeexecution/dorun.sh", null, false);
        if (file == null) {
            log.severe("Unable to locate bin/nativeexecution/dorun.sh file!");
        } else if (!Utilities.isWindows()) {
            CommonTasksSupport.chmod(ExecutionEnvironmentFactory.getLocal(), file.getAbsolutePath(), 493, null);
        }
        dorunScript = file;
    }
}

