/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.Collection;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.ListenerManager;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.openide.ErrorManager;
import org.openide.util.Mutex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransactionManager {
    private final DesignDocument document;
    private final DescriptorRegistry descriptorRegistry;
    private final ListenerManager listenerManager;
    private final Mutex mutex = new Mutex();
    private boolean notRootLevelWriteAccess = false;
    private boolean assertEventAllowed = false;
    private boolean rollback = false;
    private boolean useUndoManager = false;
    private boolean discardAllEdits = false;
    private TransactionEdit transactionEdit;

    TransactionManager(DesignDocument designDocument, DescriptorRegistry descriptorRegistry, ListenerManager listenerManager) {
        assert (Debug.isFriend(DesignDocument.class, "<init>"));
        this.document = designDocument;
        this.descriptorRegistry = descriptorRegistry;
        this.listenerManager = listenerManager;
    }

    public void readAccess(final Runnable runnable) {
        this.descriptorRegistry.readAccess(new Runnable(){

            public void run() {
                TransactionManager.this.mutex.readAccess(runnable);
            }
        });
    }

    public long writeAccess(final Runnable runnable) {
        final long[] lArray = new long[]{0L};
        this.descriptorRegistry.readAccess(new Runnable(){

            public void run() {
                TransactionManager.this.mutex.writeAccess(new Runnable(){

                    public void run() {
                        TransactionManager.this.writeAccessCore(runnable);
                        lArray[0] = TransactionManager.this.listenerManager.getEventID();
                    }
                });
            }
        });
        return lArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAccessCore(Runnable runnable) {
        boolean bl = !this.notRootLevelWriteAccess;
        this.notRootLevelWriteAccess = true;
        if (bl) {
            this.writeAccessRootBegin();
        }
        try {
            runnable.run();
        }
        finally {
            if (bl) {
                this.writeAccessRootEnd();
            }
        }
    }

    private void writeAccessRootBegin() {
        this.assertEventAllowed = true;
        this.rollback = false;
        this.useUndoManager = true;
        this.discardAllEdits = false;
        this.transactionEdit = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAccessRootEnd() {
        Object v1;
        this.assertEventAllowed = false;
        DesignEvent designEvent = null;
        try {
            if (this.rollback) {
                this.rollbackCore();
            }
            designEvent = this.listenerManager.fireEvent();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var3_3 = null;
            try {
                if (this.useUndoManager) {
                    if (this.discardAllEdits) {
                        this.document.getDocumentInterface().discardAllEdits();
                    } else if (this.transactionEdit != null) {
                        this.transactionEdit.end();
                        this.document.getDocumentInterface().undoableEditHappened(this.transactionEdit);
                    }
                }
                v0 = null;
            }
            catch (Throwable throwable2) {
                v0 = null;
            }
            Object var5_7 = v0;
            this.notRootLevelWriteAccess = false;
            if (designEvent != null && designEvent.isStructureChanged()) {
                this.document.getDocumentInterface().notifyModified();
            }
            throw throwable;
        }
        try {
            if (this.useUndoManager) {
                if (this.discardAllEdits) {
                    this.document.getDocumentInterface().discardAllEdits();
                } else if (this.transactionEdit != null) {
                    this.transactionEdit.end();
                    this.document.getDocumentInterface().undoableEditHappened(this.transactionEdit);
                }
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            v1 = null;
        }
        Object var5_6 = v1;
        this.notRootLevelWriteAccess = false;
        if (designEvent != null && designEvent.isStructureChanged()) {
            this.document.getDocumentInterface().notifyModified();
        }
    }

    public boolean isAccess() {
        return this.mutex.isReadAccess() || this.mutex.isWriteAccess();
    }

    public boolean isWriteAccess() {
        return this.mutex.isWriteAccess();
    }

    public void rollback() {
        assert (this.assertEventAllowed);
        this.rollback = true;
        this.useUndoManager = false;
    }

    private void rollbackCore() {
        if (this.discardAllEdits) {
            ErrorManager.getDefault().log(65536, "Cannot rollback operation");
            return;
        }
        ErrorManager.getDefault().log(65536, "Rollback is not supported");
    }

    void rootChangeHappened(DesignComponent designComponent) {
        assert (Debug.isFriend(DesignDocument.class, "setRootComponent"));
        assert (this.assertEventAllowed);
        this.listenerManager.addAffectedComponentHierarchy(designComponent);
        this.discardAllEdits = true;
    }

    void componentDescriptorChangeHappened(DesignComponent designComponent, Collection<? extends Presenter> collection, Collection<Presenter> collection2, boolean bl) {
        assert (Debug.isFriend(DesignComponent.class, "setComponentDescriptor"));
        assert (this.assertEventAllowed);
        this.listenerManager.addComponentDescriptorChanged(designComponent, collection, collection2);
        if (bl) {
            this.discardAllEdits = true;
        }
    }

    void parentChangeHappened(DesignComponent designComponent, DesignComponent designComponent2, DesignComponent designComponent3) {
        assert (Debug.isFriend(DesignComponent.class, "addComponent") || Debug.isFriend(DesignComponent.class, "removeComponent"));
        assert (this.assertEventAllowed);
        this.listenerManager.addAffectedComponentHierarchy(designComponent);
        this.listenerManager.addAffectedComponentHierarchy(designComponent2);
        this.listenerManager.addAffectedComponentHierarchy(designComponent3);
        this.undoableEditHappened(new SetParentEdit(designComponent, designComponent2, designComponent3));
    }

    void writePropertyHappened(DesignComponent designComponent, String string, PropertyValue propertyValue, PropertyValue propertyValue2) {
        assert (Debug.isFriend(DesignComponent.class, "writeProperty"));
        assert (this.assertEventAllowed);
        this.listenerManager.addAffectedDesignComponent(designComponent, string, propertyValue);
        this.undoableEditHappened(new WritePropertyEdit(designComponent, string, propertyValue, propertyValue2));
    }

    void selectComponentsHappened(Collection<DesignComponent> collection, Collection<DesignComponent> collection2) {
        assert (Debug.isFriend(DesignDocument.class, "setSelectedComponents"));
        assert (this.assertEventAllowed);
        this.listenerManager.setSelectionChanged();
        this.undoableEditHappened(new SelectionEdit(this.document, collection, collection2));
    }

    public void undoableEditHappened(UndoableEdit undoableEdit) {
        assert (this.isWriteAccess());
        assert (!undoableEdit.isSignificant());
        if (this.transactionEdit == null) {
            this.transactionEdit = new TransactionEdit();
        }
        this.transactionEdit.addEdit(undoableEdit);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SelectionEdit
    extends AbstractUndoableEdit {
        private DesignDocument document;
        private Collection<DesignComponent> oldSelection;
        private Collection<DesignComponent> newSelection;

        public SelectionEdit(DesignDocument designDocument, Collection<DesignComponent> collection, Collection<DesignComponent> collection2) {
            this.document = designDocument;
            this.oldSelection = collection;
            this.newSelection = collection2;
        }

        @Override
        public boolean isSignificant() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.document.setSelectedComponents(null, this.oldSelection);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.document.setSelectedComponents(null, this.newSelection);
        }
    }

    public class WritePropertyEdit
    extends AbstractUndoableEdit {
        private DesignComponent component;
        private String propertyName;
        private PropertyValue oldValue;
        private PropertyValue newValue;

        public WritePropertyEdit(DesignComponent designComponent, String string, PropertyValue propertyValue, PropertyValue propertyValue2) {
            this.component = designComponent;
            this.propertyName = string;
            this.oldValue = propertyValue;
            this.newValue = propertyValue2;
        }

        public boolean isSignificant() {
            return false;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.component.writeProperty(this.propertyName, this.oldValue);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.component.writeProperty(this.propertyName, this.newValue);
        }
    }

    public class SetParentEdit
    extends AbstractUndoableEdit {
        private DesignComponent oldParent;
        private DesignComponent newParent;
        private DesignComponent child;

        public SetParentEdit(DesignComponent designComponent, DesignComponent designComponent2, DesignComponent designComponent3) {
            this.oldParent = designComponent;
            this.newParent = designComponent2;
            this.child = designComponent3;
        }

        public boolean isSignificant() {
            return false;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (this.newParent != null) {
                this.newParent.removeComponent(this.child);
            }
            if (this.oldParent != null) {
                this.oldParent.addComponent(this.child);
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (this.oldParent != null) {
                this.oldParent.removeComponent(this.child);
            }
            if (this.newParent != null) {
                this.newParent.addComponent(this.child);
            }
        }
    }

    private class TransactionEdit
    extends CompoundEdit {
        private TransactionEdit() {
        }

        public boolean isSignificant() {
            return true;
        }

        public void undo() throws CannotUndoException {
            final boolean[] blArray = new boolean[1];
            TransactionManager.this.writeAccess(new Runnable(){

                public void run() {
                    TransactionManager.this.useUndoManager = false;
                    try {
                        TransactionEdit.super.undo();
                    }
                    catch (CannotUndoException cannotUndoException) {
                        blArray[0] = true;
                        ErrorManager.getDefault().notify(65536, (Throwable)cannotUndoException);
                    }
                }
            });
            if (blArray[0]) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotRedoException {
            final boolean[] blArray = new boolean[1];
            TransactionManager.this.writeAccess(new Runnable(){

                public void run() {
                    TransactionManager.this.useUndoManager = false;
                    try {
                        TransactionEdit.super.redo();
                    }
                    catch (CannotRedoException cannotRedoException) {
                        blArray[0] = true;
                        ErrorManager.getDefault().notify(65536, (Throwable)cannotRedoException);
                    }
                }
            });
            if (blArray[0]) {
                throw new CannotRedoException();
            }
        }
    }
}

