/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.ComponentSerializationSupport;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DescriptorRegistryListener;
import org.netbeans.modules.vmd.api.model.PropertiesProcessor;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.TypeDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.model.XMLComponentDescriptor;
import org.netbeans.modules.vmd.model.XMLComponentProducer;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GlobalDescriptorRegistry {
    private static final HashMap<String, WeakReference<GlobalDescriptorRegistry>> registries = new HashMap();
    private final String projectType;
    private final DataFolder registryFolder;
    private final DataFolder producersFolder;
    private final Mutex mutex = new Mutex();
    private HashMap<TypeID, ComponentDescriptor> descriptors = new HashMap();
    private ArrayList<ComponentProducer> producers = new ArrayList();
    private Map<TypeID, WeakReference<FileObject>> customFileObjects = new HashMap<TypeID, WeakReference<FileObject>>();
    private Map<TypeID, WeakReference<FileObject>> customProducerFileObjects = new HashMap<TypeID, WeakReference<FileObject>>();
    private final CopyOnWriteArraySet<DescriptorRegistryListener> listeners = new CopyOnWriteArraySet();
    private final HashMap<String, WeakReference<DescriptorRegistry>> projectID2projectRegistry = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GlobalDescriptorRegistry getGlobalDescriptorRegistry(String string) {
        assert (Debug.isFriend(DescriptorRegistry.class, "getDescriptorRegistry") || Debug.isFriend(ComponentSerializationSupport.class));
        HashMap<String, WeakReference<GlobalDescriptorRegistry>> hashMap = registries;
        synchronized (hashMap) {
            GlobalDescriptorRegistry globalDescriptorRegistry;
            WeakReference<GlobalDescriptorRegistry> weakReference = registries.get(string);
            GlobalDescriptorRegistry globalDescriptorRegistry2 = globalDescriptorRegistry = weakReference != null ? (GlobalDescriptorRegistry)weakReference.get() : null;
            if (globalDescriptorRegistry == null) {
                globalDescriptorRegistry = new GlobalDescriptorRegistry(string);
                registries.put(string, new WeakReference<GlobalDescriptorRegistry>(globalDescriptorRegistry));
            }
            return globalDescriptorRegistry;
        }
    }

    private GlobalDescriptorRegistry(String string) {
        assert (string != null && string.length() > 0) : "Invalid project-type: " + string;
        this.projectType = string;
        FileObject fileObject = FileUtil.getConfigFile((String)(string + "/components"));
        if (fileObject != null) {
            this.registryFolder = DataFolder.findFolder((FileObject)fileObject);
            this.registryFolder.getPrimaryFile().addFileChangeListener(new FileChangeListener(){

                public void fileFolderCreated(FileEvent fileEvent) {
                }

                public void fileDataCreated(FileEvent fileEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }

                public void fileChanged(FileEvent fileEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }

                public void fileDeleted(FileEvent fileEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }

                public void fileRenamed(FileRenameEvent fileRenameEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }

                public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }
            });
        } else {
            this.registryFolder = null;
        }
        FileObject fileObject2 = FileUtil.getConfigFile((String)(string + "/producers"));
        if (fileObject2 != null) {
            this.producersFolder = DataFolder.findFolder((FileObject)fileObject2);
            this.producersFolder.getPrimaryFile().addFileChangeListener(new FileChangeListener(){

                public void fileFolderCreated(FileEvent fileEvent) {
                }

                public void fileDataCreated(FileEvent fileEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }

                public void fileChanged(FileEvent fileEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }

                public void fileDeleted(FileEvent fileEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }

                public void fileRenamed(FileRenameEvent fileRenameEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }

                public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }
            });
        } else {
            this.producersFolder = null;
        }
        this.reload();
    }

    DataFolder getRegistryFolder() {
        assert (Debug.isFriend(ComponentSerializationSupport.class, "serializeComponentDescriptor") || Debug.isFriend(ComponentSerializationSupport.class, "refreshDescriptorRegistry"));
        return this.registryFolder;
    }

    DataFolder getProducersFolder() {
        assert (Debug.isFriend(ComponentSerializationSupport.class, "serializeComponentProducer") || Debug.isFriend(ComponentSerializationSupport.class, "refreshDescriptorRegistry"));
        return this.producersFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DescriptorRegistry getProjectRegistry(String string) {
        assert (Debug.isFriend(DescriptorRegistry.class, "getDescriptorRegistry"));
        HashMap<String, WeakReference<DescriptorRegistry>> hashMap = this.projectID2projectRegistry;
        synchronized (hashMap) {
            DescriptorRegistry descriptorRegistry;
            WeakReference<DescriptorRegistry> weakReference = this.projectID2projectRegistry.get(string);
            DescriptorRegistry descriptorRegistry2 = descriptorRegistry = weakReference != null ? (DescriptorRegistry)weakReference.get() : null;
            if (descriptorRegistry == null) {
                descriptorRegistry = new DescriptorRegistry(this);
                this.projectID2projectRegistry.put(string, new WeakReference<DescriptorRegistry>(descriptorRegistry));
            }
            return descriptorRegistry;
        }
    }

    void readAccess(Runnable runnable) {
        assert (Debug.isFriend(DescriptorRegistry.class) || Debug.isFriend(ComponentSerializationSupport.class, "runUnderDescriptorRegistryReadAccess"));
        this.mutex.readAccess(runnable);
    }

    void writeAccess(Runnable runnable) {
        assert (Debug.isFriend(DescriptorRegistry.class, "removeComponentDescriptor") || Debug.isFriend(ComponentSerializationSupport.class, "runUnderDescriptorRegistryWriteAccess"));
        this.mutex.writeAccess(runnable);
    }

    private void reloadLater() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                GlobalDescriptorRegistry.this.reload();
            }
        });
    }

    void reload() {
        this.mutex.writeAccess(new Runnable(){

            public void run() {
                GlobalDescriptorRegistry.this.reloadCore();
            }
        });
    }

    private void reloadCore() {
        Object object2;
        HashMap<TypeID, WeakReference<FileObject>> hashMap;
        ArrayList arrayList = new ArrayList();
        HashMap<TypeID, ComponentDescriptor> hashMap2 = new HashMap<TypeID, ComponentDescriptor>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        HashMap<TypeID, FileObject> hashMap3 = new HashMap<TypeID, FileObject>();
        HashMap<TypeID, FileObject> hashMap4 = new HashMap<TypeID, FileObject>();
        if (this.registryFolder != null) {
            hashMap = this.registryFolder.children();
            while (hashMap.hasMoreElements()) {
                DataObject object22 = (DataObject)hashMap.nextElement();
                object2 = this.dao2descriptor(object22, hashMap3);
                if (object2 == null) {
                    Debug.warning("No descriptor", object22.getPrimaryFile().getNameExt());
                    continue;
                }
                TypeDescriptor typeDescriptor = ((ComponentDescriptor)object2).getTypeDescriptor();
                if (typeDescriptor == null) {
                    Debug.warning("Null type descriptor", object2);
                    continue;
                }
                TypeID typeID = typeDescriptor.getThisType();
                if (hashMap2.containsKey(typeID)) {
                    Debug.warning("Duplicate descriptor", typeID);
                    continue;
                }
                ((ComponentDescriptor)object2).setSuperComponentDescriptor(null);
                ((ComponentDescriptor)object2).setPropertyDescriptors(null);
                arrayList.add(object2);
                hashMap2.put(typeID, (ComponentDescriptor)object2);
                ComponentProducer componentProducer = ComponentProducer.createDefault(object2);
                if (componentProducer == null) continue;
                arrayList2.add(componentProducer);
            }
        }
        for (ComponentDescriptor componentDescriptor : hashMap2.values()) {
            GlobalDescriptorRegistry.resolveDescriptor(this.projectType, hashMap2, componentDescriptor);
        }
        hashMap2 = new HashMap();
        for (ComponentDescriptor componentDescriptor : arrayList) {
            object2 = componentDescriptor.getTypeDescriptor();
            if (((TypeDescriptor)object2).getSuperType() != null && componentDescriptor.getSuperDescriptor() == null) {
                Debug.warning("Unresolved super descriptor", componentDescriptor);
                continue;
            }
            hashMap2.put(((TypeDescriptor)object2).getThisType(), componentDescriptor);
        }
        if (this.producersFolder != null) {
            hashMap = this.producersFolder.children();
            while (hashMap.hasMoreElements()) {
                DataObject dataObject = (DataObject)hashMap.nextElement();
                object2 = this.dao2producer(dataObject, hashMap4);
                if (object2 == null) {
                    Debug.warning("No producer", dataObject.getPrimaryFile().getNameExt());
                    continue;
                }
                arrayList2.add(object2);
            }
        }
        hashMap = new HashMap<TypeID, WeakReference<FileObject>>();
        for (Object object2 : hashMap3.keySet()) {
            if (!hashMap2.containsKey(object2)) continue;
            hashMap.put((TypeID)object2, new WeakReference(hashMap3.get(object2)));
        }
        HashMap<TypeID, WeakReference<FileObject>> hashMap5 = new HashMap<TypeID, WeakReference<FileObject>>();
        for (TypeID typeID : hashMap4.keySet()) {
            if (!hashMap2.containsKey(typeID)) continue;
            hashMap5.put(typeID, new WeakReference(hashMap4.get(typeID)));
        }
        this.descriptors = hashMap2;
        this.producers = arrayList2;
        this.customFileObjects = hashMap;
        this.customProducerFileObjects = hashMap5;
        for (DescriptorRegistryListener descriptorRegistryListener : this.listeners) {
            descriptorRegistryListener.descriptorRegistryUpdated();
        }
    }

    static void resolveDescriptor(String string, HashMap<TypeID, ComponentDescriptor> hashMap, ComponentDescriptor componentDescriptor) {
        GlobalDescriptorRegistry.resolveDescriptor(string, hashMap, new HashSet<TypeID>(), componentDescriptor);
    }

    private static void resolveDescriptor(String string, HashMap<TypeID, ComponentDescriptor> hashMap, HashSet<TypeID> hashSet, ComponentDescriptor componentDescriptor) {
        assert (Debug.isFriend(GlobalDescriptorRegistry.class) || Debug.isFriend(DescriptorRegistry.class));
        TypeID typeID = componentDescriptor.getTypeDescriptor().getThisType();
        if (typeID == null) {
            Debug.warning("Null TypeID", componentDescriptor);
            return;
        }
        if (hashSet.contains(typeID)) {
            Debug.warning("There is inheritance-loop in CD registry - cannot resolve descriptor", componentDescriptor);
            return;
        }
        hashSet.add(typeID);
        if (componentDescriptor.getPropertyDescriptors() != null) {
            return;
        }
        TypeID typeID2 = componentDescriptor.getTypeDescriptor().getSuperType();
        Collection<String> collection = componentDescriptor.getExcludedPropertyDescriptorNames();
        List<PropertyDescriptor> list = componentDescriptor.getDeclaredPropertyDescriptors();
        ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>();
        ComponentDescriptor componentDescriptor2 = null;
        if (typeID2 != null) {
            componentDescriptor2 = hashMap.get(typeID2);
            if (componentDescriptor2 == null) {
                Debug.warning("Cannot find super descriptor for TypeID", typeID2);
                return;
            }
            GlobalDescriptorRegistry.resolveDescriptor(string, hashMap, componentDescriptor2);
            if (!componentDescriptor2.getTypeDescriptor().isCanDerive()) {
                Debug.warning("Cannot derive from descriptor", componentDescriptor2);
                return;
            }
            Collection<PropertyDescriptor> collection2 = componentDescriptor2.getPropertyDescriptors();
            if (collection2 == null) {
                Debug.warning("Missing super property descriptors - cannot resolve descriptor", componentDescriptor);
                return;
            }
            block0: for (PropertyDescriptor object : collection2) {
                String string2 = object.getName();
                if (string2 == null) continue;
                if (collection != null) {
                    for (String string3 : collection) {
                        if (!string2.equals(string3)) continue;
                        continue block0;
                    }
                }
                if (list != null) {
                    for (PropertyDescriptor propertyDescriptor : list) {
                        if (!string2.equals(propertyDescriptor.getName())) continue;
                        continue block0;
                    }
                }
                arrayList.add(object);
            }
        }
        if (list != null) {
            block3: for (int i = 0; i < list.size(); ++i) {
                PropertyDescriptor propertyDescriptor = list.get(i);
                if (propertyDescriptor == null) {
                    Debug.warning("Null declared property descriptor", componentDescriptor);
                    continue;
                }
                String string4 = propertyDescriptor.getName();
                if (string4 == null) {
                    Debug.warning("Null declared property descriptor name", string4);
                    continue;
                }
                for (int j = 0; j < i; ++j) {
                    PropertyDescriptor propertyDescriptor2 = list.get(j);
                    if (propertyDescriptor2 != null && string4.equals(propertyDescriptor2.getName())) continue block3;
                }
                arrayList.add(propertyDescriptor);
            }
        }
        componentDescriptor.setSuperComponentDescriptor(componentDescriptor2);
        componentDescriptor.setPropertyDescriptors(null);
        PropertiesProcessor.postProcessDescriptor(string, componentDescriptor, arrayList);
        componentDescriptor.setPropertyDescriptors(arrayList);
    }

    private ComponentDescriptor dao2descriptor(DataObject dataObject, Map<TypeID, FileObject> map) {
        InstanceCookie.Of of = (InstanceCookie.Of)dataObject.getCookie(InstanceCookie.Of.class);
        if (of != null) {
            try {
                Object object = of.instanceCreate();
                if (object instanceof ComponentDescriptor) {
                    return (ComponentDescriptor)object;
                }
            }
            catch (IOException iOException) {
                Debug.warning(iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.warning(classNotFoundException);
            }
            Debug.warning("Instance is not ComponentDescriptor class");
            return null;
        }
        if (dataObject instanceof XMLDataObject) {
            ComponentDescriptor componentDescriptor = this.deserializeComponentDescriptorFromXML((XMLDataObject)dataObject);
            map.put(componentDescriptor.getTypeDescriptor().getThisType(), dataObject.getPrimaryFile());
            return componentDescriptor;
        }
        return null;
    }

    private ComponentProducer dao2producer(DataObject dataObject, Map<TypeID, FileObject> map) {
        InstanceCookie.Of of = (InstanceCookie.Of)dataObject.getCookie(InstanceCookie.Of.class);
        if (of != null) {
            try {
                Object object = of.instanceCreate();
                if (object instanceof ComponentProducer) {
                    return (ComponentProducer)object;
                }
            }
            catch (IOException iOException) {
                Debug.warning(iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.warning(classNotFoundException);
            }
            Debug.warning("Instance is not ComponentProducer class");
            return null;
        }
        if (dataObject instanceof XMLDataObject) {
            return this.deserializeComponentCreatorFromXML((XMLDataObject)dataObject, map);
        }
        return null;
    }

    private ComponentDescriptor deserializeComponentDescriptorFromXML(XMLDataObject xMLDataObject) {
        Document document;
        try {
            document = xMLDataObject.getDocument();
            if (document == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
        catch (SAXException sAXException) {
            ErrorManager.getDefault().notify((Throwable)sAXException);
            return null;
        }
        XMLComponentDescriptor xMLComponentDescriptor = new XMLComponentDescriptor();
        if (xMLComponentDescriptor.deserialize(this.projectType, document)) {
            return xMLComponentDescriptor;
        }
        Debug.warning("Error during deserialization", xMLDataObject.getPrimaryFile());
        return null;
    }

    private ComponentProducer deserializeComponentCreatorFromXML(XMLDataObject xMLDataObject, Map<TypeID, FileObject> map) {
        Document document;
        try {
            document = xMLDataObject.getDocument();
            if (document == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
        catch (SAXException sAXException) {
            ErrorManager.getDefault().notify((Throwable)sAXException);
            return null;
        }
        XMLComponentProducer xMLComponentProducer = XMLComponentProducer.deserialize(this.projectType, document);
        if (xMLComponentProducer != null) {
            map.put(xMLComponentProducer.getMainComponentTypeID(), xMLDataObject.getPrimaryFile());
            return xMLComponentProducer;
        }
        Debug.warning("Error during deserialization", xMLDataObject.getPrimaryFile());
        return null;
    }

    Collection<ComponentDescriptor> getComponentDescriptors() {
        return Collections.unmodifiableCollection(this.descriptors.values());
    }

    List<ComponentProducer> getComponentProducers() {
        return Collections.unmodifiableList(this.producers);
    }

    void addRegistryListener(DescriptorRegistryListener descriptorRegistryListener) {
        this.listeners.add(descriptorRegistryListener);
    }

    void removeRegistryListener(DescriptorRegistryListener descriptorRegistryListener) {
        this.listeners.remove(descriptorRegistryListener);
    }

    void removeComponentDescriptor(TypeID typeID) {
        FileObject fileObject;
        FileObject fileObject2;
        assert (Debug.isFriend(DescriptorRegistry.RemoveComponentDescriptorTask.class, "run"));
        WeakReference<FileObject> weakReference = this.customFileObjects.get(typeID);
        FileObject fileObject3 = fileObject2 = weakReference != null ? (FileObject)weakReference.get() : null;
        if (fileObject2 != null) {
            try {
                FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                    public void run() {
                        try {
                            fileObject2.delete();
                        }
                        catch (IOException iOException) {
                            throw Debug.error(iOException);
                        }
                    }
                });
            }
            catch (IOException iOException) {
                throw Debug.error(iOException);
            }
        }
        FileObject fileObject4 = fileObject = (weakReference = this.customProducerFileObjects.get(typeID)) != null ? (FileObject)weakReference.get() : null;
        if (fileObject != null) {
            try {
                FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                    public void run() {
                        try {
                            fileObject.delete();
                        }
                        catch (IOException iOException) {
                            throw Debug.error(iOException);
                        }
                    }
                });
            }
            catch (IOException iOException) {
                throw Debug.error(iOException);
            }
        }
    }
}

