/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.DesignListener;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PresenterEvent;
import org.netbeans.modules.vmd.api.model.PresenterListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DynamicPresenter
extends Presenter {
    private Listener listener;
    private State state = State.DISABLED;

    protected DynamicPresenter() {
    }

    final PresenterListener getPresenterListener() {
        return this.listener;
    }

    @Override
    final void setNotifyAttached(DesignComponent designComponent) {
        super.setNotifyAttached(designComponent);
        this.state = State.ADDING_DEPENDENCIES;
        this.notifyAttached(designComponent);
        this.state = State.DISABLED;
        DesignEventFilter designEventFilter = this.getEventFilter();
        if (designEventFilter != null) {
            if (this.listener == null) {
                this.listener = new Listener();
            }
            designComponent.getDocument().getListenerManager().addDesignListener(this.listener, designEventFilter);
        }
    }

    @Override
    final void setNotifyDetached(DesignComponent designComponent) {
        super.setNotifyDetached(designComponent);
        if (this.listener != null) {
            designComponent.getDocument().getListenerManager().removeDesignListener(this.listener);
        }
        this.state = State.REMOVING_DEPENDENCIES;
        this.notifyDetached(designComponent);
        this.state = State.DISABLED;
    }

    protected abstract void notifyAttached(DesignComponent var1);

    protected abstract void notifyDetached(DesignComponent var1);

    protected abstract DesignEventFilter getEventFilter();

    protected abstract void designChanged(DesignEvent var1);

    protected abstract void presenterChanged(PresenterEvent var1);

    protected final void firePresenterChanged() {
        DesignComponent designComponent = this.getComponent();
        assert (designComponent != null);
        DesignDocument designDocument = designComponent.getDocument();
        assert (designDocument != null);
        assert (designDocument.getTransactionManager().isWriteAccess());
        assert (this.state == State.FIRING_PRESENTER_CHANGED);
        designDocument.getListenerManager().firePresenterChanged(this);
    }

    protected final void addDependency(DesignComponent designComponent, Class<? extends Presenter> clazz) {
        assert (this.state == State.ADDING_DEPENDENCIES);
        if (this.listener == null) {
            this.listener = new Listener();
        }
        designComponent.getDocument().getListenerManager().addPresenterListener(designComponent, clazz, this.listener);
    }

    protected final void removeDependency(DesignComponent designComponent, Class<? extends Presenter> clazz) {
        assert (this.state == State.REMOVING_DEPENDENCIES);
        if (this.listener != null) {
            designComponent.getDocument().getListenerManager().removePresenterListener(designComponent, clazz, this.listener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        DISABLED,
        FIRING_PRESENTER_CHANGED,
        ADDING_DEPENDENCIES,
        REMOVING_DEPENDENCIES;

    }

    private class Listener
    implements DesignListener,
    PresenterListener {
        private Listener() {
        }

        public void designChanged(DesignEvent designEvent) {
            DynamicPresenter.this.state = State.FIRING_PRESENTER_CHANGED;
            DynamicPresenter.this.designChanged(designEvent);
            DynamicPresenter.this.state = State.DISABLED;
        }

        public void presenterChanged(PresenterEvent presenterEvent) {
            DynamicPresenter.this.state = State.FIRING_PRESENTER_CHANGED;
            DynamicPresenter.this.presenterChanged(presenterEvent);
            DynamicPresenter.this.state = State.DISABLED;
        }

        public String toString() {
            return DynamicPresenter.this.toString();
        }
    }
}

