/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.ListenerManager;

public final class DesignEventFilter {
    private DesignEventFilter[] childFilters;
    private boolean global;
    private boolean creation;
    private boolean selection;
    private final ArrayList<ComponentItem> components = new ArrayList();
    private final ArrayList<HierarchyItem> hierarchy = new ArrayList();
    private final ArrayList<DescentItem> descents = new ArrayList();
    private final ArrayList<ParentItem> parents = new ArrayList();
    private final ArrayList<Long> descriptors = new ArrayList();

    public DesignEventFilter(DesignEventFilter ... designEventFilterArray) {
        assert (this.constructorAssert(designEventFilterArray));
        this.childFilters = designEventFilterArray;
    }

    private boolean constructorAssert(DesignEventFilter ... designEventFilterArray) {
        for (DesignEventFilter designEventFilter : designEventFilterArray) {
            assert (designEventFilter != null);
        }
        return true;
    }

    public DesignEventFilter setGlobal(boolean bl) {
        this.global = bl;
        return this;
    }

    public DesignEventFilter setCreation(boolean bl) {
        this.creation = bl;
        return this;
    }

    public DesignEventFilter setSelection(boolean bl) {
        this.selection = bl;
        return this;
    }

    public DesignEventFilter addComponentFilter(DesignComponent designComponent, boolean bl) {
        ComponentItem componentItem = new ComponentItem();
        componentItem.componentID = designComponent.getComponentID();
        componentItem.includingChildren = bl;
        this.components.add(componentItem);
        return this;
    }

    public DesignEventFilter removeComponentFilter(DesignComponent designComponent, boolean bl) {
        long l = designComponent.getComponentID();
        Iterator<ComponentItem> iterator = this.components.iterator();
        while (iterator.hasNext()) {
            ComponentItem componentItem = iterator.next();
            if (componentItem.componentID != l || componentItem.includingChildren != bl) continue;
            iterator.remove();
            break;
        }
        return this;
    }

    public DesignEventFilter addHierarchyFilter(DesignComponent designComponent, boolean bl) {
        HierarchyItem hierarchyItem = new HierarchyItem();
        hierarchyItem.componentID = designComponent.getComponentID();
        hierarchyItem.includingChildren = bl;
        this.hierarchy.add(hierarchyItem);
        return this;
    }

    public DesignEventFilter removeHierarchyFilter(DesignComponent designComponent, boolean bl) {
        long l = designComponent.getComponentID();
        Iterator<HierarchyItem> iterator = this.hierarchy.iterator();
        while (iterator.hasNext()) {
            HierarchyItem hierarchyItem = iterator.next();
            if (hierarchyItem.componentID != l || hierarchyItem.includingChildren != bl) continue;
            iterator.remove();
            break;
        }
        return this;
    }

    public DesignEventFilter addParentFilter(DesignComponent designComponent, int n, boolean bl) {
        ParentItem parentItem = new ParentItem();
        parentItem.componentID = designComponent.getComponentID();
        parentItem.levels = n;
        parentItem.hierarchyOnly = bl;
        this.parents.add(parentItem);
        return this;
    }

    public DesignEventFilter removeParentFilter(DesignComponent designComponent, int n, boolean bl) {
        long l = designComponent.getComponentID();
        Iterator<ParentItem> iterator = this.parents.iterator();
        while (iterator.hasNext()) {
            ParentItem parentItem = iterator.next();
            if (parentItem.componentID != l || parentItem.levels != n || parentItem.hierarchyOnly != bl) continue;
            iterator.remove();
            break;
        }
        return this;
    }

    public DesignEventFilter addDescentFilter(DesignComponent designComponent, String string) {
        DescentItem descentItem = new DescentItem();
        descentItem.componentID = designComponent.getComponentID();
        descentItem.propertyName = string;
        this.descents.add(descentItem);
        return this;
    }

    public DesignEventFilter removeDescentFilter(DesignComponent designComponent, String string) {
        long l = designComponent.getComponentID();
        Iterator<DescentItem> iterator = this.descents.iterator();
        while (iterator.hasNext()) {
            DescentItem descentItem = iterator.next();
            if (descentItem.componentID != l || !descentItem.propertyName.equals(string)) continue;
            iterator.remove();
            break;
        }
        return this;
    }

    public DesignEventFilter addDescriptorFilter(DesignComponent designComponent) {
        this.descriptors.add(designComponent.getComponentID());
        return this;
    }

    public DesignEventFilter removeDescriptorFilter(DesignComponent designComponent) {
        this.descriptors.remove(designComponent.getComponentID());
        return this;
    }

    boolean isGlobal() {
        return this.global;
    }

    /*
     * WARNING - void declaration
     */
    boolean isAffected(DesignDocument designDocument, DesignEvent designEvent) {
        Object object;
        DesignComponent designComponent;
        void var6_14;
        Object object3;
        assert (Debug.isFriend(ListenerManager.class, "fireEventCore") || Debug.isFriend(DesignEventFilter.class, "isAffected"));
        boolean bl = false;
        for (DescentItem object4 : this.descents) {
            DesignComponent set2 = designDocument.getComponentByUID(object4.componentID);
            if (set2 == null || !designEvent.isComponentPropertyChanged(set2, object4.propertyName)) continue;
            object4.components = null;
            bl = true;
        }
        if (!this.parents.isEmpty()) {
            object3 = designEvent.getFullyAffectedHierarchies();
            block1: for (ParentItem parentItem : this.parents) {
                DesignComponent designComponent2 = designDocument.getComponentByUID(parentItem.componentID);
                if (designComponent2 == null || parentItem.components == null) continue;
                for (Object object2 : parentItem.components) {
                    if (!object3.contains(object2)) continue;
                    parentItem.components = null;
                    bl = true;
                    continue block1;
                }
            }
        }
        object3 = this.childFilters;
        int n = ((DesignEventFilter[])object3).length;
        boolean bl2 = false;
        while (var6_14 < n) {
            DesignEventFilter designEventFilter = object3[var6_14];
            if (designEventFilter.isAffected(designDocument, designEvent)) {
                return true;
            }
            ++var6_14;
        }
        if (bl) {
            return true;
        }
        if (this.global) {
            return true;
        }
        if (this.creation && !designEvent.getCreatedComponents().isEmpty()) {
            return true;
        }
        if (this.selection && designEvent.isSelectionChanged()) {
            return true;
        }
        object3 = designEvent.getFullyAffectedComponents();
        Set<DesignComponent> set = designEvent.getPartlyAffectedComponents();
        Set<DesignComponent> set2 = designEvent.getFullyAffectedHierarchies();
        Set<DesignComponent> set3 = designEvent.getPartlyAffectedHierarchies();
        Set<DesignComponent> set4 = designEvent.getDescriptorChangedComponents();
        for (ComponentItem componentItem : this.components) {
            designComponent = designDocument.getComponentByUID(componentItem.componentID);
            if (designComponent == null) continue;
            if (object3.contains(designComponent)) {
                return true;
            }
            if (!componentItem.includingChildren || !set.contains(designComponent)) continue;
            return true;
        }
        for (HierarchyItem hierarchyItem : this.hierarchy) {
            designComponent = designDocument.getComponentByUID(hierarchyItem.componentID);
            if (designComponent == null) continue;
            if (set2.contains(designComponent)) {
                return true;
            }
            if (!hierarchyItem.includingChildren || !set3.contains(designComponent)) continue;
            return true;
        }
        for (Long l : this.descriptors) {
            designComponent = designDocument.getComponentByUID(l);
            if (designComponent == null || !set4.contains(designComponent)) continue;
            return true;
        }
        for (DescentItem descentItem : this.descents) {
            designComponent = designDocument.getComponentByUID(descentItem.componentID);
            if (designComponent == null) continue;
            if (descentItem.components == null) {
                object = designComponent.readProperty(descentItem.propertyName);
                Debug.collectAllComponentReferences(object, descentItem.components = new HashSet());
            }
            for (DesignComponent designComponent3 : descentItem.components) {
                if (!object3.contains(designComponent3)) continue;
                return true;
            }
        }
        for (ParentItem parentItem : this.parents) {
            designComponent = designDocument.getComponentByUID(parentItem.componentID);
            if (designComponent == null) continue;
            if (parentItem.components == null) {
                object = designComponent;
                parentItem.components = new ArrayList();
                for (int i = 0; i <= parentItem.levels; ++i) {
                    parentItem.components.add(object);
                    if (object == null) break;
                    object = ((DesignComponent)object).getParentComponent();
                }
            }
            for (DesignComponent designComponent4 : parentItem.components) {
                if (set2.contains(designComponent4)) {
                    return true;
                }
                if (parentItem.hierarchyOnly || !object3.contains(designComponent4)) continue;
                return true;
            }
        }
        return false;
    }

    private static final class ParentItem {
        private long componentID;
        private int levels;
        private ArrayList<DesignComponent> components;
        public boolean hierarchyOnly;

        private ParentItem() {
        }
    }

    private static final class DescentItem {
        private long componentID;
        private String propertyName;
        private HashSet<DesignComponent> components;

        private DescentItem() {
        }
    }

    private static final class HierarchyItem {
        private long componentID;
        private boolean includingChildren;

        private HierarchyItem() {
        }
    }

    private static final class ComponentItem {
        private long componentID;
        private boolean includingChildren;

        private ComponentItem() {
        }
    }
}

