/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.wizards;

import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.junit.TestUtil;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    private final Project project;
    private boolean sourceGroupsOnly = true;
    private SourceGroup[] javaSourceGroups;
    private Map<SourceGroup, Object[]> sourcesToTestsMap;
    private Map<FileObject, Object> foldersToSourceGroupsMap;

    public Utils(Project project) {
        this.project = project;
    }

    static FileObject findTestsRoot(Project project) {
        SourceGroup[] sourceGroupArray = new Utils(project).getJavaSourceGroups();
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            FileObject fileObject = sourceGroupArray[i].getRootFolder();
            if (!fileObject.getName().equals("test")) continue;
            return fileObject;
        }
        return null;
    }

    static FileObject getPackageFolder(FileObject fileObject, String string) throws IOException {
        String string2 = string.replace('.', '/');
        FileObject fileObject2 = fileObject.getFileObject(string2);
        if (fileObject2 == null) {
            fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)string2);
        }
        return fileObject2;
    }

    static Collection getTestTargets(Project project, boolean bl) {
        Utils utils = new Utils(project);
        return utils.getTestTargets(bl);
    }

    public static Collection<FileObject> getTestFolders(Project project) {
        return new Utils(project).getTestFolders();
    }

    static Map getSourcesToTestsMap(Project project, boolean bl) {
        Utils utils = new Utils(project);
        return utils.getSourcesToTestsMap(bl);
    }

    Project getProject() {
        return this.project;
    }

    private Collection<FileObject> getTestFolders() {
        SourceGroup[] sourceGroupArray = this.getJavaSourceGroups();
        if (sourceGroupArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<FileObject> arrayList = null;
        for (SourceGroup sourceGroup : sourceGroupArray) {
            FileObject fileObject = sourceGroup.getRootFolder();
            FileObject[] fileObjectArray = this.getTestFoldersRaw(fileObject);
            if (fileObjectArray.length == 0) continue;
            for (FileObject fileObject2 : fileObjectArray) {
                if (fileObject2 == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<FileObject>(2);
                }
                if (arrayList.contains(fileObject2)) continue;
                arrayList.add(fileObject2);
            }
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        assert (!arrayList.isEmpty());
        return arrayList.size() == 1 ? Collections.singleton(arrayList.get(0)) : arrayList;
    }

    private Collection<Object> getTestTargets(boolean bl) {
        SourceGroup[] sourceGroupArray = this.getJavaSourceGroups();
        if (sourceGroupArray.length == 0) {
            return Collections.emptyList();
        }
        this.createFoldersToSourceGroupsMap(sourceGroupArray);
        Object[] objectArray = new Object[sourceGroupArray.length];
        int n = 0;
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            Object[] objectArray2 = this.getTestTargets(sourceGroupArray[i], bl);
            n = Utils.merge(objectArray2, objectArray, n);
        }
        if (n != objectArray.length) {
            objectArray = TestUtil.skipNulls(objectArray, new Object[0]);
        }
        return Collections.unmodifiableCollection(Arrays.asList(objectArray));
    }

    Map<SourceGroup, Object[]> getSourcesToTestsMap() {
        if (this.sourcesToTestsMap == null) {
            this.sourcesToTestsMap = this.createSourcesToTestsMap(this.sourceGroupsOnly);
        }
        return this.sourcesToTestsMap;
    }

    Map<SourceGroup, Object[]> getSourcesToTestsMap(boolean bl) {
        if (bl != this.sourceGroupsOnly) {
            this.sourcesToTestsMap = null;
            this.sourceGroupsOnly = bl;
        }
        return this.getSourcesToTestsMap();
    }

    private Map<SourceGroup, Object[]> createSourcesToTestsMap(boolean bl) {
        Object object;
        int n;
        SourceGroup[] sourceGroupArray = this.getJavaSourceGroups();
        if (sourceGroupArray.length == 0) {
            return Collections.emptyMap();
        }
        this.createFoldersToSourceGroupsMap(sourceGroupArray);
        Object[] objectArray = new Object[sourceGroupArray.length];
        HashMap<SourceGroup, Object[]> hashMap = new HashMap<SourceGroup, Object[]>((int)((float)sourceGroupArray.length * 1.33f + 0.5f), 0.75f);
        for (n = 0; n < sourceGroupArray.length; ++n) {
            object = this.getTestTargets(sourceGroupArray[n], bl);
            if (((Object[])object).length == 0) continue;
            hashMap.put(sourceGroupArray[n], (Object[])object);
        }
        if (hashMap.isEmpty()) {
            return Collections.emptyMap();
        }
        if (hashMap.size() == 1) {
            Map.Entry entry = hashMap.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        n = hashMap.size();
        if (n >= sourceGroupArray.length - 5) {
            return hashMap;
        }
        object = new HashMap((int)((float)n * 1.25f + 0.5f), 0.8f);
        object.putAll(hashMap);
        return object;
    }

    private static int merge(Object[] objectArray, Object[] objectArray2, int n) {
        if (objectArray.length == 0) {
            return n;
        }
        if (n == 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            return objectArray.length;
        }
        int n2 = n;
        block0: for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            for (int j = 0; j < n2; ++j) {
                Object object2 = Utils.chooseTarget(objectArray2[j], object);
                if (object2 == null) continue;
                objectArray2[j] = object2;
                continue block0;
            }
            objectArray2[n2++] = object;
        }
        return n2;
    }

    private static Object chooseTarget(Object object, Object object2) {
        FileObject fileObject;
        boolean bl = object instanceof SourceGroup;
        boolean bl2 = object2 instanceof SourceGroup;
        assert (bl || object instanceof FileObject);
        assert (bl2 || object2 instanceof FileObject);
        if (bl && bl2 && object.equals(object2)) {
            return object;
        }
        FileObject fileObject2 = bl ? ((SourceGroup)object).getRootFolder() : (FileObject)object;
        FileObject fileObject3 = fileObject = bl2 ? ((SourceGroup)object2).getRootFolder() : (FileObject)object2;
        if (!fileObject2.isFolder()) {
            throw new IllegalArgumentException("target1: not a folder");
        }
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException("target2: not a folder");
        }
        if (fileObject2.equals(fileObject)) {
            return bl == bl2 ? object : (bl ? object : object2);
        }
        return null;
    }

    public Object[] getTestTargets(SourceGroup sourceGroup, boolean bl) {
        FileObject[] fileObjectArray = this.getTestFoldersRaw(sourceGroup.getRootFolder());
        if (fileObjectArray.length == 0) {
            return new Object[0];
        }
        Object[] objectArray = new Object[fileObjectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            FileObject fileObject = fileObjectArray[i];
            if (fileObject == null) continue;
            Object object = this.foldersToSourceGroupsMap.get(fileObject);
            objectArray[i] = object != null ? object : (bl ? null : fileObject);
        }
        return TestUtil.skipNulls(objectArray, new Object[0]);
    }

    public FileObject[] getTestFoldersRaw(FileObject fileObject) {
        return this.getFileObjects(UnitTestForSourceQuery.findUnitTests((FileObject)fileObject), true);
    }

    public FileObject[] getSourceFoldersRaw(FileObject fileObject) {
        return this.getFileObjects(UnitTestForSourceQuery.findSources((FileObject)fileObject), false);
    }

    private FileObject[] getFileObjects(URL[] uRLArray, boolean bl) {
        if (uRLArray.length == 0) {
            return new FileObject[0];
        }
        FileObject[] fileObjectArray = new FileObject[uRLArray.length];
        for (int i = 0; i < uRLArray.length; ++i) {
            fileObjectArray[i] = URLMapper.findFileObject((URL)uRLArray[i]);
            if (fileObjectArray[i] == null) {
                if (!ErrorManager.getDefault().isLoggable(1)) continue;
                ErrorManager.getDefault().log(1, (bl ? "Test" : "Source") + " directory " + uRLArray[i] + " declared by project " + ProjectUtils.getInformation((Project)this.project).getName() + " does not exist.");
                continue;
            }
            Project project = FileOwnerQuery.getOwner((FileObject)fileObjectArray[i]);
            if (this.project.equals(project)) continue;
            fileObjectArray[i] = null;
            int n = 1;
            if (!ErrorManager.getDefault().isNotifiable(n)) continue;
            ErrorManager.getDefault().notify(n, (Throwable)new IllegalStateException("Malformed project: Found test root (" + uRLArray[i] + ')' + ' ' + (project == null ? "does not belong to any" : "belongs to a different") + " project."));
        }
        return fileObjectArray;
    }

    public static FileObject[] skipNulls(FileObject[] fileObjectArray) {
        if (fileObjectArray.length == 0) {
            return fileObjectArray;
        }
        int n = 0;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (fileObjectArray[i] != null) continue;
            ++n;
        }
        if (n == 0) {
            return fileObjectArray;
        }
        if (n == fileObjectArray.length) {
            return new FileObject[0];
        }
        FileObject[] fileObjectArray2 = new FileObject[fileObjectArray.length - n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < fileObjectArray2.length) {
            FileObject fileObject;
            if ((fileObject = fileObjectArray[n2++]) == null) continue;
            fileObjectArray2[n3++] = fileObject;
        }
        return fileObjectArray2;
    }

    private void createFoldersToSourceGroupsMap(SourceGroup[] sourceGroupArray) {
        Map<FileObject, SourceGroup> map;
        if (sourceGroupArray.length == 0) {
            map = Collections.emptyMap();
        } else {
            map = new HashMap(2 * sourceGroupArray.length, 0.5f);
            for (SourceGroup sourceGroup : sourceGroupArray) {
                map.put(sourceGroup.getRootFolder(), sourceGroup);
            }
        }
        this.foldersToSourceGroupsMap = map;
    }

    public SourceGroup[] getJavaSourceGroups() {
        if (this.javaSourceGroups == null) {
            this.javaSourceGroups = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        }
        return this.javaSourceGroups;
    }

    private static SourceGroup findSourceGroup(SourceGroup[] sourceGroupArray, FileObject fileObject) {
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            if (!sourceGroupArray[i].getRootFolder().equals(fileObject)) continue;
            return sourceGroupArray[i];
        }
        return null;
    }

    static boolean isValidClassName(String string) {
        int n;
        if (string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        int n2 = 0;
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] != '.') continue;
            if (n == n2) {
                return false;
            }
            if (!Utilities.isJavaIdentifier((String)string.substring(n2, n))) {
                return false;
            }
            n2 = n + 1;
        }
        if (n == n2) {
            return false;
        }
        return Utilities.isJavaIdentifier((String)string.substring(n2, cArray.length));
    }

    public static void openFile(FileObject fileObject, int n) {
        block9: {
            if (fileObject == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null && fileObject == dataObject.getPrimaryFile()) {
                    if (n == -1) {
                        editorCookie.open();
                        break block9;
                    }
                    editorCookie.openDocument();
                    try {
                        Line line = editorCookie.getLineSet().getOriginal(n - 1);
                        if (!line.isDeleted()) {
                            line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                        }
                        break block9;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        editorCookie.open();
                    }
                    break block9;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify(16, (Throwable)dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(16, (Throwable)iOException);
            }
        }
    }
}

