/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.netbeans.modules.junit.TestCreator;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

final class TestabilityResult {
    private long reason;
    public static final TestabilityResult OK = new TestabilityResult(0L);
    public static final TestabilityResult PACKAGE_PRIVATE_CLASS = new TestabilityResult(1L);
    public static final TestabilityResult NO_TESTEABLE_METHODS = new TestabilityResult(2L);
    public static final TestabilityResult TEST_CLASS = new TestabilityResult(4L);
    public static final TestabilityResult ABSTRACT_CLASS = new TestabilityResult(8L);
    public static final TestabilityResult NONSTATIC_INNER_CLASS = new TestabilityResult(16L);
    public static final TestabilityResult EXCEPTION_CLASS = new TestabilityResult(32L);
    public static final TestabilityResult PRIVATE_CLASS = new TestabilityResult(64L);
    private static final String[] reasonBundleKeys = new String[]{"TestabilityResult_PkgPrivate", "TestabilityResult_NoTestableMethods", "TestabilityResult_TestClass", "TestabilityResult_AbstractClass", "TestabilityResult_NonstaticInnerClass", "TestabilityResult_ExceptionClass", "TestabilityResult_Private"};

    private TestabilityResult(long l) {
        this.reason = l;
    }

    public static TestabilityResult combine(TestabilityResult testabilityResult, TestabilityResult testabilityResult2) {
        return new TestabilityResult(testabilityResult.reason | testabilityResult2.reason);
    }

    public static TestabilityResult filter(TestabilityResult testabilityResult, long l) {
        return new TestabilityResult(testabilityResult.reason & l);
    }

    public boolean isTestable() {
        return this.reason == 0L;
    }

    public boolean isFailed() {
        return this.reason != 0L;
    }

    public long getReasonValue() {
        return this.reason;
    }

    public String getReason() {
        return this.getReason(", ", ", ");
    }

    public String toString() {
        return this.getReason(", ", ", ");
    }

    public String getReason(String string, String string2) {
        try {
            ResourceBundle resourceBundle = NbBundle.getBundle(TestCreator.class);
            if (this.reason == 0L) {
                return resourceBundle.getString("TestabilityResult_OK");
            }
            String string3 = "";
            boolean bl = true;
            long l = 0L;
            long l2 = this.reason;
            while (l2 > 0L) {
                if ((l2 & 1L) != 0L) {
                    if (string3.length() > 0) {
                        if (bl) {
                            string3 = string2 + string3;
                            bl = false;
                        } else {
                            string3 = string + string3;
                        }
                    }
                    string3 = resourceBundle.getString(reasonBundleKeys[(int)l]) + string3;
                }
                l2 >>= 1;
                ++l;
            }
            return string3;
        }
        catch (MissingResourceException missingResourceException) {
            ErrorManager.getDefault().notify((Throwable)missingResourceException);
            return "";
        }
    }

    static final class SkippedClass {
        final String clsName;
        final TestabilityResult reason;

        SkippedClass(String string, TestabilityResult testabilityResult) {
            this.clsName = string;
            this.reason = testabilityResult;
        }
    }
}

