/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.microedition.m2g.SVGImage;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.mobility.svgcore.util.Util;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorMessageAwareness;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGImageCD;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGMenuCD;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGComponentImageParser;
import org.netbeans.modules.vmd.midpnb.screen.display.SVGImageComponent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGImageEditorElement
extends PropertyEditorResourceElement
implements Runnable,
CleanUp {
    private static final String EXTENSION = "svg";
    private long componentID;
    private boolean doNotFireEvent;
    private String lastDir;
    private SVGImageComponent imageView;
    private DefaultComboBoxModel comboBoxModel;
    private Map<String, FileObject> paths;
    private final AtomicBoolean requiresModelUpdate = new AtomicBoolean(false);
    private PropertyEditorResourceElement.DesignComponentWrapper wrapper;
    private PropertyEditorMessageAwareness messageAwareness;
    private JButton chooserButton;
    private JLabel heightLabel;
    private JTextField heightTextField;
    private JLabel pathLabel;
    private JComboBox pathTextComboBox;
    private JLabel previewLabel;
    private JPanel previewPanel;
    private JProgressBar progressBar;
    private JLabel widthLabel;
    private JTextField widthTextField;

    public void clean(DesignComponent designComponent) {
        this.imageView = null;
        this.comboBoxModel = null;
        if (this.paths != null) {
            this.paths.clear();
            this.paths = null;
        }
        this.wrapper = null;
        this.messageAwareness = null;
        this.chooserButton = null;
        this.heightLabel = null;
        this.heightTextField = null;
        this.pathLabel = null;
        this.pathTextComboBox = null;
        this.previewLabel = null;
        this.previewPanel = null;
        this.progressBar = null;
        this.widthLabel = null;
        this.widthTextField = null;
        this.removeAll();
    }

    public SVGImageEditorElement() {
        this.paths = new HashMap<String, FileObject>();
        this.comboBoxModel = new DefaultComboBoxModel();
        this.initComponents();
        this.progressBar.setVisible(false);
        this.imageView = new SVGImageComponent();
        this.previewPanel.add((Component)this.imageView, "Center");
    }

    public void setPropertyEditorMessageAwareness(PropertyEditorMessageAwareness propertyEditorMessageAwareness) {
        this.messageAwareness = propertyEditorMessageAwareness;
    }

    public JComponent getJComponent() {
        return this;
    }

    public TypeID getTypeID() {
        return SVGImageCD.TYPEID;
    }

    public List<String> getPropertyValueNames() {
        return Arrays.asList("resourcePath");
    }

    public void setDesignComponentWrapper(PropertyEditorResourceElement.DesignComponentWrapper designComponentWrapper) {
        this.wrapper = designComponentWrapper;
        if (designComponentWrapper == null) {
            this.setText(null);
            this.setAllEnabled(false);
            return;
        }
        this.componentID = designComponentWrapper.getComponentID();
        final String[] stringArray = new String[1];
        final DesignComponent designComponent = designComponentWrapper.getComponent();
        if (designComponent != null) {
            if (!designComponent.getType().equals((Object)this.getTypeID())) {
                throw new IllegalArgumentException("Passed component must have typeID " + this.getTypeID() + " instead passed " + designComponent.getType());
            }
            this.componentID = designComponent.getComponentID();
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    PropertyValue propertyValue = designComponent.readProperty("resourcePath");
                    if (!PropertyEditorResourceElement.isPropertyValueAUserCodeType((PropertyValue)propertyValue)) {
                        stringArray[0] = MidpTypes.getString((PropertyValue)propertyValue);
                    }
                }
            });
        }
        if (designComponentWrapper.hasChanges()) {
            Map map = designComponentWrapper.getChanges();
            for (String string : map.keySet()) {
                PropertyValue propertyValue = (PropertyValue)map.get(string);
                if (!"resourcePath".equals(string)) continue;
                stringArray[0] = MidpTypes.getString((PropertyValue)propertyValue);
            }
        }
        this.setAllEnabled(true);
        this.setText(stringArray[0]);
    }

    public boolean isPostSetValueSupported(final DesignComponent designComponent) {
        final boolean[] blArray = new boolean[1];
        designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                blArray[0] = designComponent.getDocument().getDescriptorRegistry().isInHierarchy(SVGMenuCD.TYPEID, designComponent.getType()) && designComponent.readProperty("elements").getArray().size() == 0;
            }
        });
        return blArray[0];
    }

    public void postSetValue(final DesignComponent designComponent, final DesignComponent designComponent2) {
        final FileObject[] fileObjectArray = new FileObject[1];
        designComponent2.getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                PropertyValue propertyValue = designComponent2.readProperty("resourcePath");
                if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                    Map map = MidpProjectSupport.getFileObjectsForRelativeResourcePath((DesignDocument)designComponent.getDocument(), (String)MidpTypes.getString((PropertyValue)propertyValue));
                    Iterator iterator = map.keySet().iterator();
                    fileObjectArray[0] = iterator.hasNext() ? (FileObject)iterator.next() : null;
                }
            }
        });
        this.parseSVGImageItems(fileObjectArray[0], designComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSVGImageItems(FileObject fileObject, DesignComponent designComponent) {
        if (fileObject == null) {
            return;
        }
        SVGComponentImageParser sVGComponentImageParser = SVGComponentImageParser.getParserByComponent(designComponent);
        if (sVGComponentImageParser == null) {
            return;
        }
        InputStream inputStream = null;
        inputStream = fileObject.getInputStream();
        if (inputStream != null) {
            sVGComponentImageParser.parse(inputStream, designComponent);
        }
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            Debug.warning((Object[])new Object[]{iOException});
        }
        return;
        catch (FileNotFoundException fileNotFoundException) {
            try {
                Debug.warning((Object[])new Object[]{fileNotFoundException});
                if (inputStream == null) return;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    Debug.warning((Object[])new Object[]{iOException});
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                Debug.warning((Object[])new Object[]{iOException});
            }
            return;
        }
    }

    private void setText(String string) {
        if (string == null) {
            string = "";
        }
        this.addImage(string, true);
    }

    private void addImage(String string, boolean bl) {
        this.doNotFireEvent = true;
        if (this.comboBoxModel.getIndexOf(string) == -1) {
            this.comboBoxModel.addElement(string);
            this.sortComboBoxContent();
        }
        if (bl) {
            this.pathTextComboBox.setSelectedItem(string);
            if (this.comboBoxModel != null) {
                this.updatePreview();
            }
        }
        this.doNotFireEvent = false;
    }

    private void sortComboBoxContent() {
        int n = this.pathTextComboBox.getItemCount();
        ArrayList arrayList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.pathTextComboBox.getItemAt(i));
        }
        Collections.sort(arrayList, PropertyEditorResourceElement.StringComparator.instance);
        this.pathTextComboBox.removeAllItems();
        for (Object e : arrayList) {
            this.pathTextComboBox.addItem(e);
        }
    }

    void setAllEnabled(boolean bl) {
        this.pathLabel.setEnabled(bl);
        this.pathTextComboBox.setEnabled(bl);
        this.previewLabel.setEnabled(bl);
        this.previewPanel.setEnabled(bl);
        this.widthLabel.setEnabled(bl);
        this.widthTextField.setEnabled(bl);
        this.heightLabel.setEnabled(bl);
        this.heightTextField.setEnabled(bl);
        this.chooserButton.setEnabled(bl);
    }

    private void updateModel(DesignDocument designDocument) {
        boolean bl = this.pathTextComboBox.isEnabled();
        this.pathTextComboBox.setEnabled(false);
        this.doNotFireEvent = true;
        this.comboBoxModel.removeAllElements();
        this.doNotFireEvent = false;
        this.paths.clear();
        Map map = MidpProjectSupport.getAllFilesForProjectByExt((DesignDocument)designDocument, Collections.singleton(EXTENSION));
        for (Map.Entry entry : map.entrySet()) {
            this.checkFile((FileObject)entry.getKey(), (String)entry.getValue());
        }
        if (bl) {
            this.pathTextComboBox.setEnabled(true);
        }
    }

    private void checkFile(FileObject fileObject, String string) {
        String string2;
        if (EXTENSION.equals(fileObject.getExt().toLowerCase()) && (string2 = this.convertFile(fileObject, string, false)) != null) {
            this.addImage(string2, false);
        }
    }

    private void updatePreview() {
        SVGImage sVGImage;
        block6: {
            String string = (String)this.pathTextComboBox.getSelectedItem();
            FileObject fileObject = this.paths.get(string);
            sVGImage = null;
            try {
                if (fileObject != null) {
                    sVGImage = Util.createSVGImage((FileObject)fileObject, (boolean)true);
                }
                if (this.messageAwareness != null) {
                    this.messageAwareness.clearErrorStatus();
                }
            }
            catch (IOException iOException) {
                Debug.warning((Object[])new Object[]{iOException});
                if (this.messageAwareness == null) break block6;
                this.messageAwareness.displayWarning(NbBundle.getMessage(SVGImageEditorElement.class, (String)"MSG_SVG_Image_Not_SVG_Tiny"));
            }
        }
        if (sVGImage != null) {
            int n = sVGImage.getViewportWidth();
            int n2 = sVGImage.getViewportHeight();
            this.widthTextField.setText(String.valueOf(n));
            this.heightTextField.setText(String.valueOf(n2));
        } else {
            this.widthTextField.setText(null);
            this.heightTextField.setText(null);
        }
        this.imageView.setImage(sVGImage);
        this.previewPanel.invalidate();
        this.previewPanel.validate();
        this.previewPanel.repaint();
    }

    private Project getProject() {
        DesignDocument designDocument = ActiveDocumentSupport.getDefault().getActiveDocument();
        Project project = null;
        if (designDocument != null) {
            project = ProjectUtils.getProject((DesignDocument)designDocument);
        }
        return project;
    }

    private FileObject getSourceFolder() {
        Project project = this.getProject();
        if (project == null) {
            throw Debug.illegalState((Object[])new Object[]{"Current project is null"});
        }
        String string = ProjectUtils.getProjectID((Project)project);
        return ((SourceGroup)ProjectUtils.getSourceGroups((String)string).iterator().next()).getRootFolder();
    }

    private String convertFile(FileObject fileObject, String string, boolean bl) {
        String string2;
        FileObject fileObject2 = this.getSourceFolder();
        String string3 = FileUtil.toFile((FileObject)fileObject2).getAbsolutePath();
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            string2 = !fileObject.getPath().startsWith("/", 0) ? "/" + fileObject.getPath() : fileObject.getPath();
        } else {
            String string4 = file.getAbsolutePath();
            if (string4.contains(string3)) {
                int n;
                string4 = fileObject.getPath();
                string2 = !string4.substring(n = string4.indexOf(string3) + string3.length() + 1).startsWith("/") ? "/" + string4.substring(n) : string4.substring(n);
            } else if (bl) {
                File file2 = new File(string3 + File.separator + fileObject.getNameExt());
                if (file2.exists()) {
                    return null;
                }
                try {
                    fileObject = fileObject.copy(fileObject2, fileObject.getName(), fileObject.getExt());
                }
                catch (IOException iOException) {
                    Debug.warning((Object[])new Object[]{"SVGImageEditorElement.convertFile()", "can't copy file", string4, iOException});
                }
                string2 = "/" + fileObject.getNameExt();
            } else {
                string2 = string;
            }
        }
        this.paths.put(string2, fileObject);
        return string2;
    }

    @Override
    public void run() {
        if (this.wrapper == null || this.wrapper.getComponent() == null) {
            return;
        }
        DesignComponent designComponent = this.wrapper.getComponent();
        if (designComponent == null) {
            return;
        }
        DesignDocument designDocument = designComponent.getDocument();
        if (designDocument != null) {
            this.updateModel(designDocument);
        }
        this.showProgressBar(false);
        this.setDesignComponentWrapper(this.wrapper);
        this.requiresModelUpdate.set(false);
    }

    public void addNotify() {
        super.addNotify();
        if (this.requiresModelUpdate.getAndSet(true)) {
            return;
        }
        this.showProgressBar(true);
        new Thread(this).start();
    }

    private void showProgressBar(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SVGImageEditorElement.this.progressBar.setVisible(bl);
            }
        });
    }

    public void removeNotify() {
        this.paths.clear();
        this.wrapper = null;
        super.removeNotify();
    }

    private void initComponents() {
        this.pathLabel = new JLabel();
        this.previewLabel = new JLabel();
        this.previewPanel = new JPanel();
        this.widthLabel = new JLabel();
        this.widthTextField = new JTextField();
        this.heightLabel = new JLabel();
        this.heightTextField = new JTextField();
        this.chooserButton = new JButton();
        this.pathTextComboBox = new JComboBox();
        this.progressBar = new JProgressBar();
        this.pathLabel.setLabelFor(this.pathTextComboBox);
        Mnemonics.setLocalizedText((JLabel)this.pathLabel, (String)NbBundle.getMessage(SVGImageEditorElement.class, (String)"ImageEditorElement.pathLabel.text"));
        this.pathLabel.setEnabled(false);
        this.previewLabel.setText(NbBundle.getMessage(SVGImageEditorElement.class, (String)"ImageEditorElement.previewLabel.text"));
        this.previewLabel.setEnabled(false);
        this.previewPanel.setEnabled(false);
        this.previewPanel.setLayout(new BorderLayout());
        this.widthLabel.setLabelFor(this.widthTextField);
        Mnemonics.setLocalizedText((JLabel)this.widthLabel, (String)NbBundle.getMessage(SVGImageEditorElement.class, (String)"ImageEditorElement.widthLabel.text"));
        this.widthLabel.setEnabled(false);
        this.widthTextField.setEditable(false);
        this.widthTextField.setEnabled(false);
        this.heightLabel.setLabelFor(this.heightTextField);
        Mnemonics.setLocalizedText((JLabel)this.heightLabel, (String)NbBundle.getMessage(SVGImageEditorElement.class, (String)"ImageEditorElement.heightLabel.text"));
        this.heightLabel.setEnabled(false);
        this.heightTextField.setEditable(false);
        this.heightTextField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.chooserButton, (String)NbBundle.getMessage(SVGImageEditorElement.class, (String)"ImageEditorElement.chooserButton.text"));
        this.chooserButton.setEnabled(false);
        this.chooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVGImageEditorElement.this.chooserButtonActionPerformed(actionEvent);
            }
        });
        this.pathTextComboBox.setEditable(true);
        this.pathTextComboBox.setModel(this.comboBoxModel);
        this.pathTextComboBox.setEnabled(false);
        this.pathTextComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVGImageEditorElement.this.pathTextComboBoxActionPerformed(actionEvent);
            }
        });
        this.progressBar.setIndeterminate(true);
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.pathLabel).addContainerGap(272, Short.MAX_VALUE)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.previewLabel).addPreferredGap(0).add((Component)this.previewPanel, -1, 36, Short.MAX_VALUE).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.heightLabel).add((Component)this.widthLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.widthTextField, -2, 92, -2).add((Component)this.heightTextField, -2, 92, -2))).add((Component)this.progressBar, -2, 146, -2))).add((Component)this.pathTextComboBox, 0, 246, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.chooserButton, -2, 79, -2)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.pathLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.pathTextComboBox, -2, -1, -2).add((Component)this.chooserButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.widthLabel).add((Component)this.widthTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.heightLabel).add((Component)this.heightTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.progressBar, -2, -1, -2).addContainerGap()).add((Component)this.previewLabel).add((Component)this.previewPanel, -1, 100, Short.MAX_VALUE))));
        this.widthTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageEditorElement.class, (String)"ACSN_Width"));
        this.widthTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageEditorElement.class, (String)"ACSD_Width"));
        this.heightTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageEditorElement.class, (String)"ACSN_Height"));
        this.heightTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageEditorElement.class, (String)"ACSD_Height"));
        this.chooserButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageEditorElement.class, (String)"ACSN_Browse"));
        this.chooserButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageEditorElement.class, (String)"ACSD_Browse"));
        this.pathTextComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageEditorElement.class, (String)"ACSN_ImagePath"));
        this.pathTextComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageEditorElement.class, (String)"ACSD_ImagePath"));
    }

    private void chooserButtonActionPerformed(ActionEvent actionEvent) {
        Project project = this.getProject();
        JFileChooser jFileChooser = new JFileChooser(this.lastDir != null ? this.lastDir : project.getProjectDirectory().getPath());
        jFileChooser.setFileFilter(new ImageFilter());
        int n = jFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)jFileChooser.getSelectedFile()));
            this.lastDir = jFileChooser.getSelectedFile().getParentFile().getPath();
            String string = this.convertFile(fileObject, null, true);
            if (string != null) {
                this.setText(string);
                this.pathTextComboBoxActionPerformed(null);
            } else {
                String string2 = NbBundle.getMessage(SVGImageEditorElement.class, (String)"MSG_FILE_EXIST");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2));
            }
        }
    }

    private void pathTextComboBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.doNotFireEvent) {
            String string = (String)this.pathTextComboBox.getSelectedItem();
            this.fireElementChanged(this.componentID, "resourcePath", MidpTypes.createStringValue((String)(string != null ? string : "")));
            this.updatePreview();
        }
    }

    private static class ImageFilter
    extends FileFilter {
        private String description = NbBundle.getMessage(SVGImageEditorElement.class, (String)"DISP_SVG_Image_Files");

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = ImageFilter.getExtension(file);
            return SVGImageEditorElement.EXTENSION.equals(string);
        }

        public String getDescription() {
            return this.description;
        }

        private static String getExtension(File file) {
            String string = null;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }
    }
}

