/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class EditSVGFileAction
extends SystemAction {
    public String getName() {
        return NbBundle.getMessage(EditSVGFileAction.class, (String)"NAME_EditSVGFile");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        FileObject fileObject = this.getSVGFileObject();
        if (fileObject == null) {
            return;
        }
        try {
            OpenCookie openCookie = (OpenCookie)DataObject.find((FileObject)fileObject).getCookie(OpenCookie.class);
            if (openCookie == null) {
                return;
            }
            openCookie.open();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
    }

    public boolean isEnabled() {
        FileObject fileObject = this.getSVGFileObject();
        return fileObject != null;
    }

    private DesignComponent getActiveComponent() {
        Iterator iterator;
        Collection collection = ActiveDocumentSupport.getDefault().getActiveComponents();
        if (collection.size() == 1 && (iterator = collection.iterator()).hasNext()) {
            return (DesignComponent)iterator.next();
        }
        return null;
    }

    private FileObject getSVGFileObject() {
        final DesignComponent designComponent = this.getActiveComponent();
        if (designComponent == null) {
            return null;
        }
        final FileObject[] fileObjectArray = new FileObject[1];
        designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                PropertyValue propertyValue;
                DesignComponent designComponent2;
                PropertyValue propertyValue2 = designComponent.readProperty("svgImage");
                if (!PropertyValue.Kind.USERCODE.equals((Object)propertyValue2.getKind()) && (designComponent2 = propertyValue2.getComponent()) != null && (propertyValue = designComponent2.readProperty("resourcePath")).getKind() == PropertyValue.Kind.VALUE) {
                    FileObject fileObject;
                    Map map = MidpProjectSupport.getFileObjectsForRelativeResourcePath((DesignDocument)designComponent.getDocument(), (String)MidpTypes.getString((PropertyValue)propertyValue));
                    Iterator iterator = map.keySet().iterator();
                    fileObjectArray[0] = fileObject = iterator.hasNext() ? (FileObject)iterator.next() : null;
                }
            }
        });
        return fileObjectArray[0];
    }
}

