/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.ui.options.ServerListUIEx;
import org.netbeans.modules.cnd.ui.options.ToolsCacheManager;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public class DevelopmentHostCustomizer
extends JPanel
implements VetoableChangeListener {
    private DevelopmentHostConfiguration dhconf;
    private final PropertyEnv propertyEnv;
    private final PropertyEditorSupport editor;
    private final ExecutionEnvironment oldExecEnv;
    private final AtomicReference<ExecutionEnvironment> selectedEnv;
    private final ToolsCacheManager cacheManager;

    public DevelopmentHostCustomizer(DevelopmentHostConfiguration developmentHostConfiguration, PropertyEditorSupport propertyEditorSupport, PropertyEnv propertyEnv) {
        this.dhconf = developmentHostConfiguration;
        this.editor = propertyEditorSupport;
        this.propertyEnv = propertyEnv;
        this.oldExecEnv = developmentHostConfiguration == null ? null : developmentHostConfiguration.getExecutionEnvironment();
        this.selectedEnv = new AtomicReference<ExecutionEnvironment>(this.oldExecEnv);
        this.cacheManager = new ToolsCacheManager();
        this.setLayout(new BorderLayout());
        JComponent jComponent = ServerListUIEx.getServerListComponent((ToolsCacheManager)this.cacheManager, this.selectedEnv);
        this.add((Component)jComponent, "Center");
        propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        propertyEnv.addVetoableChangeListener((VetoableChangeListener)this);
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        boolean bl = false;
        ExecutionEnvironment executionEnvironment = this.selectedEnv.get();
        if (executionEnvironment == null) {
            throw new PropertyVetoException(NbBundle.getMessage(this.getClass(), (String)"MSG_Null_Host"), propertyChangeEvent);
        }
        if (executionEnvironment.equals(this.oldExecEnv)) {
            return;
        }
        this.dhconf.setHost(executionEnvironment);
    }
}

