/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.utils.CndFileVisibilityQuery;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.actions.AddExistingFolderItemsAction;
import org.netbeans.modules.cnd.makeproject.api.actions.AddExistingItemAction;
import org.netbeans.modules.cnd.makeproject.api.actions.NewFolderAction;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configurations;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakefileConfiguration;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.api.ui.BrokenIncludes;
import org.netbeans.modules.cnd.makeproject.api.ui.LogicalViewNodeProvider;
import org.netbeans.modules.cnd.makeproject.api.ui.LogicalViewNodeProviders;
import org.netbeans.modules.cnd.makeproject.ui.AddExternalItemAction;
import org.netbeans.modules.cnd.makeproject.ui.AnnotatedNode;
import org.netbeans.modules.cnd.makeproject.ui.CompileSingleAction;
import org.netbeans.modules.cnd.makeproject.ui.ProjectTabBridge;
import org.netbeans.modules.cnd.makeproject.ui.PropertiesFolderAction;
import org.netbeans.modules.cnd.makeproject.ui.PropertiesItemAction;
import org.netbeans.modules.cnd.makeproject.ui.RemoteDevelopmentAction;
import org.netbeans.modules.cnd.makeproject.ui.RemoteSyncActions;
import org.netbeans.modules.cnd.makeproject.ui.RemoveFolderAction;
import org.netbeans.modules.cnd.makeproject.ui.RemoveItemAction;
import org.netbeans.modules.cnd.makeproject.ui.SetConfigurationAction;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.FindAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.RenameAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openidex.search.SearchInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeLogicalViewProvider
implements LogicalViewProvider {
    private final MakeProject project;
    private final SubprojectProvider spp;
    private static final Boolean ASYNC_ROOT_NODE = Boolean.getBoolean("cnd.async.root");
    private static final Logger log = Logger.getLogger("cnd.async.root");
    private static final MessageFormat ITEM_VIEW_FLAVOR = new MessageFormat("application/x-org-netbeans-modules-cnd-makeproject-uidnd; class=org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider$ViewItemNode; mask={0}");
    private static final boolean SYNC_PROJECT_ACTION = Boolean.getBoolean("cnd.remote.sync.project.action");
    private static final boolean DOWNLOAD_ACTION = Boolean.getBoolean("cnd.remote.download.project.action");
    static final String PRIMARY_TYPE = "application";
    static final String SUBTYPE = "x-org-netbeans-modules-cnd-makeproject-uidnd";
    static final String MASK = "mask";
    static StandardNodeAction renameAction = null;
    static StandardNodeAction deleteAction = null;
    private boolean findPathMode = false;
    private static final String brokenProjectBadgePath = "org/netbeans/modules/cnd/makeproject/ui/resources/brokenProjectBadge.gif";
    private static final String brokenIncludeImgPath = "org/netbeans/modules/cnd/makeproject/ui/resources/brokenIncludeBadge.png";
    private static final Image brokenProjectBadge = MakeLogicalViewProvider.loadToolTipImage("org/netbeans/modules/cnd/makeproject/ui/resources/brokenProjectBadge.gif", "BrokenProjectTxt");
    private static final Image brokenIncludeBadge = MakeLogicalViewProvider.loadToolTipImage("org/netbeans/modules/cnd/makeproject/ui/resources/brokenIncludeBadge.png", "BrokenIncludeTxt");
    private static final int WAIT_DELAY = 50;

    public MakeLogicalViewProvider(MakeProject makeProject, SubprojectProvider subprojectProvider) {
        this.project = makeProject;
        assert (makeProject != null);
        this.spp = subprojectProvider;
        assert (subprojectProvider != null);
    }

    public Node createLogicalView() {
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        if (ASYNC_ROOT_NODE.booleanValue()) {
            log.fine("creating async root node in EDT? " + SwingUtilities.isEventDispatchThread());
            return new MakeLogicalViewRootNode(makeConfigurationDescriptor.getLogicalFolders());
        }
        if (makeConfigurationDescriptor == null || makeConfigurationDescriptor.getState() == ConfigurationDescriptor.State.BROKEN || makeConfigurationDescriptor.getConfs().size() == 0) {
            return new MakeLogicalViewRootNodeBroken();
        }
        return new MakeLogicalViewRootNode(makeConfigurationDescriptor.getLogicalFolders());
    }

    private boolean isFindPathMode() {
        return this.findPathMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node findPath(Node node, Object object) {
        Node node2 = null;
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (object instanceof DataObject) {
            object = ((DataObject)object).getPrimaryFile();
        }
        if (!(object instanceof FileObject)) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)((FileObject)object));
        if (!this.gotMakeConfigurationDescriptor() || file == null) {
            return null;
        }
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        Item item = makeConfigurationDescriptor.findProjectItemByPath(file.getAbsolutePath());
        if (item == null && (item = makeConfigurationDescriptor.findExternalItemByPath(file.getAbsolutePath())) == null && (item = makeConfigurationDescriptor.findItemByFile(file)) == null) {
            return null;
        }
        try {
            this.findPathMode = true;
            Node node3 = MakeLogicalViewProvider.findFolderNode(node, item.getFolder());
            if (node3 != null) {
                Item item2;
                Node[] nodeArray = node3.getChildren().getNodes(true);
                int n = 0;
                for (n = 0; n < nodeArray.length && (item2 = (Item)nodeArray[n].getValue("Item")) != item; ++n) {
                }
                if (nodeArray.length > 0 && n < nodeArray.length) {
                    node2 = nodeArray[n];
                }
            }
        }
        finally {
            this.findPathMode = false;
        }
        return node2;
    }

    private static Node findFolderNode(Node node, Folder folder) {
        if (node.getValue("Folder") == folder) {
            return node;
        }
        Folder folder2 = folder.getParent();
        if (folder2 == null) {
            return node;
        }
        Node node2 = MakeLogicalViewProvider.findFolderNode(node, folder2);
        if (node2 == null) {
            return null;
        }
        Node[] nodeArray = node2.getChildren().getNodes(true);
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i].getValue("Folder") != folder) continue;
            return nodeArray[i];
        }
        return null;
    }

    private static Node findItemNode(Node node, Item item) {
        Node node2 = MakeLogicalViewProvider.findFolderNode(node, item.getFolder());
        if (node2 != null) {
            Node[] nodeArray = node2.getChildren().getNodes(true);
            for (int i = 0; i < nodeArray.length; ++i) {
                if (nodeArray[i].getValue("Item") != item) continue;
                return nodeArray[i];
            }
        }
        return null;
    }

    public static void setVisible(Project project, Folder folder) {
        Node node = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
        Node node2 = MakeLogicalViewProvider.findProjectNode(node, project);
        if (node2 == null) {
            return;
        }
        Node node3 = MakeLogicalViewProvider.findFolderNode(node2, folder);
        try {
            ProjectTabBridge.getInstance().getExplorerManager().setSelectedNodes(new Node[]{node3});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setVisible(final Project project, final Item[] itemArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Node node = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
                ArrayList<Node> arrayList = new ArrayList<Node>();
                for (int i = 0; i < itemArray.length; ++i) {
                    Node node2 = MakeLogicalViewProvider.findProjectNode(node, project);
                    if (node2 == null) continue;
                    arrayList.add(MakeLogicalViewProvider.findItemNode(node2, itemArray[i]));
                }
                try {
                    ProjectTabBridge.getInstance().getExplorerManager().setSelectedNodes(arrayList.toArray(new Node[0]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static void checkForChangedName(final Project project) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProjectInformation projectInformation;
                Node node = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
                Node node2 = MakeLogicalViewProvider.findProjectNode(node, project);
                if (node2 != null && (projectInformation = ProjectUtils.getInformation((Project)project)) != null) {
                    node2.setDisplayName(projectInformation.getDisplayName());
                }
            }
        });
    }

    public static void checkForChangedItems(final Project project, Folder folder, final Item item) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object object;
                Node node;
                if (item == null) {
                    MakeLogicalViewProvider.checkForChangedItems(project);
                    return;
                }
                Node node2 = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
                Node node3 = MakeLogicalViewProvider.findProjectNode(node2, project);
                if (node3 != null && (node = MakeLogicalViewProvider.findItemNode(node3, item)) instanceof FilterNode && (object = node.getLookup().lookup(ViewItemNode.class)) != null) {
                    ((ChangeListener)object).stateChanged(null);
                }
            }
        });
    }

    private static void checkForChangedItems(Project project) {
        Node node = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
        MakeLogicalViewProvider.checkForChangedItems(MakeLogicalViewProvider.findProjectNode(node, project));
    }

    private static void checkForChangedItems(Node node) {
        if (node != null) {
            for (Node node2 : node.getChildren().getNodes(true)) {
                Object object;
                MakeLogicalViewProvider.checkForChangedItems(node2);
                if (!(node2 instanceof FilterNode) || (object = node2.getLookup().lookup(ViewItemNode.class)) == null) continue;
                ((ChangeListener)object).stateChanged(null);
            }
        }
    }

    public static void refreshBrokenItems(final Project project) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MakeLogicalViewProvider.refreshBrokenItemsImpl(project);
            }
        });
    }

    private static void refreshBrokenItemsImpl(Project project) {
        Node node = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
        MakeLogicalViewProvider.refreshBrokenItemsImpl(MakeLogicalViewProvider.findProjectNode(node, project));
    }

    private static void refreshBrokenItemsImpl(Node node) {
        if (node != null) {
            if (node.isLeaf()) {
                Object object = node.getLookup().lookup(BrokenViewItemNode.class);
                if (object != null) {
                    ((BrokenViewItemNode)((Object)object)).refresh();
                }
            } else {
                for (Node node2 : node.getChildren().getNodes(true)) {
                    MakeLogicalViewProvider.refreshBrokenItemsImpl(node2);
                }
            }
        }
    }

    private static Node findProjectNode(Node node, Project project) {
        Node[] nodeArray = node.getChildren().getNodes(true);
        Lookup.Template template = new Lookup.Template(null, null, (Object)project);
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i].getLookup().lookupItem(template) == null) continue;
            return nodeArray[i];
        }
        return null;
    }

    public static boolean hasBrokenLinks() {
        return false;
    }

    private static Image loadToolTipImage(String string, String string2) {
        Image image = ImageUtilities.loadImage((String)string);
        image = ImageUtilities.assignToolTipToImage((Image)image, (String)("<img src=\"" + MakeLogicalViewRootNode.class.getClassLoader().getResource(string) + "\">&nbsp;" + NbBundle.getMessage(MakeLogicalViewRootNode.class, (String)string2)));
        return image;
    }

    private static Node getWaitNode() {
        return new LoadingNode();
    }

    private String getShortDescription() {
        String string = FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory());
        DevelopmentHostConfiguration developmentHostConfiguration = this.project.getDevelopmentHostConfiguration();
        if (developmentHostConfiguration == null || developmentHostConfiguration.isLocalhost()) {
            return NbBundle.getMessage(MakeLogicalViewProvider.class, (String)"HINT_project_root_node", (Object)string);
        }
        return NbBundle.getMessage(MakeLogicalViewProvider.class, (String)"HINT_project_root_node_on_host", (Object)string, (Object)developmentHostConfiguration.getDisplayName(true));
    }

    private MakeConfigurationDescriptor getMakeConfigurationDescriptor() {
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor makeConfigurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor();
        return makeConfigurationDescriptor;
    }

    private boolean gotMakeConfigurationDescriptor() {
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        return configurationDescriptorProvider.gotDescriptor();
    }

    private StandardNodeAction createRenameAction() {
        if (renameAction == null) {
            renameAction = new RenameNodeAction();
        }
        return renameAction;
    }

    private StandardNodeAction createDeleteAction() {
        if (deleteAction == null) {
            deleteAction = new DeleteNodeAction();
        }
        return deleteAction;
    }

    private void addSyncActions(List<Action> list) {
        list.add(RemoteSyncActions.createUploadAction());
        if (DOWNLOAD_ACTION) {
            list.add(RemoteSyncActions.createDownloadAction());
        }
    }

    private static Action[] insertSyncActions(Action[] actionArray, Class clazz) {
        Action[] actionArray2 = actionArray;
        if (DOWNLOAD_ACTION) {
            actionArray2 = MakeLogicalViewProvider.insertAfter(actionArray2, RemoteSyncActions.createDownloadAction(), clazz);
        }
        actionArray2 = MakeLogicalViewProvider.insertAfter(actionArray2, RemoteSyncActions.createUploadAction(), clazz);
        return actionArray2;
    }

    private static Action[] insertAfter(Action[] actionArray, Action action, Class clazz) {
        int n = -1;
        for (int i = 0; i < actionArray.length; ++i) {
            if (actionArray[i] == null || !actionArray[i].getClass().equals(clazz)) continue;
            n = i + 1;
            break;
        }
        if (n < 0) {
            return actionArray;
        }
        Action[] actionArray2 = new Action[actionArray.length + 1];
        System.arraycopy(actionArray, 0, actionArray2, 0, n);
        actionArray2[n] = action;
        int n2 = actionArray2.length - n - 1;
        if (n2 > 0) {
            System.arraycopy(actionArray, n, actionArray2, n + 1, n2);
        }
        return actionArray2;
    }

    private static class DeleteNodeAction
    extends StandardNodeAction {
        public DeleteNodeAction() {
            super(SystemAction.get(DeleteAction.class));
        }
    }

    private static class RenameNodeAction
    extends StandardNodeAction {
        public RenameNodeAction() {
            super(SystemAction.get(RenameAction.class));
        }
    }

    private static class StandardNodeAction
    extends NodeAction {
        SystemAction systemAction;

        public StandardNodeAction(SystemAction systemAction) {
            this.systemAction = systemAction;
        }

        protected void performAction(Node[] nodeArray) {
            Action action;
            Object object;
            if (nodeArray.length > 0) {
                ChangeListener changeListener;
                object = (Folder)nodeArray[0].getLookup().lookup(Folder.class);
                if (object == null && (changeListener = (ViewItemNode)nodeArray[0].getLookup().lookup(ViewItemNode.class)) != null) {
                    object = ((ViewItemNode)changeListener).getFolder();
                }
                if (object != null && (changeListener = ((Folder)object).getConfigurationDescriptor()) != null && !((MakeConfigurationDescriptor)changeListener).okToChange()) {
                    return;
                }
            }
            object = new InstanceContent();
            for (int i = 0; i < nodeArray.length; ++i) {
                object.add((Object)nodeArray[i]);
            }
            AbstractLookup abstractLookup = new AbstractLookup((AbstractLookup.Content)object);
            if (this.systemAction instanceof NodeAction) {
                action = ((NodeAction)this.systemAction).createContextAwareInstance((Lookup)abstractLookup);
            } else if (this.systemAction instanceof CallbackSystemAction) {
                action = ((CallbackSystemAction)this.systemAction).createContextAwareInstance((Lookup)abstractLookup);
            } else {
                action = null;
                assert (false);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    action.actionPerformed(new ActionEvent(this, 0, null));
                }
            });
        }

        protected boolean enable(Node[] nodeArray) {
            return true;
        }

        public HelpCtx getHelpCtx() {
            return this.systemAction.getHelpCtx();
        }

        public String getName() {
            return this.systemAction.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FolderSearchInfo
    implements SearchInfo {
        Folder folder;

        FolderSearchInfo(Folder folder) {
            this.folder = folder;
        }

        public boolean canSearch() {
            return true;
        }

        public Iterator<DataObject> objectsToSearch() {
            return this.folder.getAllItemsAsDataObjectSet(false, "text/").iterator();
        }
    }

    private static class RefreshItemAction
    extends AbstractAction {
        private RefreshableItemsContainer childrenKeys;
        private Folder folder;
        private Item item;

        public RefreshItemAction(RefreshableItemsContainer refreshableItemsContainer, Folder folder, Item item) {
            this.childrenKeys = refreshableItemsContainer;
            this.folder = folder;
            this.item = item;
            this.putValue("Name", NbBundle.getBundle(this.getClass()).getString("CTL_Refresh"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.item != null) {
                this.childrenKeys.refreshItem(this.item);
            } else {
                Item[] itemArray = this.folder.getItemsAsArray();
                for (int i = 0; i < itemArray.length; ++i) {
                    this.childrenKeys.refreshItem(itemArray[i]);
                }
            }
        }
    }

    private static interface RefreshableItemsContainer {
        public void refreshItem(Item var1);
    }

    private final class BrokenViewItemNode
    extends AbstractNode {
        private boolean broken;
        private RefreshableItemsContainer childrenKeys;
        private Folder folder;
        private Item item;

        public BrokenViewItemNode(RefreshableItemsContainer refreshableItemsContainer, Folder folder, Item item) {
            super(Children.LEAF);
            this.childrenKeys = refreshableItemsContainer;
            this.folder = folder;
            this.item = item;
            File file = item.getNormalizedFile();
            this.setName(file.getPath());
            this.setDisplayName(file.getName());
            this.setShortDescription(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"BrokenTxt", (Object)file.getPath()));
            this.broken = true;
        }

        public Image getIcon(int n) {
            int n2 = this.item.getDefaultTool();
            Image image = n2 == 0 ? ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/loaders/CSrcIcon.gif") : (n2 == 1 ? ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/loaders/CCSrcIcon.gif") : (n2 == 2 ? ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/loaders/FortranSrcIcon.gif") : ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/loaders/unknown.gif")));
            return this.broken ? ImageUtilities.mergeImages((Image)image, (Image)brokenProjectBadge, (int)11, (int)0) : image;
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{SystemAction.get(RemoveItemAction.class), new RefreshItemAction(this.childrenKeys, null, this.item), null, SystemAction.get(PropertiesItemAction.class)};
        }

        public void refresh() {
            this.childrenKeys.refreshItem(this.item);
        }

        public boolean canRename() {
            return false;
        }

        public Object getValue(String string) {
            if (string == null) {
                return super.getValue(null);
            }
            if (string.equals("Folder")) {
                return this.folder;
            }
            if (string.equals("Project")) {
                return MakeLogicalViewProvider.this.project;
            }
            if (string.equals("Item")) {
                return this.item;
            }
            if (string.equals("This")) {
                return this;
            }
            return super.getValue(string);
        }
    }

    private static class ViewItemTransferable
    extends ExTransferable.Single {
        private ViewItemNode node;

        public ViewItemTransferable(ViewItemNode viewItemNode, int n) throws ClassNotFoundException {
            super(new DataFlavor(ITEM_VIEW_FLAVOR.format(new Object[]{n}), null, MakeLogicalViewProvider.class.getClassLoader()));
            this.node = viewItemNode;
        }

        protected Object getData() throws IOException, UnsupportedFlavorException {
            return this.node;
        }
    }

    private class ViewItemNode
    extends FilterNode
    implements ChangeListener {
        RefreshableItemsContainer childrenKeys;
        private Folder folder;
        private Item item;

        public ViewItemNode(RefreshableItemsContainer refreshableItemsContainer, Folder folder, Item item, DataObject dataObject) {
            super(dataObject.getNodeDelegate());
            this.childrenKeys = refreshableItemsContainer;
            this.folder = folder;
            this.item = item;
            File file = item.getNormalizedFile();
            this.setShortDescription(file.getPath());
        }

        public Folder getFolder() {
            return this.folder;
        }

        public Item getItem() {
            return this.item;
        }

        public boolean canRename() {
            return true;
        }

        public boolean canDestroy() {
            return true;
        }

        public boolean canCut() {
            return true;
        }

        public boolean canCopy() {
            return true;
        }

        public Transferable clipboardCopy() throws IOException {
            return this.addViewItemTransferable(super.clipboardCopy(), 1);
        }

        public Transferable clipboardCut() throws IOException {
            return this.addViewItemTransferable(super.clipboardCut(), 2);
        }

        public Transferable drag() throws IOException {
            return this.addViewItemTransferable(super.drag(), 0);
        }

        private ExTransferable addViewItemTransferable(Transferable transferable, int n) {
            try {
                ExTransferable exTransferable = ExTransferable.create((Transferable)transferable);
                ViewItemTransferable viewItemTransferable = new ViewItemTransferable(this, n);
                exTransferable.put((ExTransferable.Single)viewItemTransferable);
                return exTransferable;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException);
            }
        }

        public void destroy() throws IOException {
            this.folder.removeItemAction(this.item);
            super.destroy();
        }

        public Object getValue(String string) {
            if (string == null) {
                return super.getValue(null);
            }
            if (string.equals("Folder")) {
                return this.getFolder();
            }
            if (string.equals("Project")) {
                return MakeLogicalViewProvider.this.project;
            }
            if (string.equals("Item")) {
                return this.getItem();
            }
            if (string.equals("This")) {
                return this;
            }
            return super.getValue(string);
        }

        public Action[] getActions(boolean bl) {
            Action[] actionArray = super.getActions(false);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (this.getItem().getFolder() == null) {
                return actionArray;
            }
            if (this.getItem().getFolder().isDiskFolder()) {
                for (int i = 0; i < actionArray.length; ++i) {
                    String string = null;
                    if (actionArray[i] != null) {
                        string = (String)actionArray[i].getValue("key");
                    }
                    if (actionArray[i] != null && actionArray[i] instanceof OpenAction) {
                        arrayList.add(actionArray[i]);
                        arrayList.add(null);
                        continue;
                    }
                    if (actionArray[i] != null && actionArray[i] instanceof RenameAction) {
                        arrayList.add((Object)MakeLogicalViewProvider.this.createRenameAction());
                        MakeLogicalViewProvider.this.addSyncActions(arrayList);
                        continue;
                    }
                    if (string != null && string.equals("delete")) {
                        arrayList.add((Object)MakeLogicalViewProvider.this.createDeleteAction());
                        continue;
                    }
                    if (actionArray[i] != null && actionArray[i] instanceof PropertiesAction && this.getFolder().isProjectFiles()) {
                        arrayList.add(SystemAction.get(PropertiesItemAction.class));
                        continue;
                    }
                    arrayList.add(actionArray[i]);
                }
                return arrayList.toArray(new Action[arrayList.size()]);
            }
            for (int i = 0; i < actionArray.length; ++i) {
                String string = null;
                if (actionArray[i] != null) {
                    string = (String)actionArray[i].getValue("key");
                }
                if (actionArray[i] != null && actionArray[i] instanceof OpenAction) {
                    arrayList.add(actionArray[i]);
                    arrayList.add(null);
                    continue;
                }
                if (actionArray[i] != null && actionArray[i] instanceof PasteAction) {
                    arrayList.add(actionArray[i]);
                    arrayList.add(SystemAction.get(CompileSingleAction.class));
                    continue;
                }
                if (actionArray[i] != null && actionArray[i] instanceof RenameAction) {
                    arrayList.add((Object)MakeLogicalViewProvider.this.createRenameAction());
                    MakeLogicalViewProvider.this.addSyncActions(arrayList);
                    continue;
                }
                if (actionArray[i] != null && actionArray[i] instanceof PropertiesAction && this.getFolder().isProjectFiles()) {
                    arrayList.add(SystemAction.get(PropertiesItemAction.class));
                    continue;
                }
                if (string != null && string.equals("delete")) {
                    arrayList.add(SystemAction.get(RemoveItemAction.class));
                    arrayList.add((Object)MakeLogicalViewProvider.this.createDeleteAction());
                    continue;
                }
                arrayList.add(actionArray[i]);
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        public Image getIcon(int n) {
            Image image = super.getIcon(n);
            if (this.isExcluded() && image instanceof BufferedImage) {
                ColorSpace colorSpace = ColorSpace.getInstance(1003);
                ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, null);
                image = colorConvertOp.filter((BufferedImage)image, null);
            }
            return image;
        }

        public String getHtmlDisplayName() {
            if (this.isExcluded()) {
                String string = super.getHtmlDisplayName();
                if (string != null && string.toLowerCase().contains("color=")) {
                    return string;
                }
                string = string != null ? string : this.getDisplayName();
                return "<font color='!controlShadow'>" + string;
            }
            return super.getHtmlDisplayName();
        }

        private boolean isExcluded() {
            if (this.item == null || this.item.getFolder() == null || this.item.getFolder().getConfigurationDescriptor() == null || this.item.getFolder().getConfigurationDescriptor().getConfs() == null) {
                return false;
            }
            MakeConfiguration makeConfiguration = this.item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
            ItemConfiguration itemConfiguration = this.item.getItemConfiguration(makeConfiguration);
            if (itemConfiguration == null) {
                return false;
            }
            BooleanConfiguration booleanConfiguration = itemConfiguration.getExcluded();
            return booleanConfiguration.getValue();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            EventQueue.invokeLater(new VisualUpdater());
        }

        class VisualUpdater
        implements Runnable {
            VisualUpdater() {
            }

            public void run() {
                ViewItemNode.this.fireIconChange();
                ViewItemNode.this.fireOpenedIconChange();
                String string = ViewItemNode.this.getDisplayName();
                ViewItemNode.this.fireDisplayNameChange(string, "");
                ViewItemNode.this.fireDisplayNameChange("", string);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExternalFilesChildren
    extends BaseMakeViewChildren {
        public ExternalFilesChildren(Project project, Folder folder) {
            super(folder);
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof LoadingNode) {
                return new Node[]{(Node)object};
            }
            if (!(object instanceof Item)) {
                System.err.println("wrong item in external files folder " + object);
                return null;
            }
            Item item = (Item)object;
            DataObject dataObject = item.getDataObject();
            Object object2 = dataObject != null ? new ViewItemNode(this, this.getFolder(), item, dataObject) : new BrokenViewItemNode(this, this.getFolder(), item);
            return new Node[]{object2};
        }

        @Override
        protected Collection<Object> getKeys() {
            return this.getFolder().getElements();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseMakeViewChildren
    extends Children.Keys<Object>
    implements ChangeListener,
    RefreshableItemsContainer {
        private final Folder folder;

        public BaseMakeViewChildren(Folder folder) {
            this.folder = folder;
        }

        protected void addNotify() {
            if (MakeLogicalViewProvider.this.isFindPathMode()) {
                super.addNotify();
                this.folder.addChangeListener(this);
                this.setKeys(this.getKeys());
            } else if (SwingUtilities.isEventDispatchThread()) {
                super.addNotify();
                this.setKeys(new Object[]{MakeLogicalViewProvider.getWaitNode()});
                this.folder.addChangeListener(this);
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        if (MakeLogicalViewProvider.this.project.getProjectDirectory() != null && MakeLogicalViewProvider.this.project.getProjectDirectory().isValid()) {
                            BaseMakeViewChildren.this.setKeys(BaseMakeViewChildren.this.getKeys());
                        }
                    }
                }, 50);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BaseMakeViewChildren.this.addNotify();
                    }
                });
            }
        }

        @Override
        public void refreshItem(Item item) {
            this.refreshKey(item);
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            this.folder.removeChangeListener(this);
            super.removeNotify();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Runnable runnable = null;
            if (changeEvent.getSource() instanceof Item) {
                Item[] itemArray;
                for (final Item item : itemArray = this.getFolder().getItemsAsArray()) {
                    if (changeEvent.getSource() != item) continue;
                    runnable = new Runnable(){

                        public void run() {
                            BaseMakeViewChildren.this.refreshItem(item);
                        }
                    };
                    break;
                }
            } else {
                final Collection<Object> collection = this.getKeys();
                runnable = new Runnable(){

                    public void run() {
                        BaseMakeViewChildren.this.setKeys(collection);
                    }
                };
            }
            if (runnable != null) {
                EventQueue.invokeLater(runnable);
            }
        }

        protected abstract Collection<Object> getKeys();

        public Folder getFolder() {
            return this.folder;
        }
    }

    private final class ExternalFilesNode
    extends AbstractNode {
        private Folder folder;

        public ExternalFilesNode(Folder folder) {
            super((Children)new ExternalFilesChildren(MakeLogicalViewProvider.this.project, folder), Lookups.fixed((Object[])new Object[]{MakeLogicalViewProvider.this.project, new FolderSearchInfo(folder)}));
            this.setName(folder.getName());
            this.setDisplayName(folder.getDisplayName());
            this.setShortDescription(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString("ONLY_REFERENCE_TXT"));
            this.folder = folder;
        }

        public Object getValue(String string) {
            if (string == null) {
                return super.getValue(null);
            }
            if (string.equals("Folder")) {
                return this.folder;
            }
            if (string.equals("Project")) {
                return MakeLogicalViewProvider.this.project;
            }
            if (string.equals("This")) {
                return this;
            }
            return super.getValue(string);
        }

        public Image getIcon(int n) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/importantFolder.gif");
        }

        public Image getOpenedIcon(int n) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/importantFolderOpened.gif");
        }

        public Action[] getActions(boolean bl) {
            Action[] actionArray = new Action[]{new AddExternalItemAction(MakeLogicalViewProvider.this.project), null, SystemAction.get(FindAction.class)};
            actionArray = MakeLogicalViewProvider.insertSyncActions(actionArray, AddExternalItemAction.class);
            return actionArray;
        }

        public boolean canRename() {
            return false;
        }
    }

    private class ViewItemPasteType
    extends PasteType {
        private final Folder toFolder;
        private final ViewItemNode viewItemNode;
        private final int type;

        public ViewItemPasteType(Folder folder, ViewItemNode viewItemNode, int n) {
            this.toFolder = folder;
            this.viewItemNode = viewItemNode;
            this.type = n;
        }

        private void copyItemConfigurations(ItemConfiguration[] itemConfigurationArray, ItemConfiguration[] itemConfigurationArray2) {
            assert (itemConfigurationArray.length == itemConfigurationArray2.length);
            for (int i = 0; i < itemConfigurationArray.length; ++i) {
                itemConfigurationArray[i].assignValues(itemConfigurationArray2[i]);
            }
        }

        public Transferable paste() throws IOException {
            if (!MakeLogicalViewProvider.this.gotMakeConfigurationDescriptor() || !MakeLogicalViewProvider.this.getMakeConfigurationDescriptor().okToChange()) {
                return null;
            }
            Item item = this.viewItemNode.getItem();
            ItemConfiguration[] itemConfigurationArray = item.getItemConfigurations();
            if (itemConfigurationArray.length == 0) {
                return null;
            }
            if (this.type == 2) {
                if (this.toFolder.getProject() == this.viewItemNode.getFolder().getProject()) {
                    if (this.toFolder.isDiskFolder()) {
                        FileObject fileObject = item.getFileObject();
                        String string = IpeUtils.toAbsolutePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)this.toFolder.getRootPath());
                        FileObject fileObject2 = FileUtil.toFileObject((File)new File(string));
                        String string2 = IpeUtils.createUniqueFileName((String)string, (String)fileObject.getName(), (String)fileObject.getExt());
                        FileObject fileObject3 = FileUtil.moveFile((FileObject)fileObject, (FileObject)fileObject2, (String)string2);
                        File file = FileUtil.toFile((FileObject)fileObject3);
                        String string3 = file.getPath();
                        string3 = IpeUtils.toRelativePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)string3);
                        Item item2 = this.toFolder.findItemByPath(string3 = FilePathAdaptor.normalize(string3));
                        if (item2 != null) {
                            this.copyItemConfigurations(item2.getItemConfigurations(), itemConfigurationArray);
                        }
                    } else if (this.viewItemNode.getFolder().removeItem(item)) {
                        this.toFolder.addItem(item);
                        this.copyItemConfigurations(item.getItemConfigurations(), itemConfigurationArray);
                    }
                } else if (this.toFolder.isDiskFolder()) {
                    FileObject fileObject = item.getFileObject();
                    String string = IpeUtils.toAbsolutePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)this.toFolder.getRootPath());
                    FileObject fileObject4 = FileUtil.toFileObject((File)new File(string));
                    String string4 = IpeUtils.createUniqueFileName((String)string, (String)fileObject.getName(), (String)fileObject.getExt());
                    FileObject fileObject5 = FileUtil.moveFile((FileObject)fileObject, (FileObject)fileObject4, (String)string4);
                } else if (IpeUtils.isPathAbsolute((String)item.getPath())) {
                    if (this.viewItemNode.getFolder().removeItem(item)) {
                        this.toFolder.addItem(item);
                    }
                } else if (item.getPath().startsWith("..")) {
                    String string = FileUtil.toFile((FileObject)this.viewItemNode.getFolder().getProject().getProjectDirectory()).getPath();
                    String string5 = FileUtil.toFile((FileObject)this.toFolder.getProject().getProjectDirectory()).getPath();
                    String string6 = IpeUtils.getRelativePath((String)string5, (String)string) + "/";
                    string6 = FilePathAdaptor.normalize(string6);
                    String string7 = string6 + item.getPath();
                    string7 = IpeUtils.trimDotDot((String)string7);
                    if (this.viewItemNode.getFolder().removeItemAction(item)) {
                        this.toFolder.addItemAction(new Item(FilePathAdaptor.normalize(string7)));
                    }
                } else {
                    Project project = this.toFolder.getProject();
                    FileObject fileObject = item.getFileObject();
                    FileObject fileObject6 = fileObject.copy(project.getProjectDirectory(), fileObject.getName(), fileObject.getExt());
                    String string = IpeUtils.toRelativePath((String)FileUtil.toFile((FileObject)project.getProjectDirectory()).getPath(), (String)FileUtil.toFile((FileObject)fileObject6).getPath());
                    if (this.viewItemNode.getFolder().removeItemAction(item)) {
                        fileObject.delete();
                        this.toFolder.addItemAction(new Item(FilePathAdaptor.normalize(string)));
                    }
                }
            } else if (this.type == 1 || this.type == 0) {
                if (this.toFolder.getProject() == this.viewItemNode.getFolder().getProject()) {
                    if ((IpeUtils.isPathAbsolute((String)item.getPath()) || item.getPath().startsWith("..")) && !this.toFolder.isDiskFolder()) {
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        FileObject fileObject = FileUtil.toFileObject((File)item.getNormalizedFile());
                        String string = fileObject.getExt();
                        if (this.toFolder.isDiskFolder()) {
                            String string8 = IpeUtils.toAbsolutePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)this.toFolder.getRootPath());
                            FileObject fileObject7 = FileUtil.toFileObject((File)new File(string8));
                            String string9 = IpeUtils.createUniqueFileName((String)string8, (String)fileObject.getName(), (String)string);
                            FileObject fileObject8 = fileObject.copy(fileObject7, string9, string);
                            File file = FileUtil.toFile((FileObject)fileObject8);
                            String string10 = file.getPath();
                            string10 = IpeUtils.toRelativePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)string10);
                            Item item3 = this.toFolder.findItemByPath(string10 = FilePathAdaptor.normalize(string10));
                            if (item3 != null) {
                                this.copyItemConfigurations(item3.getItemConfigurations(), itemConfigurationArray);
                            }
                        } else {
                            String string11 = FileUtil.toFile((FileObject)fileObject.getParent()).getPath();
                            String string12 = IpeUtils.createUniqueFileName((String)string11, (String)fileObject.getName(), (String)string);
                            fileObject.copy(fileObject.getParent(), string12, string);
                            String string13 = string11 + "/" + string12;
                            if (string.length() > 0) {
                                string13 = string13 + "." + string;
                            }
                            string13 = IpeUtils.toRelativePath((String)FileUtil.toFile((FileObject)this.viewItemNode.getFolder().getProject().getProjectDirectory()).getPath(), (String)string13);
                            Item item4 = new Item(FilePathAdaptor.normalize(string13));
                            this.toFolder.addItemAction(item4);
                            this.copyItemConfigurations(item4.getItemConfigurations(), itemConfigurationArray);
                        }
                    }
                } else if (this.toFolder.isDiskFolder()) {
                    FileObject fileObject = FileUtil.toFileObject((File)item.getNormalizedFile());
                    String string = fileObject.getExt();
                    String string14 = IpeUtils.toAbsolutePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)this.toFolder.getRootPath());
                    FileObject fileObject9 = FileUtil.toFileObject((File)new File(string14));
                    String string15 = IpeUtils.createUniqueFileName((String)string14, (String)fileObject.getName(), (String)string);
                    fileObject.copy(fileObject9, string15, string);
                } else if (IpeUtils.isPathAbsolute((String)item.getPath())) {
                    this.toFolder.addItem(new Item(item.getPath()));
                } else if (item.getPath().startsWith("..")) {
                    String string = FileUtil.toFile((FileObject)this.viewItemNode.getFolder().getProject().getProjectDirectory()).getPath();
                    String string16 = FileUtil.toFile((FileObject)this.toFolder.getProject().getProjectDirectory()).getPath();
                    String string17 = IpeUtils.getRelativePath((String)string16, (String)string) + "/";
                    string17 = FilePathAdaptor.normalize(string17);
                    String string18 = string17 + item.getPath();
                    string18 = IpeUtils.trimDotDot((String)string18);
                    this.toFolder.addItemAction(new Item(FilePathAdaptor.normalize(string18)));
                } else {
                    Project project = this.toFolder.getProject();
                    String string = FileUtil.toFile((FileObject)project.getProjectDirectory()).getPath();
                    FileObject fileObject = item.getFileObject();
                    String string19 = fileObject.getExt();
                    String string20 = IpeUtils.createUniqueFileName((String)string, (String)fileObject.getName(), (String)string19);
                    fileObject.copy(project.getProjectDirectory(), string20, string19);
                    String string21 = string20;
                    if (string19.length() > 0) {
                        string21 = string21 + "." + string19;
                    }
                    this.toFolder.addItemAction(new Item(FilePathAdaptor.normalize(string21)));
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LogicalFolderNode
    extends AnnotatedNode
    implements ChangeListener {
        private Folder folder;

        public LogicalFolderNode(Node node, Folder folder) {
            super((Children)new LogicalViewChildren(folder), Lookups.fixed((Object[])new Object[]{folder, MakeLogicalViewProvider.this.project, new FolderSearchInfo(folder)}));
            this.folder = folder;
            this.setForceAnnotation(true);
            this.updateAnnotationFiles();
        }

        private void updateAnnotationFiles() {
            RequestProcessor.getDefault().post((Runnable)new UpdateAnnotationFilesTHread(this));
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.updateAnnotationFiles();
            EventQueue.invokeLater(new VisualUpdater());
        }

        public Folder getFolder() {
            return this.folder;
        }

        public Object getValue(String string) {
            if (string == null) {
                return super.getValue(null);
            }
            if (string.equals("Folder")) {
                return this.folder;
            }
            if (string.equals("Project")) {
                return MakeLogicalViewProvider.this.project;
            }
            if (string.equals("This")) {
                return this;
            }
            return super.getValue(string);
        }

        public Image getIcon(int n) {
            if (this.folder.isDiskFolder()) {
                return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/tree_folder.gif"), n);
            }
            return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/logicalFilesFolder.gif"), n);
        }

        public Image getOpenedIcon(int n) {
            if (this.folder.isDiskFolder()) {
                return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/tree_folder.gif"), n);
            }
            return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/logicalFilesFolderOpened.gif"), n);
        }

        public String getName() {
            return this.folder.getDisplayName();
        }

        public String getDisplayName() {
            return this.annotateName(this.folder.getDisplayName());
        }

        public void setName(String string) {
            String string2 = this.folder.getDisplayName();
            if (this.folder.isDiskFolder()) {
                String string3 = this.folder.getRootPath();
                String string4 = IpeUtils.toAbsolutePath((String)this.folder.getConfigurationDescriptor().getBaseDir(), (String)string3);
                File file = new File(string4);
                if (!file.isDirectory() || !file.exists()) {
                    return;
                }
                FileObject fileObject = FileUtil.toFileObject((File)file);
                try {
                    fileObject.rename(fileObject.lock(), string, null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            if (this.folder.getParent() != null && this.folder.getParent().findFolderByDisplayName(string) != null) {
                String string5 = NbBundle.getMessage(MakeLogicalViewProvider.class, (String)"CANNOT_RENAME", (Object)string2, (Object)string);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string5));
                return;
            }
            this.folder.setDisplayName(string);
            this.fireDisplayNameChange(string2, string);
        }

        public boolean canRename() {
            return true;
        }

        public boolean canDestroy() {
            return true;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public void destroy() throws IOException {
            if (!this.getFolder().isDiskFolder()) {
                return;
            }
            String string = IpeUtils.toAbsolutePath((String)this.getFolder().getConfigurationDescriptor().getBaseDir(), (String)this.getFolder().getRootPath());
            File file = new File(string);
            if (!file.isDirectory() || !file.exists()) {
                return;
            }
            FileObject fileObject = FileUtil.toFileObject((File)file);
            fileObject.delete();
            super.destroy();
        }

        public PasteType getDropType(Transferable transferable, int n, int n2) {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].getSubType().equals(MakeLogicalViewProvider.SUBTYPE)) continue;
                return super.getDropType(transferable, n, n2);
            }
            return null;
        }

        protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].getSubType().equals(MakeLogicalViewProvider.SUBTYPE)) continue;
                try {
                    ViewItemNode viewItemNode = (ViewItemNode)transferable.getTransferData(dataFlavorArray[i]);
                    int n = new Integer(dataFlavorArray[i].getParameter(MakeLogicalViewProvider.MASK));
                    list.add(new ViewItemPasteType(this.getFolder(), viewItemNode, n));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            super.createPasteTypes(transferable, list);
        }

        public void newLogicalFolder() {
        }

        public Action[] getActions(boolean bl) {
            Action[] actionArray = this.folder.isDiskFolder() ? new Action[]{CommonProjectActions.newFileAction(), SystemAction.get(FindAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), MakeLogicalViewProvider.this.createRenameAction(), null, SystemAction.get(PropertiesFolderAction.class)} : new Action[]{CommonProjectActions.newFileAction(), SystemAction.get(NewFolderAction.class), SystemAction.get(AddExistingItemAction.class), SystemAction.get(AddExistingFolderItemsAction.class), SystemAction.get(FindAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(RemoveFolderAction.class), MakeLogicalViewProvider.this.createRenameAction(), null, SystemAction.get(PropertiesFolderAction.class)};
            actionArray = MakeLogicalViewProvider.insertSyncActions(actionArray, RenameNodeAction.class);
            return actionArray;
        }

        class VisualUpdater
        implements Runnable {
            VisualUpdater() {
            }

            public void run() {
                LogicalFolderNode.this.fireIconChange();
                LogicalFolderNode.this.fireOpenedIconChange();
            }
        }

        class UpdateAnnotationFilesTHread
        extends Thread {
            LogicalFolderNode logicalFolderNode;

            UpdateAnnotationFilesTHread(LogicalFolderNode logicalFolderNode2) {
                this.logicalFolderNode = logicalFolderNode2;
            }

            public void run() {
                LogicalFolderNode.this.setFiles(new HashSet<FileObject>());
                ArrayList<Folder> arrayList = new ArrayList<Folder>();
                arrayList.add(LogicalFolderNode.this.folder);
                arrayList.addAll(LogicalFolderNode.this.folder.getAllFolders(true));
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ((Folder)iterator.next()).addChangeListener(this.logicalFolderNode);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LogicalViewChildren
    extends BaseMakeViewChildren
    implements PropertyChangeListener {
        public LogicalViewChildren(Folder folder) {
            super(folder);
            if (folder.isDiskFolder()) {
                MakeOptions.getInstance().addPropertyChangeListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("viewBinaryFiles")) {
                this.stateChanged(new ChangeEvent(this));
            }
        }

        protected Node[] createNodes(Object object) {
            Object object2 = null;
            if (object instanceof LoadingNode) {
                object2 = (Node)object;
            } else if (object instanceof Node) {
                object2 = (Node)object;
            } else if (object instanceof Folder) {
                Folder folder = (Folder)object;
                if (folder.isProjectFiles()) {
                    FileObject fileObject = MakeLogicalViewProvider.this.project.getProjectDirectory();
                    DataObject dataObject = null;
                    try {
                        if (fileObject.isValid()) {
                            dataObject = DataObject.find((FileObject)fileObject);
                        }
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        // empty catch block
                    }
                    if (dataObject != null) {
                        object2 = new LogicalFolderNode(((DataFolder)dataObject).getNodeDelegate(), folder);
                    }
                } else {
                    object2 = new ExternalFilesNode(folder);
                }
            } else if (object instanceof Item) {
                Item item = (Item)object;
                DataObject dataObject = item.getDataObject();
                object2 = dataObject != null ? new ViewItemNode(this, this.getFolder(), item, dataObject) : new BrokenViewItemNode(this, this.getFolder(), item);
            } else if (object instanceof AbstractNode) {
                object2 = (AbstractNode)object;
            }
            if (object2 == null) {
                return new Node[0];
            }
            return new Node[]{object2};
        }

        @Override
        protected Collection<Object> getKeys() {
            LogicalViewNodeProvider[] logicalViewNodeProviderArray;
            File file;
            LogicalViewNodeProvider[] logicalViewNodeProviderArray2;
            if (this.getFolder().isDiskFolder()) {
                logicalViewNodeProviderArray2 = new ArrayList(this.getFolder().getElements());
                String string = IpeUtils.toAbsolutePath((String)this.getFolder().getConfigurationDescriptor().getBaseDir(), (String)this.getFolder().getRootPath());
                file = new File(string);
                if (file.isDirectory() && file.exists()) {
                    File[] fileArray;
                    for (File file2 : fileArray = file.listFiles()) {
                        if (!file2.isFile() || this.getFolder().findItemByName(file2.getName()) != null || !VisibilityQuery.getDefault().isVisible(file2) || !MakeOptions.getInstance().getViewBinaryFiles() && CndFileVisibilityQuery.getDefault().isIgnored(file2)) continue;
                        Item item = new Item(file2.getAbsolutePath());
                        Folder.insertItemElementInList((ArrayList<Object>)logicalViewNodeProviderArray2, item);
                    }
                }
                logicalViewNodeProviderArray = logicalViewNodeProviderArray2;
            } else {
                logicalViewNodeProviderArray = this.getFolder().getElements();
            }
            switch (this.getFolder().getConfigurationDescriptor().getState()) {
                case READING: {
                    if (logicalViewNodeProviderArray.size() != 0) break;
                    logicalViewNodeProviderArray = Collections.singletonList(new LoadingNode());
                    break;
                }
            }
            if ("root".equals(this.getFolder().getName()) && (logicalViewNodeProviderArray2 = LogicalViewNodeProviders.getInstance().getProvidersAsArray()).length > 0) {
                for (int i = 0; i < logicalViewNodeProviderArray2.length; ++i) {
                    file = logicalViewNodeProviderArray2[i].getLogicalViewNode(MakeLogicalViewProvider.this.project);
                    if (file == null) continue;
                    logicalViewNodeProviderArray.add(file);
                }
            }
            return logicalViewNodeProviderArray;
        }
    }

    private final class MakeLogicalViewRootNodeBroken
    extends AbstractNode {
        public MakeLogicalViewRootNodeBroken() {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{MakeLogicalViewProvider.this.project}));
            this.setIconBaseWithExtension("org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif");
            this.setName(ProjectUtils.getInformation((Project)MakeLogicalViewProvider.this.project).getDisplayName());
        }

        public Image getIcon(int n) {
            Image image = super.getIcon(n);
            return ImageUtilities.mergeImages((Image)image, (Image)brokenProjectBadge, (int)8, (int)0);
        }

        public Image getOpenedIcon(int n) {
            Image image = super.getOpenedIcon(n);
            return ImageUtilities.mergeImages((Image)image, (Image)brokenProjectBadge, (int)8, (int)0);
        }

        public Action[] getActions(boolean bl) {
            ArrayList<Action> arrayList = new ArrayList<Action>();
            arrayList.add(CommonProjectActions.closeProjectAction());
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        public boolean canRename() {
            return false;
        }

        public String getShortDescription() {
            return MakeLogicalViewProvider.this.getShortDescription();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MakeLogicalViewRootNode
    extends AnnotatedNode
    implements ChangeListener,
    LookupListener {
        private boolean brokenLinks;
        private boolean brokenIncludes;
        private Folder folder;
        private final Lookup.Result<BrokenIncludes> brokenIncludesResult;

        public MakeLogicalViewRootNode(Folder folder) {
            super((Children)new LogicalViewChildren(folder), Lookups.fixed((Object[])new Object[]{folder, MakeLogicalViewProvider.this.project, new FolderSearchInfo(folder)}));
            this.folder = folder;
            this.setIconBaseWithExtension("org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif");
            this.setName(ProjectUtils.getInformation((Project)MakeLogicalViewProvider.this.project).getDisplayName());
            this.brokenIncludesResult = Lookup.getDefault().lookup(new Lookup.Template(BrokenIncludes.class));
            this.brokenIncludesResult.addLookupListener((LookupListener)this);
            this.resultChanged(null);
            this.brokenLinks = MakeLogicalViewProvider.hasBrokenLinks();
            this.brokenIncludes = this.hasBrokenIncludes(MakeLogicalViewProvider.this.project);
            this.setForceAnnotation(true);
            this.updateAnnotationFiles();
        }

        public Folder getFolder() {
            return this.folder;
        }

        private void updateAnnotationFiles() {
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            FileObject fileObject = MakeLogicalViewProvider.this.project.getProjectDirectory();
            if (fileObject == null || !fileObject.isValid()) {
                Logger.getLogger("cnd.makeproject").warning("project.getProjectDirectory() == null - " + MakeLogicalViewProvider.this.project);
            }
            hashSet.add(MakeLogicalViewProvider.this.project.getProjectDirectory());
            if (!MakeLogicalViewProvider.this.gotMakeConfigurationDescriptor()) {
                return;
            }
            MakeConfigurationDescriptor makeConfigurationDescriptor = MakeLogicalViewProvider.this.getMakeConfigurationDescriptor();
            if (makeConfigurationDescriptor == null) {
                return;
            }
            Configurations configurations = makeConfigurationDescriptor.getConfs();
            if (configurations == null) {
                return;
            }
            for (Configuration configuration : configurations.getConfs()) {
                MakefileConfiguration makefileConfiguration;
                String string;
                File file;
                MakeConfiguration makeConfiguration = (MakeConfiguration)configuration;
                if (!makeConfiguration.isMakefileConfiguration() || !(file = new File(string = (makefileConfiguration = makeConfiguration.getMakefileConfiguration()).getAbsBuildCommandWorkingDir())).exists()) continue;
                try {
                    hashSet.add(FileUtil.toFileObject((File)file.getCanonicalFile()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.setFiles(hashSet);
            ArrayList arrayList = new ArrayList();
            arrayList.add(this.folder);
            arrayList.addAll(this.folder.getAllFolders(true));
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((Folder)iterator.next()).addChangeListener(this);
            }
        }

        public String getShortDescription() {
            return MakeLogicalViewProvider.this.getShortDescription();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.brokenLinks = MakeLogicalViewProvider.hasBrokenLinks();
            this.brokenIncludes = this.hasBrokenIncludes(MakeLogicalViewProvider.this.project);
            this.updateAnnotationFiles();
            EventQueue.invokeLater(new VisualUpdater());
        }

        public Object getValue(String string) {
            if (string == null) {
                return super.getValue(null);
            }
            if (string.equals("Folder")) {
                return this.folder;
            }
            if (string.equals("Project")) {
                return MakeLogicalViewProvider.this.project;
            }
            if (string.equals("This")) {
                return this;
            }
            return super.getValue(string);
        }

        public Image getIcon(int n) {
            return this.mergeBadge(this.annotateIcon(super.getIcon(n), n));
        }

        private Image mergeBadge(Image image) {
            if (this.brokenLinks) {
                return ImageUtilities.mergeImages((Image)image, (Image)brokenProjectBadge, (int)8, (int)0);
            }
            if (this.brokenIncludes) {
                return ImageUtilities.mergeImages((Image)image, (Image)brokenIncludeBadge, (int)8, (int)0);
            }
            return image;
        }

        public Image getOpenedIcon(int n) {
            return this.mergeBadge(this.annotateIcon(super.getOpenedIcon(n), n));
        }

        public Action[] getActions(boolean bl) {
            MakeConfigurationDescriptor makeConfigurationDescriptor = MakeLogicalViewProvider.this.getMakeConfigurationDescriptor();
            if (makeConfigurationDescriptor != null) {
                makeConfigurationDescriptor.getLogicalFolders();
            }
            ArrayList<Action> arrayList = new ArrayList<Action>();
            MakeConfiguration makeConfiguration = makeConfigurationDescriptor == null ? null : makeConfigurationDescriptor.getActiveConfiguration();
            Action[] actionArray = makeConfigurationDescriptor == null || makeConfiguration == null || makeConfiguration.isMakefileConfiguration() ? this.getAdditionalDiskFolderActions() : this.getAdditionalLogicalFolderActions();
            for (int i = 0; i < actionArray.length; ++i) {
                arrayList.add(actionArray[i]);
            }
            arrayList.add(null);
            arrayList.addAll(Utilities.actionsForPath((String)"NativeProjects/Menu"));
            arrayList.add(null);
            arrayList.add((Action)SystemAction.get(FindAction.class));
            arrayList.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
            arrayList.add(null);
            arrayList.add(CommonProjectActions.customizeProjectAction());
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        public boolean canRename() {
            return false;
        }

        public PasteType getDropType(Transferable transferable, int n, int n2) {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].getSubType().equals(MakeLogicalViewProvider.SUBTYPE)) continue;
                return super.getDropType(transferable, n, n2);
            }
            return null;
        }

        protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].getSubType().equals(MakeLogicalViewProvider.SUBTYPE)) continue;
                try {
                    ViewItemNode viewItemNode = (ViewItemNode)transferable.getTransferData(dataFlavorArray[i]);
                    int n = new Integer(dataFlavorArray[i].getParameter(MakeLogicalViewProvider.MASK));
                    list.add(new ViewItemPasteType(this.getFolder(), viewItemNode, n));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            super.createPasteTypes(transferable, list);
        }

        private Action[] getAdditionalLogicalFolderActions() {
            ResourceBundle resourceBundle = NbBundle.getBundle(MakeLogicalViewProvider.class);
            Action[] actionArray = new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(AddExistingItemAction.class), SystemAction.get(AddExistingFolderItemsAction.class), SystemAction.get(NewFolderAction.class), new AddExternalItemAction(MakeLogicalViewProvider.this.project), null, ProjectSensitiveActions.projectCommandAction((String)"build", (String)resourceBundle.getString("LBL_BuildAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)resourceBundle.getString("LBL_RebuildAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"clean", (String)resourceBundle.getString("LBL_CleanAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"build_packages", (String)resourceBundle.getString("LBL_BuildPackagesAction_Name"), null), new RemoteDevelopmentAction(MakeLogicalViewProvider.this.project), new SetConfigurationAction(MakeLogicalViewProvider.this.project), null, ProjectSensitiveActions.projectCommandAction((String)"run", (String)resourceBundle.getString("LBL_RunAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"debug", (String)resourceBundle.getString("LBL_DebugAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"debug.stepinto", (String)resourceBundle.getString("LBL_DebugAction_Step_Name"), null), null, CommonProjectActions.setAsMainProjectAction(), CommonProjectActions.openSubprojectsAction(), CommonProjectActions.closeProjectAction(), null, CommonProjectActions.renameProjectAction(), CommonProjectActions.moveProjectAction(), CommonProjectActions.copyProjectAction(), CommonProjectActions.deleteProjectAction(), null};
            if (SYNC_PROJECT_ACTION) {
                actionArray = MakeLogicalViewProvider.insertSyncActions(actionArray, RemoteDevelopmentAction.class);
            }
            return actionArray;
        }

        private Action[] getAdditionalDiskFolderActions() {
            ResourceBundle resourceBundle = NbBundle.getBundle(MakeLogicalViewProvider.class);
            Action[] actionArray = new Action[]{CommonProjectActions.newFileAction(), null, new AddExternalItemAction(MakeLogicalViewProvider.this.project), null, ProjectSensitiveActions.projectCommandAction((String)"build", (String)resourceBundle.getString("LBL_BuildAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)resourceBundle.getString("LBL_RebuildAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"clean", (String)resourceBundle.getString("LBL_CleanAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"build_packages", (String)resourceBundle.getString("LBL_BuildPackagesAction_Name"), null), new RemoteDevelopmentAction(MakeLogicalViewProvider.this.project), new SetConfigurationAction(MakeLogicalViewProvider.this.project), null, ProjectSensitiveActions.projectCommandAction((String)"run", (String)resourceBundle.getString("LBL_RunAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"debug", (String)resourceBundle.getString("LBL_DebugAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"debug.stepinto", (String)resourceBundle.getString("LBL_DebugAction_Step_Name"), null), null, CommonProjectActions.setAsMainProjectAction(), CommonProjectActions.openSubprojectsAction(), CommonProjectActions.closeProjectAction(), null, CommonProjectActions.renameProjectAction(), CommonProjectActions.moveProjectAction(), CommonProjectActions.copyProjectAction(), CommonProjectActions.deleteProjectAction(), null};
            if (SYNC_PROJECT_ACTION) {
                actionArray = MakeLogicalViewProvider.insertSyncActions(actionArray, RemoteDevelopmentAction.class);
            }
            return actionArray;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            for (BrokenIncludes brokenIncludes : this.brokenIncludesResult.allInstances()) {
                brokenIncludes.addChangeListener(this);
            }
        }

        private boolean hasBrokenIncludes(Project project) {
            NativeProject nativeProject;
            BrokenIncludes brokenIncludes = (BrokenIncludes)Lookup.getDefault().lookup(BrokenIncludes.class);
            if (brokenIncludes != null && (nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class)) != null) {
                return brokenIncludes.isBroken(nativeProject);
            }
            return false;
        }

        class VisualUpdater
        implements Runnable {
            VisualUpdater() {
            }

            public void run() {
                MakeLogicalViewRootNode.this.fireIconChange();
                MakeLogicalViewRootNode.this.fireOpenedIconChange();
                MakeLogicalViewRootNode.this.fireDisplayNameChange(null, null);
            }
        }
    }

    private static class LoadingNode
    extends AbstractNode {
        public LoadingNode() {
            super(Children.LEAF);
            this.setName("dummy");
            this.setDisplayName(NbBundle.getMessage(MakeLogicalViewProvider.class, (String)"Tree_Loading"));
        }

        public Image getIcon(int n) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/waitNode.gif");
        }
    }
}

