/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerManager;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.makeproject.api.configurations.ArchiverConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CustomToolConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.DefaultMakefileWriter;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.LinkerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakefileConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platform;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platforms;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.configurations.QmakeProjectWriter;
import org.netbeans.modules.cnd.makeproject.packaging.DummyPackager;
import org.netbeans.modules.cnd.makeproject.spi.configurations.MakefileWriter;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationMakefileWriter {
    private MakeConfigurationDescriptor projectDescriptor;

    public ConfigurationMakefileWriter(MakeConfigurationDescriptor makeConfigurationDescriptor) {
        this.projectDescriptor = makeConfigurationDescriptor;
    }

    public void write() {
        Collection<MakeConfiguration> collection = this.getProtectedConfigurations();
        this.cleanup(collection);
        this.writeMakefileImpl();
        Configuration[] configurationArray = this.projectDescriptor.getConfs().getConfs();
        for (int i = 0; i < configurationArray.length; ++i) {
            MakeConfiguration makeConfiguration = (MakeConfiguration)configurationArray[i];
            if (collection.contains(makeConfiguration)) continue;
            this.writeMakefileConf(makeConfiguration);
            this.writePackagingScript(makeConfiguration);
        }
        this.writeMakefileVariables(this.projectDescriptor);
    }

    private Collection<MakeConfiguration> getProtectedConfigurations() {
        ArrayList<MakeConfiguration> arrayList = new ArrayList<MakeConfiguration>();
        ArrayList<MakeConfiguration> arrayList2 = new ArrayList<MakeConfiguration>();
        Configuration[] configurationArray = this.projectDescriptor.getConfs().getConfs();
        for (int i = 0; i < configurationArray.length; ++i) {
            MakeConfiguration makeConfiguration = (MakeConfiguration)configurationArray[i];
            if (makeConfiguration.getDevelopmentHost().isLocalhost() && CompilerSetManager.getDefault((ExecutionEnvironment)makeConfiguration.getDevelopmentHost().getExecutionEnvironment()).getPlatform() != makeConfiguration.getDevelopmentHost().getBuildPlatformConfiguration().getValue()) {
                arrayList2.add(makeConfiguration);
                arrayList.add(makeConfiguration);
                continue;
            }
            if (makeConfiguration.getCompilerSet().getCompilerSet() != null) continue;
            arrayList.add(makeConfiguration);
        }
        if (!arrayList2.isEmpty()) {
            ExecutionEnvironment executionEnvironment = ExecutionEnvironmentFactory.fromUniqueID((String)"localhost");
            int n = CompilerSetManager.getDefault((ExecutionEnvironment)executionEnvironment).getPlatform();
            Platform platform = Platforms.getPlatform(n);
            StringBuffer stringBuffer = new StringBuffer();
            for (MakeConfiguration makeConfiguration : arrayList2) {
                stringBuffer.append(ConfigurationMakefileWriter.getString("CONF", makeConfiguration.getName(), makeConfiguration.getDevelopmentHost().getBuildPlatformConfiguration().getName()) + "\n");
            }
            final String string = ConfigurationMakefileWriter.getString("TARGET_MISMATCH_TXT", platform.getDisplayName(), stringBuffer.toString());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
            });
        }
        return arrayList;
    }

    private void cleanup(Collection<MakeConfiguration> collection) {
        File file = new File(this.projectDescriptor.getBaseDir() + '/' + "nbproject");
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getName();
            if (!string.startsWith("Makefile-") && !string.startsWith("Package-")) continue;
            boolean bl = false;
            for (MakeConfiguration makeConfiguration : collection) {
                if (!string.equals("Makefile-" + makeConfiguration.getName() + ".mk") && !string.equals("Package-" + makeConfiguration.getName() + ".bash")) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            fileArray[i].delete();
        }
    }

    private void writeMakefileImpl() {
        Object object;
        String string = "/org/netbeans/modules/cnd/makeproject/resources/MasterMakefile-impl.mk";
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            object = new URL("nbresloc:" + string);
            inputStream = ((URL)object).openStream();
        }
        catch (Exception exception) {
            inputStream = MakeConfigurationDescriptor.class.getResourceAsStream(string);
        }
        object = this.projectDescriptor.getBaseDir() + '/' + "nbproject" + '/' + "Makefile-impl.mk";
        try {
            fileOutputStream = new FileOutputStream((String)object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (inputStream == null || fileOutputStream == null) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        String string2 = IpeUtils.getBaseName((String)this.projectDescriptor.getBaseDir());
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.projectDescriptor.getConfs().getConfs().length; ++i) {
            stringBuilder.append(this.projectDescriptor.getConfs().getConfs()[i].getName());
            stringBuilder.append(" ");
        }
        try {
            String string3;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.indexOf("<PN>") >= 0) {
                    string3 = string3.replaceFirst("<PN>", string2);
                } else if (string3.indexOf("<CNS>") >= 0) {
                    string3 = string3.replaceFirst("<CNS>", stringBuilder.toString());
                } else if (string3.indexOf("<CN>") >= 0) {
                    string3 = string3.replaceFirst("<CN>", this.projectDescriptor.getConfs().getConf(0).getName());
                }
                bufferedWriter.write(string3 + "\n");
            }
            bufferedReader.close();
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeMakefileConf(MakeConfiguration makeConfiguration) {
        Object object;
        String string = this.projectDescriptor.getBaseDir() + '/' + "nbproject" + '/' + "Makefile-" + makeConfiguration.getName() + ".mk";
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MakefileWriter makefileWriter = null;
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet != null && (object = compilerSet.getCompilerFlavor().getToolchainDescriptor().getMakefileWriter()) != null) {
            Collection collection = Lookup.getDefault().lookupAll(MakefileWriter.class);
            for (MakefileWriter makefileWriter2 : collection) {
                if (!((String)object).equals(makefileWriter2.getClass().getName())) continue;
                makefileWriter = makefileWriter2;
                break;
            }
            if (makefileWriter == null) {
                System.err.println("ERROR: class" + (String)object + " is not found or is not instance of MakefileWriter");
            }
        }
        if (makefileWriter == null) {
            makefileWriter = new DefaultMakefileWriter();
        }
        object = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        try {
            makefileWriter.writePrelude(this.projectDescriptor, makeConfiguration, (Writer)object);
            this.writeBuildTargets(makefileWriter, this.projectDescriptor, makeConfiguration, (BufferedWriter)object);
            makefileWriter.writeCleanTarget(this.projectDescriptor, makeConfiguration, (Writer)object);
            makefileWriter.writeDependencyChecking(this.projectDescriptor, makeConfiguration, (Writer)object);
            ((BufferedWriter)object).flush();
            ((BufferedWriter)object).close();
            if (makeConfiguration.isQmakeConfiguration()) {
                new QmakeProjectWriter(this.projectDescriptor, makeConfiguration).write();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getCompilerName(MakeConfiguration makeConfiguration, int n) {
        Tool tool;
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet != null && (tool = compilerSet.getTool(n)) != null) {
            BasicCompilerConfiguration basicCompilerConfiguration = null;
            switch (n) {
                case 0: {
                    basicCompilerConfiguration = makeConfiguration.getCCompilerConfiguration();
                    break;
                }
                case 1: {
                    basicCompilerConfiguration = makeConfiguration.getCCCompilerConfiguration();
                    break;
                }
                case 2: {
                    basicCompilerConfiguration = makeConfiguration.getFortranCompilerConfiguration();
                    break;
                }
                case 4: {
                    basicCompilerConfiguration = makeConfiguration.getAssemblerConfiguration();
                }
            }
            if (basicCompilerConfiguration != null && basicCompilerConfiguration.getTool().getModified()) {
                return basicCompilerConfiguration.getTool().getValue();
            }
            if (0 < tool.getName().length()) {
                return tool.getName();
            }
            if (compilerSet.isUrlPointer()) {
                return tool.getDescriptor().getNames()[0];
            }
        }
        return "";
    }

    public static void writePrelude(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, Writer writer) throws IOException {
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return;
        }
        BasicCompiler basicCompiler = (BasicCompiler)compilerSet.getTool(0);
        BasicCompiler basicCompiler2 = (BasicCompiler)compilerSet.getTool(1);
        BasicCompiler basicCompiler3 = (BasicCompiler)compilerSet.getTool(2);
        BasicCompiler basicCompiler4 = (BasicCompiler)compilerSet.getTool(4);
        writer.write("#\n");
        writer.write("# Generated Makefile - do not edit!\n");
        writer.write("#\n");
        writer.write("# Edit the Makefile in the project folder instead (../Makefile). Each target\n");
        writer.write("# has a -pre and a -post target defined where you can add customized code.\n");
        writer.write("#\n");
        writer.write("# This makefile implements configuration specific macros and targets.\n");
        writer.write("\n");
        writer.write("\n");
        writer.write("# Environment\n");
        writer.write("MKDIR=mkdir\n");
        writer.write("CP=cp\n");
        writer.write("CCADMIN=CCadmin\n");
        writer.write("RANLIB=ranlib\n");
        writer.write("CC=" + ConfigurationMakefileWriter.getCompilerName(makeConfiguration, 0) + "\n");
        writer.write("CCC=" + ConfigurationMakefileWriter.getCompilerName(makeConfiguration, 1) + "\n");
        writer.write("CXX=" + ConfigurationMakefileWriter.getCompilerName(makeConfiguration, 1) + "\n");
        writer.write("FC=" + ConfigurationMakefileWriter.getCompilerName(makeConfiguration, 2) + "\n");
        writer.write("AS=" + ConfigurationMakefileWriter.getCompilerName(makeConfiguration, 4) + "\n");
        if (makeConfiguration.getArchiverConfiguration().getTool().getModified()) {
            writer.write("AR=" + makeConfiguration.getArchiverConfiguration().getTool().getValue() + "\n");
        }
        if (makeConfiguration.isQmakeConfiguration()) {
            writer.write("QMAKE=" + ConfigurationMakefileWriter.getCompilerName(makeConfiguration, 7) + "\n");
        }
        writer.write("\n");
        writer.write("# Macros\n");
        writer.write("CND_PLATFORM=" + makeConfiguration.getVariant() + "\n");
        writer.write("CND_CONF=" + makeConfiguration.getName() + "\n");
        writer.write("CND_DISTDIR=dist\n");
        writer.write("\n");
        writer.write("# Include project Makefile\n");
        writer.write("include " + makeConfigurationDescriptor.getProjectMakefileName() + "\n");
        writer.write("\n");
        writer.write("# Object Directory\n");
        writer.write("OBJECTDIR=" + ConfigurationMakefileWriter.getObjectDir(makeConfiguration) + "\n");
        writer.write("\n");
        writer.write("# Object Files\n");
        writer.write("OBJECTFILES=" + ConfigurationMakefileWriter.getObjectFiles(makeConfigurationDescriptor, makeConfiguration) + "\n");
        writer.write("\n");
        if (basicCompiler != null) {
            writer.write("# C Compiler Flags\n");
            writer.write("CFLAGS=" + makeConfiguration.getCCompilerConfiguration().getCFlags(basicCompiler) + "\n");
            writer.write("\n");
        }
        if (basicCompiler2 != null) {
            writer.write("# CC Compiler Flags\n");
            writer.write("CCFLAGS=" + makeConfiguration.getCCCompilerConfiguration().getCCFlags(basicCompiler2) + "\n");
            writer.write("CXXFLAGS=" + makeConfiguration.getCCCompilerConfiguration().getCCFlags(basicCompiler2) + "\n");
            writer.write("\n");
        }
        if (basicCompiler3 != null) {
            writer.write("# Fortran Compiler Flags\n");
            writer.write("FFLAGS=" + makeConfiguration.getFortranCompilerConfiguration().getFFlags(basicCompiler3) + "\n");
            writer.write("\n");
        }
        if (basicCompiler4 != null) {
            writer.write("# Assembler Flags\n");
            writer.write("ASFLAGS=" + makeConfiguration.getAssemblerConfiguration().getAsFlags(basicCompiler4) + "\n");
            writer.write("\n");
        }
        writer.write("# Link Libraries and Options\n");
        writer.write("LDLIBSOPTIONS=" + makeConfiguration.getLinkerConfiguration().getLibraryItems() + "\n");
        writer.write("\n");
        if (makeConfiguration.isQmakeConfiguration()) {
            String string = makeConfiguration.getQmakeConfiguration().getQmakeSpec().getValue();
            if (string.length() == 0 && makeConfiguration.getDevelopmentHost().getBuildPlatform() == 4) {
                string = compilerSet.getQmakeSpec(makeConfiguration.getDevelopmentHost().getBuildPlatform());
            }
            if (0 < string.length()) {
                string = "-spec " + string + " ";
            }
            writer.write("nbproject/qt-${CND_CONF}.mk: nbproject/qt-${CND_CONF}.pro FORCE\n");
            writer.write("\t${QMAKE} VPATH=. " + string + "-o qttmp-${CND_CONF}.mk nbproject/qt-${CND_CONF}.pro\n");
            writer.write("\tmv -f qttmp-${CND_CONF}.mk nbproject/qt-${CND_CONF}.mk\n");
            if (makeConfiguration.getDevelopmentHost().getBuildPlatform() == 3) {
                writer.write("\t@sed -e 's:\\\\\\(.\\):/\\1:g' nbproject/qt-${CND_CONF}.mk >nbproject/qt-${CND_CONF}.tmp\n");
                writer.write("\t@mv -f nbproject/qt-${CND_CONF}.tmp nbproject/qt-${CND_CONF}.mk\n");
            }
            writer.write(10);
            writer.write("FORCE:\n\n");
        }
    }

    protected void writeBuildTargets(MakefileWriter makefileWriter, MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, BufferedWriter bufferedWriter) throws IOException {
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            bufferedWriter.write(".build-conf:\n");
            bufferedWriter.write("\t@echo 'Tool collection " + makeConfiguration.getCompilerSet().getCompilerSetName().getValue() + " was missing when this makefile was generated'\n");
            bufferedWriter.write("\t@echo 'Please specify existing tool collection in project properties'\n");
            bufferedWriter.write("\t@exit 1\n\n");
            return;
        }
        if (makeConfiguration.isCompileConfiguration()) {
            makefileWriter.writeBuildTarget(makeConfigurationDescriptor, makeConfiguration, bufferedWriter);
            if (makeConfiguration.isLinkerConfiguration()) {
                makefileWriter.writeLinkTarget(makeConfigurationDescriptor, makeConfiguration, bufferedWriter);
            }
            if (makeConfiguration.isArchiverConfiguration()) {
                makefileWriter.writeArchiveTarget(makeConfigurationDescriptor, makeConfiguration, bufferedWriter);
            }
            if (makeConfiguration.isCompileConfiguration()) {
                makefileWriter.writeCompileTargets(makeConfigurationDescriptor, makeConfiguration, bufferedWriter);
            }
        } else if (makeConfiguration.isMakefileConfiguration()) {
            makefileWriter.writeMakefileTarget(makeConfigurationDescriptor, makeConfiguration, bufferedWriter);
        } else if (makeConfiguration.isQmakeConfiguration()) {
            makefileWriter.writeQTTarget(makeConfigurationDescriptor, makeConfiguration, bufferedWriter);
        }
        makefileWriter.writeSubProjectBuildTargets(makeConfigurationDescriptor, makeConfiguration, bufferedWriter);
    }

    public static void writeQTTarget(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, Writer writer) throws IOException {
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        String string = compilerSet.normalizeDriveLetter(ConfigurationMakefileWriter.getOutput(makeConfiguration));
        writer.write("# Build Targets\n");
        writer.write(".build-conf: ${BUILD_SUBPROJECTS} nbproject/qt-${CND_CONF}.mk\n");
        writer.write("\t${MAKE} -f nbproject/qt-${CND_CONF}.mk " + string + "\n");
    }

    public static void writeBuildTarget(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, Writer writer) throws IOException {
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        String string = compilerSet.normalizeDriveLetter(ConfigurationMakefileWriter.getOutput(makeConfiguration));
        writer.write("# Build Targets\n");
        writer.write(".build-conf: ${BUILD_SUBPROJECTS}\n");
        writer.write("\t${MAKE}  -f nbproject/Makefile-" + makeConfiguration.getName() + ".mk " + string + "\n\n");
    }

    public static void writeLinkTarget(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, Writer writer) throws IOException {
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        String string = compilerSet.normalizeDriveLetter(ConfigurationMakefileWriter.getOutput(makeConfiguration));
        LinkerConfiguration linkerConfiguration = makeConfiguration.getLinkerConfiguration();
        CompilerSet compilerSet2 = makeConfiguration.getCompilerSet().getCompilerSet();
        string = compilerSet2.normalizeDriveLetter(string);
        String string2 = "";
        string2 = linkerConfiguration.getTool().getModified() ? string2 + linkerConfiguration.getTool().getValue() + " " : (makeConfiguration.hasCPPFiles(makeConfigurationDescriptor) ? string2 + "${LINK.cc} " : (makeConfiguration.hasFortranFiles(makeConfigurationDescriptor) ? string2 + "${LINK.f} " : string2 + "${LINK.c} "));
        string2 = string2 + linkerConfiguration.getOptions() + " ";
        string2 = string2 + "${OBJECTFILES} ";
        string2 = string2 + "${LDLIBSOPTIONS} ";
        String[] stringArray = linkerConfiguration.getAdditionalDependencies().getValues();
        for (int i = 0; i < stringArray.length; ++i) {
            writer.write(string + ": " + stringArray[i] + "\n\n");
        }
        for (LibraryItem libraryItem : linkerConfiguration.getLibrariesConfiguration().getValue()) {
            String string3 = libraryItem.getPath();
            if (string3 == null || string3.length() <= 0) continue;
            writer.write(string + ": " + IpeUtils.escapeOddCharacters((String)compilerSet2.normalizeDriveLetter(string3)) + "\n\n");
        }
        writer.write(string + ": ${OBJECTFILES}\n");
        String string4 = IpeUtils.getDirName((String)string);
        if (string4 != null) {
            writer.write("\t${MKDIR} -p " + (String)string4 + "\n");
        }
        writer.write("\t" + string2 + "\n");
    }

    public static void writeArchiveTarget(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, Writer writer) throws IOException {
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        String string = compilerSet.normalizeDriveLetter(ConfigurationMakefileWriter.getOutput(makeConfiguration));
        ArchiverConfiguration archiverConfiguration = makeConfiguration.getArchiverConfiguration();
        String string2 = "${AR} ";
        string2 = string2 + archiverConfiguration.getOptions() + " ";
        string2 = string2 + "${OBJECTFILES} ";
        writer.write(string + ": " + "${OBJECTFILES}" + "\n");
        String string3 = IpeUtils.getDirName((String)string);
        if (string3 != null) {
            writer.write("\t${MKDIR} -p " + string3 + "\n");
        }
        writer.write("\t${RM} " + string + "\n");
        writer.write("\t" + string2 + "\n");
        if (archiverConfiguration.getRunRanlib().getValue()) {
            writer.write("\t" + archiverConfiguration.getRunRanlib().getOption() + " " + string + "\n");
        }
    }

    public static void writeCompileTargets(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, Writer writer) throws IOException {
        Item[] itemArray = makeConfigurationDescriptor.getProjectItems();
        if (makeConfiguration.isCompileConfiguration()) {
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            for (int i = 0; i < itemArray.length; ++i) {
                Object object;
                CompilerSet compilerSet;
                ItemConfiguration itemConfiguration = itemArray[i].getItemConfiguration(makeConfiguration);
                if (itemConfiguration.getExcluded().getValue() || (compilerSet = makeConfiguration.getCompilerSet().getCompilerSet()) == null) continue;
                string3 = IpeUtils.escapeOddCharacters((String)compilerSet.normalizeDriveLetter(itemArray[i].getPath()));
                string4 = "";
                string5 = null;
                string6 = null;
                if (itemConfiguration.isCompilerToolConfiguration()) {
                    object = (BasicCompiler)compilerSet.getTool(itemConfiguration.getTool());
                    BasicCompilerConfiguration basicCompilerConfiguration = itemConfiguration.getCompilerConfiguration();
                    string = basicCompilerConfiguration.getOutputFile(itemArray[i], makeConfiguration, false);
                    if (object != null && ((BasicCompiler)((Object)object)).getDescriptor() != null) {
                        String string7 = "";
                        if (makeConfiguration.getConfigurationType().getValue() == 2 && makeConfiguration.getLinkerConfiguration().getPICOption().getValue()) {
                            string7 = " " + makeConfiguration.getLinkerConfiguration().getPICOption(compilerSet);
                        }
                        string4 = string4 + basicCompilerConfiguration.getOptions((BasicCompiler)((Object)object)) + string7 + " ";
                        if (makeConfiguration.getDependencyChecking().getValue() && ((BasicCompiler)((Object)object)).getDependencyGenerationOption().length() > 0) {
                            string4 = "${RM} $@.d\n\t" + string4 + ((BasicCompiler)((Object)object)).getDependencyGenerationOption() + " ";
                        }
                        if (itemArray[i].hasHeaderOrSourceExtension(false, false)) {
                            String string8 = ((BasicCompiler)((Object)object)).getDescriptor().getPrecompiledHeaderFlags();
                            if (string8 == null) {
                                string4 = "# command to precompile header ";
                                string5 = "Current compiler does not support header precompilation";
                            } else {
                                string4 = string4 + ((BasicCompiler)((Object)object)).getDescriptor().getPrecompiledHeaderFlags() + " ";
                            }
                        } else {
                            string4 = string4 + ((BasicCompiler)((Object)object)).getDescriptor().getOutputObjectFileFlags() + string + " ";
                        }
                        string4 = string4 + IpeUtils.escapeOddCharacters((String)compilerSet.normalizeDriveLetter(itemArray[i].getPath(true)));
                    }
                    string6 = basicCompilerConfiguration.getAdditionalDependencies().getValue();
                } else if (itemConfiguration.getTool() == 3) {
                    object = itemConfiguration.getCustomToolConfiguration();
                    if (!((CustomToolConfiguration)object).getModified()) continue;
                    string = ((CustomToolConfiguration)object).getOutputs().getValue(" + ");
                    string4 = ((CustomToolConfiguration)object).getCommandLine().getValue();
                    string5 = ((CustomToolConfiguration)object).getDescription().getValue();
                    string6 = ((CustomToolConfiguration)object).getAdditionalDependencies().getValue();
                } else assert (false);
                string2 = IpeUtils.getDirName(string);
                writer.write("\n");
                if (string6 != null) {
                    writer.write(string + ": nbproject/Makefile-${CND_CONF}.mk " + string3 + " " + string6 + "\n");
                } else {
                    writer.write(string + ": nbproject/Makefile-${CND_CONF}.mk " + string3 + "\n");
                }
                if (string2 != null) {
                    writer.write("\t${MKDIR} -p " + string2 + "\n");
                }
                if (string5 != null) {
                    writer.write("\t@echo " + string5 + "\n");
                }
                writer.write("\t" + string4 + "\n");
            }
        }
    }

    public static void writeMakefileTarget(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, Writer writer) throws IOException {
        MakefileConfiguration makefileConfiguration = makeConfiguration.getMakefileConfiguration();
        String string = makefileConfiguration.getOutput().getValue();
        String string2 = makefileConfiguration.getBuildCommandWorkingDirValue();
        String string3 = makefileConfiguration.getBuildCommand().getValue();
        writer.write("# Build Targets\n");
        writer.write(".build-conf: ${BUILD_SUBPROJECTS}\n");
        writer.write("\tcd " + IpeUtils.escapeOddCharacters((String)FilePathAdaptor.normalize(string2)) + " && " + string3 + "\n");
    }

    public static void writeSubProjectBuildTargets(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, Writer writer) throws IOException {
        Object object;
        Object object2;
        writer.write("\n");
        writer.write("# Subprojects\n");
        writer.write(".build-subprojects:\n");
        LibrariesConfiguration librariesConfiguration = null;
        if (makeConfiguration.isLinkerConfiguration()) {
            librariesConfiguration = makeConfiguration.getLinkerConfiguration().getLibrariesConfiguration();
            for (LibraryItem libraryItem : librariesConfiguration.getValue()) {
                if (!(libraryItem instanceof LibraryItem.ProjectItem)) continue;
                object2 = libraryItem;
                object = ((LibraryItem.ProjectItem)object2).getMakeArtifact();
                String string = ((MakeArtifact)object).getWorkingDirectory();
                if (!((MakeArtifact)object).getBuild()) continue;
                writer.write("\tcd " + IpeUtils.escapeOddCharacters((String)FilePathAdaptor.normalize(string)) + " && " + ((MakeArtifact)object).getBuildCommand() + "\n");
            }
        }
        for (LibraryItem libraryItem : makeConfiguration.getRequiredProjectsConfiguration().getValue()) {
            object2 = libraryItem.getMakeArtifact();
            object = ((MakeArtifact)object2).getWorkingDirectory();
            if (!((MakeArtifact)object2).getBuild()) continue;
            writer.write("\tcd " + IpeUtils.escapeOddCharacters((String)FilePathAdaptor.normalize((String)object)) + " && " + ((MakeArtifact)object2).getBuildCommand() + "\n");
        }
        writer.write("\n");
    }

    private static void writeSubProjectCleanTargets(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, Writer writer) throws IOException {
        Object object;
        Object object2;
        writer.write("\n");
        writer.write("# Subprojects\n");
        writer.write(".clean-subprojects:\n");
        LibrariesConfiguration librariesConfiguration = null;
        if (makeConfiguration.isLinkerConfiguration()) {
            librariesConfiguration = makeConfiguration.getLinkerConfiguration().getLibrariesConfiguration();
            for (LibraryItem libraryItem : librariesConfiguration.getValue()) {
                if (!(libraryItem instanceof LibraryItem.ProjectItem)) continue;
                object2 = libraryItem;
                object = ((LibraryItem.ProjectItem)object2).getMakeArtifact();
                String string = ((MakeArtifact)object).getWorkingDirectory();
                if (!((MakeArtifact)object).getBuild()) continue;
                writer.write("\tcd " + IpeUtils.escapeOddCharacters((String)FilePathAdaptor.normalize(string)) + " && " + ((MakeArtifact)object).getCleanCommand() + "\n");
            }
        }
        for (LibraryItem libraryItem : makeConfiguration.getRequiredProjectsConfiguration().getValue()) {
            object2 = libraryItem.getMakeArtifact();
            object = ((MakeArtifact)object2).getWorkingDirectory();
            if (!((MakeArtifact)object2).getBuild()) continue;
            writer.write("\tcd " + IpeUtils.escapeOddCharacters((String)FilePathAdaptor.normalize((String)object)) + " && " + ((MakeArtifact)object2).getCleanCommand() + "\n");
        }
    }

    public static void writeCleanTarget(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, Writer writer) throws IOException {
        writer.write("# Clean Targets\n");
        writer.write(".clean-conf: ${CLEAN_SUBPROJECTS}");
        if (makeConfiguration.isQmakeConfiguration()) {
            writer.write(" nbproject/qt-" + makeConfiguration.getName() + ".mk");
        }
        writer.write(10);
        if (makeConfiguration.isCompileConfiguration()) {
            writer.write("\t${RM} -r build/" + makeConfiguration.getName() + "\n");
            writer.write("\t${RM} " + ConfigurationMakefileWriter.getOutput(makeConfiguration) + "\n");
            if (makeConfiguration.getCompilerSet().getCompilerSet() != null && makeConfiguration.getCompilerSet().getCompilerSet().isSunCompiler() && makeConfiguration.hasCPPFiles(makeConfigurationDescriptor)) {
                writer.write("\t${CCADMIN} -clean\n");
            }
            if (makeConfiguration.hasFortranFiles(makeConfigurationDescriptor)) {
                writer.write("\t${RM} *.mod\n");
            }
            Item[] itemArray = makeConfigurationDescriptor.getProjectItems();
            for (int i = 0; i < itemArray.length; ++i) {
                ItemConfiguration itemConfiguration = itemArray[i].getItemConfiguration(makeConfiguration);
                if (itemConfiguration.getExcluded().getValue() || itemConfiguration.getTool() != 3 || !itemConfiguration.getCustomToolConfiguration().getModified()) continue;
                writer.write("\t${RM} " + itemConfiguration.getCustomToolConfiguration().getOutputs().getValue() + "\n");
            }
        } else if (makeConfiguration.isMakefileConfiguration()) {
            MakefileConfiguration makefileConfiguration = makeConfiguration.getMakefileConfiguration();
            String string = makefileConfiguration.getOutput().getValue();
            String string2 = makefileConfiguration.getBuildCommandWorkingDirValue();
            String string3 = makefileConfiguration.getCleanCommand().getValue();
            writer.write("\tcd " + IpeUtils.escapeOddCharacters((String)FilePathAdaptor.normalize(string2)) + " && " + string3 + "\n");
        } else if (makeConfiguration.isQmakeConfiguration()) {
            writer.write("\t$(MAKE) -f nbproject/qt-" + makeConfiguration.getName() + ".mk distclean\n");
        }
        ConfigurationMakefileWriter.writeSubProjectCleanTargets(makeConfigurationDescriptor, makeConfiguration, writer);
    }

    public static void writeDependencyChecking(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, Writer writer) throws IOException {
        if (makeConfiguration.getDependencyChecking().getValue() && !makeConfiguration.isMakefileConfiguration() && !makeConfiguration.isQmakeConfiguration() && makeConfiguration.getCompilerSet().getCompilerSet() != null) {
            writer.write("\n");
            writer.write("# Enable dependency checking\n");
            writer.write(".dep.inc: .depcheck-impl\n");
            writer.write("\n");
            writer.write("include .dep.inc\n");
        }
    }

    private static String getOutput(MakeConfiguration makeConfiguration) {
        String string = makeConfiguration.getOutputValue();
        switch (makeConfiguration.getDevelopmentHost().getBuildPlatform()) {
            case 3: {
                switch (makeConfiguration.getConfigurationType().getValue()) {
                    case 1: 
                    case 4: {
                        string = ConfigurationMakefileWriter.mangleAppnameWin(string);
                    }
                }
            }
        }
        return makeConfiguration.expandMacros(string);
    }

    private static String mangleAppnameWin(String string) {
        if (string.endsWith(".exe")) {
            return string;
        }
        return string + ".exe";
    }

    public static String getObjectDir(MakeConfiguration makeConfiguration) {
        return "build/${CND_CONF}/${CND_PLATFORM}";
    }

    private static String getObjectFiles(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration) {
        Item[] itemArray = makeConfigurationDescriptor.getProjectItems();
        StringBuilder stringBuilder = new StringBuilder();
        if (makeConfiguration.isCompileConfiguration()) {
            for (int i = 0; i < itemArray.length; ++i) {
                ItemConfiguration itemConfiguration = itemArray[i].getItemConfiguration(makeConfiguration);
                if (itemConfiguration.getExcluded().getValue() || !itemConfiguration.isCompilerToolConfiguration() || itemArray[i].hasHeaderOrSourceExtension(false, false)) continue;
                BasicCompilerConfiguration basicCompilerConfiguration = itemConfiguration.getCompilerConfiguration();
                stringBuilder.append(" \\\n\t");
                stringBuilder.append(basicCompilerConfiguration.getOutputFile(itemArray[i], makeConfiguration, false));
            }
        }
        return stringBuilder.toString();
    }

    private void writeMakefileVariables(MakeConfigurationDescriptor makeConfigurationDescriptor) {
        String string = this.projectDescriptor.getBaseDir() + '/' + "nbproject" + '/' + "Makefile-variables.mk";
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        try {
            this.writeMakefileVariablesBody(bufferedWriter, makeConfigurationDescriptor);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeMakefileVariablesBody(BufferedWriter bufferedWriter, MakeConfigurationDescriptor makeConfigurationDescriptor) throws IOException {
        bufferedWriter.write("#\n");
        bufferedWriter.write("# Generated - do not edit!\n");
        bufferedWriter.write("#\n");
        bufferedWriter.write("# NOCDDL\n");
        bufferedWriter.write("#\n");
        bufferedWriter.write("CND_BASEDIR=`pwd`\n");
        bufferedWriter.write("CND_BUILDDIR=build\n");
        bufferedWriter.write("CND_DISTDIR=dist\n");
        Configuration[] configurationArray = this.projectDescriptor.getConfs().getConfs();
        for (int i = 0; i < configurationArray.length; ++i) {
            MakeConfiguration makeConfiguration = (MakeConfiguration)configurationArray[i];
            bufferedWriter.write("# " + makeConfiguration.getName() + " configuration");
            bufferedWriter.write("\n");
            bufferedWriter.write("CND_PLATFORM_" + makeConfiguration.getName() + "=" + makeConfiguration.getVariant());
            bufferedWriter.write("\n");
            String string = makeConfiguration.expandMacros(makeConfiguration.getOutputValue());
            String string2 = IpeUtils.getDirName((String)string);
            if (string2 == null) {
                string2 = "";
            }
            String string3 = IpeUtils.getBaseName((String)string);
            bufferedWriter.write("CND_ARTIFACT_DIR_" + makeConfiguration.getName() + "=" + string2);
            bufferedWriter.write("\n");
            bufferedWriter.write("CND_ARTIFACT_NAME_" + makeConfiguration.getName() + "=" + string3);
            bufferedWriter.write("\n");
            bufferedWriter.write("CND_ARTIFACT_PATH_" + makeConfiguration.getName() + "=" + string);
            bufferedWriter.write("\n");
            PackagerDescriptor packagerDescriptor = PackagerManager.getDefault().getPackager(makeConfiguration.getPackagingConfiguration().getType().getValue());
            string = makeConfiguration.expandMacros(makeConfiguration.getPackagingConfiguration().getOutputValue());
            if (!packagerDescriptor.isOutputAFolder()) {
                string2 = IpeUtils.getDirName((String)string);
                if (string2 == null) {
                    string2 = "";
                }
                string3 = IpeUtils.getBaseName((String)string);
            } else {
                string2 = string;
                string = "";
                string3 = "";
            }
            bufferedWriter.write("CND_PACKAGE_DIR_" + makeConfiguration.getName() + "=" + string2);
            bufferedWriter.write("\n");
            bufferedWriter.write("CND_PACKAGE_NAME_" + makeConfiguration.getName() + "=" + string3);
            bufferedWriter.write("\n");
            bufferedWriter.write("CND_PACKAGE_PATH_" + makeConfiguration.getName() + "=" + string);
            bufferedWriter.write("\n");
        }
    }

    private void writePackagingScript(MakeConfiguration makeConfiguration) {
        String string = this.projectDescriptor.getBaseDir() + '/' + "nbproject" + '/' + "Package-" + makeConfiguration.getName() + ".bash";
        if (makeConfiguration.getPackagingConfiguration().getFiles().getValue().size() == 0) {
            return;
        }
        PackagerDescriptor packagerDescriptor = PackagerManager.getDefault().getPackager(makeConfiguration.getPackagingConfiguration().getType().getValue());
        if (packagerDescriptor == null || packagerDescriptor instanceof DummyPackager) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        try {
            this.writePackagingScriptBody(bufferedWriter, makeConfiguration);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writePackagingScriptBody(BufferedWriter bufferedWriter, MakeConfiguration makeConfiguration) throws IOException {
        String string = "tmp-packaging";
        String string2 = ConfigurationMakefileWriter.getObjectDir(makeConfiguration) + "/" + string;
        PackagingConfiguration packagingConfiguration = makeConfiguration.getPackagingConfiguration();
        String string3 = packagingConfiguration.getOutputValue();
        PackagerDescriptor packagerDescriptor = PackagerManager.getDefault().getPackager(packagingConfiguration.getType().getValue());
        bufferedWriter.write("#!/bin/bash");
        if (makeConfiguration.getPackagingConfiguration().getVerbose().getValue()) {
            bufferedWriter.write(" -x");
        }
        bufferedWriter.write("\n");
        bufferedWriter.write("\n");
        bufferedWriter.write("#\n");
        bufferedWriter.write("# Generated - do not edit!\n");
        bufferedWriter.write("#\n");
        bufferedWriter.write("\n");
        bufferedWriter.write("# Macros\n");
        bufferedWriter.write("TOP=`pwd`\n");
        bufferedWriter.write("CND_PLATFORM=" + makeConfiguration.getVariant() + "\n");
        bufferedWriter.write("CND_CONF=" + makeConfiguration.getName() + "\n");
        bufferedWriter.write("CND_DISTDIR=dist\n");
        bufferedWriter.write("TMPDIR=" + string2 + "\n");
        bufferedWriter.write("TMPDIRNAME=" + string + "\n");
        String string4 = makeConfiguration.getOutputValue();
        if (string4 == null || string4.length() == 0) {
            string4 = "MissingOutputInProject";
        }
        bufferedWriter.write("OUTPUT_PATH=" + string4 + "\n");
        bufferedWriter.write("OUTPUT_BASENAME=" + IpeUtils.getBaseName((String)string4) + "\n");
        bufferedWriter.write("PACKAGE_TOP_DIR=" + (packagingConfiguration.getTopDirValue().length() > 0 ? packagingConfiguration.getTopDirValue() + "/" : "") + "\n");
        bufferedWriter.write("\n");
        bufferedWriter.write("# Functions\n");
        bufferedWriter.write("function checkReturnCode\n");
        bufferedWriter.write("{\n");
        bufferedWriter.write("    rc=$?\n");
        bufferedWriter.write("    if [ $rc != 0 ]\n");
        bufferedWriter.write("    then\n");
        bufferedWriter.write("        exit $rc\n");
        bufferedWriter.write("    fi\n");
        bufferedWriter.write("}\n");
        bufferedWriter.write("function makeDirectory\n");
        bufferedWriter.write("# $1 directory path\n");
        bufferedWriter.write("# $2 permission (optional)\n");
        bufferedWriter.write("{\n");
        bufferedWriter.write("    mkdir -p \"$1\"\n");
        bufferedWriter.write("    checkReturnCode\n");
        bufferedWriter.write("    if [ \"$2\" != \"\" ]\n");
        bufferedWriter.write("    then\n");
        bufferedWriter.write("      chmod $2 \"$1\"\n");
        bufferedWriter.write("      checkReturnCode\n");
        bufferedWriter.write("    fi\n");
        bufferedWriter.write("}\n");
        bufferedWriter.write("function copyFileToTmpDir\n");
        bufferedWriter.write("# $1 from-file path\n");
        bufferedWriter.write("# $2 to-file path\n");
        bufferedWriter.write("# $3 permission\n");
        bufferedWriter.write("{\n");
        bufferedWriter.write("    cp \"$1\" \"$2\"\n");
        bufferedWriter.write("    checkReturnCode\n");
        bufferedWriter.write("    if [ \"$3\" != \"\" ]\n");
        bufferedWriter.write("    then\n");
        bufferedWriter.write("        chmod $3 \"$2\"\n");
        bufferedWriter.write("        checkReturnCode\n");
        bufferedWriter.write("    fi\n");
        bufferedWriter.write("}\n");
        bufferedWriter.write("\n");
        bufferedWriter.write("# Setup\n");
        bufferedWriter.write("cd \"${TOP}\"\n");
        if (packagerDescriptor.isOutputAFolder()) {
            bufferedWriter.write("mkdir -p " + string3 + "\n");
        } else {
            bufferedWriter.write("mkdir -p " + IpeUtils.getDirName((String)string3) + "\n");
        }
        bufferedWriter.write("rm -rf ${TMPDIR}\n");
        bufferedWriter.write("mkdir -p ${TMPDIR}\n");
        bufferedWriter.write("\n");
        packagerDescriptor.getShellFileWriter().writeShellScript(bufferedWriter, makeConfiguration, packagingConfiguration);
        bufferedWriter.write("# Cleanup\n");
        bufferedWriter.write("cd \"${TOP}\"\n");
        bufferedWriter.write("rm -rf ${TMPDIR}\n");
    }

    private static String getString(String string) {
        return NbBundle.getMessage(ConfigurationMakefileWriter.class, (String)string);
    }

    private static String getString(String string, String string2) {
        return NbBundle.getMessage(ConfigurationMakefileWriter.class, (String)string, (Object)string2);
    }

    private static String getString(String string, String string2, String string3) {
        return NbBundle.getMessage(ConfigurationMakefileWriter.class, (String)string, (Object)string2, (Object)string3);
    }
}

