/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.makeproject.api.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.spi.configurations.UserOptionsProvider;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Item
implements NativeFileItem,
PropertyChangeListener {
    private final String path;
    private Folder folder;
    private File file = null;
    private DataObject lastDataObject = null;
    private static final SpiAccessor SPI_ACCESSOR = new SpiAccessor();

    public Item(String string) {
        this.path = string;
        this.folder = null;
    }

    private void rename(String string, boolean bl) {
        String string2;
        if (string == null || string.length() == 0 || this.getFolder() == null) {
            return;
        }
        if (this.path.equals(string)) {
            return;
        }
        int n = this.path.lastIndexOf(47);
        n = n < 0 ? 0 : ++n;
        int n2 = this.path.lastIndexOf(46);
        if (n2 < n || !bl) {
            n2 = -1;
        }
        if ((string2 = n2 >= 0 ? this.path.substring(n, n2) : this.path.substring(n)).equals(string)) {
            return;
        }
        String string3 = "";
        if (n > 0) {
            string3 = this.path.substring(0, n);
        }
        string3 = string3 + string;
        if (n2 >= 0) {
            string3 = string3 + this.path.substring(n2);
        }
        this.renameTo(string3);
    }

    private void renameTo(String string) {
        Folder folder = this.getFolder();
        String string2 = this.getAbsPath();
        Item item = folder.addItem(new Item(string));
        if (item != null && item.getFolder() != null) {
            if (item.getFolder().isProjectFiles()) {
                Item.copyItemConfigurations(this, item);
            }
            folder.removeItem(this);
            folder.renameItemAction(string2, item);
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getSortName() {
        return this.getName();
    }

    public String getName() {
        return IpeUtils.getBaseName((String)this.path);
    }

    public String getPath(boolean bl) {
        String string = "./";
        if (bl && this.getPath().startsWith(string)) {
            return this.getPath().substring(2);
        }
        return this.getPath();
    }

    public String getAbsPath() {
        String string = null;
        if (IpeUtils.isPathAbsolute((String)this.getPath())) {
            string = this.getPath();
            string = FilePathAdaptor.mapToLocal(string);
        } else if (this.getFolder() != null) {
            string = this.getFolder().getConfigurationDescriptor().getBaseDir() + '/' + this.getPath();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFolder(Folder folder) {
        if (folder == null && this.file == null) {
            this.getCanonicalFile();
        }
        if (folder == null) {
            Item item = this;
            synchronized (item) {
                if (this.lastDataObject != null) {
                    this.lastDataObject.removePropertyChangeListener((PropertyChangeListener)this);
                    this.lastDataObject = null;
                }
            }
        } else {
            this.folder = folder;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("name")) {
            boolean bl = true;
            Object object = propertyChangeEvent.getSource();
            if (object instanceof DataObject) {
                String string;
                String string2 = ((DataObject)object).getName();
                FileObject fileObject = ((DataObject)object).getPrimaryFile();
                if (fileObject != null && string2.equals(string = fileObject.getNameExt())) {
                    bl = false;
                }
            }
            this.rename((String)propertyChangeEvent.getNewValue(), bl);
        } else if (propertyChangeEvent.getPropertyName().equals("valid")) {
            Folder folder;
            if (!((Boolean)propertyChangeEvent.getNewValue()).booleanValue() && (folder = this.getFolder()) != null) {
                folder.refresh(this);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("primaryFile") && this.getFolder() != null) {
            FileObject fileObject = (FileObject)propertyChangeEvent.getNewValue();
            String string = FileUtil.toFile((FileObject)fileObject).getPath();
            if (!IpeUtils.isPathAbsolute((String)this.getPath())) {
                string = IpeUtils.toRelativePath((String)this.getFolder().getConfigurationDescriptor().getBaseDir(), (String)string);
            }
            string = FilePathAdaptor.normalize(string);
            this.renameTo(string);
        }
    }

    public Folder getFolder() {
        return this.folder;
    }

    public File getNormalizedFile() {
        String string = this.getAbsPath();
        if (string != null) {
            return CndFileUtils.normalizeFile((File)new File(string));
        }
        return this.file;
    }

    public File getFile() {
        return this.getNormalizedFile();
    }

    public File getCanonicalFile() {
        if (this.file == null) {
            try {
                this.file = new File(this.getAbsPath()).getCanonicalFile();
            }
            catch (IOException iOException) {
                this.file = CndFileUtils.normalizeFile((File)new File(this.getAbsPath()));
            }
        }
        return this.file;
    }

    public String getId() {
        return this.getPath();
    }

    public ItemConfiguration getItemConfiguration(Configuration configuration) {
        if (configuration != null) {
            return (ItemConfiguration)configuration.getAuxObject(this.getId());
        }
        return null;
    }

    public ItemConfiguration[] getItemConfigurations() {
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return new ItemConfiguration[0];
        }
        Configuration[] configurationArray = makeConfigurationDescriptor.getConfs().getConfs();
        ItemConfiguration[] itemConfigurationArray = new ItemConfiguration[configurationArray.length];
        for (int i = 0; i < configurationArray.length; ++i) {
            itemConfigurationArray[i] = this.getItemConfiguration(configurationArray[i]);
        }
        return itemConfigurationArray;
    }

    public void copyConfigurations(Item item) {
        if (item.getFolder() == null) {
            return;
        }
        MakeConfigurationDescriptor makeConfigurationDescriptor = item.getFolder().getConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return;
        }
        for (Configuration configuration : makeConfigurationDescriptor.getConfs().getConfs()) {
            ItemConfiguration itemConfiguration = item.getItemConfiguration(configuration);
            ItemConfiguration itemConfiguration2 = this.getItemConfiguration(configuration);
            if (itemConfiguration == null || itemConfiguration2 == null) continue;
            itemConfiguration2.assignValues(itemConfiguration);
        }
    }

    private static void copyItemConfigurations(Item item, Item item2) {
        MakeConfigurationDescriptor makeConfigurationDescriptor = item.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor != null) {
            for (Configuration configuration : makeConfigurationDescriptor.getConfs().getConfs()) {
                ItemConfiguration itemConfiguration = new ItemConfiguration(configuration, item2);
                itemConfiguration.assignValues(item.getItemConfiguration(configuration));
                configuration.addAuxObject(itemConfiguration);
            }
        }
    }

    public FileObject getFileObject() {
        File file = this.getNormalizedFile();
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            fileObject = FileUtil.toFileObject((File)this.getCanonicalFile());
        }
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject getDataObject() {
        Item item = this;
        synchronized (item) {
            if (this.lastDataObject != null && this.lastDataObject.isValid()) {
                return this.lastDataObject;
            }
        }
        item = null;
        FileObject fileObject = this.getFileObject();
        if (fileObject != null) {
            try {
                item = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            }
        }
        Item item2 = this;
        synchronized (item2) {
            if (item != this.lastDataObject) {
                if (this.lastDataObject != null) {
                    this.lastDataObject.removePropertyChangeListener((PropertyChangeListener)this);
                }
                if (item != null) {
                    item.addPropertyChangeListener(this);
                }
                this.lastDataObject = item;
            }
        }
        return item;
    }

    public final String getMIMEType() {
        DataObject dataObject = this.getDataObject();
        FileObject fileObject = dataObject == null ? null : dataObject.getPrimaryFile();
        String string = "";
        string = fileObject == null ? MIMESupport.getFileMIMEType((File)this.getNormalizedFile()) : MIMESupport.getFileMIMEType((FileObject)fileObject);
        return string;
    }

    public int getDefaultTool() {
        String string = this.getMIMEType();
        int n = "text/x-c".equals(string) ? 0 : ("text/x-h".equals(string) ? 3 : ("text/x-c++".equals(string) ? 1 : ("text/x-fortran".equals(string) ? 2 : ("text/x-asm".equals(string) ? 4 : 3))));
        return n;
    }

    private MakeConfigurationDescriptor getMakeConfigurationDescriptor() {
        if (this.getFolder() == null) {
            return null;
        }
        return this.getFolder().getConfigurationDescriptor();
    }

    private MakeConfiguration getMakeConfiguration() {
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return null;
        }
        return makeConfigurationDescriptor.getActiveConfiguration();
    }

    public NativeProject getNativeProject() {
        Project project;
        Folder folder = this.getFolder();
        if (folder != null && (project = folder.getProject()) != null) {
            return (NativeProject)project.getLookup().lookup(NativeProject.class);
        }
        return null;
    }

    public List<String> getSystemIncludePaths() {
        ArrayList<String> arrayList = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return arrayList;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return arrayList;
        }
        BasicCompiler basicCompiler = (BasicCompiler)compilerSet.getTool(itemConfiguration.getTool());
        BasicCompilerConfiguration basicCompilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (basicCompilerConfiguration instanceof CCCCompilerConfiguration && basicCompiler != null && basicCompiler.getPath() != null && basicCompiler.getPath().length() > 0) {
            arrayList.addAll(basicCompiler.getSystemIncludeDirectories());
        }
        return arrayList;
    }

    public List<String> getUserIncludePaths() {
        List<String> list = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return list;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return list;
        }
        BasicCompiler basicCompiler = (BasicCompiler)compilerSet.getTool(itemConfiguration.getTool());
        BasicCompilerConfiguration basicCompilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (basicCompilerConfiguration instanceof CCCCompilerConfiguration) {
            ArrayList<String> arrayList = new ArrayList<String>();
            CCCCompilerConfiguration cCCCompilerConfiguration = (CCCCompilerConfiguration)basicCompilerConfiguration;
            CCCCompilerConfiguration cCCCompilerConfiguration2 = (CCCCompilerConfiguration)cCCCompilerConfiguration.getMaster();
            while (cCCCompilerConfiguration2 != null && cCCCompilerConfiguration.getInheritIncludes().getValue()) {
                arrayList.addAll(cCCCompilerConfiguration2.getIncludeDirectories().getValue());
                if (cCCCompilerConfiguration2.getInheritIncludes().getValue()) {
                    cCCCompilerConfiguration2 = (CCCCompilerConfiguration)cCCCompilerConfiguration2.getMaster();
                    continue;
                }
                cCCCompilerConfiguration2 = null;
            }
            arrayList.addAll(cCCCompilerConfiguration.getIncludeDirectories().getValue());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                list.add(IpeUtils.toAbsolutePath((String)this.getFolder().getConfigurationDescriptor().getBaseDir(), (String)((String)iterator.next())));
            }
            if (cCCCompilerConfiguration instanceof AllOptionsProvider) {
                list = Item.SPI_ACCESSOR.getItemUserIncludePaths(list, (AllOptionsProvider)((Object)cCCCompilerConfiguration), basicCompiler, makeConfiguration);
            }
        }
        return list;
    }

    public List<String> getSystemMacroDefinitions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return arrayList;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return arrayList;
        }
        BasicCompiler basicCompiler = (BasicCompiler)compilerSet.getTool(itemConfiguration.getTool());
        BasicCompilerConfiguration basicCompilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (basicCompilerConfiguration instanceof CCCCompilerConfiguration && basicCompiler != null && basicCompiler.getPath() != null && basicCompiler.getPath().length() > 0) {
            arrayList.addAll(basicCompiler.getSystemPreprocessorSymbols());
        }
        return arrayList;
    }

    public List<String> getUserMacroDefinitions() {
        List<String> list = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return list;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return list;
        }
        BasicCompiler basicCompiler = (BasicCompiler)compilerSet.getTool(itemConfiguration.getTool());
        BasicCompilerConfiguration basicCompilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (basicCompilerConfiguration instanceof CCCCompilerConfiguration) {
            CCCCompilerConfiguration cCCCompilerConfiguration = (CCCCompilerConfiguration)basicCompilerConfiguration;
            CCCCompilerConfiguration cCCCompilerConfiguration2 = (CCCCompilerConfiguration)cCCCompilerConfiguration.getMaster();
            while (cCCCompilerConfiguration2 != null && cCCCompilerConfiguration.getInheritPreprocessor().getValue()) {
                list.addAll(cCCCompilerConfiguration2.getPreprocessorConfiguration().getValue());
                if (cCCCompilerConfiguration2.getInheritIncludes().getValue()) {
                    cCCCompilerConfiguration2 = (CCCCompilerConfiguration)cCCCompilerConfiguration2.getMaster();
                    continue;
                }
                cCCCompilerConfiguration2 = null;
            }
            list.addAll(cCCCompilerConfiguration.getPreprocessorConfiguration().getValue());
            if (cCCCompilerConfiguration instanceof AllOptionsProvider) {
                list = Item.SPI_ACCESSOR.getItemUserMacros(list, (AllOptionsProvider)((Object)cCCCompilerConfiguration), basicCompiler, makeConfiguration);
            }
        }
        return list;
    }

    public boolean hasHeaderOrSourceExtension(boolean bl, boolean bl2) {
        String string = this.getMIMEType();
        return "text/x-h".equals(string) || bl2 && "text/x-c++".equals(string) || bl && "text/x-c".equals(string);
    }

    public NativeFileItem.Language getLanguage() {
        int n;
        ItemConfiguration itemConfiguration = null;
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            itemConfiguration = this.getItemConfiguration(makeConfiguration);
        }
        NativeFileItem.Language language = (n = itemConfiguration != null ? itemConfiguration.getTool() : this.getDefaultTool()) == 0 ? NativeFileItem.Language.C : (n == 1 ? NativeFileItem.Language.CPP : (n == 2 ? NativeFileItem.Language.FORTRAN : (this.hasHeaderOrSourceExtension(true, true) ? NativeFileItem.Language.C_HEADER : NativeFileItem.Language.OTHER)));
        return language;
    }

    public NativeFileItem.LanguageFlavor getLanguageFlavor() {
        return NativeFileItem.LanguageFlavor.GENERIC;
    }

    public boolean isExcluded() {
        ItemConfiguration itemConfiguration = this.getItemConfiguration(this.getMakeConfiguration());
        if (itemConfiguration != null) {
            return itemConfiguration.getExcluded().getValue();
        }
        return true;
    }

    public String toString() {
        return this.path;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SpiAccessor {
        private UserOptionsProvider provider;

        private synchronized UserOptionsProvider getProvider() {
            if (this.provider == null) {
                this.provider = (UserOptionsProvider)Lookup.getDefault().lookup(UserOptionsProvider.class);
            }
            return this.provider;
        }

        private SpiAccessor() {
        }

        private List<String> getItemUserIncludePaths(List<String> list, AllOptionsProvider allOptionsProvider, BasicCompiler basicCompiler, MakeConfiguration makeConfiguration) {
            if (this.getProvider() != null) {
                return this.getProvider().getItemUserIncludePaths(list, allOptionsProvider, basicCompiler, makeConfiguration);
            }
            return list;
        }

        private List<String> getItemUserMacros(List<String> list, AllOptionsProvider allOptionsProvider, BasicCompiler basicCompiler, MakeConfiguration makeConfiguration) {
            if (this.getProvider() != null) {
                return this.getProvider().getItemUserMacros(list, allOptionsProvider, basicCompiler, makeConfiguration);
            }
            return list;
        }
    }
}

