/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.makeproject.api.configurations.BuildPlatformConfiguration;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platform;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platforms;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.NbBundle;

public class DevelopmentHostConfiguration {
    public static final String PROP_DEV_HOST = "devHost";
    private final int def;
    private int value = 0;
    private List<ExecutionEnvironment> servers = ServerList.getEnvironments();
    private BuildPlatformConfiguration buildPlatformConfiguration;
    private boolean modified;
    private boolean dirty = false;
    private PropertyChangeSupport pcs;

    public DevelopmentHostConfiguration(ExecutionEnvironment executionEnvironment) {
        int n;
        for (n = 0; n < this.servers.size(); ++n) {
            if (!executionEnvironment.equals(this.servers.get(n))) continue;
            this.value = n;
            break;
        }
        this.def = this.value;
        this.pcs = new PropertyChangeSupport(this);
        n = CompilerSetManager.getDefault((ExecutionEnvironment)executionEnvironment).getPlatform();
        if (n == -1) {
            n = 6;
        }
        this.buildPlatformConfiguration = new BuildPlatformConfiguration(n, Platforms.getPlatformDisplayNames());
    }

    public String getHostKey() {
        return ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.servers.get(this.value));
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.servers.get(this.value);
    }

    public String getDisplayName(boolean bl) {
        String string = ServerList.get((ExecutionEnvironment)this.getExecutionEnvironment()).getDisplayName();
        if (bl && !this.isConfigured()) {
            string = NbBundle.getMessage(DevelopmentHostConfiguration.class, (String)"NOT_CONFIGURED", (Object)string);
        } else {
            int n = this.getBuildPlatformConfiguration().getValue();
            Platform platform = Platforms.getPlatform(n);
            if (platform != null) {
                string = string + " [" + platform.getDisplayName() + "]";
            }
        }
        return string;
    }

    public String getHostDisplayName(boolean bl) {
        String string = ServerList.get((ExecutionEnvironment)this.getExecutionEnvironment()).getServerDisplayName();
        if (bl && !this.isConfigured()) {
            string = NbBundle.getMessage(DevelopmentHostConfiguration.class, (String)"NOT_CONFIGURED", (Object)string);
        }
        return string;
    }

    public boolean isConfigured() {
        return !CompilerSetManager.getDefault((ExecutionEnvironment)this.getExecutionEnvironment()).isUninitialized();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.setValue(string, false);
    }

    public void setValue(String string, boolean bl) {
        if (this.setValueImpl(string, bl)) {
            return;
        }
        this.addDevelopmentHost(string);
        this.setValueImpl(string, bl);
    }

    public boolean setHost(ExecutionEnvironment executionEnvironment) {
        CndUtils.assertTrue((executionEnvironment != null ? 1 : 0) != 0);
        if (this.setHostImpl(executionEnvironment)) {
            return true;
        }
        this.addDevelopmentHost(executionEnvironment);
        return this.setHostImpl(executionEnvironment);
    }

    private boolean setHostImpl(ExecutionEnvironment executionEnvironment) {
        for (int i = 0; i < this.servers.size(); ++i) {
            if (!this.servers.get(i).equals(executionEnvironment)) continue;
            this.value = i;
            this.setBuildPlatform(CompilerSetManager.getDefault((ExecutionEnvironment)executionEnvironment).getPlatform());
            if (this.getBuildPlatform() == -1) {
                this.setBuildPlatform(6);
            }
            return true;
        }
        return false;
    }

    private boolean setValueImpl(String string, final boolean bl) {
        for (int i = 0; i < this.servers.size(); ++i) {
            final ExecutionEnvironment executionEnvironment = this.servers.get(i);
            final ServerRecord serverRecord = ServerList.get((ExecutionEnvironment)executionEnvironment);
            if (!serverRecord.getDisplayName().equals(string)) continue;
            final int n = i;
            final Runnable runnable = new Runnable(){

                public void run() {
                    DevelopmentHostConfiguration.this.value = n;
                    DevelopmentHostConfiguration.this.setBuildPlatform(CompilerSetManager.getDefault((ExecutionEnvironment)executionEnvironment).getPlatform());
                    if (DevelopmentHostConfiguration.this.getBuildPlatform() == -1) {
                        DevelopmentHostConfiguration.this.setBuildPlatform(6);
                    }
                    if (bl) {
                        DevelopmentHostConfiguration.this.pcs.firePropertyChange(DevelopmentHostConfiguration.PROP_DEV_HOST, ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)serverRecord.getExecutionEnvironment()), DevelopmentHostConfiguration.this);
                    }
                }
            };
            if (serverRecord.isSetUp()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (serverRecord.setUp()) {
                            runnable.run();
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    private boolean addDevelopmentHost(String string) {
        return this.addDevelopmentHost(ExecutionEnvironmentFactory.fromUniqueID((String)string));
    }

    private boolean addDevelopmentHost(ExecutionEnvironment executionEnvironment) {
        ServerRecord serverRecord = ServerList.addServer((ExecutionEnvironment)executionEnvironment, null, null, (boolean)false, (boolean)false);
        this.servers = ServerList.getEnvironments();
        return serverRecord != null;
    }

    public void reset() {
        this.servers = ServerList.getEnvironments();
        this.value = this.def;
    }

    public boolean getModified() {
        return this.modified;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    void assign(DevelopmentHostConfiguration developmentHostConfiguration) {
        boolean bl = false;
        ExecutionEnvironment executionEnvironment = this.getExecutionEnvironment();
        ExecutionEnvironment executionEnvironment2 = developmentHostConfiguration.getExecutionEnvironment();
        if (this.servers.size() != developmentHostConfiguration.servers.size()) {
            this.servers = ServerList.getEnvironments();
            bl = true;
        }
        if (!executionEnvironment2.equals(executionEnvironment)) {
            bl = true;
        }
        this.setDirty(bl);
        this.setHost(executionEnvironment2);
        this.getBuildPlatformConfiguration().assign(developmentHostConfiguration.getBuildPlatformConfiguration());
    }

    public DevelopmentHostConfiguration clone() {
        DevelopmentHostConfiguration developmentHostConfiguration = new DevelopmentHostConfiguration(this.getExecutionEnvironment());
        developmentHostConfiguration.setHost(this.getExecutionEnvironment());
        developmentHostConfiguration.setBuildPlatformConfiguration(this.getBuildPlatformConfiguration().clone());
        return developmentHostConfiguration;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isLocalhost() {
        return this.getExecutionEnvironment().isLocal();
    }

    public int getBuildPlatform() {
        return this.getBuildPlatformConfiguration().getValue();
    }

    public void setBuildPlatform(int n) {
        this.getBuildPlatformConfiguration().setValue(n);
    }

    public String getBuildPlatformDisplayName() {
        if (this.isConfigured()) {
            return Platforms.getPlatform(this.getBuildPlatform()).getDisplayName();
        }
        return "";
    }

    public BuildPlatformConfiguration getBuildPlatformConfiguration() {
        return this.buildPlatformConfiguration;
    }

    public void setBuildPlatformConfiguration(BuildPlatformConfiguration buildPlatformConfiguration) {
        this.buildPlatformConfiguration = buildPlatformConfiguration;
    }
}

