/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.compilers;

import java.io.BufferedReader;
import java.io.IOException;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.ToolchainManager;
import org.netbeans.modules.cnd.makeproject.api.compilers.CCCCompiler;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public abstract class GNUCCCCompiler
extends CCCCompiler {
    public GNUCCCCompiler(ExecutionEnvironment executionEnvironment, CompilerSet.CompilerFlavor compilerFlavor, int n, String string, String string2, String string3) {
        super(executionEnvironment, compilerFlavor, n, string, string2, string3);
    }

    protected String getCompilerStderrCommand() {
        ToolchainManager.CompilerDescriptor compilerDescriptor = this.getDescriptor();
        if (compilerDescriptor != null) {
            return " " + compilerDescriptor.getIncludeFlags();
        }
        return "";
    }

    protected String getCompilerStdoutCommand() {
        ToolchainManager.CompilerDescriptor compilerDescriptor = this.getDescriptor();
        if (compilerDescriptor != null) {
            return " " + compilerDescriptor.getMacroFlags();
        }
        return "";
    }

    protected CCCCompiler.Pair getFreshSystemIncludesAndDefines() {
        CCCCompiler.Pair pair = new CCCCompiler.Pair();
        try {
            this.getSystemIncludesAndDefines(this.getCompilerStderrCommand(), false, pair);
            this.getSystemIncludesAndDefines(this.getCompilerStdoutCommand(), true, pair);
            if (!this.containsMacro(pair.systemPreprocessorSymbolsList, "__STDC__")) {
                pair.systemPreprocessorSymbolsList.add("__STDC__=1");
            }
        }
        catch (IOException iOException) {
            System.err.println("IOException " + iOException);
            String string = this.getExecutionEnvironment().isLocal() ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CANTFINDCOMPILER", (Object)this.getPath()) : NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CANT_FIND_REMOTE_COMPILER", (Object)this.getPath(), (Object)this.getExecutionEnvironment().getDisplayName());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
        }
        return pair;
    }

    private boolean startsWithPath(String string) {
        if ((string = string.trim()).startsWith("/")) {
            return true;
        }
        return string.length() > 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':';
    }

    protected String cutIncludePrefix(String string) {
        ToolchainManager.CompilerDescriptor compilerDescriptor = this.getDescriptor();
        if (compilerDescriptor != null && compilerDescriptor.getRemoveIncludeOutputPrefix() != null) {
            String string2 = compilerDescriptor.getRemoveIncludeOutputPrefix();
            if (string.toLowerCase().startsWith(this.getIncludeFilePathPrefix().toLowerCase())) {
                string = string.substring(this.getIncludeFilePathPrefix().length());
            } else if (string.toLowerCase().startsWith(string2)) {
                string = string.substring(string2.length());
            }
        }
        return string;
    }

    protected void parseCompilerOutput(BufferedReader bufferedReader, CCCCompiler.Pair pair) {
        try {
            String string;
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                if ((string = string.trim()).contains("#include <...>")) {
                    bl = true;
                    continue;
                }
                if (bl) {
                    if (string.startsWith("End of search") || !this.startsWithPath(string)) {
                        bl = false;
                        continue;
                    }
                    if (string.length() > 2 && string.charAt(1) == ':') {
                        pair.systemIncludeDirectoriesList.addUnique(this.normalizePath(string));
                        continue;
                    }
                    if ((string = this.cutIncludePrefix(string)).endsWith(" (framework directory)")) {
                        string = string.substring(0, string.lastIndexOf(40)).trim();
                    }
                    pair.systemIncludeDirectoriesList.addUnique(this.applyPathPrefix(string));
                    if (this.getDescriptor().getRemoveIncludePathPrefix() == null || !string.startsWith("/usr/lib")) continue;
                    pair.systemIncludeDirectoriesList.addUnique(this.applyPathPrefix(string.substring(4)));
                    continue;
                }
                this.parseUserMacros(string, pair.systemPreprocessorSymbolsList);
                if (!string.startsWith("#define ") || (n = string.indexOf(32, 8)) <= 0) continue;
                String string2 = string.substring(8, n) + "=" + string.substring(n + 1);
                pair.systemPreprocessorSymbolsList.addUnique(string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(16, (Throwable)iOException);
        }
    }
}

