/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.io.File;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.api.utils.CndFileVisibilityQuery;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.openide.util.Mutex;

public class MakeSharabilityQuery
implements SharabilityQueryImplementation {
    private File baseDirFile;
    private String baseDir;
    private int baseDirLength;
    private boolean privateShared;
    private ConfigurationDescriptorProvider projectDescriptorProvider;
    private static final boolean IGNORE_BINARIES = CndUtils.getBoolean((String)"cnd.vcs.ignore.binaries", (boolean)true);

    MakeSharabilityQuery(ConfigurationDescriptorProvider configurationDescriptorProvider, File file) {
        this.projectDescriptorProvider = configurationDescriptorProvider;
        this.baseDirFile = file;
        this.baseDir = file.getPath();
        this.baseDirLength = this.baseDir.length();
        this.privateShared = false;
    }

    public int getSharability(final File file) {
        Integer n = (Integer)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer run() {
                MakeSharabilityQuery makeSharabilityQuery = MakeSharabilityQuery.this;
                synchronized (makeSharabilityQuery) {
                    if (IGNORE_BINARIES && CndFileVisibilityQuery.getDefault().isIgnored(file)) {
                        return 2;
                    }
                    boolean bl = file.getPath().startsWith(MakeSharabilityQuery.this.baseDir);
                    if (!bl) {
                        return 0;
                    }
                    if (file.getPath().equals(MakeSharabilityQuery.this.baseDir)) {
                        return 3;
                    }
                    if (file.getPath().length() <= MakeSharabilityQuery.this.baseDirLength + 1) {
                        return 0;
                    }
                    String string = file.getPath().substring(MakeSharabilityQuery.this.baseDirLength + 1);
                    if (string.equals("nbproject")) {
                        return 3;
                    }
                    if (string.equals("Makefile")) {
                        return 1;
                    }
                    if (string.equals("nbproject" + File.separator + "configurations.xml")) {
                        return 1;
                    }
                    if (string.equals("nbproject" + File.separator + "private")) {
                        return MakeSharabilityQuery.this.privateShared ? 1 : 2;
                    }
                    if (string.equals("nbproject" + File.separator + "project.properties")) {
                        return 1;
                    }
                    if (string.equals("nbproject" + File.separator + "project.xml")) {
                        return 1;
                    }
                    if (string.startsWith("nbproject" + File.separator + "Makefile-")) {
                        return 1;
                    }
                    if (string.startsWith("nbproject" + File.separator + "Package-")) {
                        return 1;
                    }
                    if (string.startsWith("nbproject" + File.separator + "qt-")) {
                        return string.endsWith(".pro") ? 1 : 2;
                    }
                    if (string.startsWith("build" + File.separator)) {
                        return 2;
                    }
                    if (string.startsWith("dist" + File.separator)) {
                        return 2;
                    }
                    return 0;
                }
            }
        });
        return n;
    }

    public void setPrivateShared(boolean bl) {
        this.privateShared = bl;
    }

    public boolean getPrivateShared() {
        return this.privateShared;
    }
}

