/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.options;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.options.BooleanNodeProp;
import org.netbeans.modules.cnd.editor.options.BracePlacementProperty;
import org.netbeans.modules.cnd.editor.options.EditorOptions;
import org.netbeans.modules.cnd.editor.options.EditorOptionsPanelController;
import org.netbeans.modules.cnd.editor.options.IntNodeProp;
import org.netbeans.modules.cnd.editor.options.ManageStylesPanel;
import org.netbeans.modules.cnd.editor.options.PreprocessorIndentProperty;
import org.netbeans.modules.cnd.editor.options.PreviewPreferences;
import org.netbeans.modules.cnd.editor.reformat.Reformatter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorPropertySheet
extends JPanel
implements ActionListener,
PropertyChangeListener,
PreferenceChangeListener {
    private static final boolean TRACE = false;
    private final EditorOptionsPanelController topController;
    private boolean loaded = false;
    private final CodeStyle.Language language;
    private String lastChangedproperty;
    private String defaultStyles;
    private Map<String, PreviewPreferences> preferences = new HashMap<String, PreviewPreferences>();
    private PropertySheet holder;
    private Object[] originalEditorProperties = null;
    private PreviewPreferences lastSheetPreferences = null;
    private JPanel categoryPanel;
    private JLabel jLabel1;
    private JButton manageStyles;
    private JCheckBox overrideGlobalOptions;
    private JComboBox styleComboBox;

    EditorPropertySheet(EditorOptionsPanelController editorOptionsPanelController, CodeStyle.Language language) {
        this.topController = editorOptionsPanelController;
        this.language = language;
        this.initComponents();
        this.overrideGlobalOptions.setSelected(EditorOptions.getOverideTabIndents(language));
        this.overrideGlobalOptions.addActionListener(this);
        this.holder = new PropertySheet();
        this.holder.setOpaque(false);
        this.holder.setDescriptionAreaVisible(false);
        this.holder.setPreferredSize(new Dimension(250, 150));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.categoryPanel.add((Component)this.holder, gridBagConstraints);
        this.manageStyles.setMinimumSize(new Dimension(126, 26));
        this.setName(EditorPropertySheet.getString("Tab_Name"));
    }

    private void initLanguageMap() {
        for (String string : EditorOptions.getAllStyles(this.language)) {
            this.initLanguageStylePreferences(this.language, string);
        }
        this.defaultStyles = EditorOptions.getCurrentProfileId(this.language);
    }

    private void initLanguageStylePreferences(CodeStyle.Language language, String string) {
        if (this.preferences == null) {
            this.preferences = new HashMap<String, PreviewPreferences>();
        }
        PreviewPreferences previewPreferences = new PreviewPreferences(EditorOptions.getPreferences(language, string), language, string);
        this.preferences.put(string, previewPreferences);
    }

    private void initLanguageCategory() {
        this.styleComboBox.removeActionListener(this);
        DefaultComboBoxModel<EntryWrapper> defaultComboBoxModel = new DefaultComboBoxModel<EntryWrapper>();
        ArrayList<EntryWrapper> arrayList = new ArrayList<EntryWrapper>();
        for (Map.Entry<String, PreviewPreferences> entry : this.preferences.entrySet()) {
            arrayList.add(new EntryWrapper(entry));
        }
        Collections.sort(arrayList);
        int n = 0;
        int n2 = 0;
        for (EntryWrapper entryWrapper : arrayList) {
            if (entryWrapper.name.equals(this.defaultStyles)) {
                n = n2;
            }
            defaultComboBoxModel.addElement(entryWrapper);
            ++n2;
        }
        this.styleComboBox.setModel(defaultComboBoxModel);
        this.styleComboBox.setSelectedIndex(n);
        EntryWrapper entryWrapper = (EntryWrapper)this.styleComboBox.getSelectedItem();
        this.initSheets(entryWrapper.preferences);
        this.defaultStyles = entryWrapper.name;
        this.styleComboBox.addActionListener(this);
        this.repaintPreview();
    }

    private void initSheets(PreviewPreferences previewPreferences) {
        if (this.lastSheetPreferences != null) {
            this.lastSheetPreferences.removePreferenceChangeListener(this);
        }
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("Indents");
        set.setDisplayName(EditorPropertySheet.getString("LBL_TabsAndIndents"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_TabsAndIndents"));
        if (this.overrideGlobalOptions.isSelected()) {
            set.put((Node.Property)new IntNodeProp(this.language, previewPreferences, "indentSize"));
            set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "expandTabToSpaces"));
            set.put((Node.Property)new IntNodeProp(this.language, previewPreferences, "tabSize"));
        } else {
            set.put((Node.Property)new IntNodeProp(this.language, previewPreferences, "indentSize", EditorOptions.getGlobalIndentSize()));
            set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "expandTabToSpaces", EditorOptions.getGlobalExpandTabs()));
            set.put((Node.Property)new IntNodeProp(this.language, previewPreferences, "tabSize", EditorOptions.getGlobalTabSize()));
        }
        set.put((Node.Property)new IntNodeProp(this.language, previewPreferences, "statementContinuationIndent"));
        set.put((Node.Property)new IntNodeProp(this.language, previewPreferences, "constructorListContinuationIndent"));
        set.put((Node.Property)new PreprocessorIndentProperty(this.language, previewPreferences, "indentPreprocessorDirectives"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "sharpAtStartLine"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "indentNamespace"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "indentCasesFromSwitch"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "absoluteLabelIndent"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("BracesPlacement");
        set.setDisplayName(EditorPropertySheet.getString("LBL_BracesPlacement"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_BracesPlacement"));
        set.put((Node.Property)new BracePlacementProperty(this.language, previewPreferences, "newLineBeforeBraceNamespace"));
        set.put((Node.Property)new BracePlacementProperty(this.language, previewPreferences, "newLineBeforeBraceClass"));
        set.put((Node.Property)new BracePlacementProperty(this.language, previewPreferences, "newLineBeforeBraceDeclaration"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "ignoreEmptyFunctionBody"));
        set.put((Node.Property)new BracePlacementProperty(this.language, previewPreferences, "newLineBeforeBraceSwitch"));
        set.put((Node.Property)new BracePlacementProperty(this.language, previewPreferences, "newLineBeforeBrace"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("MultilineAlignment");
        set.setDisplayName(EditorPropertySheet.getString("LBL_MultilineAlignment"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_MultilineAlignment"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "alignMultilineMethodParams"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "alignMultilineCallArgs"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "alignMultilineArrayInit"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "alignMultilineFor"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "alignMultilineIfCondition"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "alignMultilineWhileCondition"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "alignMultilineParen"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("NewLine");
        set.setDisplayName(EditorPropertySheet.getString("LBL_NewLine"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_NewLine"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "newLineFunctionDefinitionName"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "newLineCatch"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "newLineElse"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "newLineWhile"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("SpacesBeforeKeywords");
        set.setDisplayName(EditorPropertySheet.getString("LBL_BeforeKeywords"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_BeforeKeywords"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeCatch"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeElse"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeWhile"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("SpacesBeforeParentheses");
        set.setDisplayName(EditorPropertySheet.getString("LBL_BeforeParentheses"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_BeforeParentheses"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeMethodDeclParen"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeMethodCallParen"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeCatchParen"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeForParen"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeIfParen"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeSwitchParen"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeWhileParen"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeKeywordParen"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("SpacesAroundOperators");
        set.setDisplayName(EditorPropertySheet.getString("LBL_AroundOperators"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_AroundOperators"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceAroundAssignOps"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceAroundBinaryOps"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceAroundTernaryOps"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceAroundUnaryOps"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("SpacesBeforeLeftBracess");
        set.setDisplayName(EditorPropertySheet.getString("LBL_BeforeLeftBraces"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_BeforeLeftBraces"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeClassDeclLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeMethodDeclLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeArrayInitLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeCatchLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeDoLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeElseLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeForLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeIfLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeSwitchLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeTryLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeWhileLeftBrace"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("SpacesWithinParentheses");
        set.setDisplayName(EditorPropertySheet.getString("LBL_WithinParentheses"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_WithinParentheses"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceWithinMethodDeclParens"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceWithinMethodCallParens"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceWithinBraces"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceWithinParens"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceWithinCatchParens"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceWithinForParens"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceWithinIfParens"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceWithinSwitchParens"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceWithinTypeCastParens"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceWithinWhileParens"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("SpacesOther");
        set.setDisplayName(EditorPropertySheet.getString("LBL_Other_Spaces"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_Other_Spaces"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeComma"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceAfterComma"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeSemi"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceAfterSemi"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceBeforeColon"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceAfterColon"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "spaceAfterTypeCast"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("BlankLines");
        set.setDisplayName(EditorPropertySheet.getString("LBL_BlankLines"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_BlankLines"));
        set.put((Node.Property)new IntNodeProp(this.language, previewPreferences, "blankLinesBeforeClass"));
        set.put((Node.Property)new IntNodeProp(this.language, previewPreferences, "blankLinesAfterClassHeader"));
        set.put((Node.Property)new IntNodeProp(this.language, previewPreferences, "blankLinesBeforeMethods"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("Other");
        set.setDisplayName(EditorPropertySheet.getString("LBL_Other"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_Other"));
        set.put((Node.Property)new BooleanNodeProp(this.language, previewPreferences, "addLeadingStarInComment"));
        sheet.put(set);
        DummyNode[] dummyNodeArray = new DummyNode[]{new DummyNode(sheet, "Sheet")};
        this.holder.setNodes((Node[])dummyNodeArray);
        previewPreferences.addPreferenceChangeListener(this);
        this.lastSheetPreferences = previewPreferences;
    }

    void load() {
        this.loaded = false;
        this.originalEditorProperties = this.preserveEditorProperties();
        this.initLanguageMap();
        this.initLanguageCategory();
        this.loaded = true;
        this.repaintPreview();
    }

    void store() {
        EditorOptions.setCurrentProfileId(this.language, this.defaultStyles);
        EditorOptions.setOverideTabIndents(this.language, this.overrideGlobalOptions.isSelected());
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, PreviewPreferences> entry : this.preferences.entrySet()) {
            String string = entry.getKey();
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string);
            PreviewPreferences previewPreferences = entry.getValue();
            Preferences preferences = EditorOptions.getPreferences(this.language, string);
            if (string.equals(this.defaultStyles)) {
                EditorOptions.setPreferences(CodeStyle.getDefault(this.language), preferences);
            }
            for (String string2 : EditorOptions.keys()) {
                Object object;
                Object object2 = EditorOptions.getDefault(this.language, string, string2);
                if (object2 instanceof Boolean) {
                    object = previewPreferences.getBoolean(string2, (Boolean)object2);
                    if (!object2.equals(object)) {
                        preferences.putBoolean(string2, (Boolean)object);
                        continue;
                    }
                    preferences.remove(string2);
                    continue;
                }
                if (object2 instanceof Integer) {
                    object = previewPreferences.getInt(string2, (Integer)object2);
                    if (!object2.equals(object)) {
                        preferences.putInt(string2, (Integer)object);
                        continue;
                    }
                    preferences.remove(string2);
                    continue;
                }
                object = previewPreferences.get(string2, object2.toString());
                if (!object2.equals(object)) {
                    preferences.put(string2, (String)object);
                    continue;
                }
                preferences.remove(string2);
            }
            if (!string.equals(this.defaultStyles)) continue;
            EditorOptions.updateSimplePreferences(this.language, CodeStyle.getDefault(this.language));
        }
        EditorOptions.setAllStyles(this.language, stringBuilder.toString());
        this.defaultStyles = null;
        this.preferences.clear();
        this.holder.setNodes(null);
    }

    void cancel() {
        if (this.originalEditorProperties != null) {
            this.restoreEditorProperties(this.originalEditorProperties);
            this.originalEditorProperties = null;
        }
        this.defaultStyles = null;
        this.preferences.clear();
        this.holder.setNodes(null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        EntryWrapper entryWrapper;
        this.lastChangedproperty = null;
        if (this.styleComboBox.equals(actionEvent.getSource())) {
            EntryWrapper entryWrapper2 = (EntryWrapper)this.styleComboBox.getSelectedItem();
            if (entryWrapper2 != null) {
                this.defaultStyles = entryWrapper2.name;
                this.initSheets(entryWrapper2.preferences);
                this.repaintPreview();
            }
        } else if (this.overrideGlobalOptions.equals(actionEvent.getSource()) && (entryWrapper = (EntryWrapper)this.styleComboBox.getSelectedItem()) != null) {
            this.defaultStyles = entryWrapper.name;
            this.initSheets(entryWrapper.preferences);
            this.repaintPreview();
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        this.lastChangedproperty = preferenceChangeEvent.getKey();
        this.change();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.change();
    }

    private void change() {
        if (!this.loaded) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                EditorPropertySheet.this.topController.changed();
                EditorPropertySheet.this.repaintPreview();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void repaintPreview() {
        EntryWrapper entryWrapper = (EntryWrapper)this.styleComboBox.getSelectedItem();
        if (entryWrapper == null) {
            entryWrapper = (EntryWrapper)this.styleComboBox.getItemAt(0);
        }
        JEditorPane jEditorPane = (JEditorPane)this.topController.getPreviewComponent();
        if (this.loaded) {
            PreviewPreferences previewPreferences = new PreviewPreferences(entryWrapper.preferences, entryWrapper.preferences.getLanguage(), entryWrapper.preferences.getStyleId());
            previewPreferences.makeAllKeys(entryWrapper.preferences);
            previewPreferences.putBoolean("overrideTabIndents", this.overrideGlobalOptions.isSelected());
            if (!this.overrideGlobalOptions.isSelected()) {
                previewPreferences.putInt("indentSize", EditorOptions.getGlobalIndentSize());
                previewPreferences.putBoolean("expandTabToSpaces", EditorOptions.getGlobalExpandTabs());
                previewPreferences.putInt("tabSize", EditorOptions.getGlobalTabSize());
            }
            previewPreferences.putInt("tab-size", previewPreferences.getInt("tabSize", 8));
            previewPreferences.putInt("spaces-per-tab", previewPreferences.getInt("tabSize", 8));
            previewPreferences.putBoolean("expand-tabs", previewPreferences.getBoolean("expandTabToSpaces", true));
            previewPreferences.putInt("indent-shift-width", previewPreferences.getInt("indentSize", 4));
            jEditorPane.setIgnoreRepaint(true);
            this.refreshPreview(jEditorPane, previewPreferences);
            jEditorPane.setIgnoreRepaint(false);
            jEditorPane.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
            jEditorPane.repaint(100L);
        }
    }

    private String getPreviewText() {
        String string;
        switch (this.language) {
            case C: {
                string = ".c";
                break;
            }
            case HEADER: {
                string = ".cpp";
                break;
            }
            default: {
                string = ".cpp";
            }
        }
        if (this.lastChangedproperty != null) {
            if (this.lastChangedproperty.startsWith("space")) {
                return this.loadPreviewExample("SAMPLE_Spaces" + string);
            }
            if (this.lastChangedproperty.startsWith("blank")) {
                return this.loadPreviewExample("SAMPLE_BlankLines" + string);
            }
            if (this.lastChangedproperty.startsWith("align") || this.lastChangedproperty.startsWith("new")) {
                return this.loadPreviewExample("SAMPLE_AlignBraces" + string);
            }
        }
        return this.loadPreviewExample("SAMPLE_TabsIndents" + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadPreviewExample(String string) {
        FileObject fileObject = FileUtil.getConfigFile((String)("OptionsDialog/CPlusPlus/FormatterPreviewExamples/" + string));
        if (fileObject != null && fileObject.getSize() > 0L) {
            StringBuilder stringBuilder = new StringBuilder((int)fileObject.getSize());
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(fileObject.getInputStream());
                char[] cArray = new char[1024];
                try {
                    int n;
                    while (0 < (n = inputStreamReader.read(cArray, 0, cArray.length))) {
                        stringBuilder.append(cArray, 0, n);
                    }
                }
                finally {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return stringBuilder.toString();
        }
        return "";
    }

    private void refreshPreview(JEditorPane jEditorPane, Preferences preferences) {
        jEditorPane.setText(this.getPreviewText());
        BaseDocument baseDocument = (BaseDocument)jEditorPane.getDocument();
        CodeStyle codeStyle = EditorOptions.createCodeStyle(this.language, preferences, false);
        this.setEditorProperties(preferences);
        try {
            new Reformatter((Document)baseDocument, codeStyle).reformat();
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private void setEditorProperties(Preferences preferences) {
        Preferences preferences2 = null;
        switch (this.language) {
            case C: {
                preferences2 = (Preferences)MimeLookup.getLookup((String)"text/x-c").lookup(Preferences.class);
                break;
            }
            case HEADER: {
                preferences2 = (Preferences)MimeLookup.getLookup((String)"text/x-h").lookup(Preferences.class);
                break;
            }
            default: {
                preferences2 = (Preferences)MimeLookup.getLookup((String)"text/x-c++").lookup(Preferences.class);
            }
        }
        if (preferences2 != null) {
            preferences2.putInt("tab-size", preferences.getInt("tabSize", 8));
            preferences2.putInt("spaces-per-tab", preferences.getInt("tabSize", 8));
            preferences2.putBoolean("expand-tabs", preferences.getBoolean("expandTabToSpaces", true));
            preferences2.putInt("indent-shift-width", preferences.getInt("indentSize", 4));
        }
    }

    private Object[] preserveEditorProperties() {
        Preferences preferences = null;
        Object[] objectArray = null;
        switch (this.language) {
            case C: {
                preferences = (Preferences)MimeLookup.getLookup((String)"text/x-c").lookup(Preferences.class);
                break;
            }
            case HEADER: {
                preferences = (Preferences)MimeLookup.getLookup((String)"text/x-h").lookup(Preferences.class);
                break;
            }
            default: {
                preferences = (Preferences)MimeLookup.getLookup((String)"text/x-c++").lookup(Preferences.class);
            }
        }
        if (preferences != null) {
            objectArray = new Object[]{null, null, null, null};
            if (null != preferences.get("tab-size", null)) {
                objectArray[0] = preferences.getInt("tab-size", 8);
            }
            if (null != preferences.get("spaces-per-tab", null)) {
                objectArray[1] = preferences.getInt("spaces-per-tab", 8);
            }
            if (null != preferences.get("expand-tabs", null)) {
                objectArray[2] = preferences.getBoolean("expand-tabs", true);
            }
            if (null != preferences.get("indent-shift-width", null)) {
                objectArray[3] = preferences.getInt("indent-shift-width", 4);
            }
        }
        return objectArray;
    }

    private void restoreEditorProperties(Object[] objectArray) {
        Preferences preferences = null;
        switch (this.language) {
            case C: {
                preferences = (Preferences)MimeLookup.getLookup((String)"text/x-c").lookup(Preferences.class);
                break;
            }
            case HEADER: {
                preferences = (Preferences)MimeLookup.getLookup((String)"text/x-h").lookup(Preferences.class);
                break;
            }
            default: {
                preferences = (Preferences)MimeLookup.getLookup((String)"text/x-c++").lookup(Preferences.class);
            }
        }
        if (preferences != null && objectArray != null) {
            if (objectArray[0] == null) {
                preferences.remove("tab-size");
            } else {
                preferences.putInt("tab-size", (Integer)objectArray[0]);
            }
            if (objectArray[1] == null) {
                preferences.remove("spaces-per-tab");
            } else {
                preferences.putInt("spaces-per-tab", (Integer)objectArray[1]);
            }
            if (objectArray[2] == null) {
                preferences.remove("expand-tabs");
            } else {
                preferences.putBoolean("expand-tabs", (Boolean)objectArray[2]);
            }
            if (objectArray[3] == null) {
                preferences.remove("indent-shift-width");
            } else {
                preferences.putInt("indent-shift-width", (Integer)objectArray[3]);
            }
        }
    }

    private static String getString(String string) {
        return NbBundle.getMessage(EditorPropertySheet.class, (String)string);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.styleComboBox = new JComboBox();
        this.categoryPanel = new JPanel();
        this.manageStyles = new JButton();
        this.overrideGlobalOptions = new JCheckBox();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.styleComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(EditorPropertySheet.class, (String)"LBL_Style_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 6);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.styleComboBox.setMaximumSize(new Dimension(100, 25));
        this.styleComboBox.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.styleComboBox, gridBagConstraints);
        this.categoryPanel.setBorder(BorderFactory.createEtchedBorder());
        this.categoryPanel.setOpaque(false);
        this.categoryPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.categoryPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.manageStyles, (String)NbBundle.getMessage(EditorPropertySheet.class, (String)"EditorPropertySheet.manageStyles.text"));
        this.manageStyles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorPropertySheet.this.manageStylesActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 12, 6);
        this.add((Component)this.manageStyles, gridBagConstraints);
        this.overrideGlobalOptions.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.overrideGlobalOptions, (String)NbBundle.getMessage(EditorPropertySheet.class, (String)"LBL_OverrideGlobalOptions"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.overrideGlobalOptions, gridBagConstraints);
    }

    private void manageStylesActionPerformed(ActionEvent actionEvent) {
        Map<String, PreviewPreferences> map = this.clonePreferences();
        ManageStylesPanel manageStylesPanel = new ManageStylesPanel(this.language, map);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)manageStylesPanel, EditorPropertySheet.getString("MANAGE_STYLES_DIALOG_TITLE"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            this.preferences = map;
            this.initLanguageCategory();
        }
    }

    private Map<String, PreviewPreferences> clonePreferences() {
        HashMap<String, PreviewPreferences> hashMap = new HashMap<String, PreviewPreferences>();
        for (Map.Entry<String, PreviewPreferences> entry : this.preferences.entrySet()) {
            PreviewPreferences previewPreferences = entry.getValue();
            PreviewPreferences previewPreferences2 = new PreviewPreferences(previewPreferences, this.language, entry.getKey());
            hashMap.put(entry.getKey(), previewPreferences2);
        }
        return hashMap;
    }

    private static class DummyNode
    extends AbstractNode {
        public DummyNode(Sheet sheet, String string) {
            super(Children.LEAF);
            if (sheet != null) {
                this.setSheet(sheet);
            }
            this.setName(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryWrapper
    implements Comparable<EntryWrapper> {
        private final String name;
        private String displayName;
        private final PreviewPreferences preferences;

        private EntryWrapper(Map.Entry<String, PreviewPreferences> entry) {
            this.name = entry.getKey();
            this.preferences = entry.getValue();
            this.displayName = EditorOptions.getStyleDisplayName(this.preferences.getLanguage(), this.name);
        }

        public String toString() {
            return this.displayName;
        }

        @Override
        public int compareTo(EntryWrapper entryWrapper) {
            return this.displayName.compareTo(entryWrapper.displayName);
        }
    }
}

