/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.options;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.options.EditorPropertySheet;
import org.netbeans.modules.options.editor.spi.PreviewProvider;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class EditorOptionsPanelController
extends OptionsPanelController
implements PreviewProvider {
    private JEditorPane previewPane;
    private final EditorPropertySheet panel;
    private final CodeStyle.Language language;
    private static final boolean TRACE = false;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    private boolean changed;

    public EditorOptionsPanelController(CodeStyle.Language language) {
        this.language = language;
        this.panel = new EditorPropertySheet(this, language);
    }

    public void update() {
        this.changed = false;
        this.panel.load();
    }

    public void applyChanges() {
        this.panel.store();
    }

    public void cancel() {
        this.panel.cancel();
    }

    public boolean isValid() {
        return true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("netbeans.optionsDialog.advanced.formEditor");
    }

    public JComponent getComponent(Lookup lookup) {
        return this.panel;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    void changed() {
        if (!this.changed) {
            this.changed = true;
            this.pcs.firePropertyChange("changed", false, true);
        }
        this.pcs.firePropertyChange("valid", null, null);
    }

    public JComponent getPreviewComponent() {
        if (this.previewPane == null) {
            this.previewPane = new JEditorPane();
            this.previewPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditorOptionsPanelController.class, (String)"AN_Preview"));
            this.previewPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditorOptionsPanelController.class, (String)"AD_Preview"));
            this.previewPane.putClientProperty("HighlightsLayerIncludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.SyntaxHighlighting$");
            switch (this.language) {
                case C: {
                    this.previewPane.setEditorKit(CloneableEditorSupport.getEditorKit((String)"text/x-c"));
                    break;
                }
                case HEADER: {
                    this.previewPane.setEditorKit(CloneableEditorSupport.getEditorKit((String)"text/x-h"));
                    break;
                }
                default: {
                    this.previewPane.setEditorKit(CloneableEditorSupport.getEditorKit((String)"text/x-c++"));
                }
            }
            this.previewPane.setEditable(false);
        }
        return this.previewPane;
    }

    public void refreshPreview() {
        this.panel.repaintPreview();
    }

    public static OptionsPanelController getCController() {
        return new EditorOptionsPanelController(CodeStyle.Language.C);
    }

    public static OptionsPanelController getCCController() {
        return new EditorOptionsPanelController(CodeStyle.Language.CPP);
    }

    public static OptionsPanelController getHController() {
        return new EditorOptionsPanelController(CodeStyle.Language.HEADER);
    }
}

