/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.indent;

import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.FortranTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenItem {
    private final int index;
    private final FortranTokenId tokenId;
    protected final TokenSequence<FortranTokenId> tokenSeq;
    private final String text;

    public TokenItem(TokenSequence<FortranTokenId> tokenSequence) {
        this.index = tokenSequence.index();
        this.tokenId = (FortranTokenId)tokenSequence.token().id();
        this.tokenSeq = tokenSequence;
        this.text = ((Object)tokenSequence.token().text()).toString();
    }

    public TokenSequence<FortranTokenId> getTokenSequence() {
        return this.tokenSeq;
    }

    private void go() {
        this.tokenSeq.moveIndex(this.index);
        this.tokenSeq.moveNext();
    }

    public FortranTokenId getTokenID() {
        return this.tokenId;
    }

    public int index() {
        return this.index;
    }

    public String getImage() {
        return this.text;
    }

    public TokenItem getNext() {
        this.go();
        while (this.tokenSeq.moveNext()) {
            if (this.tokenSeq.token().id() == FortranTokenId.PREPROCESSOR_DIRECTIVE) continue;
            return new TokenItem(this.tokenSeq);
        }
        return null;
    }

    public TokenItem getPrevious() {
        this.go();
        while (this.tokenSeq.movePrevious()) {
            if (this.tokenSeq.token().id() == FortranTokenId.PREPROCESSOR_DIRECTIVE) continue;
            return new TokenItem(this.tokenSeq);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof TokenItem) {
            return ((TokenItem)object).index == this.index;
        }
        return false;
    }

    public int hashCode() {
        int n = 5;
        n = 43 * n + this.index;
        n = 43 * n + (this.tokenId != null ? this.tokenId.hashCode() : 0);
        return n;
    }

    public String toString() {
        return this.tokenId + "(" + this.index + ")";
    }
}

