/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.indent;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.modules.cnd.editor.fortran.indent.FortranIndentSupport;
import org.netbeans.modules.cnd.editor.fortran.indent.TokenItem;
import org.netbeans.modules.cnd.editor.fortran.options.FortranCodeStyle;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.IndentTask;

public class FortranIndentTask
extends FortranIndentSupport
implements IndentTask {
    private Context context;
    private Document doc;

    public FortranIndentTask(Context context) {
        this.context = context;
        this.doc = context.document();
    }

    public void reindent() throws BadLocationException {
        if (this.codeStyle == null) {
            this.codeStyle = FortranCodeStyle.get(this.doc);
        }
        int n = this.context.caretOffset();
        int n2 = this.context.lineStartOffset(n);
        this.ts = CndLexerUtilities.getFortranTokenSequence((Document)this.doc, (int)n2);
        if (this.ts == null || !this.ts.moveNext()) {
            return;
        }
        int n3 = this.indentLine(new TokenItem((TokenSequence<FortranTokenId>)this.ts), n);
        if (n3 >= 0) {
            this.context.modifyIndent(n2, n3);
        }
    }

    public ExtraLock indentLock() {
        return null;
    }

    public int indentLine(TokenItem tokenItem, int n) {
        if (this.isFixedFormatComment(tokenItem = this.moveToFirstLineImportantToken(tokenItem)) || this.isPreprocessor(tokenItem)) {
            return 0;
        }
        if (this.isFreeFormatComment(tokenItem)) {
            return this.findIndent(tokenItem);
        }
        if (this.isFixedFormatLabel(tokenItem)) {
            TokenItem tokenItem2 = tokenItem.getNext();
            while (tokenItem2.getTokenID() == this.getWhitespaceTokenID()) {
                TokenItem tokenItem3 = tokenItem2.getNext();
                this.removeToken(tokenItem2);
                tokenItem2 = tokenItem3;
            }
            int n2 = this.findInlineSpacing(tokenItem);
            for (int i = 0; i < n2 - 5; ++i) {
                this.insertToken(tokenItem2, this.getWhitespaceTokenID(), " ");
            }
            return 1;
        }
        if (this.isFixedFormatLineContinuation(tokenItem)) {
            TokenItem tokenItem4 = tokenItem.getNext();
            while (tokenItem4.getTokenID() == this.getWhitespaceTokenID()) {
                TokenItem tokenItem5 = tokenItem4.getNext();
                this.removeToken(tokenItem4);
                tokenItem4 = tokenItem5;
            }
            int n3 = this.findInlineSpacing(tokenItem);
            for (int i = 0; i < n3 - 5; ++i) {
                this.insertToken(tokenItem4, this.getWhitespaceTokenID(), " ");
            }
            return 5;
        }
        if (!this.getFreeFormat() && tokenItem.getTokenID() == FortranTokenId.KW_SUBROUTINE || tokenItem.getTokenID() == FortranTokenId.KW_ENTRY || tokenItem.getTokenID() == FortranTokenId.KW_FUNCTION) {
            return 6;
        }
        int n4 = this.findIndent(tokenItem);
        if (!this.getFreeFormat() && n4 < 6) {
            n4 = 6;
        }
        return n4;
    }

    public void insertToken(TokenItem tokenItem, FortranTokenId fortranTokenId, String string) {
    }

    public void removeToken(TokenItem tokenItem) {
    }

    public int findIndent(TokenItem tokenItem) {
        int n = -1;
        if (tokenItem == null) {
            return 0;
        }
        TokenItem tokenItem2 = null;
        switch (tokenItem.getTokenID()) {
            case KW_CASE: 
            case KW_DEFAULT: {
                tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_SELECT, FortranTokenId.KW_ENDSELECT);
                if (tokenItem2 == null) {
                    tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_SELECTCASE, FortranTokenId.KW_ENDSELECT);
                }
                if (tokenItem2 == null) break;
                n = this.getTokenIndent(tokenItem2) + this.getShiftWidth();
                break;
            }
            case KW_PROGRAM: 
            case KW_ENDPROGRAM: {
                n = 0;
                break;
            }
            case KW_END: {
                TokenItem tokenItem3 = tokenItem.getNext();
                if (tokenItem3 == null) {
                    if (this.getFreeFormat()) {
                        n = 0;
                        break;
                    }
                    n = 6;
                    break;
                }
                if (tokenItem3.getTokenID() == FortranTokenId.WHITESPACE) {
                    tokenItem3 = tokenItem3.getNext();
                }
                if (tokenItem3 == null) {
                    n = 0;
                    break;
                }
                if (tokenItem3.getTokenID() == FortranTokenId.NEW_LINE) {
                    n = 0;
                    break;
                }
                switch (tokenItem3.getTokenID()) {
                    case KW_IF: 
                    case KW_ELSE: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_IF, FortranTokenId.KW_ENDIF);
                        break;
                    }
                    case KW_BLOCK: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_BLOCK, FortranTokenId.KW_ENDBLOCK);
                        if (tokenItem2 != null) break;
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_BLOCKDATA, FortranTokenId.KW_ENDBLOCKDATA);
                        break;
                    }
                    case KW_BLOCKDATA: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_BLOCKDATA, FortranTokenId.KW_ENDBLOCKDATA);
                        break;
                    }
                    case KW_DO: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_DO, FortranTokenId.KW_ENDDO);
                        break;
                    }
                    case KW_FORALL: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_FORALL, FortranTokenId.KW_ENDFORALL);
                        break;
                    }
                    case KW_FUNCTION: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_FUNCTION, FortranTokenId.KW_ENDFUNCTION);
                        break;
                    }
                    case KW_INTERFACE: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_INTERFACE, FortranTokenId.KW_ENDINTERFACE);
                        break;
                    }
                    case KW_MAP: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_MAP, FortranTokenId.KW_ENDMAP);
                        break;
                    }
                    case KW_MODULE: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_MODULE, FortranTokenId.KW_ENDMODULE);
                        break;
                    }
                    case KW_PROGRAM: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_PROGRAM, FortranTokenId.KW_ENDPROGRAM);
                        break;
                    }
                    case KW_SELECT: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_SELECT, FortranTokenId.KW_ENDSELECT);
                        if (tokenItem2 != null) break;
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_SELECTCASE, FortranTokenId.KW_ENDSELECT);
                        break;
                    }
                    case KW_STRUCTURE: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_STRUCTURE, FortranTokenId.KW_ENDSTRUCTURE);
                        break;
                    }
                    case KW_SUBROUTINE: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_SUBROUTINE, FortranTokenId.KW_ENDSUBROUTINE);
                        break;
                    }
                    case KW_TYPE: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_TYPE, FortranTokenId.KW_ENDTYPE);
                        break;
                    }
                    case KW_ENUM: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_ENUM, FortranTokenId.KW_ENDENUM);
                        break;
                    }
                    case KW_UNION: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_UNION, FortranTokenId.KW_ENDUNION);
                        break;
                    }
                    case KW_WHERE: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_WHERE, FortranTokenId.KW_ENDWHERE);
                        break;
                    }
                    case KW_WHILE: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_WHILE, FortranTokenId.KW_ENDWHILE);
                    }
                }
                if (tokenItem2 == null) break;
                n = this.getTokenIndent(tokenItem2);
                break;
            }
            default: {
                switch (tokenItem.getTokenID()) {
                    case KW_ELSE: 
                    case KW_ELSEIF: 
                    case KW_ENDIF: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_IF, FortranTokenId.KW_ENDIF);
                        if (tokenItem2 != null) break;
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_WHERE, FortranTokenId.KW_ENDWHERE);
                        break;
                    }
                    case KW_ENDBLOCK: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_BLOCK, FortranTokenId.KW_ENDBLOCK);
                        if (tokenItem2 != null) break;
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_BLOCKDATA, FortranTokenId.KW_ENDBLOCKDATA);
                        break;
                    }
                    case KW_ENDBLOCKDATA: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_BLOCKDATA, FortranTokenId.KW_ENDBLOCKDATA);
                        break;
                    }
                    case KW_ENDDO: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_DO, FortranTokenId.KW_ENDDO);
                        break;
                    }
                    case KW_ENDFORALL: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_FORALL, FortranTokenId.KW_ENDFORALL);
                        break;
                    }
                    case KW_ENDFUNCTION: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_FUNCTION, FortranTokenId.KW_ENDFUNCTION);
                        break;
                    }
                    case KW_ENDINTERFACE: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_INTERFACE, FortranTokenId.KW_ENDINTERFACE);
                        break;
                    }
                    case KW_ENDMAP: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_MAP, FortranTokenId.KW_ENDMAP);
                        break;
                    }
                    case KW_ENDMODULE: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_MODULE, FortranTokenId.KW_ENDMODULE);
                        break;
                    }
                    case KW_ENDSELECT: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_SELECT, FortranTokenId.KW_ENDSELECT);
                        if (tokenItem2 != null) break;
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_SELECTCASE, FortranTokenId.KW_ENDSELECT);
                        break;
                    }
                    case KW_ENDSTRUCTURE: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_STRUCTURE, FortranTokenId.KW_ENDSTRUCTURE);
                        break;
                    }
                    case KW_ENDSUBROUTINE: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_SUBROUTINE, FortranTokenId.KW_ENDSUBROUTINE);
                        break;
                    }
                    case KW_ENDTYPE: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_TYPE, FortranTokenId.KW_ENDTYPE);
                        break;
                    }
                    case KW_ENDENUM: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_ENUM, FortranTokenId.KW_ENDENUM);
                        break;
                    }
                    case KW_ENDUNION: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_UNION, FortranTokenId.KW_ENDUNION);
                        break;
                    }
                    case KW_ENDWHERE: 
                    case KW_ELSEWHERE: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_WHERE, FortranTokenId.KW_ENDWHERE);
                        break;
                    }
                    case KW_ENDWHILE: {
                        tokenItem2 = this.findMatchingToken(tokenItem, FortranTokenId.KW_WHILE, FortranTokenId.KW_ENDWHILE);
                    }
                }
                if (tokenItem2 == null) break;
                n = this.getTokenIndent(tokenItem2);
            }
        }
        if (n < 0) {
            TokenItem tokenItem4 = this.findImportantToken(tokenItem, null, true);
            TokenItem tokenItem5 = this.findLineStartToken(tokenItem4);
            if (tokenItem5 == null) {
                return 0;
            }
            while (this.isFixedFormatLineContinuation(tokenItem5) || this.isPreprocessor(tokenItem5) || tokenItem5.getTokenID() == FortranTokenId.KW_ENTRY) {
                tokenItem4 = this.findImportantToken(tokenItem5, null, true);
                if ((tokenItem5 = this.findLineStartToken(tokenItem4)) != null) continue;
                return 0;
            }
            if (tokenItem4 != null) {
                while (this.isFixedFormatLabel(tokenItem5) || tokenItem5.getTokenID() == FortranTokenId.WHITESPACE) {
                    if ((tokenItem5 = tokenItem5.getNext()) != null) continue;
                    return 0;
                }
                block44 : switch (tokenItem5.getTokenID()) {
                    case KW_DO: {
                        if (!this.getFreeFormat()) {
                            TokenItem tokenItem6 = tokenItem5.getNext();
                            while (tokenItem6.getTokenID() == FortranTokenId.WHITESPACE) {
                                tokenItem6 = tokenItem6.getNext();
                            }
                            if (tokenItem6.getTokenID() == FortranTokenId.NUM_LITERAL_INT) {
                                n = this.getTokenIndent(tokenItem5);
                                break;
                            }
                        }
                        n = this.getTokenIndent(tokenItem5) + this.getShiftWidth();
                        break;
                    }
                    case KW_ELSE: 
                    case KW_BLOCK: 
                    case KW_BLOCKDATA: 
                    case KW_FORALL: 
                    case KW_FUNCTION: 
                    case KW_INTERFACE: 
                    case KW_MAP: 
                    case KW_PROGRAM: 
                    case KW_SELECT: 
                    case KW_STRUCTURE: 
                    case KW_SUBROUTINE: 
                    case KW_ENUM: 
                    case KW_UNION: 
                    case KW_WHERE: 
                    case KW_ELSEWHERE: 
                    case KW_CASE: 
                    case KW_RECURSIVE: 
                    case KW_DOUBLEPRECISION: 
                    case KW_SELECTCASE: {
                        n = this.getTokenIndent(tokenItem5) + this.getShiftWidth();
                        break;
                    }
                    case KW_TYPE: {
                        TokenItem tokenItem7 = this.findImportantToken(tokenItem5.getNext(), null, false);
                        if (tokenItem7 != null && tokenItem7.getTokenID() == FortranTokenId.LPAREN) {
                            n = this.getTokenIndent(tokenItem5);
                            break;
                        }
                        n = this.getTokenIndent(tokenItem5) + this.getShiftWidth();
                        break;
                    }
                    case KW_MODULE: {
                        TokenItem tokenItem8 = this.findImportantToken(tokenItem5.getNext(), null, false);
                        if (tokenItem8 != null) {
                            switch (tokenItem8.getTokenID()) {
                                case KW_FUNCTION: 
                                case KW_SUBROUTINE: 
                                case KW_PROCEDURE: {
                                    n = this.getTokenIndent(tokenItem5);
                                    break block44;
                                }
                            }
                            n = this.getTokenIndent(tokenItem5) + this.getShiftWidth();
                            break;
                        }
                        n = this.getTokenIndent(tokenItem5) + this.getShiftWidth();
                        break;
                    }
                    case KW_ELSEIF: {
                        n = this.getTokenIndent(tokenItem5) + this.getShiftWidth();
                        break;
                    }
                    case KW_IF: {
                        if (this.isIfThenStatement(tokenItem5)) {
                            n = this.getTokenIndent(tokenItem5) + this.getShiftWidth();
                            break;
                        }
                        n = this.getTokenIndent(tokenItem5);
                        break;
                    }
                    default: {
                        n = this.getTokenIndent(tokenItem5);
                    }
                }
                if (n < 0) {
                    n = this.getTokenIndent(tokenItem4);
                }
            }
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public FortranIndentTask(Document document) {
        this.doc = document;
    }

    public void reindent(int n) throws BadLocationException {
        if (this.codeStyle == null) {
            this.codeStyle = FortranCodeStyle.get(this.doc);
        }
        int n2 = IndentUtils.lineStartOffset((Document)this.doc, (int)n);
        this.ts = CndLexerUtilities.getFortranTokenSequence((Document)this.doc, (int)n2);
        if (this.ts == null || !this.ts.moveNext() && !this.ts.movePrevious()) {
            return;
        }
        int n3 = this.indentLine(new TokenItem((TokenSequence<FortranTokenId>)this.ts), n);
        if (n3 >= 0) {
            this.modifyIndent(n2, n3);
        }
    }

    private void modifyIndent(int n, int n2) throws BadLocationException {
        char c;
        int n3;
        int n4 = 0;
        int n5 = -1;
        String string = this.doc.getText(0, this.doc.getLength());
        for (n3 = n; n3 < string.length() && (c = string.charAt(n3)) != '\n'; ++n3) {
            if (c == '\t') {
                if (n5 == -1) {
                    n5 = IndentUtils.tabSize((Document)this.doc);
                }
                n4 = (n4 + n5) / n5 * n5;
                continue;
            }
            if (!Character.isWhitespace(c)) break;
            ++n4;
        }
        String string2 = IndentUtils.createIndentString((Document)this.doc, (int)n2);
        int n6 = n;
        for (int i = 0; i < string2.length() && n + i < n3; ++i) {
            if (string2.charAt(i) == string.charAt(n + i)) continue;
            n6 = n + i;
            string2 = string2.substring(i);
            break;
        }
        if (n6 < n3) {
            this.doc.remove(n6, n3 - n6);
        }
        if (string2.length() > 0) {
            this.doc.insertString(n6, string2, null);
        }
    }
}

