/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran;

import java.util.prefs.Preferences;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FortranBracketCompletion {
    private FortranBracketCompletion() {
    }

    static void charInserted(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (!FortranBracketCompletion.completionSettingEnabled()) {
            return;
        }
        Token<FortranTokenId> token = FortranBracketCompletion.getToken(baseDocument, n);
        if (token == null) {
            return;
        }
        if (c == ')' || c == '(') {
            switch ((FortranTokenId)token.id()) {
                case RPAREN: {
                    FortranBracketCompletion.skipClosingBracket(baseDocument, caret, c);
                    break;
                }
                case LPAREN: {
                    FortranBracketCompletion.completeOpeningBracket(baseDocument, n, caret, c);
                }
            }
        } else if (c == '\"' || c == '\'') {
            FortranBracketCompletion.completeQuote(baseDocument, n, caret, c);
        }
    }

    private static Token<FortranTokenId> getToken(BaseDocument baseDocument, int n) {
        TokenSequence tokenSequence = CndLexerUtilities.getFortranTokenSequence((Document)baseDocument, (int)n);
        if (tokenSequence == null) {
            return null;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext()) {
            return null;
        }
        return tokenSequence.token();
    }

    private static TokenSequence<FortranTokenId> getTokenSequence(BaseDocument baseDocument, int n) {
        TokenSequence tokenSequence = CndLexerUtilities.getFortranTokenSequence((Document)baseDocument, (int)n);
        if (tokenSequence == null) {
            return null;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext()) {
            return null;
        }
        return tokenSequence;
    }

    private static void skipClosingBracket(BaseDocument baseDocument, Caret caret, char c) throws BadLocationException {
        int n = caret.getDot();
        if (FortranBracketCompletion.isSkipClosingBracket(baseDocument, n, FortranTokenId.RPAREN)) {
            baseDocument.remove(n - 1, 1);
            caret.setDot(n);
        }
    }

    static boolean isSkipClosingBracket(BaseDocument baseDocument, int n, FortranTokenId fortranTokenId) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return false;
        }
        boolean bl = false;
        TokenSequence<FortranTokenId> tokenSequence = FortranBracketCompletion.getTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return false;
        }
        if (tokenSequence.token().id() == fortranTokenId) {
            FortranTokenId fortranTokenId2;
            FortranTokenId fortranTokenId3 = FortranTokenId.LPAREN;
            int n2 = tokenSequence.index();
            while (tokenSequence.moveNext() && tokenSequence.token().id() == fortranTokenId) {
                n2 = tokenSequence.index();
            }
            boolean bl2 = false;
            int n3 = -1;
            boolean bl3 = false;
            while (!bl3 && tokenSequence.movePrevious()) {
                fortranTokenId2 = (FortranTokenId)tokenSequence.token().id();
                switch (fortranTokenId2) {
                    case LPAREN: {
                        if (fortranTokenId2 != fortranTokenId || ++n3 != 0) break;
                        if (bl2) {
                            n3 = 1;
                        }
                        bl3 = true;
                        break;
                    }
                    case RPAREN: {
                        if (fortranTokenId2 != fortranTokenId) break;
                        --n3;
                    }
                }
            }
            if (n3 != 0) {
                bl = true;
            } else {
                bl2 = false;
                n3 = 1;
                tokenSequence.moveIndex(n2);
                tokenSequence.moveNext();
                tokenSequence.moveNext();
                bl3 = false;
                while (!bl3 && tokenSequence.movePrevious()) {
                    fortranTokenId2 = (FortranTokenId)tokenSequence.token().id();
                    switch (fortranTokenId2) {
                        case LPAREN: {
                            if (fortranTokenId2 != fortranTokenId3) break;
                            ++n3;
                            break;
                        }
                        case RPAREN: {
                            if (fortranTokenId2 != fortranTokenId || --n3 != 0) break;
                            if (bl2) {
                                n3 = -1;
                            }
                            bl3 = true;
                        }
                    }
                }
                bl = n3 == 0;
            }
        }
        return bl;
    }

    private static void completeOpeningBracket(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (FortranBracketCompletion.isCompletablePosition(baseDocument, n + 1)) {
            String string = "" + FortranBracketCompletion.matching(c);
            baseDocument.insertString(n + 1, string, null);
            caret.setDot(n + 1);
        }
    }

    private static boolean isEscapeSequence(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n <= 0) {
            return false;
        }
        char c = baseDocument.getChars(n - 1, 1)[0];
        return c == '\\';
    }

    private static void completeQuote(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (FortranBracketCompletion.isEscapeSequence(baseDocument, n)) {
            return;
        }
        FortranTokenId[] fortranTokenIdArray = new FortranTokenId[]{FortranTokenId.STRING_LITERAL};
        if (FortranBracketCompletion.posWithinQuotes(baseDocument, n + 1, c, fortranTokenIdArray) && FortranBracketCompletion.isCompletablePosition(baseDocument, n + 1) && FortranBracketCompletion.isUnclosedStringAtLineEnd(baseDocument, n + 1, fortranTokenIdArray) && (baseDocument.getLength() == n + 1 || baseDocument.getLength() != n + 1 && baseDocument.getChars(n + 1, 1)[0] != c)) {
            baseDocument.insertString(n + 1, "" + c, null);
            caret.setDot(n + 1);
        } else {
            char[] cArray = baseDocument.getChars(n + 1, 1);
            if (cArray != null && cArray[0] == c) {
                baseDocument.remove(n + 1, 1);
            }
        }
    }

    private static boolean isCompletablePosition(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return true;
        }
        char c = baseDocument.getChars(n, 1)[0];
        return c == ')' || c == ',' || c == '\"' || c == '\'' || c == ' ' || c == '-' || c == '+' || c == '|' || c == '&' || c == ']' || c == '}' || c == '\n' || c == '\t' || c == ';';
    }

    private static boolean completionSettingEnabled() {
        Preferences preferences = (Preferences)MimeLookup.getLookup((String)"text/x-fortran").lookup(Preferences.class);
        return preferences.getBoolean("pair-characters-completion", true);
    }

    private static char matching(char c) {
        switch (c) {
            case '(': {
                return ')';
            }
            case '\'': {
                return '\'';
            }
        }
        return ' ';
    }

    private static boolean posWithinQuotes(BaseDocument baseDocument, int n, char c, FortranTokenId[] fortranTokenIdArray) {
        TokenSequence<FortranTokenId> tokenSequence = FortranBracketCompletion.getTokenSequence(baseDocument, n);
        if (tokenSequence != null && FortranBracketCompletion.matchIDs((FortranTokenId)tokenSequence.token().id(), fortranTokenIdArray)) {
            return n - tokenSequence.offset() == 1 || DocumentUtilities.getText((Document)baseDocument).charAt(n - 1) != c;
        }
        return false;
    }

    private static boolean isUnclosedStringAtLineEnd(BaseDocument baseDocument, int n, FortranTokenId[] fortranTokenIdArray) {
        int n2;
        try {
            n2 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        TokenSequence<FortranTokenId> tokenSequence = FortranBracketCompletion.getTokenSequence(baseDocument, n2);
        if (tokenSequence != null) {
            return FortranBracketCompletion.matchIDs((FortranTokenId)tokenSequence.token().id(), fortranTokenIdArray);
        }
        return false;
    }

    static boolean matchIDs(FortranTokenId fortranTokenId, FortranTokenId[] fortranTokenIdArray) {
        for (int i = fortranTokenIdArray.length - 1; i >= 0; --i) {
            if (fortranTokenId != fortranTokenIdArray[i]) continue;
            return true;
        }
        return false;
    }
}

