/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.SwingUtilities;
import org.netbeans.modules.web.monitor.client.Controller;
import org.netbeans.modules.web.monitor.client.MonitorAction;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

public class PutTransaction
extends HttpServlet {
    private static FileObject currDir = null;
    private static boolean debug = false;
    private ServletConfig servletConfig = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        PrintWriter printWriter;
        String string;
        if (debug) {
            this.log("doPost");
        }
        if (currDir == null) {
            try {
                currDir = Controller.getCurrDir();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (debug) {
                    this.log("Couldn't write the transaction data");
                }
                return;
            }
        }
        if ((string = httpServletRequest.getQueryString()) == null || string.length() == 0) {
            if (debug) {
                this.log("Bad request, exiting...");
            }
            return;
        }
        string = string.substring(0, string.indexOf("|"));
        if (debug) {
            this.log(" Trying to add the transaction");
        }
        FileObject fileObject = null;
        try {
            if (debug) {
                this.log(" Before creating the file");
            }
            fileObject = currDir.createData(string, "xml");
            if (debug) {
                this.log(" After creating the file");
            }
        }
        catch (IOException iOException) {
            if (debug) {
                this.log(" Could not create the file, exiting...");
            }
            return;
        }
        FileLock fileLock = null;
        try {
            fileLock = fileObject.lock();
            if (debug) {
                this.log(" Got the lock");
            }
        }
        catch (FileAlreadyLockedException fileAlreadyLockedException) {
            if (debug) {
                this.log(" Couldn't get a file lock, exiting...");
            }
            return;
        }
        boolean bl = false;
        try {
            printWriter = new PrintWriter(fileObject.getOutputStream(fileLock));
            try {
                object = new InputStreamReader((InputStream)httpServletRequest.getInputStream());
                try {
                    int n;
                    char[] cArray = new char[4096];
                    while ((n = ((InputStreamReader)object).read(cArray, 0, 4096)) != -1) {
                        printWriter.write(cArray, 0, n);
                    }
                }
                finally {
                    ((InputStreamReader)object).close();
                }
            }
            finally {
                printWriter.close();
            }
            bl = true;
            if (debug) {
                this.log("...success");
            }
        }
        catch (IOException iOException) {
            if (debug) {
                this.log("Failed to read/write the record:");
                this.log(iOException);
            }
        }
        finally {
            fileLock.releaseLock();
            try {
                httpServletResponse.setContentType("text/plain");
                printWriter = httpServletResponse.getWriter();
                try {
                    printWriter.println("ACK");
                }
                finally {
                    printWriter.close();
                }
            }
            catch (Exception exception) {}
        }
        final boolean bl2 = bl;
        object = string;
        SwingUtilities.invokeLater(new Runnable((String)object){
            private final /* synthetic */ String val$id2;
            {
                this.val$id2 = string;
            }

            public void run() {
                if (bl2) {
                    MonitorAction.addTransaction(this.val$id2);
                }
            }
        });
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        PrintWriter printWriter;
        block5: {
            if (debug) {
                this.log("doGet");
            }
            printWriter = httpServletResponse.getWriter();
            try {
                printWriter.println("Shouldn't use GET for this!");
            }
            catch (Exception exception) {
                if (!debug) break block5;
                this.log(exception.getMessage());
            }
        }
        try {
            printWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
        if (debug) {
            this.log("init");
        }
    }

    public void log(String string) {
        System.out.println("PutTransaction::" + string);
    }

    public void log(Throwable throwable) {
        this.log(PutTransaction.getStackTrace(throwable));
    }

    public static String getStackTrace(Throwable throwable) {
        String string = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            stringWriter.close();
            string = stringWriter.getBuffer().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }
}

