/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.web.monitor.client.DataDisplay;
import org.netbeans.modules.web.monitor.client.DisplayTable;
import org.netbeans.modules.web.monitor.data.EngineData;
import org.netbeans.modules.web.monitor.data.MonitorData;
import org.netbeans.modules.web.monitor.data.ServletData;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

class EditPanelServer
extends DataDisplay {
    private static final boolean debug = false;
    private boolean holdTableChanges = false;
    private DisplayTable serverTable = null;
    private MonitorData monitorData = null;

    EditPanelServer() {
    }

    void setData(MonitorData monitorData) {
        this.monitorData = monitorData;
        this.setServerTable();
        this.removeAll();
        int n = -1;
        this.addGridBagComponent(this, EditPanelServer.createTopSpacer(), 0, ++n, 0, 1, 0.0, 0.0, 17, 0, topSpacerInsets, 0, 0);
        this.addGridBagComponent(this, EditPanelServer.createHeaderLabel(NbBundle.getBundle((Class)EditPanelServer.class).getString("MON_Exec_server_Header"), NbBundle.getBundle((Class)EditPanelServer.class).getString("ACS_MON_Exec_serverA11yDesc"), this.serverTable), 0, ++n, 0, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
        this.addGridBagComponent(this, this.serverTable, 0, ++n, 0, 1, 1.0, 0.0, 17, 2, tableInsets, 0, 0);
        this.addGridBagComponent(this, EditPanelServer.createGlue(), 0, ++n, 1, 1, 1.0, 1.0, 17, 1, zeroInsets, 0, 0);
        int n2 = -1;
        this.addGridBagComponent(this, EditPanelServer.createGlue(), ++n2, ++n, 1, 1, 1.0, 0.0, 17, 0, buttonInsets, 0, 0);
        this.setMaximumSize(this.getPreferredSize());
        this.repaint();
    }

    void setServerTable() {
        String[] stringArray = new String[]{NbBundle.getBundle((Class)EditPanelServer.class).getString("MON_Server_name"), NbBundle.getBundle((Class)EditPanelServer.class).getString("MON_Server_port")};
        this.serverTable = new DisplayTable(stringArray, 2);
        this.holdTableChanges = true;
        EngineData engineData = this.monitorData.getEngineData();
        if (engineData != null) {
            this.serverTable.setValueAt(engineData.getAttributeValue("serverName"), 0, 1);
            this.serverTable.setValueAt(engineData.getAttributeValue("serverPort"), 1, 1);
        } else {
            ServletData servletData = this.monitorData.getServletData();
            this.serverTable.setValueAt(servletData.getAttributeValue("serverName"), 0, 1);
            this.serverTable.setValueAt(servletData.getAttributeValue("serverPort"), 1, 1);
        }
        this.holdTableChanges = false;
        this.serverTable.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)EditPanelServer.class).getString("ACS_MON_Exec_serverTableA11yName"));
        this.serverTable.setToolTipText(NbBundle.getBundle((Class)EditPanelServer.class).getString("ACS_MON_Exec_serverTableA11yDesc"));
        this.serverTable.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (EditPanelServer.this.holdTableChanges) {
                    return;
                }
                boolean bl = true;
                String string = (String)EditPanelServer.this.serverTable.getValueAt(0, 1);
                string = string.trim();
                String string2 = (String)EditPanelServer.this.serverTable.getValueAt(1, 1);
                string2 = string2.trim();
                if (string.equals("")) {
                    bl = false;
                }
                if (string2.equals("")) {
                    string2 = "80";
                }
                int n = 0;
                if (bl) {
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                }
                if (bl) {
                    try {
                        URL uRL = new URL("http", string, n, "");
                    }
                    catch (MalformedURLException malformedURLException) {
                        bl = false;
                    }
                }
                if (bl) {
                    EditPanelServer.this.monitorData.setServerName(string);
                    EditPanelServer.this.monitorData.setServerPort(string2);
                } else {
                    EditPanelServer.this.showErrorDialog();
                    EditPanelServer.this.setData(EditPanelServer.this.monitorData);
                }
            }
        });
    }

    public void repaint() {
        super.repaint();
    }

    void showErrorDialog() {
        Object[] objectArray = new Object[]{NotifyDescriptor.OK_OPTION};
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getBundle((Class)EditPanelServer.class).getString("MON_Bad_server"), NbBundle.getBundle((Class)EditPanelServer.class).getString("MON_Invalid_input"), -1, 0, objectArray, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
    }

    void log(String string) {
        System.out.println("EditPanelServer::" + string);
    }
}

