/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.modules.hibernate.wizards.Util;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class HibernateConfigurationWizardPanel
extends JPanel {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JComboBox cmbDbConnection;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField txtDialect;

    public HibernateConfigurationWizardPanel() {
        this.initComponents();
        this.setDefaults();
        this.cmbDbConnection.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                HibernateConfigurationWizardPanel.this.changeSupport.fireChange();
            }
        });
    }

    public void setDefaults() {
        this.cmbDbConnection.setModel(new DefaultComboBoxModel<String>(new String[0]));
        DatabaseExplorerUIs.connect((JComboBox)this.cmbDbConnection, (ConnectionManager)ConnectionManager.getDefault());
        if (this.cmbDbConnection.getItemCount() > 1) {
            this.cmbDbConnection.setSelectedIndex(0);
        }
    }

    public String getName() {
        return NbBundle.getMessage(HibernateConfigurationWizardPanel.class, (String)"LBL_HibernateConfigurationPanel_Name");
    }

    private void fillComponents() {
        DatabaseConnection databaseConnection = this.getDatabaseConnection();
        if (databaseConnection != null && this.cmbDbConnection.getItemCount() != 0) {
            this.txtDialect.setText(Util.getDialectName(databaseConnection.getDriverClass()));
        }
    }

    private void checkAndRegisterDBDriver() {
    }

    private void initComponents() {
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.cmbDbConnection = new JComboBox();
        this.txtDialect = new JTextField();
        this.setName(NbBundle.getMessage(HibernateConfigurationWizardPanel.class, (String)"LBL_HibernateConfigurationPanel_Name"));
        this.jLabel4.setLabelFor(this.txtDialect);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(HibernateConfigurationWizardPanel.class, (String)"HibernateConfigurationWizardPanel.jLabel4.text"));
        this.jLabel3.setLabelFor(this.cmbDbConnection);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(HibernateConfigurationWizardPanel.class, (String)"HibernateConfigurationWizardPanel.jLabel3.text"));
        this.cmbDbConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HibernateConfigurationWizardPanel.this.cmbDbConnectionActionPerformed(actionEvent);
            }
        });
        this.txtDialect.setEditable(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel3, -1, 128, Short.MAX_VALUE).addPreferredGap(0)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel4).add(40, 40, 40))).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.txtDialect, -1, 392, Short.MAX_VALUE).add(2, (Component)this.cmbDbConnection, 0, 392, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.cmbDbConnection, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.txtDialect, -2, -1, -2)).addContainerGap(24, Short.MAX_VALUE)));
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HibernateConfigurationWizardPanel.class, (String)"HibernateConfigurationWizardPanel.jLabel4.AccessibleContext.accessibleDescription"));
    }

    private void cmbDbConnectionActionPerformed(ActionEvent actionEvent) {
        this.fillComponents();
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public String getSelectedDialect() {
        if (this.txtDialect.getText() != null) {
            return this.txtDialect.getText().trim();
        }
        return null;
    }

    public void setDialect(String string) {
        this.txtDialect.setText(string);
    }

    public String getSelectedDriver() {
        if (this.getDatabaseConnection() != null && this.getDatabaseConnection().getDriverClass() != null) {
            return this.getDatabaseConnection().getDriverClass().trim();
        }
        return null;
    }

    public String getSelectedURL() {
        if (this.getDatabaseConnection() != null && this.getDatabaseConnection().getDatabaseURL() != null) {
            return this.getDatabaseConnection().getDatabaseURL().trim();
        }
        return null;
    }

    public String getUserName() {
        if (this.getDatabaseConnection() != null && this.getDatabaseConnection().getUser() != null) {
            return this.getDatabaseConnection().getUser().trim();
        }
        return null;
    }

    public String getPassword() {
        if (this.getDatabaseConnection() != null && this.getDatabaseConnection().getPassword() != null) {
            return this.getDatabaseConnection().getPassword().trim();
        }
        return null;
    }

    public DatabaseConnection getDatabaseConnection() {
        return (DatabaseConnection)this.cmbDbConnection.getSelectedItem();
    }

    public void setDatabaseConnection(String string) {
        for (int i = 0; i < this.cmbDbConnection.getItemCount(); ++i) {
            DatabaseConnection databaseConnection;
            if (!(this.cmbDbConnection.getItemAt(i) instanceof DatabaseConnection) || !(databaseConnection = (DatabaseConnection)this.cmbDbConnection.getItemAt(i)).getDatabaseURL().equals(string)) continue;
            this.cmbDbConnection.setSelectedItem(databaseConnection);
            break;
        }
    }

    public boolean isPanelValid() {
        return this.cmbDbConnection.getModel().getSize() > 1;
    }

    public void disable() {
        super.disable();
        for (Component component : this.getComponents()) {
            component.setEnabled(false);
        }
    }
}

