/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.modules.hibernate.mapping.model.Any;
import org.netbeans.modules.hibernate.mapping.model.Array;
import org.netbeans.modules.hibernate.mapping.model.Bag;
import org.netbeans.modules.hibernate.mapping.model.Component;
import org.netbeans.modules.hibernate.mapping.model.CompositeElement;
import org.netbeans.modules.hibernate.mapping.model.CompositeId;
import org.netbeans.modules.hibernate.mapping.model.CompositeIndex;
import org.netbeans.modules.hibernate.mapping.model.CompositeMapKey;
import org.netbeans.modules.hibernate.mapping.model.DynamicComponent;
import org.netbeans.modules.hibernate.mapping.model.HibernateMapping;
import org.netbeans.modules.hibernate.mapping.model.Id;
import org.netbeans.modules.hibernate.mapping.model.Idbag;
import org.netbeans.modules.hibernate.mapping.model.Join;
import org.netbeans.modules.hibernate.mapping.model.JoinedSubclass;
import org.netbeans.modules.hibernate.mapping.model.KeyManyToOne;
import org.netbeans.modules.hibernate.mapping.model.KeyProperty;
import org.netbeans.modules.hibernate.mapping.model.List;
import org.netbeans.modules.hibernate.mapping.model.ManyToOne;
import org.netbeans.modules.hibernate.mapping.model.Map;
import org.netbeans.modules.hibernate.mapping.model.MyClass;
import org.netbeans.modules.hibernate.mapping.model.NaturalId;
import org.netbeans.modules.hibernate.mapping.model.NestedCompositeElement;
import org.netbeans.modules.hibernate.mapping.model.OneToOne;
import org.netbeans.modules.hibernate.mapping.model.Properties;
import org.netbeans.modules.hibernate.mapping.model.Property;
import org.netbeans.modules.hibernate.mapping.model.Set;
import org.netbeans.modules.hibernate.mapping.model.Subclass;
import org.netbeans.modules.hibernate.mapping.model.UnionSubclass;
import org.netbeans.modules.hibernate.refactoring.RenameTransaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFieldRenameTransaction
extends RenameTransaction {
    private final String nameAttrib = "Name";
    private String className;

    public JavaFieldRenameTransaction(java.util.Set<FileObject> set, String string, String string2, String string3) {
        super(set, string2, string3);
        this.className = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doChanges() {
        for (FileObject fileObject : this.getToBeModifiedFiles()) {
            OutputStream outputStream = null;
            try {
                InputStream inputStream = fileObject.getInputStream();
                HibernateMapping hibernateMapping = HibernateMapping.createGraph(inputStream);
                this.refactoringMyClasses(hibernateMapping.getMyClass());
                this.refactoringSubclasses(hibernateMapping.getSubclass());
                this.refactoringJoinedSubclasses(hibernateMapping.getJoinedSubclass());
                this.refactoringUnionSubclasses(hibernateMapping.getUnionSubclass());
                outputStream = fileObject.getOutputStream();
                hibernateMapping.write(outputStream);
            }
            catch (FileAlreadyLockedException fileAlreadyLockedException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileAlreadyLockedException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            finally {
                try {
                    if (outputStream == null) continue;
                    outputStream.close();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        }
    }

    private void refactoringMyClasses(MyClass[] myClassArray) {
        for (int i = 0; i < myClassArray.length; ++i) {
            MyClass myClass = myClassArray[i];
            String string = myClass.getAttributeValue("Name");
            if (string != null && string.equals(this.className)) {
                String string2;
                Object object;
                Object object2;
                Id id = myClass.getId();
                if (id != null && (object2 = id.getAttributeValue("Name")) != null && ((String)object2).equals(this.origName)) {
                    id.setAttributeValue("Name", this.newName);
                }
                if ((object2 = myClass.getVersion()) != null && (object = object2.getAttributeValue("Name")) != null && ((String)object).equals(this.origName)) {
                    object2.setAttributeValue("Name", this.newName);
                }
                if ((object = myClass.getTimestamp()) != null && (string2 = object.getAttributeValue("Name")) != null && string2.equals(this.origName)) {
                    object.setAttributeValue("Name", this.newName);
                }
                this.refactoringCompositeId(myClass.getCompositeId());
                this.refactoringProperty(myClass.getProperty2());
                this.refactoringJoins(myClass.getJoin());
                this.refactoringNaturalId(myClass.getNaturalId());
                this.refactoringMaps(myClass.getMap());
                this.refactoringSets(myClass.getSet());
                this.refactoringLists(myClass.getList());
                this.refactoringArrays(myClass.getArray());
                this.refactoringBags(myClass.getBag());
                this.refactoringIdbags(myClass.getIdbag());
                this.refactoringDynamicComponents(myClass.getDynamicComponent());
                this.refactoringComponents(myClass.getComponent());
                this.refactoringAnys(myClass.getAny());
                this.refactoringManyToOnes(myClass.getManyToOne());
                this.refactoringPropertiez(myClass.getProperties());
                this.refactoringOneToOnes(myClass.getOneToOne());
            }
            this.refactoringSubclasses(myClass.getSubclass());
            this.refactoringJoinedSubclasses(myClass.getJoinedSubclass());
            this.refactoringUnionSubclasses(myClass.getUnionSubclass());
        }
    }

    private void refactoringSubclasses(Subclass[] subclassArray) {
        for (int i = 0; i < subclassArray.length; ++i) {
            String string = subclassArray[i].getAttributeValue("Name");
            if (string != null && string.equals(this.className)) {
                this.refactoringProperty(subclassArray[i].getProperty2());
                this.refactoringJoins(subclassArray[i].getJoin());
                this.refactoringMaps(subclassArray[i].getMap());
                this.refactoringDynamicComponents(subclassArray[i].getDynamicComponent());
                this.refactoringComponents(subclassArray[i].getComponent());
                this.refactoringSets(subclassArray[i].getSet());
                this.refactoringLists(subclassArray[i].getList());
                this.refactoringArrays(subclassArray[i].getArray());
                this.refactoringBags(subclassArray[i].getBag());
                this.refactoringIdbags(subclassArray[i].getIdbag());
                this.refactoringAnys(subclassArray[i].getAny());
                this.refactoringManyToOnes(subclassArray[i].getManyToOne());
                this.refactoringOneToOnes(subclassArray[i].getOneToOne());
            }
            this.refactoringSubclasses(subclassArray[i].getSubclass());
        }
    }

    private void refactoringJoinedSubclasses(JoinedSubclass[] joinedSubclassArray) {
        for (int i = 0; i < joinedSubclassArray.length; ++i) {
            String string = joinedSubclassArray[i].getAttributeValue("Name");
            if (string != null && string.equals(this.className)) {
                this.refactoringProperty(joinedSubclassArray[i].getProperty2());
                this.refactoringMaps(joinedSubclassArray[i].getMap());
                this.refactoringDynamicComponents(joinedSubclassArray[i].getDynamicComponent());
                this.refactoringComponents(joinedSubclassArray[i].getComponent());
                this.refactoringSets(joinedSubclassArray[i].getSet());
                this.refactoringLists(joinedSubclassArray[i].getList());
                this.refactoringArrays(joinedSubclassArray[i].getArray());
                this.refactoringBags(joinedSubclassArray[i].getBag());
                this.refactoringIdbags(joinedSubclassArray[i].getIdbag());
                this.refactoringAnys(joinedSubclassArray[i].getAny());
                this.refactoringManyToOnes(joinedSubclassArray[i].getManyToOne());
                this.refactoringPropertiez(joinedSubclassArray[i].getProperties());
                this.refactoringOneToOnes(joinedSubclassArray[i].getOneToOne());
            }
            this.refactoringJoinedSubclasses(joinedSubclassArray[i].getJoinedSubclass());
        }
    }

    private void refactoringUnionSubclasses(UnionSubclass[] unionSubclassArray) {
        for (int i = 0; i < unionSubclassArray.length; ++i) {
            String string = unionSubclassArray[i].getAttributeValue("Name");
            if (string != null && string.equals(this.className)) {
                this.refactoringProperty(unionSubclassArray[i].getProperty2());
                this.refactoringMaps(unionSubclassArray[i].getMap());
                this.refactoringDynamicComponents(unionSubclassArray[i].getDynamicComponent());
                this.refactoringComponents(unionSubclassArray[i].getComponent());
                this.refactoringSets(unionSubclassArray[i].getSet());
                this.refactoringLists(unionSubclassArray[i].getList());
                this.refactoringArrays(unionSubclassArray[i].getArray());
                this.refactoringBags(unionSubclassArray[i].getBag());
                this.refactoringIdbags(unionSubclassArray[i].getIdbag());
                this.refactoringAnys(unionSubclassArray[i].getAny());
                this.refactoringManyToOnes(unionSubclassArray[i].getManyToOne());
                this.refactoringPropertiez(unionSubclassArray[i].getProperties());
                this.refactoringOneToOnes(unionSubclassArray[i].getOneToOne());
            }
            this.refactoringUnionSubclasses(unionSubclassArray[i].getUnionSubclass());
        }
    }

    private void refactoringCompositeId(CompositeId compositeId) {
        if (compositeId == null) {
            return;
        }
        if (compositeId != null) {
            String string = compositeId.getAttributeValue("Name");
            if (string != null && string.equals(this.origName)) {
                compositeId.setAttributeValue("Name", this.newName);
            }
            this.refactoringKeyProperty(compositeId.getKeyProperty());
            this.refactoringKeyManyToOne(compositeId.getKeyManyToOne());
        }
    }

    private void refactoringKeyManyToOne(KeyManyToOne[] keyManyToOneArray) {
        for (int i = 0; i < keyManyToOneArray.length; ++i) {
            String string = keyManyToOneArray[i].getAttributeValue("Name");
            if (string == null || !string.equals(this.origName)) continue;
            keyManyToOneArray[i].setAttributeValue("Name", this.newName);
        }
    }

    private void refactoringMaps(Map[] mapArray) {
        for (int i = 0; i < mapArray.length; ++i) {
            CompositeIndex compositeIndex;
            CompositeMapKey compositeMapKey;
            String string = mapArray[i].getAttributeValue("Name");
            if (string != null && string.equals(this.origName)) {
                mapArray[i].setAttributeValue("Name", this.newName);
            }
            if ((compositeMapKey = mapArray[i].getCompositeMapKey()) != null) {
                this.refactoringKeyProperty(compositeMapKey.getKeyProperty());
                this.refactoringKeyManyToOne(compositeMapKey.getKeyManyToOne());
            }
            if ((compositeIndex = mapArray[i].getCompositeIndex()) != null) {
                this.refactoringKeyProperty(compositeIndex.getKeyProperty());
                this.refactoringKeyManyToOne(compositeIndex.getKeyManyToOne());
            }
            this.refactoringCompositeElement(mapArray[i].getCompositeElement());
        }
    }

    private void refactoringKeyProperty(KeyProperty[] keyPropertyArray) {
        for (int i = 0; i < keyPropertyArray.length; ++i) {
            String string = keyPropertyArray[i].getAttributeValue("Name");
            if (string == null || !string.equals(this.origName)) continue;
            keyPropertyArray[i].setAttributeValue("Name", this.newName);
        }
    }

    private void refactoringNaturalId(NaturalId naturalId) {
        if (naturalId == null) {
            return;
        }
        this.refactoringProperty(naturalId.getProperty2());
        this.refactoringAnys(naturalId.getAny());
        this.refactoringManyToOnes(naturalId.getManyToOne());
    }

    private void refactoringJoins(Join[] joinArray) {
        for (int i = 0; i < joinArray.length; ++i) {
            Join join = joinArray[i];
            this.refactoringProperty(join.getProperty2());
            this.refactoringAnys(join.getAny());
            this.refactoringManyToOnes(join.getManyToOne());
        }
    }

    private void refactoringProperty(Property[] propertyArray) {
        for (int i = 0; i < propertyArray.length; ++i) {
            String string = propertyArray[i].getAttributeValue("Name");
            if (!string.equals(this.origName)) continue;
            propertyArray[i].setAttributeValue("Name", this.newName);
            break;
        }
    }

    private void refactoringComponents(Component[] componentArray) {
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            this.refactoringMaps(component.getMap());
            this.refactoringSets(component.getSet());
            this.refactoringArrays(component.getArray());
            this.refactoringBags(component.getBag());
            this.refactoringAnys(component.getAny());
            this.refactoringManyToOnes(component.getManyToOne());
            this.refactoringOneToOnes(component.getOneToOne());
        }
    }

    private void refactoringDynamicComponents(DynamicComponent[] dynamicComponentArray) {
        for (int i = 0; i < dynamicComponentArray.length; ++i) {
            DynamicComponent dynamicComponent = dynamicComponentArray[i];
            this.refactoringMaps(dynamicComponent.getMap());
            this.refactoringSets(dynamicComponent.getSet());
            this.refactoringArrays(dynamicComponent.getArray());
            this.refactoringBags(dynamicComponent.getBag());
            this.refactoringAnys(dynamicComponent.getAny());
            this.refactoringManyToOnes(dynamicComponent.getManyToOne());
            this.refactoringOneToOnes(dynamicComponent.getOneToOne());
        }
    }

    private void refactoringSets(Set[] setArray) {
        for (int i = 0; i < setArray.length; ++i) {
            String string = setArray[i].getAttributeValue("Name");
            if (string != null && string.equals(this.origName)) {
                setArray[i].setAttributeValue("Name", this.newName);
            }
            this.refactoringCompositeElement(setArray[i].getCompositeElement());
        }
    }

    private void refactoringLists(List[] listArray) {
        for (int i = 0; i < listArray.length; ++i) {
            String string = listArray[i].getAttributeValue("Name");
            if (string != null && string.equals(this.origName)) {
                listArray[i].setAttributeValue("Name", this.newName);
            }
            this.refactoringCompositeElement(listArray[i].getCompositeElement());
        }
    }

    private void refactoringAnys(Any[] anyArray) {
        for (int i = 0; i < anyArray.length; ++i) {
            String string = anyArray[i].getAttributeValue("Name");
            if (string == null || !string.equals(this.origName)) continue;
            anyArray[i].setAttributeValue("Name", this.newName);
        }
    }

    private void refactoringManyToOnes(ManyToOne[] manyToOneArray) {
        for (int i = 0; i < manyToOneArray.length; ++i) {
            String string = manyToOneArray[i].getAttributeValue("Name");
            if (string == null || !string.equals(this.origName)) continue;
            manyToOneArray[i].setAttributeValue("Name", this.newName);
        }
    }

    private void refactoringArrays(Array[] arrayArray) {
        for (int i = 0; i < arrayArray.length; ++i) {
            this.refactoringCompositeElement(arrayArray[i].getCompositeElement());
        }
    }

    private void refactoringBags(Bag[] bagArray) {
        for (int i = 0; i < bagArray.length; ++i) {
            this.refactoringCompositeElement(bagArray[i].getCompositeElement());
        }
    }

    private void refactoringIdbags(Idbag[] idbagArray) {
        for (int i = 0; i > idbagArray.length; ++i) {
            this.refactoringCompositeElement(idbagArray[i].getCompositeElement());
        }
    }

    private void refactoringCompositeElement(CompositeElement compositeElement) {
        if (compositeElement == null) {
            return;
        }
        this.refactoringManyToOnes(compositeElement.getManyToOne());
        this.refactoringNestedCompositeElements(compositeElement.getNestedCompositeElement());
    }

    private void refactoringNestedCompositeElements(NestedCompositeElement[] nestedCompositeElementArray) {
        for (int i = 0; i < nestedCompositeElementArray.length; ++i) {
            this.refactoringManyToOnes(nestedCompositeElementArray[i].getManyToOne());
        }
    }

    private void refactoringPropertiez(Properties[] propertiesArray) {
        for (int i = 0; i < propertiesArray.length; ++i) {
            this.refactoringProperty(propertiesArray[i].getProperty2());
            this.refactoringManyToOnes(propertiesArray[i].getManyToOne());
        }
    }

    private void refactoringOneToOnes(OneToOne[] oneToOneArray) {
        for (int i = 0; i < oneToOneArray.length; ++i) {
            String string = oneToOneArray[i].getAttributeValue("Name");
            if (string == null || !string.equals(this.origName)) continue;
            oneToOneArray[i].setAttributeValue("Name", this.newName);
        }
    }
}

