/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.netbeans.modules.hibernate.mapping.model.HibernateMapping;
import org.netbeans.modules.hibernate.refactoring.JavaRenameChanger;
import org.netbeans.modules.hibernate.refactoring.RenameTransaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassRenameTransaction
extends RenameTransaction {
    public JavaClassRenameTransaction(Set<FileObject> set, String string, String string2) {
        super(set, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doChanges() {
        JavaRenameChanger javaRenameChanger = new JavaRenameChanger(false, this.origName, this.newName);
        for (FileObject fileObject : this.getToBeModifiedFiles()) {
            OutputStream outputStream = null;
            try {
                InputStream inputStream = fileObject.getInputStream();
                HibernateMapping hibernateMapping = HibernateMapping.createGraph(inputStream);
                javaRenameChanger.refactoringImports(hibernateMapping);
                javaRenameChanger.refactoringMyClasses(hibernateMapping.getMyClass());
                javaRenameChanger.refactoringSubclasses(hibernateMapping.getSubclass());
                javaRenameChanger.refactoringJoinedSubclasses(hibernateMapping.getJoinedSubclass());
                javaRenameChanger.refactoringUnionSubclasses(hibernateMapping.getUnionSubclass());
                outputStream = fileObject.getOutputStream();
                hibernateMapping.write(outputStream);
            }
            catch (FileAlreadyLockedException fileAlreadyLockedException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileAlreadyLockedException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            finally {
                try {
                    if (outputStream == null) continue;
                    outputStream.close();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        }
    }
}

