/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.remote;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.Lookup;

public abstract class RemoteSyncFactory {
    public abstract RemoteSyncWorker createNew(ExecutionEnvironment var1, PrintWriter var2, PrintWriter var3, File var4, File ... var5);

    public abstract RemoteSyncWorker createNew(Project var1, PrintWriter var2, PrintWriter var3);

    public abstract boolean isApplicable(ExecutionEnvironment var1);

    public abstract String getDisplayName();

    public abstract String getDescription();

    public abstract String getID();

    public static RemoteSyncFactory fromID(String string) {
        assert (string != null);
        for (RemoteSyncFactory remoteSyncFactory : RemoteSyncFactory.getFactories()) {
            if (!string.equals(remoteSyncFactory.getID())) continue;
            return remoteSyncFactory;
        }
        Logger.global.severe("No RemoteSyncFactory found by with ID " + string);
        return null;
    }

    public static RemoteSyncFactory[] getFactories() {
        Collection collection = Lookup.getDefault().lookupAll(RemoteSyncFactory.class);
        ArrayList arrayList = new ArrayList(collection);
        String string = System.getProperty("cnd.remote.default.sync");
        if (string != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!string.equals(((RemoteSyncFactory)arrayList.get(i)).getID())) continue;
                if (i <= 0) break;
                RemoteSyncFactory remoteSyncFactory = (RemoteSyncFactory)arrayList.get(0);
                arrayList.set(0, arrayList.get(i));
                arrayList.set(i, remoteSyncFactory);
                break;
            }
        }
        return arrayList.toArray(new RemoteSyncFactory[arrayList.size()]);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static RemoteSyncFactory getDefault() {
        RemoteSyncFactory[] remoteSyncFactoryArray = RemoteSyncFactory.getFactories();
        assert (remoteSyncFactoryArray.length > 0);
        return remoteSyncFactoryArray[0];
    }

    public boolean isPathMappingCustomizable() {
        return false;
    }
}

