/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.core.api.support.classpath.ContainerClassPathModifier;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.Util;
import org.netbeans.modules.web.wizards.AnnotationGenerator;
import org.netbeans.modules.web.wizards.DeployData;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.FinishableProxyWizardPanel;
import org.netbeans.modules.web.wizards.ServletData;
import org.netbeans.modules.web.wizards.ServletPanel;
import org.netbeans.modules.web.wizards.TargetEvaluator;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.modules.web.wizards.WrapperSelection;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator {
    private static final long serialVersionUID = -4147344271705652643L;
    private transient FileType fileType;
    private transient TargetEvaluator evaluator = null;
    private transient DeployData deployData = null;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient TemplateWizard wizard;
    private transient WizardDescriptor.Panel customPanel;

    private ServletIterator(FileType fileType) {
        this.fileType = fileType;
    }

    public static ServletIterator createServletIterator() {
        return new ServletIterator(FileType.SERVLET);
    }

    public static ServletIterator createFilterIterator() {
        return new ServletIterator(FileType.FILTER);
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = (TemplateWizard)wizardDescriptor;
        this.index = 0;
        if (this.fileType.equals(FileType.SERVLET) || this.fileType.equals(FileType.FILTER)) {
            this.deployData = new ServletData(this.fileType);
            if (Utilities.isJavaEE6(this.wizard)) {
                this.deployData.setMakeEntry(false);
            }
            this.evaluator = new TargetEvaluator(this.fileType, this.deployData);
        }
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        DataFolder dataFolder = null;
        try {
            dataFolder = this.wizard.getTargetFolder();
        }
        catch (IOException iOException) {
            dataFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        }
        this.evaluator.setInitialFolder(dataFolder, project);
        boolean bl = ((ServletData)this.deployData).canCreate(this.wizard);
        if (this.fileType == FileType.SERVLET) {
            this.panels = new WizardDescriptor.Panel[]{new FinishableProxyWizardPanel(this.createPackageChooserPanel(this.wizard, null), new HelpCtx(ServletIterator.class.getName() + "." + this.fileType), bl), ServletPanel.createServletPanel(this.evaluator, this.wizard)};
        } else if (this.fileType == FileType.FILTER) {
            this.customPanel = new WrapperSelection(this.wizard);
            this.panels = new WizardDescriptor.Panel[]{bl ? this.createPackageChooserPanel(this.wizard, this.customPanel) : new FinishableProxyWizardPanel(this.createPackageChooserPanel(this.wizard, this.customPanel), new HelpCtx(ServletIterator.class.getName() + "." + this.fileType), false), ServletPanel.createServletPanel(this.evaluator, this.wizard), ServletPanel.createFilterPanel(this.evaluator, this.wizard)};
        }
        Object object = this.wizard.getProperty("WizardPanel_contentData");
        String[] stringArray = null;
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = Utilities.createSteps(stringArray, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            JComponent jComponent = (JComponent)this.panels[i].getComponent();
            if (stringArray2[i] == null) {
                stringArray2[i] = jComponent.getName();
            }
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
    }

    private WizardDescriptor.Panel createPackageChooserPanel(TemplateWizard templateWizard, WizardDescriptor.Panel panel) {
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        SourceGroup[] sourceGroupArray = Util.getJavaSourceGroups(project);
        if (panel == null) {
            if (sourceGroupArray.length == 0) {
                Sources sources = ProjectUtils.getSources((Project)project);
                sourceGroupArray = sources.getSourceGroups("generic");
                return Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroupArray);
            }
            return JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroupArray);
        }
        if (sourceGroupArray.length == 0) {
            Sources sources = ProjectUtils.getSources((Project)project);
            sourceGroupArray = sources.getSourceGroups("generic");
            return Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroupArray, (WizardDescriptor.Panel)panel);
        }
        return JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroupArray, (WizardDescriptor.Panel)panel);
    }

    public Set<DataObject> instantiate() throws IOException {
        Object object;
        FileObject fileObject;
        Object object2;
        FileObject fileObject2;
        FileObject fileObject3 = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject3);
        FileObject fileObject4 = Templates.getTemplate((WizardDescriptor)this.wizard);
        if (FileType.FILTER.equals(this.fileType) && ((WrapperSelection)this.customPanel).isWrapper()) {
            fileObject4 = Templates.getTemplate((WizardDescriptor)this.wizard);
            fileObject2 = fileObject4.getParent();
            fileObject4 = fileObject2.getFileObject("AdvancedFilter", "java");
        }
        fileObject2 = new HashMap();
        fileObject2.put("servletEditorFold", NbBundle.getMessage(ServletIterator.class, (String)"MSG_ServletEditorFold"));
        this.initServletEmptyData();
        if (!this.deployData.makeEntry() && Utilities.isJavaEE6(this.wizard)) {
            if (this.fileType == FileType.SERVLET) {
                AnnotationGenerator.webServlet((ServletData)this.deployData, (Map<String, String>)fileObject2);
            }
            if (this.fileType == FileType.FILTER) {
                AnnotationGenerator.webFilter((ServletData)this.deployData, (Map<String, String>)fileObject2);
            }
        }
        DataObject dataObject = DataObject.find((FileObject)fileObject4);
        DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, Templates.getTargetName((WizardDescriptor)this.wizard), (Map)fileObject2);
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        ContainerClassPathModifier containerClassPathModifier = (ContainerClassPathModifier)project.getLookup().lookup(ContainerClassPathModifier.class);
        if (containerClassPathModifier != null) {
            containerClassPathModifier.extendClasspath(dataObject2.getPrimaryFile(), new String[]{"servlet-api"});
        }
        if (!this.deployData.makeEntry()) {
            return Collections.singleton(dataObject2);
        }
        if (!this.deployData.hasDD() && (object2 = WebModule.getWebModule((FileObject)project.getProjectDirectory())) != null && (fileObject = object2.getWebInf()) != null) {
            object = DDHelper.createWebXml((Profile)object2.getJ2eeProfile(), (FileObject)fileObject);
            this.deployData.setWebApp((FileObject)object);
        }
        if (this.deployData.getClassName().length() == 0) {
            object2 = this.wizard.getTargetName();
            fileObject = Templates.getTargetFolder((WizardDescriptor)this.wizard);
            object = null;
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
            for (int i = 0; i < sourceGroupArray.length && object == null; ++i) {
                if (WebModule.getWebModule((FileObject)sourceGroupArray[i].getRootFolder()) == null) continue;
                object = FileUtil.getRelativePath((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject);
            }
            object = object != null ? ((String)object).replace('/', '.') : "";
            this.deployData.setClassName((String)(((String)object).length() == 0 ? object2 : (String)object + "." + (String)object2));
            String string = ((ServletData)this.deployData).createDDServletName((String)object2);
            ((ServletData)this.deployData).createDDServletMapping(string);
        }
        this.deployData.createDDEntries();
        if (this.fileType == FileType.SERVLET && dataObject2.getPrimaryFile() != null) {
            dataObject2.getPrimaryFile().setAttribute("org.netbeans.modules.web.IsServletFile", (Object)Boolean.TRUE);
        }
        return Collections.singleton(dataObject2);
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wizard = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage(ServletIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1 && (this.deployData.hasDD() || Utilities.isJavaEE6(this.wizard));
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    private void initServletEmptyData() {
        if (this.fileType != FileType.SERVLET) {
            return;
        }
        if (!(this.deployData instanceof ServletData)) {
            return;
        }
        ServletData servletData = (ServletData)this.deployData;
        if (this.evaluator.getClassName() == null) {
            this.panels[1].readSettings((Object)this.wizard);
            servletData.createDDServletName(this.evaluator.getFileName());
            servletData.createDDServletMapping(servletData.getName());
        }
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }
}

