/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.loaders.JavaDataSupport;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Task;

public final class JspServletDataObject
extends MultiDataObject {
    public static final String EA_ORIGIN_JSP_PAGE = "NetBeansAttrOriginJspPage";

    public JspServletDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
    }

    public Node createNodeDelegate() {
        return JavaDataSupport.createJavaNode((FileObject)this.getPrimaryFile());
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    public String getName() {
        String string;
        DataObject dataObject = this.getSourceJspPage();
        if (dataObject == null) {
            return super.getName();
        }
        int n = this.getPrimaryFile().getName().lastIndexOf("_jsp");
        String string2 = string = n == -1 ? "" : this.getPrimaryFile().getName().substring(n + "_jsp".length());
        if (string.startsWith("_")) {
            string = string.substring(1);
        }
        if ("".equals(string)) {
            return NbBundle.getMessage(JspServletDataObject.class, (String)"LBL_ServletDisplayNameNoNumber", (Object)dataObject.getPrimaryFile().getName());
        }
        return NbBundle.getMessage(JspServletDataObject.class, (String)"LBL_ServletDisplayName", (Object[])new Object[]{string, dataObject.getPrimaryFile().getName()});
    }

    public void setSourceJspPage(DataObject dataObject) throws IOException {
        JspServletDataObject.setSourceJspPage(this.getPrimaryFile(), dataObject);
        this.firePropertyChange("cookie", null, null);
    }

    public static void setSourceJspPage(FileObject fileObject, DataObject dataObject) throws IOException {
        fileObject.setAttribute(EA_ORIGIN_JSP_PAGE, (Object)dataObject.getPrimaryFile());
    }

    public DataObject getSourceJspPage() {
        Object object = this.getPrimaryFile().getAttribute(EA_ORIGIN_JSP_PAGE);
        if (object instanceof DataObject) {
            return (DataObject)object;
        }
        if (object instanceof FileObject && ((FileObject)object).isValid()) {
            try {
                return DataObject.find((FileObject)((FileObject)object));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private static class ServletEditorCookie
    implements EditorCookie.Observable,
    PropertyChangeListener {
        private EditorCookie original;
        private JspServletDataObject servlet;
        private EditorCookie currentEditor;
        private PropertyChangeSupport pcs;

        public ServletEditorCookie(EditorCookie editorCookie, JspServletDataObject jspServletDataObject) {
            this.original = editorCookie;
            this.servlet = jspServletDataObject;
            this.pcs = new PropertyChangeSupport(this);
        }

        private EditorCookie currentEditorCookie() {
            EditorCookie editorCookie = this.computeCurrentEditorCookie();
            if (this.currentEditor != editorCookie) {
                if (this.currentEditor != null && this.currentEditor instanceof EditorCookie.Observable) {
                    ((EditorCookie.Observable)this.currentEditor).removePropertyChangeListener((PropertyChangeListener)this);
                }
                if (editorCookie != null && editorCookie instanceof EditorCookie.Observable) {
                    ((EditorCookie.Observable)editorCookie).addPropertyChangeListener((PropertyChangeListener)this);
                }
                this.currentEditor = editorCookie;
            }
            return this.currentEditor;
        }

        private EditorCookie computeCurrentEditorCookie() {
            EditorCookie editorCookie;
            DataObject dataObject = this.servlet.getSourceJspPage();
            if (dataObject != null && dataObject instanceof JspDataObject && ((JspDataObject)dataObject).getServletDataObject() == this.servlet && (editorCookie = ((JspDataObject)dataObject).getServletEditor()) != null) {
                return editorCookie;
            }
            return this.original;
        }

        public Line.Set getLineSet() {
            return this.currentEditorCookie().getLineSet();
        }

        public void open() {
            this.currentEditorCookie().open();
        }

        public boolean close() {
            return this.currentEditorCookie().close();
        }

        public Task prepareDocument() {
            return this.currentEditorCookie().prepareDocument();
        }

        public StyledDocument openDocument() throws IOException {
            return this.currentEditorCookie().openDocument();
        }

        public StyledDocument getDocument() {
            return this.currentEditorCookie().getDocument();
        }

        public void saveDocument() throws IOException {
            this.currentEditorCookie().saveDocument();
        }

        public boolean isModified() {
            return this.currentEditorCookie().isModified();
        }

        public JEditorPane[] getOpenedPanes() {
            return this.currentEditorCookie().getOpenedPanes();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.pcs.firePropertyChange(propertyChangeEvent);
        }
    }
}

