/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.analyzer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.analyzer.Analyzer;

public class AnalyzerPanel
extends JPanel {
    private static final Font LABEL_FONT = new Font("Dialog", 1, 16);
    private static final Color LABEL_COLOR = new Color(0x868686);
    private static final Color BORDER_COLOR = new Color(13355457);
    private static final Color GRADIENT_COLOR = new Color(0xD5D5D5);
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final Insets INSETS = new Insets(10, 10, 10, 10);

    public AnalyzerPanel(Analyzer analyzer, JComponent jComponent) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = EMPTY_INSETS;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 18;
        Image image = analyzer.getIcon();
        JLabel jLabel = new JLabel(analyzer.getDisplayName(), image != null ? new ImageIcon(image) : null, 0){

            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, Color.WHITE, 0.0f, this.getHeight(), GRADIENT_COLOR));
                graphics2D.fill(new Rectangle(this.getWidth(), this.getHeight()));
                super.paint(graphics);
            }

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width += 8;
                dimension.height += 8;
                return dimension;
            }
        };
        jLabel.setBorder(null);
        jLabel.setFont(LABEL_FONT);
        jLabel.setToolTipText(analyzer.getToolTip());
        jLabel.setBackground(null);
        jLabel.setForeground(LABEL_COLOR);
        jLabel.setOpaque(false);
        this.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(true);
        jPanel.setBackground(BORDER_COLOR);
        jPanel.setPreferredSize(new Dimension(0, 1));
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.insets = INSETS;
        this.add((Component)jComponent, gridBagConstraints);
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = graphics2D.getClip();
        graphics2D.clip(new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight(), 8.0f, 8.0f));
        super.paint(graphics);
        graphics2D.setClip(shape);
    }

    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(BORDER_COLOR);
        graphics2D.draw(new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth() - 1, this.getHeight() - 1, 8.0f, 8.0f));
    }
}

