/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.procfs.reader.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.util.DLightLogger;

final class ReusableByteBuffer {
    private static final Logger log = DLightLogger.getLogger(ReusableByteBuffer.class);
    private static final boolean TRACE = Boolean.getBoolean("TraceReusableByteBuffer");
    public final byte[] buffer;
    private final int size;
    private final int count;
    private final ConcurrentHashMap<Integer, Integer> marks;
    private final AtomicInteger idx = new AtomicInteger(0);

    public ReusableByteBuffer(int n, int n2) {
        if (n > 65535 && n2 > 65535) {
            throw new IllegalArgumentException();
        }
        this.size = n;
        this.count = n2;
        this.buffer = new byte[(0xFFFF & this.count) * (0xFFFF & this.size)];
        this.marks = new ConcurrentHashMap(this.count);
    }

    public int getAndLockOffset() {
        int n;
        Integer n2;
        do {
            if (this.marks.size() != this.count) continue;
            if (TRACE) {
                log.info("All chuncks are locked!");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((n2 = this.marks.get(n = (0xFFFF & this.idx.getAndIncrement() % this.count) * this.size)) != null || this.marks.putIfAbsent(n, n) != null);
        return n;
    }

    public void unlock(int n) {
        this.marks.remove(n);
    }
}

