/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.procfs.reader.api;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.procfs.api.LWPUsage;
import org.netbeans.modules.dlight.procfs.api.PStatus;
import org.netbeans.modules.dlight.procfs.api.PUsage;
import org.netbeans.modules.dlight.procfs.reader.api.ProcReader;
import org.netbeans.modules.dlight.procfs.reader.impl.DataModel;
import org.netbeans.modules.dlight.procfs.reader.impl.LocalProcReader;
import org.netbeans.modules.dlight.procfs.reader.impl.ProcReaderImpl;
import org.netbeans.modules.dlight.procfs.reader.impl.ProcessStatusProvider;
import org.netbeans.modules.dlight.procfs.reader.impl.ProcessStatusProvider64;
import org.netbeans.modules.dlight.procfs.reader.impl.ProcessUsageProvider;
import org.netbeans.modules.dlight.procfs.reader.impl.RemoteProcReader;
import org.netbeans.modules.dlight.procfs.reader.impl.ThreadsInfoProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;

public final class ProcReaderFactory {
    private ProcReaderFactory() {
    }

    public static ProcReader getReader(ExecutionEnvironment executionEnvironment, int n) {
        ProcReader procReader = null;
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment);
            ByteOrder byteOrder = hostInfo.getCpuFamily() == HostInfo.CpuFamily.SPARC ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
            DataModel dataModel = ProcReaderFactory.getDataModel(executionEnvironment, n);
            ProcessStatusProvider processStatusProvider = null;
            ProcessUsageProvider processUsageProvider = null;
            ThreadsInfoProvider threadsInfoProvider = null;
            ProcReaderImpl procReaderImpl = null;
            procReaderImpl = executionEnvironment.isLocal() ? new LocalProcReader(n, byteOrder, dataModel) : new RemoteProcReader(executionEnvironment, n, byteOrder, dataModel);
            processUsageProvider = procReaderImpl;
            threadsInfoProvider = procReaderImpl;
            processStatusProvider = dataModel == DataModel._LP64 ? new ProcessStatusProvider64(executionEnvironment, n) : (ProcessStatusProvider)procReaderImpl;
            final ProcessStatusProvider processStatusProvider2 = processStatusProvider;
            final ProcessUsageProvider processUsageProvider2 = processUsageProvider;
            final ThreadsInfoProvider threadsInfoProvider2 = threadsInfoProvider;
            procReader = new ProcReader(){

                @Override
                public PUsage getProcessUsage() throws IOException {
                    return processUsageProvider2.getProcessUsage();
                }

                @Override
                public List<LWPUsage> getThreadsInfo() throws IOException {
                    return threadsInfoProvider2.getThreadsInfo();
                }

                @Override
                public PStatus getProcessStatus() throws IOException {
                    return processStatusProvider2.getProcessStatus();
                }
            };
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return procReader;
    }

    private static DataModel getDataModel(ExecutionEnvironment executionEnvironment, int n) {
        DataModel dataModel;
        block4: {
            dataModel = DataModel._LP64;
            try {
                NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)executionEnvironment);
                nativeProcessBuilder.setExecutable("/bin/pflags").setArguments(new String[]{"" + n});
                NativeProcess nativeProcess = nativeProcessBuilder.call();
                List list = ProcessUtils.readProcessOutput((Process)nativeProcess);
                int n2 = nativeProcess.waitFor();
                Pattern pattern = Pattern.compile("[ \t]+data model = ([^ ]+).*");
                if (n2 != 0) break block4;
                for (String string : list) {
                    Matcher matcher = pattern.matcher(string);
                    if (!matcher.matches()) continue;
                    String string2 = matcher.group(1);
                    dataModel = DataModel.valueOf(string2);
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return dataModel;
    }
}

