/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.visualizers.api.ColumnsUIMapping;
import org.netbeans.spi.viewmodel.ColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeTableVisualizerColumnModel
extends ColumnModel {
    private final DataTableMetadata.Column column;
    private final ColumnsUIMapping columnsUIMapping;
    boolean isVisible = true;
    boolean isSorted = false;
    boolean isSortedDescending = false;
    int currentOrderNumber = -1;

    TreeTableVisualizerColumnModel(DataTableMetadata.Column column, ColumnsUIMapping columnsUIMapping) {
        this.column = column;
        this.columnsUIMapping = columnsUIMapping;
    }

    public String getID() {
        return this.column.getColumnName();
    }

    public String getDisplayName() {
        if (this.columnsUIMapping == null || this.columnsUIMapping.getDisplayedName(this.column.getColumnName()) == null) {
            return this.column.getColumnUName();
        }
        return this.columnsUIMapping.getDisplayedName(this.column.getColumnName());
    }

    public String getShortDescription() {
        if (this.columnsUIMapping == null || this.columnsUIMapping.getTooltip(this.column.getColumnName()) == null) {
            return this.column.getColumnLongUName();
        }
        return this.columnsUIMapping.getTooltip(this.column.getColumnName());
    }

    public Class<?> getType() {
        return this.column.getColumnClass();
    }

    public void setCurrentOrderNumber(int n) {
        this.currentOrderNumber = n;
    }

    public int getCurrentOrderNumber() {
        return this.currentOrderNumber;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isSortable() {
        return true;
    }

    public boolean isSorted() {
        return this.isSorted;
    }

    public void setSorted(boolean bl) {
        this.isSorted = bl;
    }

    public void setSortedDescending(boolean bl) {
        this.isSortedDescending = bl;
    }

    public boolean isSortedDescending() {
        return this.isSortedDescending;
    }
}

