/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.spi.impl.TableDataProvider;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.visualizers.DualPaneSupport;
import org.netbeans.modules.dlight.visualizers.FunctionsListSheetCell;
import org.netbeans.modules.dlight.visualizers.ImageLoader;
import org.netbeans.modules.dlight.visualizers.OnTimerRefreshVisualizerHandler;
import org.netbeans.modules.dlight.visualizers.OnTimerTask;
import org.netbeans.modules.dlight.visualizers.VisualizerTopComponentTopComponent;
import org.netbeans.modules.dlight.visualizers.api.AdvancedTableViewVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.impl.AdvancedTableViewVisualizerConfigurationAccessor;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.outline.Outline;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AdvancedTableViewVisualizer
extends JPanel
implements Visualizer<AdvancedTableViewVisualizerConfiguration>,
OnTimerTask,
ComponentListener,
ExplorerManager.Provider {
    private static final long MIN_REFRESH_MILLIS = 500L;
    private TableDataProvider provider;
    private AdvancedTableViewVisualizerConfiguration configuration;
    private final List<DataRow> data = new ArrayList<DataRow>();
    private JButton refresh;
    private OnTimerRefreshVisualizerHandler timerHandler;
    private boolean isEmptyContent;
    private boolean isShown = true;
    private final OutlineView outlineView;
    private final String nodeColumnName;
    private final String nodeRowColumnID;
    private final ExplorerManager explorerManager;
    private Future<Boolean> task;
    private final Object queryLock = new Object();
    private final Object uiLock = new Object();
    private final String iconColumnID;
    private String resourceID;
    private final boolean dualPaneMode;
    private final DualPaneSupport<DataRow> dualPaneSupport;
    private Map<Integer, Boolean> ascColumnValues = new HashMap<Integer, Boolean>();
    private static final boolean isMacLaf = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static final Color macBackground = UIManager.getColor("NbExplorerView.background");

    AdvancedTableViewVisualizer(TableDataProvider tableDataProvider, AdvancedTableViewVisualizerConfiguration advancedTableViewVisualizerConfiguration) {
        super(new BorderLayout());
        this.provider = tableDataProvider;
        this.configuration = advancedTableViewVisualizerConfiguration;
        this.explorerManager = new ExplorerManager();
        this.addComponentListener(this);
        AdvancedTableViewVisualizerConfigurationAccessor advancedTableViewVisualizerConfigurationAccessor = AdvancedTableViewVisualizerConfigurationAccessor.getDefault();
        this.nodeColumnName = advancedTableViewVisualizerConfigurationAccessor.getNodeColumnName(advancedTableViewVisualizerConfiguration);
        this.nodeRowColumnID = advancedTableViewVisualizerConfigurationAccessor.getRowNodeColumnName(advancedTableViewVisualizerConfiguration);
        this.outlineView = new OutlineView(advancedTableViewVisualizerConfiguration.getMetadata().getColumnByName(this.nodeColumnName).getColumnUName());
        this.outlineView.getOutline().setRootVisible(false);
        this.iconColumnID = advancedTableViewVisualizerConfigurationAccessor.getIconColumnID(advancedTableViewVisualizerConfiguration);
        if (this.iconColumnID == null || advancedTableViewVisualizerConfiguration.getMetadata().getColumnByName(this.iconColumnID) == null) {
            this.outlineView.getOutline().setDefaultRenderer(Object.class, (TableCellRenderer)new ExtendedTableCellRendererForNode());
        }
        this.resourceID = this.iconColumnID == null ? null : advancedTableViewVisualizerConfigurationAccessor.getIconPath(advancedTableViewVisualizerConfiguration);
        List<String> list = advancedTableViewVisualizerConfigurationAccessor.getHiddenColumnNames(advancedTableViewVisualizerConfiguration);
        ArrayList<1> arrayList = new ArrayList<1>();
        ArrayList<DataTableMetadata.Column> arrayList2 = new ArrayList<DataTableMetadata.Column>();
        for (String string : advancedTableViewVisualizerConfiguration.getMetadata().getColumnNames()) {
            if (this.nodeColumnName.equals(string) || this.nodeRowColumnID.equals(string) || list.contains(string)) continue;
            DataTableMetadata.Column column = advancedTableViewVisualizerConfiguration.getMetadata().getColumnByName(string);
            arrayList2.add(column);
            PropertySupport propertySupport = new PropertySupport(column.getColumnName(), column.getColumnClass(), column.getColumnUName(), column.getColumnUName(), true, false){

                public Object getValue() throws IllegalAccessException, InvocationTargetException {
                    return null;
                }

                public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                }
            };
            arrayList.add(propertySupport);
        }
        this.outlineView.getOutline().setDefaultRenderer(Node.Property.class, (TableCellRenderer)new FunctionsListSheetCell.OutlineSheetCell(this.outlineView.getOutline(), arrayList2));
        this.outlineView.setProperties(arrayList.toArray(new Node.Property[0]));
        this.outlineView.setPopupAllowed(false);
        this.outlineView.setDragSource(false);
        this.outlineView.setDropTarget(false);
        this.outlineView.setAllowedDragActions(0);
        this.outlineView.setAllowedDropActions(0);
        final Outline outline = this.outlineView.getOutline();
        outline.getTableHeader().setReorderingAllowed(false);
        outline.setRootVisible(false);
        int n = arrayList2.size() + 1;
        int n2 = 49;
        for (int i = 1; i <= n; ++i) {
            final int n3 = i - 1;
            KeyStroke keyStroke = KeyStroke.getKeyStroke(n2++, 8, true);
            this.outlineView.getInputMap(1).put(keyStroke, "ascSortFor" + i);
            this.outlineView.getActionMap().put("ascSortFor" + i, new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = n3;
                    ETableColumnModel eTableColumnModel = null;
                    if (outline.getColumnModel() instanceof ETableColumnModel) {
                        eTableColumnModel = (ETableColumnModel)outline.getColumnModel();
                        eTableColumnModel.clearSortedColumns();
                    }
                    boolean bl = !AdvancedTableViewVisualizer.this.ascColumnValues.containsKey(n) ? true : (Boolean)AdvancedTableViewVisualizer.this.ascColumnValues.get(n);
                    outline.setColumnSorted(n, bl, 1);
                    AdvancedTableViewVisualizer.this.ascColumnValues.put(n, !bl);
                    outline.getTableHeader().resizeAndRepaint();
                }
            });
        }
        outline.getSelectionModel().setSelectionMode(0);
        this.outlineView.setProperties(arrayList.toArray(new Node.Property[0]));
        VisualizerTopComponentTopComponent.findInstance().addComponentListener(this);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, true);
        this.outlineView.getOutline().getInputMap(1).put(keyStroke, "return");
        this.outlineView.getOutline().getActionMap().put("return", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedTableViewVisualizer.this.refresh.requestFocus(false);
            }
        });
        this.dualPaneMode = advancedTableViewVisualizerConfigurationAccessor.isDualPaneMode(advancedTableViewVisualizerConfiguration);
        this.dualPaneSupport = this.dualPaneMode ? DualPaneSupport.forExplorerManager(this, this.explorerManager, advancedTableViewVisualizerConfigurationAccessor.getDetailsRenderer(advancedTableViewVisualizerConfiguration), new DualPaneSupport.DataAdapter<Node, DataRow>(){

            @Override
            public DataRow convert(Node node) {
                if (node instanceof DataRowNode) {
                    return ((DataRowNode)node).getDataRow();
                }
                return null;
            }
        }) : null;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    @Override
    public void requestFocus() {
        if (this.refresh != null) {
            this.refresh.requestFocus();
        } else {
            this.outlineView.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.refresh != null) {
            return this.refresh.requestFocusInWindow();
        }
        return this.outlineView.requestFocusInWindow();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addComponentListener(this);
        VisualizerTopComponentTopComponent.findInstance().addComponentListener(this);
        this.asyncFillModel();
        if (this.timerHandler != null && this.timerHandler.isSessionRunning()) {
            this.timerHandler.startTimer();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        super.removeNotify();
        Object object = this.queryLock;
        synchronized (object) {
            if (this.task != null) {
                this.task.cancel(true);
            }
        }
        if (this.timerHandler != null) {
            this.timerHandler.stopTimer();
        }
        this.removeComponentListener(this);
        VisualizerTopComponentTopComponent.findInstance().removeComponentListener(this);
    }

    private void setEmptyContent() {
        this.isEmptyContent = true;
        this.removeAll();
        JLabel jLabel = new JLabel(this.timerHandler != null && this.timerHandler.isSessionAnalyzed() ? AdvancedTableViewVisualizerConfigurationAccessor.getDefault().getEmptyAnalyzeMessage(this.configuration) : AdvancedTableViewVisualizerConfigurationAccessor.getDefault().getEmptyRunningMessage(this.configuration), 0);
        this.add((Component)jLabel, "Center");
        this.add((Component)this.createToolbar(), "West");
        this.repaint();
        this.revalidate();
    }

    private void setLoadingContent() {
        this.isEmptyContent = false;
        this.removeAll();
        JLabel jLabel = new JLabel(AdvancedTableViewVisualizer.getMessage("Loading"), 0);
        this.add((Component)jLabel, "Center");
        this.repaint();
        this.revalidate();
    }

    private void setContent(boolean bl) {
        if (this.isEmptyContent && bl) {
            return;
        }
        if (this.isEmptyContent && !bl) {
            this.setNonEmptyContent();
            return;
        }
        if (!this.isEmptyContent && bl) {
            this.setEmptyContent();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateList(List<DataRow> list) {
        Object object = this.uiLock;
        synchronized (object) {
            this.setNonEmptyContent();
            this.explorerManager.setRootContext((Node)new AbstractNode((Children)new DataChildren(list)));
        }
    }

    private void setNonEmptyContent() {
        this.isEmptyContent = false;
        this.removeAll();
        this.add((Component)this.createToolbar(), "West");
        this.add((Component)this.outlineView, "Center");
        this.repaint();
        this.validate();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.outlineView);
        arrayList.add(this.refresh);
        this.refresh.requestFocus();
    }

    private JToolBar createToolbar() {
        JToolBar jToolBar = new JToolBar();
        if (isMacLaf) {
            jToolBar.setBackground(macBackground);
        }
        jToolBar.setFloatable(false);
        jToolBar.setOrientation(1);
        jToolBar.setRollover(true);
        this.refresh = new JButton();
        this.refresh.setIcon(ImageLoader.loadIcon("refresh.png"));
        this.refresh.setToolTipText(AdvancedTableViewVisualizer.getMessage("Refresh.Tooltip"));
        this.refresh.setHorizontalTextPosition(0);
        this.refresh.setVerticalTextPosition(3);
        this.refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedTableViewVisualizer.this.asyncFillModel();
            }
        });
        jToolBar.add(this.refresh);
        return jToolBar;
    }

    public VisualizerContainer getDefaultContainer() {
        return VisualizerTopComponentTopComponent.findInstance();
    }

    @Override
    public int onTimer() {
        if (!this.isShown || !this.isShowing()) {
            return 0;
        }
        return 0;
    }

    public void refresh() {
        this.asyncFillModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncFillModel() {
        Object object = this.queryLock;
        synchronized (object) {
            if (this.task != null) {
                this.task.cancel(true);
            }
            UIThread.invoke((Runnable)new Runnable(){

                public void run() {
                    AdvancedTableViewVisualizer.this.setLoadingContent();
                }
            });
            this.task = DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AdvancedTableViewVisualizer.this.syncFillModel(true);
                    return Boolean.FALSE;
                }
            }, (String)("AdvancedTableViewVisualizer Async data load for " + this.configuration.getID()));
        }
    }

    private void syncFillModel(boolean bl) {
        long l = System.currentTimeMillis();
        Future future = DLightExecutorService.submit((Callable)new Callable<List<DataRow>>(){

            @Override
            public List<DataRow> call() throws Exception {
                return AdvancedTableViewVisualizer.this.provider.queryData(AdvancedTableViewVisualizer.this.configuration.getMetadata());
            }
        }, (String)("AdvancedTableViewVisualizer Async data from provider  load for " + this.configuration.getID()));
        try {
            final List list = (List)future.get();
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (bl && l3 < 500L) {
                Thread.sleep(500L - l3);
            }
            final boolean bl2 = list == null || list.isEmpty();
            UIThread.invoke((Runnable)new Runnable(){

                public void run() {
                    AdvancedTableViewVisualizer.this.setContent(bl2);
                    if (bl2) {
                        return;
                    }
                    AdvancedTableViewVisualizer.this.updateList(list);
                }
            });
        }
        catch (ExecutionException executionException) {
            Thread.currentThread().interrupt();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public AdvancedTableViewVisualizerConfiguration getVisualizerConfiguration() {
        return this.configuration;
    }

    public JComponent getComponent() {
        return this.dualPaneMode ? this.dualPaneSupport : this;
    }

    @Override
    public void timerStopped() {
        if (this.isEmptyContent) {
            this.setEmptyContent();
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this.isShown) {
            return;
        }
        this.isShown = this.isShowing();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.isShown = false;
    }

    public void updateVisualizerConfiguration(AdvancedTableViewVisualizerConfiguration advancedTableViewVisualizerConfiguration) {
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(AdvancedTableViewVisualizer.class, (String)string);
    }

    private class ExtendedTableCellRendererForNode
    extends DefaultTableCellRenderer {
        private ExtendedTableCellRendererForNode() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 != 0) {
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(AdvancedTableViewVisualizer.this.configuration.getMetadata().getColumnByName(AdvancedTableViewVisualizer.this.nodeColumnName).getColumnClass());
            if (propertyEditor != null && object != null && !(object + "").trim().equals("")) {
                propertyEditor.setValue(object);
                return super.getTableCellRendererComponent(jTable, propertyEditor.getAsText(), bl, bl2, n, n2);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private class DataRowNode
    extends AbstractNode {
        private final DataRow dataRow;
        private Node.PropertySet propertySet;

        DataRowNode(DataRow dataRow) {
            super(Children.LEAF);
            this.dataRow = dataRow;
            this.propertySet = new Node.PropertySet(){

                public Node.Property<?>[] getProperties() {
                    ArrayList<1> arrayList = new ArrayList<1>();
                    for (String string : DataRowNode.this.dataRow.getColumnNames()) {
                        if (string.equals(AdvancedTableViewVisualizer.this.nodeColumnName) || string.equals(AdvancedTableViewVisualizer.this.nodeRowColumnID)) continue;
                        final DataTableMetadata.Column column = AdvancedTableViewVisualizer.this.configuration.getMetadata().getColumnByName(string);
                        PropertySupport propertySupport = new PropertySupport(string, column.getColumnClass(), column.getColumnUName(), column.getColumnUName(), true, false){

                            public Object getValue() throws IllegalAccessException, InvocationTargetException {
                                return DataRowNode.this.dataRow.getData(column.getColumnName());
                            }

                            public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                            }
                        };
                        arrayList.add(propertySupport);
                    }
                    return arrayList.toArray(new Node.Property[0]);
                }
            };
        }

        public DataRow getDataRow() {
            return this.dataRow;
        }

        public Image getIcon(int n) {
            if (AdvancedTableViewVisualizer.this.iconColumnID == null) {
                return super.getIcon(n);
            }
            return ImageUtilities.loadImage((String)(AdvancedTableViewVisualizer.this.resourceID + "/" + this.dataRow.getStringValue(AdvancedTableViewVisualizer.this.iconColumnID) + ".png"));
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public String getDisplayName() {
            return this.dataRow.getData(AdvancedTableViewVisualizer.this.nodeColumnName) + "";
        }

        public Node.PropertySet[] getPropertySets() {
            return new Node.PropertySet[]{this.propertySet};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DataChildren
    extends Children.Keys<DataRow> {
        private final List<DataRow> list;

        public DataChildren(List<DataRow> list) {
            this.list = list;
        }

        protected Node[] createNodes(DataRow dataRow) {
            return new Node[]{new DataRowNode(dataRow)};
        }

        protected void addNotify() {
            this.setKeys(this.list);
        }
    }
}

