/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.sharability;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation2;
import org.netbeans.spi.project.libraries.LibraryStorageArea;
import org.openide.util.NbCollections;

class ServerVolumeContentModel
extends AbstractListModel {
    private LibraryImplementation impl;
    private LibraryImplementation2 impl2;
    private LibraryStorageArea area;
    private String volumeType;
    private List<Object> content;

    public ServerVolumeContentModel(LibraryImplementation libraryImplementation, LibraryStorageArea libraryStorageArea, String string) {
        this.impl = libraryImplementation;
        this.area = libraryStorageArea;
        this.volumeType = string;
        if (libraryImplementation instanceof LibraryImplementation2) {
            this.impl2 = (LibraryImplementation2)libraryImplementation;
        }
        if (this.impl2 != null) {
            List list = this.impl2.getURIContent(string);
            if (list != null) {
                this.content = new ArrayList<Object>(list);
            }
        } else {
            List list = this.impl.getContent(string);
            if (list != null) {
                this.content = new ArrayList<Object>(list);
            }
        }
        if (this.content == null) {
            this.content = new ArrayList<Object>();
        }
    }

    public LibraryStorageArea getArea() {
        return this.area;
    }

    public int getSize() {
        return this.content.size();
    }

    public Object getElementAt(int n) {
        if (n < 0 || n >= this.content.size()) {
            throw new IllegalArgumentException();
        }
        return this.content.get(n);
    }

    public void addResource(URL uRL) {
        assert (this.impl2 == null);
        this.content.add(uRL);
        int n = this.content.size() - 1;
        this.propagateContent();
        this.fireIntervalAdded(this, n, n);
    }

    public void addResource(URI uRI) {
        assert (this.impl2 != null);
        this.content.add(uRI);
        int n = this.content.size() - 1;
        this.propagateContent();
        this.fireIntervalAdded(this, n, n);
    }

    private void propagateContent() {
        if (this.impl2 != null) {
            this.impl2.setURIContent(this.volumeType, NbCollections.checkedListByCopy(this.content, URI.class, (boolean)true));
        } else {
            this.impl.setContent(this.volumeType, NbCollections.checkedListByCopy(this.content, URL.class, (boolean)true));
        }
    }

    public void removeResources(int[] nArray) {
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.content.remove(nArray[i]);
        }
        this.propagateContent();
        this.fireIntervalRemoved(this, nArray[0], nArray[nArray.length - 1]);
    }

    public void moveUp(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            Object object = this.content.remove(nArray[i]);
            this.content.add(nArray[i] - 1, object);
        }
        this.propagateContent();
        this.fireContentsChanged(this, nArray[0] - 1, nArray[nArray.length - 1]);
    }

    public void moveDown(int[] nArray) {
        for (int i = nArray.length - 1; i >= 0; --i) {
            Object object = this.content.remove(nArray[i]);
            this.content.add(nArray[i] + 1, object);
        }
        this.propagateContent();
        this.fireContentsChanged(this, nArray[0], nArray[nArray.length - 1] + 1);
    }
}

