/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.deployment.config.J2eeModuleAccessor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceCreationException;
import org.netbeans.modules.j2ee.deployment.plugins.spi.OptionalDeploymentManagerFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.ServerInitializationException;
import org.netbeans.modules.j2ee.deployment.profiler.spi.Profiler;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerRegistry
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(ServerRegistry.class.getName());
    public static final String DIR_INSTALLED_SERVERS = "/J2EE/InstalledServers";
    public static final String DIR_JSR88_PLUGINS = "/J2EE/DeploymentPlugins";
    public static final String URL_ATTR = "url";
    public static final String USERNAME_ATTR = "username";
    public static final String PASSWORD_ATTR = "password";
    public static final String TARGETNAME_ATTR = "targetName";
    public static final String SERVER_NAME = "serverName";
    private static ServerRegistry instance = null;
    private transient Map<String, Server> servers = null;
    private transient Map instances = null;
    private transient Collection pluginListeners = new HashSet();
    private transient Collection instanceListeners = new ArrayList();
    private transient InstanceListener[] instanceListenersArray;
    private transient PluginInstallListener pluginL;
    private transient InstanceInstallListener instanceL;
    private static HashMap configNamesByType = null;
    private static final J2eeModule.Type[] allTypes = new J2eeModule.Type[]{J2eeModule.Type.EAR, J2eeModule.Type.RAR, J2eeModule.Type.CAR, J2eeModule.Type.EJB, J2eeModule.Type.WAR};

    public static synchronized ServerRegistry getInstance() {
        if (instance == null) {
            instance = new ServerRegistry();
        }
        return instance;
    }

    public static synchronized boolean wasInitialized() {
        return instance != null && ServerRegistry.instance.servers != null && ServerRegistry.instance.instances != null;
    }

    private ServerRegistry() {
    }

    private synchronized void init() {
        LOGGER.log(Level.FINEST, "Entering registry initialization");
        if (this.servers != null && this.instances != null) {
            return;
        }
        this.servers = new HashMap<String, Server>();
        this.instances = new HashMap();
        FileObject fileObject = FileUtil.getConfigFile((String)DIR_JSR88_PLUGINS);
        if (fileObject != null) {
            int n;
            LOGGER.log(Level.FINE, "Loading server plugins");
            this.pluginL = new PluginInstallListener(fileObject);
            fileObject.addFileChangeListener((FileChangeListener)this.pluginL);
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (n = 0; n < fileObjectArray.length; ++n) {
                this.addPlugin(fileObjectArray[n]);
            }
            LOGGER.log(Level.FINE, "Loading server instances");
            fileObject = FileUtil.getConfigFile((String)DIR_INSTALLED_SERVERS);
            this.instanceL = new InstanceInstallListener(fileObject);
            fileObject.addFileChangeListener((FileChangeListener)this.instanceL);
            fileObjectArray = fileObject.getChildren();
            for (n = 0; n < fileObjectArray.length; ++n) {
                this.addInstance(fileObjectArray[n]);
            }
            LOGGER.log(Level.FINE, "Finish initializing plugins");
            LinkedList<String> linkedList = new LinkedList<String>();
            for (Map.Entry<String, Server> entry : this.serversMap().entrySet()) {
                OptionalDeploymentManagerFactory optionalDeploymentManagerFactory = entry.getValue().getOptionalFactory();
                if (null == optionalDeploymentManagerFactory) continue;
                try {
                    optionalDeploymentManagerFactory.finishServerInitialization();
                }
                catch (ServerInitializationException serverInitializationException) {
                    LOGGER.log(Level.INFO, "Server plugin not initialized", serverInitializationException);
                    linkedList.add(entry.getKey());
                }
                catch (RuntimeException runtimeException) {
                    LOGGER.log(Level.WARNING, "Plugin implementation BUG -- Unexpected Exception from finishServerInitialization", runtimeException);
                    linkedList.add(entry.getKey());
                }
            }
            this.serversMap().keySet().removeAll(linkedList);
        } else {
            LOGGER.log(Level.WARNING, "No DIR_JSR88_PLUGINS folder found, no server plugins will be availabe");
        }
    }

    private Map<String, Server> serversMap() {
        this.init();
        return this.servers;
    }

    private synchronized Map instancesMap() {
        this.init();
        return this.instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPlugin(FileObject fileObject) {
        block7: {
            String string = "";
            try {
                if (!fileObject.isFolder()) break block7;
                string = fileObject.getName();
                Server server = null;
                ServerRegistry serverRegistry = this;
                synchronized (serverRegistry) {
                    if (this.serversMap().containsKey(string)) {
                        return;
                    }
                    server = new Server(fileObject);
                    this.serversMap().put(string, server);
                }
                if (server != null) {
                    this.firePluginListeners(server, true);
                    this.fetchInstances(server);
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.INFO, null, exception);
            }
        }
    }

    private void fetchInstances(Server server) {
        FileObject fileObject = FileUtil.getConfigFile((String)DIR_INSTALLED_SERVERS);
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            String string = (String)fileObjectArray[i].getAttribute(URL_ATTR);
            if (string == null || !server.handlesUri(string)) continue;
            this.addInstance(fileObjectArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePlugin(FileObject fileObject) {
        Server server = null;
        ServerRegistry serverRegistry = this;
        synchronized (serverRegistry) {
            String string = fileObject.getName();
            server = this.serversMap().get(string);
            if (server != null) {
                ServerInstance[] serverInstanceArray = this.getServerInstances();
                for (int i = 0; i < serverInstanceArray.length; ++i) {
                    ServerInstance serverInstance = serverInstanceArray[i];
                    if (!server.equals(serverInstance.getServer())) continue;
                    this.removeServerInstance(serverInstance.getUrl());
                }
            }
            this.serversMap().remove(string);
        }
        if (server != null) {
            this.firePluginListeners(server, false);
        }
    }

    public Collection<Server> getServers() {
        return this.serversMap().values();
    }

    public synchronized Collection getInstances() {
        return new ArrayList(this.instancesMap().values());
    }

    public synchronized String[] getInstanceURLs() {
        return this.instancesMap().keySet().toArray(new String[this.instancesMap().size()]);
    }

    public void checkInstanceAlreadyExists(String string) throws InstanceCreationException {
        if (this.getServerInstance(string) != null) {
            String string2 = NbBundle.getMessage(ServerRegistry.class, (String)"MSG_InstanceAlreadyExists", (Object)string);
            throw new InstanceCreationException(string2);
        }
    }

    public void checkInstanceExists(String string) {
        if (this.getServerInstance(string) == null) {
            String string2 = NbBundle.getMessage(ServerRegistry.class, (String)"MSG_InstanceNotExists", (Object)string);
            throw new IllegalArgumentException(string2);
        }
    }

    public Server getServer(String string) {
        return this.serversMap().get(string);
    }

    public void addPluginListener(PluginListener pluginListener) {
        this.pluginListeners.add(pluginListener);
    }

    public synchronized ServerInstance getServerInstance(String string) {
        return (ServerInstance)this.instancesMap().get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServerInstance(String string) {
        if (string == null) {
            return;
        }
        ServerInstance serverInstance = null;
        ServerRegistry serverRegistry = this;
        synchronized (serverRegistry) {
            serverInstance = (ServerInstance)this.instancesMap().remove(string);
        }
        if (serverInstance != null) {
            this.fireInstanceListeners(string, false);
            this.removeInstanceFromFile(string);
        }
    }

    public synchronized ServerInstance[] getServerInstances() {
        ServerInstance[] serverInstanceArray = new ServerInstance[this.instancesMap().size()];
        this.instancesMap().values().toArray(serverInstanceArray);
        return serverInstanceArray;
    }

    public static FileObject getInstanceFileObject(String string) {
        FileObject fileObject = FileUtil.getConfigFile((String)DIR_INSTALLED_SERVERS);
        if (fileObject == null) {
            return null;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            String string2 = (String)fileObjectArray[i].getAttribute(URL_ATTR);
            if (string2 == null || !string2.equals(string)) continue;
            return fileObjectArray[i];
        }
        return null;
    }

    public void addInstance(String string, String string2, String string3, String string4, boolean bl, Map<String, String> map) throws InstanceCreationException {
        if (string == null || string.equals("")) {
            LOGGER.log(Level.INFO, NbBundle.getMessage(ServerRegistry.class, (String)"MSG_EmptyUrl"));
            return;
        }
        this.checkInstanceAlreadyExists(string);
        try {
            this.addInstanceImpl(string, string2, string3, string4, bl, map, true);
        }
        catch (InstanceCreationException instanceCreationException) {
            InstanceCreationException instanceCreationException2 = new InstanceCreationException(NbBundle.getMessage(ServerRegistry.class, (String)"MSG_FailedToCreateInstance", (Object)string4));
            instanceCreationException2.initCause(instanceCreationException);
            throw instanceCreationException2;
        }
    }

    private synchronized void writeInstanceToFile(String string, String string2, String string3) throws IOException {
        if (string == null) {
            Logger.getLogger("global").log(Level.SEVERE, NbBundle.getMessage(ServerRegistry.class, (String)"MSG_NullUrl"));
            return;
        }
        FileObject fileObject = FileUtil.getConfigFile((String)DIR_INSTALLED_SERVERS);
        FileObject[] fileObjectArray = fileObject.getChildren();
        FileObject fileObject2 = null;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!string.equals(fileObjectArray[i].getAttribute(URL_ATTR))) continue;
            fileObject2 = fileObjectArray[i];
        }
        String string4 = FileUtil.findFreeFileName((FileObject)fileObject, (String)"instance", null);
        if (fileObject2 == null) {
            fileObject2 = fileObject.createData(string4);
        }
        fileObject2.setAttribute(URL_ATTR, (Object)string);
        fileObject2.setAttribute(USERNAME_ATTR, (Object)string2);
        fileObject2.setAttribute(PASSWORD_ATTR, (Object)string3);
    }

    private synchronized void removeInstanceFromFile(String string) {
        FileObject fileObject = ServerRegistry.getInstanceFileObject(string);
        if (fileObject == null) {
            return;
        }
        try {
            fileObject.delete();
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstanceImpl(String string, String string2, String string3, String string4, boolean bl, Map<String, String> map, boolean bl2) throws InstanceCreationException {
        ServerRegistry serverRegistry = this;
        synchronized (serverRegistry) {
            if (this.instancesMap().containsKey(string)) {
                throw new InstanceCreationException("already exists");
            }
            LOGGER.log(Level.FINE, "Registering instance {0}", string);
            FileObject[] fileObjectArray = this.cleanInitialProperties(map);
            Collection<Server> collection = this.serversMap().values();
            for (Server server : collection) {
                try {
                    if (!server.handlesUri(string)) continue;
                    ServerInstance serverInstance = new ServerInstance(server, string);
                    this.instancesMap().put(string, serverInstance);
                    this.writeInstanceToFile(string, string2, string3);
                    serverInstance.getInstanceProperties().setProperty("registeredWithoutUI", Boolean.toString(bl));
                    if (string4 != null) {
                        serverInstance.getInstanceProperties().setProperty("displayName", string4);
                    }
                    for (Map.Entry entry : fileObjectArray.entrySet()) {
                        serverInstance.getInstanceProperties().setProperty((String)entry.getKey(), (String)entry.getValue());
                    }
                    DeploymentManager deploymentManager = server.getDisconnectedDeploymentManager(string);
                    if (deploymentManager != null) {
                        this.fireInstanceListeners(string, true);
                        return;
                    }
                    this.removeInstanceFromFile(string);
                    this.instancesMap().remove(string);
                }
                catch (Exception exception) {
                    if (this.instancesMap().containsKey(string)) {
                        this.removeInstanceFromFile(string);
                        this.instancesMap().remove(string);
                    }
                    LOGGER.log(Level.INFO, null, exception);
                }
            }
        }
        if (bl2) {
            serverRegistry = FileUtil.getConfigFile((String)DIR_JSR88_PLUGINS);
            if (serverRegistry != null) {
                for (FileObject fileObject : serverRegistry.getChildren()) {
                    this.addPlugin(fileObject);
                }
            }
            this.addInstanceImpl(string, string2, string3, string4, bl, map, false);
            return;
        }
        throw new InstanceCreationException("No handlers for " + string);
    }

    private Map<String, String> cleanInitialProperties(Map<String, String> map) {
        if (map == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        hashMap.remove(URL_ATTR);
        hashMap.remove(USERNAME_ATTR);
        hashMap.remove(PASSWORD_ATTR);
        hashMap.remove("displayName");
        hashMap.remove("registeredWithoutUI");
        return hashMap;
    }

    public void addInstance(FileObject fileObject) {
        String string = (String)fileObject.getAttribute(URL_ATTR);
        String string2 = (String)fileObject.getAttribute(USERNAME_ATTR);
        String string3 = (String)fileObject.getAttribute(PASSWORD_ATTR);
        String string4 = (String)fileObject.getAttribute("displayName");
        String string5 = (String)fileObject.getAttribute("registeredWithoutUI");
        boolean bl = string5 == null ? false : Boolean.valueOf(string5);
        try {
            this.addInstanceImpl(string, string2, string3, string4, bl, null, false);
        }
        catch (InstanceCreationException instanceCreationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getInstances(InstanceListener instanceListener) {
        if (instanceListener != null) {
            Collection collection = this.instanceListeners;
            synchronized (collection) {
                this.instanceListenersArray = null;
                this.instanceListeners.add(instanceListener);
            }
        }
        return this.getInstances();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceListener(InstanceListener instanceListener) {
        Collection collection = this.instanceListeners;
        synchronized (collection) {
            this.instanceListenersArray = null;
            this.instanceListeners.add(instanceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceListener(InstanceListener instanceListener) {
        Collection collection = this.instanceListeners;
        synchronized (collection) {
            this.instanceListenersArray = null;
            this.instanceListeners.remove(instanceListener);
        }
    }

    public synchronized void removePluginListener(PluginListener pluginListener) {
        this.pluginListeners.remove(pluginListener);
    }

    private void firePluginListeners(Server server, boolean bl) {
        LOGGER.log(Level.FINE, "Firing plugin listener");
        for (PluginListener pluginListener : this.pluginListeners) {
            if (bl) {
                pluginListener.serverAdded(server);
                continue;
            }
            pluginListener.serverRemoved(server);
        }
        configNamesByType = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstanceListener[] getInstanceListeners() {
        InstanceListener[] instanceListenerArray = null;
        Collection collection = this.instanceListeners;
        synchronized (collection) {
            instanceListenerArray = this.instanceListenersArray;
            if (instanceListenerArray == null) {
                instanceListenerArray = this.instanceListeners.toArray(new InstanceListener[this.instanceListeners.size()]);
                this.instanceListenersArray = instanceListenerArray;
            }
        }
        return instanceListenerArray;
    }

    private void fireInstanceListeners(String string, boolean bl) {
        InstanceListener[] instanceListenerArray = this.getInstanceListeners();
        for (int i = 0; i < instanceListenerArray.length; ++i) {
            if (bl) {
                instanceListenerArray[i].instanceAdded(string);
                continue;
            }
            instanceListenerArray[i].instanceRemoved(string);
        }
    }

    private void initConfigNamesByType() {
        if (configNamesByType != null) {
            return;
        }
        configNamesByType = new HashMap();
        for (int i = 0; i < allTypes.length; ++i) {
            HashSet<String> hashSet = new HashSet<String>();
            for (Server server : this.servers.values()) {
                String[] stringArray = server.getDeploymentPlanFiles(allTypes[i]);
                if (stringArray == null) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    File file = new File(stringArray[j]);
                    hashSet.add(file.getName());
                }
            }
            configNamesByType.put(allTypes[i], hashSet);
        }
    }

    public boolean isConfigFileName(String string, J2eeModule.Type type) {
        this.initConfigNamesByType();
        ModuleType moduleType = J2eeModuleAccessor.getDefault().getJsrModuleType(type);
        Set set = (Set)configNamesByType.get(moduleType);
        return set != null && set.contains(string);
    }

    public static Profiler getProfiler() {
        return (Profiler)Lookup.getDefault().lookup(Profiler.class);
    }

    public static interface PluginListener
    extends EventListener {
        public void serverAdded(Server var1);

        public void serverRemoved(Server var1);
    }

    class InstanceInstallListener
    extends FileChangeAdapter {
        private final FileObject dir;

        private InstanceInstallListener(FileObject fileObject) {
            this.dir = fileObject;
        }

        public void fileDataCreated(FileEvent fileEvent) {
            super.fileDataCreated(fileEvent);
            ServerRegistry.this.addInstance(fileEvent.getFile());
        }
    }

    class PluginInstallListener
    extends FileChangeAdapter {
        private final FileObject dir;

        private PluginInstallListener(FileObject fileObject) {
            this.dir = fileObject;
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            super.fileFolderCreated(fileEvent);
            ServerRegistry.this.addPlugin(fileEvent.getFile());
        }

        public void fileDeleted(FileEvent fileEvent) {
            super.fileDeleted(fileEvent);
            ServerRegistry.this.removePlugin(fileEvent.getFile());
        }
    }
}

