/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.api.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.impl.common.DDUtils;
import org.netbeans.modules.j2ee.dd.impl.web.WebAppProxy;
import org.netbeans.modules.j2ee.dd.impl.web.WebParseUtils;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DDProvider {
    private static DDProvider ddProvider;
    private final Map ddMap = new HashMap(5);
    private final Map baseBeanMap = new HashMap(5);
    private final Map errorMap = new HashMap(5);
    private final FCA fileChangeListener = new FCA();
    private static final Logger LOGGER;

    private DDProvider() {
    }

    public static synchronized DDProvider getDefault() {
        if (ddProvider == null) {
            ddProvider = new DDProvider();
        }
        return ddProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebApp getDDRoot(FileObject fileObject) throws IOException {
        Object object;
        Object object2;
        Parameters.notNull((CharSequence)"fo", (Object)fileObject);
        WebAppProxy webAppProxy = null;
        Object object3 = this.ddMap;
        synchronized (object3) {
            webAppProxy = this.getFromCache(fileObject);
            if (webAppProxy != null) {
                return webAppProxy;
            }
        }
        fileObject.addFileChangeListener((FileChangeListener)this.fileChangeListener);
        object3 = null;
        SAXParseException sAXParseException = null;
        try {
            object2 = null;
            object = this.baseBeanMap;
            synchronized (object) {
                object2 = this.getOriginalFromCache(fileObject);
                if (object2 == null) {
                    object3 = WebParseUtils.getVersion(fileObject.getInputStream());
                    if (object3 != null) {
                        sAXParseException = this.parse(fileObject);
                        object2 = DDUtils.createWebApp(fileObject.getInputStream(), (String)object3);
                        this.baseBeanMap.put(fileObject.getURL(), new WeakReference<Object>(object2));
                        this.errorMap.put(fileObject.getURL(), sAXParseException);
                    }
                } else {
                    object3 = object2.getVersion();
                    sAXParseException = (SAXParseException)this.errorMap.get(fileObject.getURL());
                }
            }
            if (object3 != null) {
                webAppProxy = new WebAppProxy((WebApp)object2, (String)object3);
                if (sAXParseException != null) {
                    webAppProxy.setStatus(1);
                    webAppProxy.setError(sAXParseException);
                }
            } else {
                webAppProxy = new WebAppProxy(null, null);
                webAppProxy.setStatus(2);
                webAppProxy.setError(new SAXParseException(NbBundle.getMessage(DDProvider.class, (String)"MSG_cannotDetermineVersion"), null));
            }
        }
        catch (SAXException sAXException) {
            webAppProxy = new WebAppProxy(null, (String)object3);
            webAppProxy.setStatus(2);
            if (sAXException instanceof SAXParseException) {
                webAppProxy.setError((SAXParseException)sAXException);
            } else if (sAXException.getException() instanceof SAXParseException) {
                webAppProxy.setError((SAXParseException)sAXException.getException());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.log(Level.INFO, "A file referenced from [" + FileUtil.getFileDisplayName((FileObject)fileObject) + "] could not be found", fileNotFoundException);
            webAppProxy = new WebAppProxy(null, (String)object3);
            webAppProxy.setStatus(2);
            webAppProxy.setError(new SAXParseException(fileNotFoundException.getMessage(), null, fileNotFoundException));
        }
        object2 = this.ddMap;
        synchronized (object2) {
            object = this.getFromCache(fileObject);
            if (object != null) {
                return object;
            }
            this.ddMap.put(fileObject.getURL(), new WeakReference<WebAppProxy>(webAppProxy));
        }
        return webAppProxy;
    }

    public WebApp getDDRoot(FileObject fileObject, boolean bl) throws IOException {
        if (!bl) {
            this.removeFromCache(fileObject);
        }
        return this.getDDRoot(fileObject);
    }

    public WebApp getDDRootCopy(FileObject fileObject) throws IOException {
        return (WebApp)this.getDDRoot(fileObject).clone();
    }

    private WebAppProxy getFromCache(FileObject fileObject) throws IOException {
        WeakReference weakReference = (WeakReference)this.ddMap.get(fileObject.getURL());
        if (weakReference == null) {
            return null;
        }
        WebAppProxy webAppProxy = (WebAppProxy)weakReference.get();
        if (webAppProxy == null) {
            this.ddMap.remove(fileObject.getURL());
        }
        return webAppProxy;
    }

    private WebApp getOriginalFromCache(FileObject fileObject) throws IOException {
        WeakReference weakReference = (WeakReference)this.baseBeanMap.get(fileObject.getURL());
        if (weakReference == null) {
            return null;
        }
        WebApp webApp = (WebApp)weakReference.get();
        if (webApp == null) {
            this.baseBeanMap.remove(fileObject.getURL());
            this.errorMap.remove(fileObject.getURL());
        }
        return webApp;
    }

    public WebApp getDDRoot(File file) throws IOException, SAXException {
        return DDUtils.createWebApp(new FileInputStream(file), WebParseUtils.getVersion(new FileInputStream(file)));
    }

    public BaseBean getBaseBean(CommonDDBean commonDDBean) {
        if (commonDDBean instanceof BaseBean) {
            return (BaseBean)commonDDBean;
        }
        if (commonDDBean instanceof WebAppProxy) {
            return (BaseBean)((WebAppProxy)commonDDBean).getOriginal();
        }
        return null;
    }

    public SAXParseException parse(FileObject fileObject) throws SAXException, IOException {
        return WebParseUtils.parse(fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromCache(FileObject fileObject) {
        try {
            URL uRL = fileObject.getURL();
            Map map = this.ddMap;
            synchronized (map) {
                this.ddMap.remove(uRL);
            }
            this.baseBeanMap.remove(uRL);
            this.errorMap.remove(uRL);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
    }

    static {
        LOGGER = Logger.getLogger(DDProvider.class.getName());
    }

    private class FCA
    extends FileChangeAdapter {
        private FCA() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileChanged(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            try {
                if (DataObject.find((FileObject)fileObject) != null) {
                    return;
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOGGER.log(Level.INFO, null, dataObjectNotFoundException);
            }
            try {
                Map map = DDProvider.this.ddMap;
                synchronized (map) {
                    Map map2 = DDProvider.this.baseBeanMap;
                    synchronized (map2) {
                        WebAppProxy webAppProxy = DDProvider.this.getFromCache(fileObject);
                        WebApp webApp = DDProvider.this.getOriginalFromCache(fileObject);
                        if (webAppProxy != null) {
                            String string = null;
                            try {
                                string = WebParseUtils.getVersion(fileObject.getInputStream());
                                SAXParseException sAXParseException = DDProvider.this.parse(fileObject);
                                if (sAXParseException != null) {
                                    webAppProxy.setError(sAXParseException);
                                    webAppProxy.setStatus(1);
                                } else {
                                    webAppProxy.setError(null);
                                    webAppProxy.setStatus(0);
                                }
                                WebApp webApp2 = DDUtils.createWebApp(fileObject.getInputStream(), string);
                                DDProvider.this.baseBeanMap.put(fileObject.getURL(), new WeakReference<WebApp>(webApp2));
                                DDProvider.this.errorMap.put(fileObject.getURL(), webAppProxy.getError());
                                webAppProxy.merge(webApp2, 3);
                            }
                            catch (SAXException sAXException) {
                                if (sAXException instanceof SAXParseException) {
                                    webAppProxy.setError((SAXParseException)sAXException);
                                } else if (sAXException.getException() instanceof SAXParseException) {
                                    webAppProxy.setError((SAXParseException)sAXException.getException());
                                }
                                webAppProxy.setStatus(2);
                                webAppProxy.setOriginal(null);
                                webAppProxy.setProxyVersion(string);
                            }
                        } else if (webApp != null) {
                            String string = null;
                            try {
                                string = WebParseUtils.getVersion(fileObject.getInputStream());
                                WebApp webApp3 = DDUtils.createWebApp(fileObject.getInputStream(), string);
                                if (webApp3.getClass().equals(webApp.getClass())) {
                                    webApp.merge(webApp3, 3);
                                } else {
                                    DDProvider.this.baseBeanMap.put(fileObject.getURL(), new WeakReference<WebApp>(webApp3));
                                }
                            }
                            catch (SAXException sAXException) {
                                DDProvider.this.baseBeanMap.remove(fileObject.getURL());
                            }
                        }
                    }
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, "Merging of webApp graphs failed.", iOException);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            DDProvider.this.removeFromCache(fileEvent.getFile());
        }
    }
}

