/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.kenai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonChangeListener;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonManager;
import org.netbeans.modules.hudson.api.UI;
import org.netbeans.modules.hudson.kenai.BuildHandleImpl;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.spi.BuildAccessor;
import org.netbeans.modules.kenai.ui.spi.BuildHandle;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildAccessorImpl
extends BuildAccessor {
    private static final Logger LOG = Logger.getLogger(BuildAccessorImpl.class.getName());
    private final Map<ProjectHandle, HudsonChangeListener> listeners = new WeakHashMap<ProjectHandle, HudsonChangeListener>();

    private static Collection<HudsonInstance> findServers(ProjectHandle projectHandle) {
        ArrayList<HudsonInstance> arrayList = new ArrayList<HudsonInstance>();
        String string = projectHandle.getId();
        try {
            KenaiProject kenaiProject = Kenai.getDefault().getProject(string);
            if (kenaiProject != null) {
                for (KenaiFeature kenaiFeature : kenaiProject.getFeatures(KenaiService.Type.HUDSON)) {
                    String string2 = kenaiFeature.getWebLocation().toString();
                    arrayList.add(HudsonManager.addInstance((String)string, (String)string2, (int)5, (boolean)false));
                }
            }
        }
        catch (KenaiException kenaiException) {
            LOG.log(Level.FINE, "Could not find project " + string, kenaiException);
        }
        return arrayList;
    }

    public boolean isEnabled(ProjectHandle projectHandle) {
        String string = projectHandle.getId();
        try {
            KenaiProject kenaiProject = Kenai.getDefault().getProject(string);
            if (kenaiProject != null) {
                return kenaiProject.getFeatures(KenaiService.Type.HUDSON).length > 0;
            }
        }
        catch (KenaiException kenaiException) {
            LOG.log(Level.FINE, "Could not find project " + string, kenaiException);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BuildHandle> getBuilds(final ProjectHandle projectHandle) {
        HudsonChangeListener hudsonChangeListener;
        Object object = this.listeners;
        synchronized (object) {
            if (this.listeners.containsKey(projectHandle)) {
                hudsonChangeListener = null;
            } else {
                hudsonChangeListener = new HudsonChangeListener(){

                    private void change() {
                        projectHandle.firePropertyChange("buildList", null, null);
                    }

                    public void stateChanged() {
                        this.change();
                    }

                    public void contentChanged() {
                        this.change();
                    }
                };
                this.listeners.put(projectHandle, hudsonChangeListener);
            }
        }
        object = new ArrayList();
        for (HudsonInstance hudsonInstance : BuildAccessorImpl.findServers(projectHandle)) {
            if (hudsonChangeListener != null) {
                hudsonInstance.addHudsonChangeListener((HudsonChangeListener)WeakListeners.create(HudsonChangeListener.class, (EventListener)hudsonChangeListener, (Object)hudsonInstance));
            }
            for (HudsonJob hudsonJob : hudsonInstance.getJobs()) {
                object.add(new BuildHandleImpl(hudsonJob));
            }
        }
        return object;
    }

    public Action getNewBuildAction(ProjectHandle projectHandle) {
        Collection<HudsonInstance> collection = BuildAccessorImpl.findServers(projectHandle);
        if (collection.isEmpty()) {
            return null;
        }
        return UI.createJobAction((HudsonInstance)collection.iterator().next());
    }
}

