/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.remote.ui.wizard.CreateHostData;
import org.netbeans.modules.cnd.remote.ui.wizard.HostValidatorImpl;
import org.netbeans.modules.cnd.spi.remote.setup.support.TextComponentWriter;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.PasswordManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CreateHostVisualPanel2
extends JPanel {
    private final ChangeListener wizardListener;
    private final CreateHostData data;
    private ProgressHandle phandle;
    private ExecutionEnvironment hostFound = null;
    private Runnable runOnFinish = null;
    private JCheckBox cbSavePassword;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JPanel pbarStatusPanel;
    private JTextField textLoginName;
    private JPasswordField textPassword;
    private JTextPane tpOutput;

    public CreateHostVisualPanel2(CreateHostData createHostData, ChangeListener changeListener) {
        Object object;
        this.data = createHostData;
        this.wizardListener = changeListener;
        this.initComponents();
        this.textLoginName.setText(System.getProperty("user.name"));
        if (Boolean.getBoolean("cnd.remote.keep.pwd")) {
            char[] cArray;
            object = CreateHostData.getLastExecutionEnvironment();
            if (object != null && (cArray = PasswordManager.getInstance().get(object)) != null) {
                this.textPassword.setText(new String(cArray));
            }
        } else {
            this.textPassword.setText("");
        }
        object = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                CreateHostVisualPanel2.this.fireChange();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                CreateHostVisualPanel2.this.fireChange();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                CreateHostVisualPanel2.this.fireChange();
            }
        };
        this.textLoginName.getDocument().addDocumentListener((DocumentListener)object);
        this.textPassword.getDocument().addDocumentListener((DocumentListener)object);
    }

    private void fireChange() {
        this.hostFound = null;
        this.wizardListener.stateChanged(null);
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(this.getClass(), (String)"CreateHostVisualPanel2.Title");
    }

    void init() {
    }

    private String getLoginName() {
        return this.textLoginName.getText();
    }

    char[] getPassword() {
        return this.textPassword.getPassword();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.textLoginName = new JTextField();
        this.jLabel2 = new JLabel();
        this.textPassword = new JPasswordField();
        this.cbSavePassword = new JCheckBox();
        this.pbarStatusPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tpOutput = new JTextPane();
        this.jLabel3 = new JLabel();
        this.setPreferredSize(new Dimension(534, 409));
        this.setRequestFocusEnabled(false);
        this.jLabel1.setLabelFor(this.textLoginName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CreateHostVisualPanel2.class, (String)"CreateHostVisualPanel2.jLabel1.text"));
        this.textLoginName.setText(NbBundle.getMessage(CreateHostVisualPanel2.class, (String)"CreateHostVisualPanel2.textLoginName.text"));
        this.jLabel2.setLabelFor(this.textPassword);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CreateHostVisualPanel2.class, (String)"CreateHostVisualPanel2.jLabel2.text"));
        this.textPassword.setText(NbBundle.getMessage(CreateHostVisualPanel2.class, (String)"CreateHostVisualPanel2.textPassword.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbSavePassword, (String)NbBundle.getMessage(CreateHostVisualPanel2.class, (String)"CreateHostVisualPanel2.cbSavePassword.text"));
        this.pbarStatusPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 10));
        this.pbarStatusPanel.setMinimumSize(new Dimension(100, 10));
        this.pbarStatusPanel.setLayout(new BorderLayout());
        this.tpOutput.setEditable(false);
        this.tpOutput.setText(NbBundle.getMessage(CreateHostVisualPanel2.class, (String)"CreateHostVisualPanel2.tpOutput.text"));
        this.tpOutput.setOpaque(false);
        this.jScrollPane1.setViewportView(this.tpOutput);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(CreateHostVisualPanel2.class, (String)"CreateHostVisualPanel2.jLabel3.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel3, -1, 534, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.cbSavePassword).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel1)).add(24, 24, 24).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.textPassword).add((Component)this.textLoginName, -2, 204, -2)).add(207, 207, 207)).add((Component)this.jScrollPane1, -1, 534, Short.MAX_VALUE).add((Component)this.pbarStatusPanel, -1, 534, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.textLoginName, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.textPassword, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((Component)this.cbSavePassword).addPreferredGap(1).add((Component)this.jScrollPane1, -2, 242, -2).addPreferredGap(0).add((Component)this.pbarStatusPanel, -2, 11, -2).addContainerGap(52, Short.MAX_VALUE)));
    }

    ExecutionEnvironment getHost() {
        return this.hostFound;
    }

    Runnable getRunOnFinish() {
        return this.runOnFinish;
    }

    public void enableControls(boolean bl) {
        this.textPassword.setEnabled(bl);
        this.textLoginName.setEnabled(bl);
        this.cbSavePassword.setEnabled(bl);
    }

    public boolean canValidateHost() {
        return true;
    }

    public Future<Boolean> validateHost() {
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                char[] cArray = CreateHostVisualPanel2.this.getPassword();
                boolean bl = CreateHostVisualPanel2.this.cbSavePassword.isSelected();
                ExecutionEnvironment executionEnvironment = ExecutionEnvironmentFactory.createNew((String)CreateHostVisualPanel2.this.getLoginName(), (String)CreateHostVisualPanel2.this.data.getHostName(), (int)CreateHostVisualPanel2.this.data.getPort());
                CreateHostVisualPanel2.this.tpOutput.setText("");
                CreateHostVisualPanel2.this.phandle = ProgressHandleFactory.createHandle((String)"");
                CreateHostVisualPanel2.this.pbarStatusPanel.removeAll();
                CreateHostVisualPanel2.this.pbarStatusPanel.add((Component)ProgressHandleFactory.createProgressComponent((ProgressHandle)CreateHostVisualPanel2.this.phandle), "Center");
                CreateHostVisualPanel2.this.pbarStatusPanel.validate();
                CreateHostVisualPanel2.this.phandle.start();
                try {
                    HostValidatorImpl hostValidatorImpl = new HostValidatorImpl(CreateHostVisualPanel2.this.data.getCacheManager());
                    if (hostValidatorImpl.validate(executionEnvironment, cArray, bl, new TextComponentWriter(CreateHostVisualPanel2.this.tpOutput))) {
                        CreateHostVisualPanel2.this.hostFound = executionEnvironment;
                        CreateHostVisualPanel2.this.runOnFinish = hostValidatorImpl.getRunOnFinish();
                        try {
                            Thread.sleep(1500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    CreateHostVisualPanel2.this.phandle.finish();
                    CreateHostVisualPanel2.this.wizardListener.stateChanged(null);
                    CreateHostVisualPanel2.this.pbarStatusPanel.setVisible(false);
                }
                return true;
            }
        });
        RequestProcessor.getDefault().post(futureTask);
        return futureTask;
    }
}

