/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.remote.support.RemoteProjectSupport;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.remote.ServerListImplementation;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServerList
implements ServerListImplementation {
    private static final String CND_REMOTE = "cnd.remote";
    private static final String REMOTE_SERVERS = "cnd.remote.servers";
    private static final char SERVER_RECORD_SEPARATOR = '|';
    private static final String SERVER_LIST_SEPARATOR = ",";
    private static final String DEFAULT_INDEX = "cnd.remote.default";
    private int defaultIndex;
    private final PropertyChangeSupport pcs;
    private final ChangeSupport cs;
    private final ArrayList<RemoteServerRecord> unlisted;
    private final ArrayList<RemoteServerRecord> items = new ArrayList();
    private static final Comparator<RemoteServerRecord> RECORDS_COMPARATOR = new Comparator<RemoteServerRecord>(){

        @Override
        public int compare(RemoteServerRecord remoteServerRecord, RemoteServerRecord remoteServerRecord2) {
            boolean bl;
            if (remoteServerRecord == remoteServerRecord2) {
                return 0;
            }
            boolean bl2 = remoteServerRecord.getExecutionEnvironment().isLocal();
            if (bl2 != (bl = remoteServerRecord2.getExecutionEnvironment().isLocal())) {
                if (bl2) {
                    return -1;
                }
                if (bl) {
                    return 1;
                }
            }
            return remoteServerRecord.getServerName().compareTo(remoteServerRecord2.getServerName());
        }
    };

    public RemoteServerList() {
        String string = RemoteServerList.getPreferences().get(REMOTE_SERVERS, null);
        this.defaultIndex = RemoteServerList.getPreferences().getInt(DEFAULT_INDEX, 0);
        this.pcs = new PropertyChangeSupport(this);
        this.cs = new ChangeSupport((Object)this);
        this.unlisted = new ArrayList();
        this.addServer(ExecutionEnvironmentFactory.getLocal(), null, RemoteSyncFactory.getDefault(), false, RemoteServerRecord.State.ONLINE);
        if (string != null) {
            for (String string2 : string.split(SERVER_LIST_SEPARATOR)) {
                Object object;
                String string3 = null;
                RemoteSyncFactory remoteSyncFactory = RemoteSyncFactory.getDefault();
                String[] stringArray = string2.split("\\|");
                CndUtils.assertTrue((stringArray.length > 0 ? 1 : 0) != 0);
                String string4 = stringArray[0];
                if (stringArray.length > 1) {
                    string3 = stringArray[1];
                }
                ExecutionEnvironment executionEnvironment = ExecutionEnvironmentFactory.fromUniqueID((String)string4);
                if (stringArray.length > 2 && (remoteSyncFactory = RemoteSyncFactory.fromID((String)(object = stringArray[2]))) == null) {
                    remoteSyncFactory = RemoteSyncFactory.getDefault();
                    RemoteUtil.LOGGER.warning("Unsupported synchronization mode \"" + (String)object + "\" for " + executionEnvironment.toString() + ". Switching to default one.");
                }
                if (!executionEnvironment.isRemote()) continue;
                object = this.addServer(executionEnvironment, string3, remoteSyncFactory, false, RemoteServerRecord.State.OFFLINE);
                if (stringArray.length <= 3) continue;
                ((RemoteServerRecord)object).setX11Forwarding(Boolean.parseBoolean(stringArray[3]));
            }
        }
        this.defaultIndex = Math.min(this.defaultIndex, this.items.size() - 1);
        this.refresh();
    }

    public synchronized ServerRecord get(ExecutionEnvironment executionEnvironment) {
        for (RemoteServerRecord remoteServerRecord : this.items) {
            if (!executionEnvironment.equals(remoteServerRecord.getExecutionEnvironment())) continue;
            return remoteServerRecord;
        }
        for (RemoteServerRecord remoteServerRecord : this.unlisted) {
            if (!executionEnvironment.equals(remoteServerRecord.getExecutionEnvironment())) continue;
            return remoteServerRecord;
        }
        RemoteServerRecord remoteServerRecord = new RemoteServerRecord(executionEnvironment, null, RemoteSyncFactory.getDefault(), false);
        this.unlisted.add(remoteServerRecord);
        return remoteServerRecord;
    }

    public ServerRecord get(Project project) {
        ExecutionEnvironment executionEnvironment = RemoteProjectSupport.getExecutionEnvironment(project);
        if (executionEnvironment != null) {
            return this.get(executionEnvironment);
        }
        return null;
    }

    public synchronized ServerRecord getDefaultRecord() {
        return this.items.get(this.defaultIndex);
    }

    private synchronized void setDefaultIndexImpl(int n) {
        this.defaultIndex = n;
        RemoteServerList.getPreferences().putInt(DEFAULT_INDEX, n);
    }

    public void setDefaultRecord(ServerRecord serverRecord) {
        assert (serverRecord != null);
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).equals(serverRecord)) continue;
            this.setDefaultIndexImpl(i);
            return;
        }
        CndUtils.assertTrue((boolean)false, (String)"Can not set nonexistent record as default");
    }

    public synchronized List<ExecutionEnvironment> getEnvironments() {
        ArrayList<ExecutionEnvironment> arrayList = new ArrayList<ExecutionEnvironment>(this.items.size());
        for (RemoteServerRecord remoteServerRecord : this.items) {
            arrayList.add(remoteServerRecord.getExecutionEnvironment());
        }
        return arrayList;
    }

    private RemoteServerRecord addServer(ExecutionEnvironment executionEnvironment, String string, RemoteSyncFactory remoteSyncFactory, boolean bl, RemoteServerRecord.State state) {
        RemoteServerRecord remoteServerRecord = (RemoteServerRecord)this.addServer(executionEnvironment, string, remoteSyncFactory, bl, false);
        remoteServerRecord.setState(state);
        return remoteServerRecord;
    }

    public synchronized ServerRecord addServer(ExecutionEnvironment executionEnvironment, String string, RemoteSyncFactory remoteSyncFactory, boolean bl, boolean bl2) {
        RemoteServerRecord remoteServerRecord = null;
        if (remoteSyncFactory == null) {
            remoteSyncFactory = RemoteSyncFactory.getDefault();
        }
        for (RemoteServerRecord remoteServerRecord2 : this.items) {
            if (!remoteServerRecord2.getExecutionEnvironment().equals(executionEnvironment)) continue;
            if (bl) {
                this.defaultIndex = this.items.indexOf(remoteServerRecord2);
                RemoteServerList.getPreferences().putInt(DEFAULT_INDEX, this.defaultIndex);
            }
            return remoteServerRecord2;
        }
        for (RemoteServerRecord remoteServerRecord2 : this.unlisted) {
            if (!remoteServerRecord2.getExecutionEnvironment().equals(executionEnvironment)) continue;
            remoteServerRecord = remoteServerRecord2;
            break;
        }
        if (remoteServerRecord == null) {
            remoteServerRecord = new RemoteServerRecord(executionEnvironment, string, remoteSyncFactory, bl2);
        } else {
            remoteServerRecord.setDeleted(false);
            remoteServerRecord.setDisplayName(string);
            remoteServerRecord.setSyncFactory(remoteSyncFactory);
            this.unlisted.remove(remoteServerRecord);
        }
        this.items.add(remoteServerRecord);
        Collections.sort(this.items, RECORDS_COMPARATOR);
        if (bl) {
            this.defaultIndex = this.items.indexOf(remoteServerRecord);
        }
        this.refresh();
        RemoteServerList.storePreferences(remoteServerRecord);
        RemoteServerList.getPreferences().putInt(DEFAULT_INDEX, this.defaultIndex);
        return remoteServerRecord;
    }

    public static void storePreferences(RemoteServerRecord remoteServerRecord) {
        String string = remoteServerRecord.getRawDisplayName();
        String string2 = RemoteServerList.getPreferences().get(REMOTE_SERVERS, null);
        String string3 = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)remoteServerRecord.getExecutionEnvironment());
        String string4 = string3 + '|' + (string == null ? "" : string) + '|' + remoteServerRecord.getSyncFactory().getID() + '|' + remoteServerRecord.getX11Forwarding();
        if (string2 == null) {
            RemoteServerList.getPreferences().put(REMOTE_SERVERS, string4);
        } else {
            StringBuilder stringBuilder = new StringBuilder(string4);
            for (String string5 : string2.split(SERVER_LIST_SEPARATOR)) {
                String string6;
                int n = string5.indexOf(124);
                String string7 = string6 = n > 0 ? string5.substring(0, n) : string5;
                if (string6.equals(string3)) continue;
                stringBuilder.append(SERVER_LIST_SEPARATOR);
                stringBuilder.append(string5);
            }
            RemoteServerList.getPreferences().put(REMOTE_SERVERS, stringBuilder.toString());
        }
    }

    public synchronized void set(List<ServerRecord> list, ServerRecord serverRecord) {
        RemoteUtil.LOGGER.finest("ServerList: set " + list);
        Collection<ExecutionEnvironment> collection = this.clear();
        for (ServerRecord serverRecord2 : list) {
            this.addServer(serverRecord2.getExecutionEnvironment(), serverRecord2.getDisplayName(), serverRecord2.getSyncFactory(), false, false);
            collection.remove(serverRecord2.getExecutionEnvironment());
        }
        this.setDefaultRecord(serverRecord);
    }

    private Collection<ExecutionEnvironment> clear() {
        ArrayList<ExecutionEnvironment> arrayList = new ArrayList<ExecutionEnvironment>();
        for (RemoteServerRecord remoteServerRecord : this.items) {
            remoteServerRecord.setDeleted(true);
            arrayList.add(remoteServerRecord.getExecutionEnvironment());
        }
        RemoteServerList.getPreferences().remove(REMOTE_SERVERS);
        this.unlisted.addAll(this.items);
        this.items.clear();
        return arrayList;
    }

    private void removeFromPreferences(ServerRecord serverRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        for (RemoteServerRecord remoteServerRecord : this.items) {
            if (serverRecord.equals(remoteServerRecord)) continue;
            stringBuilder.append(remoteServerRecord.getDisplayName());
            stringBuilder.append(',');
        }
        RemoteServerList.getPreferences().put(REMOTE_SERVERS, stringBuilder.toString());
    }

    protected void refresh() {
        this.cs.fireChange();
    }

    public synchronized RemoteServerRecord getLocalhostRecord() {
        return this.items.get(0);
    }

    public boolean isValidExecutable(ExecutionEnvironment executionEnvironment, String string) {
        int n;
        if (string == null || string.length() == 0) {
            return false;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            RemoteUtil.LOGGER.warning("RemoteServerList.isValidExecutable from EDT");
        }
        if ((n = RemoteCommandSupport.run(executionEnvironment, "test", "-x", string)) != 0 && !IpeUtils.isPathAbsolute((String)string)) {
            n = RemoteCommandSupport.run(executionEnvironment, "test", "-x", "`which " + string + "`");
        }
        return n == 0;
    }

    public synchronized Collection<? extends ServerRecord> getRecords() {
        return new ArrayList<RemoteServerRecord>(this.items);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object) {
        this.pcs.firePropertyChange(string, null, object);
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(RemoteServerList.class);
    }

    public ServerRecord createServerRecord(ExecutionEnvironment executionEnvironment, String string, RemoteSyncFactory remoteSyncFactory) {
        return new RemoteServerRecord(executionEnvironment, string, remoteSyncFactory, false);
    }
}

