/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.fs.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.remote.fs.ui.NotifierPanel;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RemoteFileSystemNotifier {
    private final ExecutionEnvironment env;
    private final Callback callback;
    private boolean shown;
    private Notification notification;

    public RemoteFileSystemNotifier(ExecutionEnvironment executionEnvironment, Callback callback) {
        this.env = executionEnvironment;
        this.callback = callback;
        this.shown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showIfNeed() {
        RemoteFileSystemNotifier remoteFileSystemNotifier = this;
        synchronized (remoteFileSystemNotifier) {
            if (this.shown) {
                return;
            }
            this.shown = true;
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            Listener listener = new Listener();
            connectionManager.addConnectionListener((ConnectionListener)listener);
            this.show();
        }
    }

    public static String getDisplayName(ExecutionEnvironment executionEnvironment) {
        ServerRecord serverRecord = ServerList.get((ExecutionEnvironment)executionEnvironment);
        if (serverRecord == null) {
            return executionEnvironment.getDisplayName();
        }
        return serverRecord.getDisplayName();
    }

    private void show() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteFileSystemNotifier.this.showConnectDialog();
            }
        };
        String string = RemoteFileSystemNotifier.getDisplayName(this.env);
        this.notification = NotificationDisplayer.getDefault().notify(NbBundle.getMessage(RemoteFileSystemNotifier.class, (String)"RemoteFileSystemNotifier.TITLE", (Object)string), (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/remote/fs/ui/error.gif", (boolean)false), NbBundle.getMessage(RemoteFileSystemNotifier.class, (String)"RemoteFileSystemNotifier.DETAILS", (Object)string), actionListener, NotificationDisplayer.Priority.HIGH);
    }

    private void showConnectDialog() {
        final NotifierPanel notifierPanel = new NotifierPanel(this.env);
        notifierPanel.setPendingFiles(this.callback.getPendingFiles());
        String string = RemoteFileSystemNotifier.getDisplayName(this.env);
        String string2 = NbBundle.getMessage(RemoteFileSystemNotifier.class, (String)"RemoteFileSystemNotifier.TITLE", (Object)string);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)notifierPanel, string2, true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            RequestProcessor.getDefault().post((Runnable)new NamedRunnable("Requesting connection for " + this.env.getDisplayName()){

                protected void runImpl() {
                    RemoteFileSystemNotifier.this.connect(notifierPanel.getPassword(), notifierPanel.isRememberPassword());
                }
            });
        } else {
            this.reShow();
        }
    }

    private void connect(char[] cArray, boolean bl) {
        boolean bl2 = false;
        try {
            if (cArray == null || cArray.length == 0) {
                ConnectionManager.getInstance().connectTo(this.env);
            } else {
                ConnectionManager.getInstance().connectTo(this.env, cArray, bl);
            }
            bl2 = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        if (!bl2) {
            this.reShow();
        }
    }

    private void reShow() {
        this.shown = false;
        this.show();
    }

    private class Listener
    implements ConnectionListener {
        private Listener() {
        }

        public void connected(ExecutionEnvironment executionEnvironment) {
            if (RemoteFileSystemNotifier.this.env.equals(executionEnvironment)) {
                ConnectionManager.getInstance().removeConnectionListener((ConnectionListener)this);
                RequestProcessor.getDefault().post((Runnable)new NamedRunnable("Pending files synchronizer for " + executionEnvironment.getDisplayName()){

                    protected void runImpl() {
                        RemoteFileSystemNotifier.this.notification.clear();
                        RemoteFileSystemNotifier.this.callback.connected();
                    }
                });
            }
        }

        public void disconnected(ExecutionEnvironment executionEnvironment) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Callback {
        public void connected();

        public List<String> getPendingFiles();
    }
}

