/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.services;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.navigation.services.IncludedModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IncludedModelImpl
implements IncludedModel {
    private Map<CsmFile, Set<CsmFile>> map;
    private Action[] actions;
    private Action close;
    private boolean direction;

    public IncludedModelImpl(CsmFile csmFile, Action[] actionArray, boolean bl, boolean bl2, boolean bl3) {
        Set<CsmFile> set;
        this.actions = actionArray;
        this.direction = bl;
        this.map = bl ? this.buildWhoIncludes(csmFile) : this.buildWhoIsIncluded(csmFile);
        if (!bl3) {
            set = this.map.get(csmFile);
            if (set == null) {
                set = new HashSet<CsmFile>();
            }
            this.map = new HashMap<CsmFile, Set<CsmFile>>();
            this.map.put(csmFile, set);
        }
        if (bl2) {
            set = new HashSet<CsmFile>();
            this.gatherList(csmFile, set, this.map);
            this.map = new HashMap<CsmFile, Set<CsmFile>>();
            this.map.put(csmFile, set);
        }
    }

    private void gatherList(CsmFile csmFile, Set<CsmFile> set, Map<CsmFile, Set<CsmFile>> map) {
        Set<CsmFile> set2 = map.get(csmFile);
        if (set2 == null) {
            return;
        }
        for (CsmFile csmFile2 : set2) {
            if (set.contains(csmFile2)) continue;
            set.add(csmFile2);
            this.gatherList(csmFile2, set, map);
        }
    }

    @Override
    public Map<CsmFile, Set<CsmFile>> getModel() {
        return this.map;
    }

    @Override
    public boolean isDownDirection() {
        return !this.direction;
    }

    private Map<CsmFile, Set<CsmFile>> buildWhoIncludes(CsmFile csmFile) {
        HashMap<CsmFile, Set<CsmFile>> hashMap = new HashMap<CsmFile, Set<CsmFile>>();
        for (CsmProject csmProject : CsmModelAccessor.getModel().projects()) {
            for (CsmFile csmFile2 : csmProject.getSourceFiles()) {
                this.buildWhoIncludes(csmFile2, hashMap);
            }
            for (CsmFile csmFile2 : csmProject.getHeaderFiles()) {
                this.buildWhoIncludes(csmFile2, hashMap);
            }
            for (CsmFile csmFile2 : csmProject.getLibraries()) {
                for (CsmFile csmFile3 : csmFile2.getSourceFiles()) {
                    this.buildWhoIncludes(csmFile3, hashMap);
                }
                for (CsmFile csmFile3 : csmFile2.getHeaderFiles()) {
                    this.buildWhoIncludes(csmFile3, hashMap);
                }
            }
        }
        return hashMap;
    }

    private void buildWhoIncludes(CsmFile csmFile, Map<CsmFile, Set<CsmFile>> map) {
        for (CsmInclude csmInclude : csmFile.getIncludes()) {
            CsmFile csmFile2 = csmInclude.getIncludeFile();
            if (csmFile2 == null) continue;
            Set<CsmFile> set = map.get(csmFile2);
            if (set == null) {
                set = new HashSet<CsmFile>();
                map.put(csmFile2, set);
            }
            if (set.contains(csmFile)) continue;
            set.add(csmFile);
            this.buildWhoIncludes(csmFile2, map);
        }
    }

    private Map<CsmFile, Set<CsmFile>> buildWhoIsIncluded(CsmFile csmFile) {
        HashMap<CsmFile, Set<CsmFile>> hashMap = new HashMap<CsmFile, Set<CsmFile>>();
        this.buildWhoIsIncluded(csmFile, hashMap);
        return hashMap;
    }

    private void buildWhoIsIncluded(CsmFile csmFile, Map<CsmFile, Set<CsmFile>> map) {
        Set<CsmFile> set = map.get(csmFile);
        if (set != null) {
            return;
        }
        set = new HashSet<CsmFile>();
        map.put(csmFile, set);
        for (CsmInclude csmInclude : csmFile.getIncludes()) {
            CsmFile csmFile2 = csmInclude.getIncludeFile();
            if (csmFile2 == null) continue;
            set.add(csmFile2);
            this.buildWhoIsIncluded(csmFile2, map);
        }
    }

    @Override
    public Action[] getDefaultActions() {
        return this.actions;
    }

    @Override
    public Action getCloseWindowAction() {
        return this.close;
    }

    @Override
    public void setCloseWindowAction(Action action) {
        this.close = action;
    }
}

