/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.hierarchy;

import java.util.Collections;
import java.util.Iterator;
import javax.swing.JEditorPane;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextUtils {
    public static final boolean USE_REFERENCE_RESOLVER = CndUtils.getBoolean((String)"hierarchy.use.reference", (boolean)true);

    private ContextUtils() {
    }

    public static CsmFile findFile(Node[] nodeArray) {
        if (nodeArray != null && nodeArray.length > 0) {
            CsmInclude csmInclude;
            CsmFile csmFile;
            CsmReference csmReference;
            if (USE_REFERENCE_RESOLVER && (csmReference = ContextUtils.findReference(nodeArray[0])) != null && CsmKindUtilities.isInclude((CsmObject)csmReference.getOwner()) && (csmFile = (csmInclude = (CsmInclude)csmReference.getOwner()).getIncludeFile()) != null) {
                return csmFile;
            }
            return ContextUtils.findFile(nodeArray[0]);
        }
        return null;
    }

    public static CsmFile findFile(Node node) {
        EditorCookie editorCookie = (EditorCookie)node.getCookie(EditorCookie.class);
        if (editorCookie != null && CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)editorCookie) != null) {
            return CsmUtilities.getCsmFile((Node)node, (boolean)false);
        }
        return null;
    }

    public static CsmClass getContextClass(Node[] nodeArray) {
        CsmReference csmReference;
        CsmDeclaration csmDeclaration = null;
        if (USE_REFERENCE_RESOLVER && ContextUtils.isSupportedReference(csmReference = ContextUtils.findReference(nodeArray[0]))) {
            csmDeclaration = csmReference.getReferencedObject();
            if (CsmKindUtilities.isClass((CsmObject)csmDeclaration)) {
                return (CsmClass)csmDeclaration;
            }
            if (CsmKindUtilities.isVariable((CsmObject)csmDeclaration)) {
                CsmClassifier csmClassifier;
                CsmVariable csmVariable = (CsmVariable)csmDeclaration;
                CsmType csmType = csmVariable.getType();
                CsmClassifier csmClassifier2 = csmClassifier = csmType == null ? null : csmType.getClassifier();
                if (CsmKindUtilities.isClass((CsmObject)csmClassifier)) {
                    return (CsmClass)csmClassifier;
                }
            }
        }
        if (CsmKindUtilities.isClass((CsmObject)(csmDeclaration = ContextUtils.findDeclaration(nodeArray[0])))) {
            return (CsmClass)csmDeclaration;
        }
        return null;
    }

    public static boolean isSupportedReference(CsmReference csmReference) {
        return csmReference != null && !CsmKindUtilities.isMacro((CsmObject)csmReference.getOwner()) && !CsmKindUtilities.isInclude((CsmObject)csmReference.getOwner());
    }

    public static CsmReference findReference(Node node) {
        return CsmReferenceResolver.getDefault().findReference(node);
    }

    public static CsmDeclaration findDeclaration(Node node) {
        JEditorPane jEditorPane;
        EditorCookie editorCookie = (EditorCookie)node.getCookie(EditorCookie.class);
        if (editorCookie != null && (jEditorPane = CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)editorCookie)) != null) {
            int n = jEditorPane.getCaret().getDot();
            CsmFile csmFile = CsmUtilities.getCsmFile((Node)node, (boolean)false);
            if (csmFile != null) {
                return ContextUtils.findInnerFileDeclaration(csmFile, n);
            }
        }
        return null;
    }

    public static CsmDeclaration findInnerFileDeclaration(CsmFile csmFile, int n) {
        CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createOffsetFilter(n);
        Iterator<? extends CsmObject> iterator = ContextUtils.getInnerObjectsIterator(csmFilter, (CsmScope)csmFile);
        CsmDeclaration csmDeclaration = (CsmDeclaration)(iterator.hasNext() ? iterator.next() : null);
        if (csmDeclaration != null && CsmKindUtilities.isScope((CsmObject)csmDeclaration)) {
            CsmDeclaration csmDeclaration2 = ContextUtils.findInnerDeclaration(csmFilter, (CsmScope)csmDeclaration);
            csmDeclaration = csmDeclaration2 != null ? csmDeclaration2 : csmDeclaration;
        }
        return csmDeclaration;
    }

    private static Iterator<? extends CsmObject> getInnerObjectsIterator(CsmSelect.CsmFilter csmFilter, CsmScope csmScope) {
        Iterator iterator = Collections.emptyList().iterator();
        iterator = CsmKindUtilities.isFile((CsmObject)csmScope) ? CsmSelect.getDeclarations((CsmFile)((CsmFile)csmScope), (CsmSelect.CsmFilter)csmFilter) : (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmScope) ? CsmSelect.getDeclarations((CsmNamespaceDefinition)((CsmNamespaceDefinition)csmScope), (CsmSelect.CsmFilter)csmFilter) : (CsmKindUtilities.isClass((CsmObject)csmScope) ? CsmSelect.getClassMembers((CsmClass)((CsmClass)csmScope), (CsmSelect.CsmFilter)csmFilter) : csmScope.getScopeElements().iterator()));
        return iterator;
    }

    private static CsmDeclaration findInnerDeclaration(CsmSelect.CsmFilter csmFilter, CsmScope csmScope) {
        CsmObject csmObject;
        Iterator<? extends CsmObject> iterator = ContextUtils.getInnerObjectsIterator(csmFilter, csmScope);
        if (iterator != null && iterator.hasNext() && CsmKindUtilities.isScope((CsmObject)(csmObject = iterator.next()))) {
            CsmDeclaration csmDeclaration = ContextUtils.findInnerDeclaration(csmFilter, (CsmScope)csmObject);
            if (CsmKindUtilities.isClass((CsmObject)csmDeclaration)) {
                return (CsmClass)csmDeclaration;
            }
            if (CsmKindUtilities.isClass((CsmObject)csmObject)) {
                return (CsmClass)csmObject;
            }
        }
        return null;
    }

    private static boolean isInObject(CsmObject csmObject, int n) {
        if (!CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return false;
        }
        CsmOffsetable csmOffsetable = (CsmOffsetable)csmObject;
        return csmOffsetable.getStartOffset() <= n && n <= csmOffsetable.getEndOffset();
    }

    public static CsmScope findScope(Node node) {
        JEditorPane jEditorPane;
        EditorCookie editorCookie = (EditorCookie)node.getCookie(EditorCookie.class);
        if (editorCookie != null && (jEditorPane = CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)editorCookie)) != null) {
            int n = jEditorPane.getCaret().getDot();
            CsmFile csmFile = CsmUtilities.getCsmFile((Node)node, (boolean)false);
            if (csmFile != null) {
                return ContextUtils.findInnerFileScope(csmFile, n);
            }
        }
        return null;
    }

    public static CsmScope findInnerFileScope(CsmFile csmFile, int n) {
        CsmScope csmScope = null;
        for (CsmDeclaration csmDeclaration : csmFile.getDeclarations()) {
            if (!CsmKindUtilities.isScope((CsmObject)csmDeclaration) || !ContextUtils.isInObject((CsmObject)csmDeclaration, n)) continue;
            csmScope = ContextUtils.findInnerScope((CsmScope)csmDeclaration, n);
            csmScope = csmScope != null ? csmScope : (CsmScope)csmDeclaration;
            break;
        }
        return csmScope;
    }

    private static CsmScope findInnerScope(CsmScope csmScope, int n) {
        CsmScope csmScope2;
        for (CsmScopeElement csmScopeElement : csmScope.getScopeElements()) {
            if (!CsmKindUtilities.isScope((CsmObject)csmScopeElement) || !ContextUtils.isInObject((CsmObject)csmScopeElement, n)) continue;
            csmScope2 = ContextUtils.findInnerScope((CsmScope)csmScopeElement, n);
            if (csmScope2 != null) {
                return csmScope2;
            }
            if (!CsmKindUtilities.isClass((CsmObject)csmScopeElement) && !CsmKindUtilities.isNamespace((Object)csmScopeElement) && !CsmKindUtilities.isFunction((CsmObject)csmScopeElement) && !CsmKindUtilities.isEnum((CsmObject)csmScopeElement) && !CsmKindUtilities.isUnion((CsmObject)csmScopeElement) && !CsmKindUtilities.isFile((CsmObject)csmScopeElement)) continue;
            return (CsmScope)csmScopeElement;
        }
        if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmScope)) {
            for (CsmScopeElement csmScopeElement : ((CsmNamespaceDefinition)csmScope).getDeclarations()) {
                if (!CsmKindUtilities.isScope((CsmObject)csmScopeElement) || !ContextUtils.isInObject((CsmObject)csmScopeElement, n)) continue;
                csmScope2 = ContextUtils.findInnerScope((CsmScope)csmScopeElement, n);
                if (csmScope2 != null) {
                    return csmScope2;
                }
                if (!CsmKindUtilities.isClass((CsmObject)csmScopeElement) && !CsmKindUtilities.isNamespace((Object)csmScopeElement) && !CsmKindUtilities.isFunction((CsmObject)csmScopeElement) && !CsmKindUtilities.isEnum((CsmObject)csmScopeElement) && !CsmKindUtilities.isUnion((CsmObject)csmScopeElement) && !CsmKindUtilities.isFile((CsmObject)csmScopeElement)) continue;
                return (CsmScope)csmScopeElement;
            }
        }
        return null;
    }
}

